/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.modules.message.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.zhxu.bs.BeanSearcher;
import cn.zhxu.bs.FieldOp;
import cn.zhxu.bs.FieldOps;
import cn.zhxu.bs.util.MapBuilder;
import cn.zhxu.bs.util.MapUtils;
import com.elitescloud.boot.datasecurity.dpr.beansearcher.BeanSearcherFactory;
import com.elitescloud.boot.datasecurity.dpr.beansearcher.CloudBeanSearcherEnum;
import com.elitescloud.cloudt.messenger.model.MessageAccountVO;
import com.elitescloud.cloudt.system.constant.MsgSendStateEnum;
import com.elitescloud.cloudt.system.constant.MsgSendTypeEnum;
import com.elitescloud.cloudt.system.constant.MsgTypeEnum;
import com.elitescloud.cloudt.system.constant.SysMsgReceiverTypeEnum;
import com.elitescloud.cloudt.system.dto.req.msg.MsgRecipientUserDTO;
import com.elitescloud.cloudt.system.model.vo.sbean.EmployeePagedRespBean;
import com.elitescloud.cloudt.system.modules.message.bo.SendTempLateMsgBO;
import com.elitescloud.cloudt.system.modules.message.entity.SysMsgSendRecordDO;
import com.elitescloud.cloudt.system.modules.message.entity.SysMsgSendRecordDtlDO;
import com.elitescloud.cloudt.system.modules.message.repository.SysMsgSendRecordDtlRepository;
import com.elitescloud.cloudt.system.modules.message.repository.SysMsgSendRecordRepository;
import com.elitescloud.cloudt.system.modules.message.service.impl.SysMsgSendCommonServiceAbstract;
import com.elitescloud.cloudt.system.modules.message.service.impl.SysMsgSendService;
import com.elitescloud.cloudt.system.modules.message.vo.respose.SysMsgTemplateConfigVO;
import com.elitescloud.cloudt.system.service.model.entity.SysEmployeeDO;
import com.elitescloud.cloudt.system.service.repo.EmployeeRepoProc;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class SysMsgSendCommonService
extends SysMsgSendCommonServiceAbstract {
    private static final Logger log = LoggerFactory.getLogger(SysMsgSendCommonService.class);
    private final SysMsgSendRecordDtlRepository sysMsgSendRecordDtlRepository;
    private final SysMsgSendRecordRepository sysMsgSendRecordRepository;
    private final BeanSearcherFactory beanSearcherFactory;
    private final BeanSearcher beanSearcher;
    private final PlatformTransactionManager transactionManager;
    private final SysMsgSendService sysMsgSendService;
    @Autowired
    private EmployeeRepoProc employeeRepoProc;

    protected SysMsgSendCommonService(SysMsgSendRecordDtlRepository sysMsgSendRecordDtlRepository, SysMsgSendRecordRepository sysMsgSendRecordRepository, BeanSearcherFactory beanSearcherFactory, PlatformTransactionManager transactionManager, SysMsgSendService sysMsgSendService) {
        this.sysMsgSendRecordDtlRepository = sysMsgSendRecordDtlRepository;
        this.sysMsgSendRecordRepository = sysMsgSendRecordRepository;
        this.beanSearcherFactory = beanSearcherFactory;
        this.beanSearcher = beanSearcherFactory.getBeanSearcherService(CloudBeanSearcherEnum.BS_TENANT);
        this.transactionManager = transactionManager;
        this.sysMsgSendService = sysMsgSendService;
    }

    public List<EmployeePagedRespBean> getCheckEmployeePagedRespBeans(List<MsgRecipientUserDTO> recipientUserList) {
        List<Long> userIds = recipientUserList.stream().map(MsgRecipientUserDTO::getUserId).collect(Collectors.toList());
        MapBuilder wereSqlMapBuilder = (MapBuilder)((MapBuilder)MapUtils.builder().field(SysEmployeeDO::getUserId, userIds)).op((FieldOp)FieldOps.InList);
        List employeeList = this.beanSearcher.searchAll(EmployeePagedRespBean.class, wereSqlMapBuilder.build());
        this.checkFindMismatchedEmployeeIds(userIds, employeeList);
        return employeeList;
    }

    public List<EmployeePagedRespBean> getCheckEmployeePagedRespBeans(Set<Long> userIds) {
        MapBuilder wereSqlMapBuilder = (MapBuilder)((MapBuilder)MapUtils.builder().field(SysEmployeeDO::getUserId, userIds)).op((FieldOp)FieldOps.InList);
        List employeeList = this.beanSearcher.searchAll(EmployeePagedRespBean.class, wereSqlMapBuilder.build());
        this.checkFindMismatchedEmployeeIds(userIds, employeeList);
        return employeeList;
    }

    public String sendBatchMsg(String uuidBatch, List<MessageAccountVO> sendPathMap, MsgSendTypeEnum sendTypeEnum, SysMsgTemplateConfigVO msgTemplateTxtReplaceDTO, Map<String, String> templateParams, List<EmployeePagedRespBean> carbonUserEmployeeList, List<String> fileCodes, String receiptAccount) {
        switch (sendTypeEnum) {
            case EMAIL: {
                return this.sysMsgSendService.sendBatchEmailMsg(uuidBatch, sendPathMap, msgTemplateTxtReplaceDTO, carbonUserEmployeeList, fileCodes, receiptAccount);
            }
            case MOBILE_SMS: {
                return this.sysMsgSendService.sendBatchSmsMsg(uuidBatch, sendPathMap, msgTemplateTxtReplaceDTO, templateParams);
            }
            case SYS_INTERIOR: {
                return this.sysMsgSendService.sendBatchSiteMsg(uuidBatch, sendPathMap, msgTemplateTxtReplaceDTO);
            }
            case APP: {
                return this.sysMsgSendService.sendBatchAppMsg(uuidBatch, sendPathMap, msgTemplateTxtReplaceDTO);
            }
            case WX_BOOT: {
                return this.sysMsgSendService.sendBatchWxBootMsg(uuidBatch, msgTemplateTxtReplaceDTO);
            }
            case WECOM: {
                return this.sysMsgSendService.sendBatchWecomMsg(uuidBatch, sendPathMap, msgTemplateTxtReplaceDTO);
            }
            case DINGDING_BOOT: {
                return this.sysMsgSendService.sendBatchDingdingBootMsg(uuidBatch, msgTemplateTxtReplaceDTO);
            }
        }
        log.error("\u6682\u4e0d\u652f\u6301\u7684\u6d88\u606f\u6e20\u9053\uff1a{}", (Object)sendTypeEnum);
        return "\u6682\u4e0d\u652f\u6301";
    }

    private void addSendPathMapByEmployeeSendType(Map<MsgSendTypeEnum, List<MessageAccountVO>> sendPathMap, EmployeePagedRespBean msgRecipientUserDTO, MsgSendTypeEnum sendTypeEnum, SysMsgSendRecordDtlDO sysMsgSendRecordDtlDO, boolean isReceiver) {
        switch (sendTypeEnum) {
            case EMAIL: {
                if (StringUtils.hasText((String)msgRecipientUserDTO.getEmail())) {
                    if (isReceiver) {
                        sendPathMap.computeIfAbsent(MsgSendTypeEnum.EMAIL, k -> new ArrayList()).add(new MessageAccountVO(msgRecipientUserDTO.getEmail(), msgRecipientUserDTO.getLastName()));
                    }
                    sysMsgSendRecordDtlDO.setRecipientAccount(msgRecipientUserDTO.getEmail());
                    break;
                }
                sysMsgSendRecordDtlDO.setSendState(MsgSendStateEnum.FAILED.name());
                sysMsgSendRecordDtlDO.setSentErrMessage("\u5458\u5de5\u90ae\u7bb1\u4e3a\u7a7a\uff0c\u8df3\u8fc7\u53d1\u9001");
                break;
            }
            case MOBILE_SMS: {
                if (StringUtils.hasText((String)msgRecipientUserDTO.getPhone())) {
                    sendPathMap.computeIfAbsent(MsgSendTypeEnum.MOBILE_SMS, k -> new ArrayList()).add(new MessageAccountVO(msgRecipientUserDTO.getPhone(), msgRecipientUserDTO.getLastName()));
                    sysMsgSendRecordDtlDO.setRecipientAccount(msgRecipientUserDTO.getPhone());
                    break;
                }
                sysMsgSendRecordDtlDO.setSendState(MsgSendStateEnum.FAILED.name());
                sysMsgSendRecordDtlDO.setSentErrMessage("\u5458\u5de5\u624b\u673a\u53f7\u4e3a\u7a7a\uff0c\u8df3\u8fc7\u53d1\u9001");
                break;
            }
            case WX_BOOT: {
                sendPathMap.computeIfAbsent(MsgSendTypeEnum.WX_BOOT, t -> new ArrayList()).add(new MessageAccountVO(msgRecipientUserDTO.getUsername()));
                sysMsgSendRecordDtlDO.setRecipientAccount(msgRecipientUserDTO.getUsername());
                sysMsgSendRecordDtlDO.setSendState(MsgSendStateEnum.OK.name());
                sysMsgSendRecordDtlDO.setSentTimeEnd(LocalDateTime.now());
                break;
            }
            case WECOM: {
                sendPathMap.computeIfAbsent(MsgSendTypeEnum.WECOM, t -> new ArrayList()).add(new MessageAccountVO(msgRecipientUserDTO.getUsername()));
                sysMsgSendRecordDtlDO.setRecipientAccount(msgRecipientUserDTO.getUsername());
                sysMsgSendRecordDtlDO.setSendState(MsgSendStateEnum.OK.name());
                sysMsgSendRecordDtlDO.setSentTimeEnd(LocalDateTime.now());
                break;
            }
            case SYS_INTERIOR: {
                sendPathMap.computeIfAbsent(MsgSendTypeEnum.SYS_INTERIOR, t -> new ArrayList()).add(new MessageAccountVO(msgRecipientUserDTO.getUsername()));
                sysMsgSendRecordDtlDO.setRecipientAccount(msgRecipientUserDTO.getUsername());
                sysMsgSendRecordDtlDO.setSendState(MsgSendStateEnum.OK.name());
                sysMsgSendRecordDtlDO.setSentTimeEnd(LocalDateTime.now());
                break;
            }
            case APP: {
                sendPathMap.computeIfAbsent(MsgSendTypeEnum.APP, t -> new ArrayList()).add(new MessageAccountVO(msgRecipientUserDTO.getUsername()));
                sysMsgSendRecordDtlDO.setRecipientAccount(msgRecipientUserDTO.getUsername());
                sysMsgSendRecordDtlDO.setSendState(MsgSendStateEnum.OK.name());
                sysMsgSendRecordDtlDO.setSentTimeEnd(LocalDateTime.now());
                break;
            }
            default: {
                log.error("\u6682\u672a\u5b9e\u73b0\u7684\u6d88\u606f\u7c7b\u578b\uff1a{}", (Object)sendTypeEnum.name());
            }
        }
    }

    public Map<MsgSendTypeEnum, List<MessageAccountVO>> saveSendRecordToMsgSendTypeEnumListMap(SendTempLateMsgBO sendBo, MsgTypeEnum msgTypeEnum, boolean save) {
        if (msgTypeEnum.name().equals(MsgTypeEnum.TEMPLATE.name())) {
            this.msgTemplateSetMesText(sendBo.getTemplateDo().getId(), sendBo.getContentReplaceMap(), sendBo.getGroupedSendMap());
            this.msgTemplateSetMesTitle(sendBo.getTemplateDo().getId(), sendBo.getTitleReplaceMap(), sendBo.getGroupedSendMap());
        }
        if (sendBo.getReceiptUserId() != null) {
            sendBo.setReceiptAccount(this.employeeRepoProc.getEmailByUserId(sendBo.getReceiptUserId()));
        }
        TransactionTemplate transactionTemplate = new TransactionTemplate(this.transactionManager);
        return (Map)transactionTemplate.execute(status -> {
            try {
                String mesJoinParamJson = this.getMesJoinParamJson(sendBo);
                log.info("\u53d1\u9001\u6a21\u677f\u6d88\u606f\uff1a{}\uff0c\u63a5\u6536\u4eba\u6570\u91cf\uff1a{}\uff0c\u9ed8\u8ba4\u63a5\u6536\u4eba\u6570\u91cf\uff1a{}\uff0c\u6d88\u606f\u6e20\u9053\u6570\u91cf\uff1a{}", new Object[]{sendBo.getTemplateDo().getTemplateCode(), sendBo.getRecipientEmployeeList().size(), sendBo.getDefaultReceiverMap().size(), sendBo.getGroupedSendMap().size()});
                EnumMap sendPathMap = new EnumMap(MsgSendTypeEnum.class);
                sendBo.getRecipientEmployeeList().forEach(msgRecipientUserDTO -> {
                    SysMsgSendRecordDO sysMsgSendRecordDO = this.newSysMsgSendRecordDO(msgTypeEnum, (EmployeePagedRespBean)((Object)((Object)msgRecipientUserDTO)), sendBo);
                    sysMsgSendRecordDO.setCustomParamJson(mesJoinParamJson);
                    if (save) {
                        this.sysMsgSendRecordRepository.save((Object)sysMsgSendRecordDO);
                    }
                    sendBo.getGroupedSendMap().forEach((sendTypeEnum, msgTemplateTxtReplaceDTO) -> {
                        SysMsgSendRecordDtlDO sysMsgSendRecordDtlDO = this.newSysMsgSendRecordDtlDO(sendBo, sysMsgSendRecordDO, (MsgSendTypeEnum)sendTypeEnum, (SysMsgTemplateConfigVO)msgTemplateTxtReplaceDTO);
                        sysMsgSendRecordDtlDO.setCustomParamJson(mesJoinParamJson);
                        sysMsgSendRecordDtlDO.setTemplateSendParamJson(this.toJsonString(msgRecipientUserDTO));
                        sysMsgSendRecordDtlDO.setExtend1(CollectionUtils.isEmpty(sendBo.getFileCodes()) ? null : this.toJsonString(sendBo.getFileCodes()));
                        sysMsgSendRecordDtlDO.setExtend2(CollectionUtils.isEmpty(sendBo.getCarbonUserEmployeeList()) ? null : this.toJsonString(sendBo.getCarbonUserEmployeeList().stream().map(employeePagedRespBean -> " UserId=" + employeePagedRespBean.getUserId() + " Username=" + employeePagedRespBean.getUsername() + " Phone=" + employeePagedRespBean.getPhone() + " Email=" + employeePagedRespBean.getEmail()).collect(Collectors.toList())));
                        this.addSendPathMapByEmployeeSendType(sendPathMap, (EmployeePagedRespBean)((Object)((Object)msgRecipientUserDTO)), (MsgSendTypeEnum)sendTypeEnum, sysMsgSendRecordDtlDO, true);
                        sysMsgSendRecordDtlDO.setRecipientAccountType(SysMsgReceiverTypeEnum.RECEIVER.name());
                        sysMsgSendRecordDtlDO.setReceiptUserId(sendBo.getReceiptUserId() == null ? null : sendBo.getReceiptUserId().toString());
                        sysMsgSendRecordDtlDO.setReceiptAccount(sendBo.getReceiptAccount());
                        if (save) {
                            this.sysMsgSendRecordDtlRepository.save((Object)sysMsgSendRecordDtlDO);
                        }
                    });
                });
                if (CollUtil.isNotEmpty(sendBo.getCarbonUserEmployeeList()) && sendBo.getGroupedSendMap().containsKey(MsgSendTypeEnum.EMAIL)) {
                    sendBo.getCarbonUserEmployeeList().forEach(msgRecipientUserDTO -> {
                        SysMsgSendRecordDO sysMsgSendRecordDO = this.newSysMsgSendRecordDO(msgTypeEnum, (EmployeePagedRespBean)((Object)((Object)msgRecipientUserDTO)), sendBo);
                        sysMsgSendRecordDO.setCustomParamJson(mesJoinParamJson);
                        if (save) {
                            this.sysMsgSendRecordRepository.save((Object)sysMsgSendRecordDO);
                        }
                        sendBo.getGroupedSendMap().forEach((sendTypeEnum, msgTemplateTxtReplaceDTO) -> {
                            if (sendTypeEnum != MsgSendTypeEnum.EMAIL) {
                                return;
                            }
                            SysMsgSendRecordDtlDO sysMsgSendRecordDtlDO = this.newSysMsgSendRecordDtlDO(sendBo, sysMsgSendRecordDO, (MsgSendTypeEnum)sendTypeEnum, (SysMsgTemplateConfigVO)msgTemplateTxtReplaceDTO);
                            sysMsgSendRecordDtlDO.setCustomParamJson(mesJoinParamJson);
                            sysMsgSendRecordDtlDO.setTemplateSendParamJson(this.toJsonString(msgRecipientUserDTO));
                            sysMsgSendRecordDtlDO.setExtend1(CollectionUtils.isEmpty(sendBo.getFileCodes()) ? null : this.toJsonString(sendBo.getFileCodes()));
                            sysMsgSendRecordDtlDO.setExtend2(CollectionUtils.isEmpty(sendBo.getCarbonUserEmployeeList()) ? null : this.toJsonString(sendBo.getCarbonUserEmployeeList().stream().map(employeePagedRespBean -> " UserId=" + employeePagedRespBean.getUserId() + " Username=" + employeePagedRespBean.getUsername() + " Phone=" + employeePagedRespBean.getPhone() + " Email=" + employeePagedRespBean.getEmail()).collect(Collectors.toList())));
                            this.addSendPathMapByEmployeeSendType(sendPathMap, (EmployeePagedRespBean)((Object)((Object)msgRecipientUserDTO)), (MsgSendTypeEnum)sendTypeEnum, sysMsgSendRecordDtlDO, false);
                            sysMsgSendRecordDtlDO.setRecipientAccountType(SysMsgReceiverTypeEnum.CARBON_COPY.name());
                            if (save) {
                                this.sysMsgSendRecordDtlRepository.save((Object)sysMsgSendRecordDtlDO);
                            }
                        });
                    });
                }
                if (CollUtil.isNotEmpty(sendBo.getDefaultReceiverMap())) {
                    sendBo.getGroupedSendMap().forEach((sendTypeEnum, msgTemplateTxtReplaceDTO) -> {
                        List<EmployeePagedRespBean> defaultReceiverList = sendBo.getDefaultReceiverMap().get(sendTypeEnum);
                        if (defaultReceiverList.isEmpty()) {
                            return;
                        }
                        for (EmployeePagedRespBean msgRecipientUserDTO : defaultReceiverList) {
                            SysMsgSendRecordDO sysMsgSendRecordDO = this.newSysMsgSendRecordDO(msgTypeEnum, msgRecipientUserDTO, sendBo);
                            sysMsgSendRecordDO.setCustomParamJson(mesJoinParamJson);
                            if (save) {
                                this.sysMsgSendRecordRepository.save((Object)sysMsgSendRecordDO);
                            }
                            SysMsgSendRecordDtlDO sysMsgSendRecordDtlDO = this.newSysMsgSendRecordDtlDO(sendBo, sysMsgSendRecordDO, (MsgSendTypeEnum)sendTypeEnum, (SysMsgTemplateConfigVO)msgTemplateTxtReplaceDTO);
                            sysMsgSendRecordDtlDO.setCustomParamJson(mesJoinParamJson);
                            sysMsgSendRecordDtlDO.setTemplateSendParamJson(this.toJsonString((Object)msgRecipientUserDTO));
                            sysMsgSendRecordDtlDO.setExtend1(CollectionUtils.isEmpty(sendBo.getFileCodes()) ? null : this.toJsonString(sendBo.getFileCodes()));
                            sysMsgSendRecordDtlDO.setRecipientAccountType(SysMsgReceiverTypeEnum.DEFAULT.name());
                            this.addSendPathMapByEmployeeSendType(sendPathMap, msgRecipientUserDTO, (MsgSendTypeEnum)sendTypeEnum, sysMsgSendRecordDtlDO, true);
                            if (!save) continue;
                            this.sysMsgSendRecordDtlRepository.save((Object)sysMsgSendRecordDtlDO);
                        }
                    });
                }
                status.flush();
                return sendPathMap;
            }
            catch (Exception e) {
                status.setRollbackOnly();
                log.error("\u4fdd\u5b58\u6d88\u606f\u8bb0\u5f55\u660e\u7ec6\u5f02\u5e38\uff1a", (Throwable)e);
                throw e;
            }
        });
    }

    @Nullable
    private String getMesJoinParamJson(SendTempLateMsgBO sendBo) {
        String mesJoinParamJson = this.toJsonString(sendBo.getMesJoinParamMap());
        if (mesJoinParamJson != null && mesJoinParamJson.length() > 2000) {
            throw new RuntimeException("\u6d88\u606f\u670d\u52a1\u7a0b\u5e8f\u5f02\u5e38\uff1a\u81ea\u5b9a\u4e49\u53c2\u6570\u8fc7\u957f\uff0c\u8d85\u8fc72000.");
        }
        return mesJoinParamJson;
    }
}

