/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.modules.message.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.nacos.common.codec.Base64;
import com.elitescloud.boot.util.RestTemplateFactory;
import com.elitescloud.cloudt.messenger.Messenger;
import com.elitescloud.cloudt.messenger.message.AbstractMessageSenderVO;
import com.elitescloud.cloudt.messenger.message.AppMessageVO;
import com.elitescloud.cloudt.messenger.message.EmailMessageVO;
import com.elitescloud.cloudt.messenger.message.SiteMessageVO;
import com.elitescloud.cloudt.messenger.message.SmsMessageVO;
import com.elitescloud.cloudt.messenger.message.WecomMessageVO;
import com.elitescloud.cloudt.messenger.model.FileMessageAttachmentVO;
import com.elitescloud.cloudt.messenger.model.MessageAccountVO;
import com.elitescloud.cloudt.messenger.model.dto.MsgResultDTO;
import com.elitescloud.cloudt.system.constant.MsgSendStateEnum;
import com.elitescloud.cloudt.system.constant.MsgSendTypeEnum;
import com.elitescloud.cloudt.system.model.vo.sbean.EmployeePagedRespBean;
import com.elitescloud.cloudt.system.modules.message.repository.SysMsgSendRecordDtlRepository;
import com.elitescloud.cloudt.system.modules.message.service.impl.SysMsgSendCommonServiceAbstract;
import com.elitescloud.cloudt.system.modules.message.vo.respose.SysMsgTemplateConfigVO;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

@Service
public class SysMsgSendService
extends SysMsgSendCommonServiceAbstract {
    private static final Logger log = LoggerFactory.getLogger(SysMsgSendService.class);
    private final SysMsgSendRecordDtlRepository sysMsgSendRecordDtlRepository;
    private final RestTemplate restTemplate = RestTemplateFactory.instance();

    public SysMsgSendService(SysMsgSendRecordDtlRepository sysMsgSendRecordDtlRepository) {
        this.sysMsgSendRecordDtlRepository = sysMsgSendRecordDtlRepository;
    }

    public String sendBatchWxBootMsg(String uuidBatch, SysMsgTemplateConfigVO msgTemplateTxtReplaceDTO) {
        String MSG_TYPE = "markdown";
        String wxBootUrl = msgTemplateTxtReplaceDTO.getExternalTemplateId();
        if (StrUtil.isBlank((CharSequence)wxBootUrl)) {
            return "\u673a\u5668\u4eba\u5730\u5740\u672a\u914d\u7f6e";
        }
        String title = msgTemplateTxtReplaceDTO.getMesTitle();
        String mesText = msgTemplateTxtReplaceDTO.getMesText();
        String content = "# " + title + " \n " + mesText;
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.put("msgtype", MSG_TYPE);
        body.put(MSG_TYPE, Map.of("content", content));
        log.info("\u3010\u4f01\u5fae\u673a\u5668\u4eba\u3011\u53d1\u9001\u9884\u8b66\uff1a{}, {}", (Object)wxBootUrl, (Object)content);
        MsgSendStateEnum state = MsgSendStateEnum.FAILED;
        Object msg = "\u53d1\u9001\u5931\u8d25";
        String receipt = null;
        try {
            ResponseEntity resp = this.restTemplate.exchange(wxBootUrl, HttpMethod.POST, new HttpEntity(body), String.class, new Object[0]);
            receipt = (String)resp.getBody();
            if (resp.getStatusCode().is2xxSuccessful()) {
                state = MsgSendStateEnum.OK;
                msg = null;
            }
        }
        catch (RestClientException e) {
            log.error("\u53d1\u9001\u4f01\u4e1a\u5fae\u4fe1\u673a\u5668\u4eba\u6d88\u606f\u5f02\u5e38\uff1a", (Throwable)e);
            msg = "\u53d1\u9001\u5f02\u5e38\uff1a" + e.getMessage();
        }
        this.sysMsgSendRecordDtlRepository.updateByCondition(receipt, (String)msg, state.name(), LocalDateTime.now(), uuidBatch, MsgSendTypeEnum.WX_BOOT.name());
        return msg;
    }

    public String sendBatchDingdingBootMsg(String uuidBatch, SysMsgTemplateConfigVO msgTemplateTxtReplaceDTO) {
        Object bootUrl = msgTemplateTxtReplaceDTO.getExternalTemplateId();
        if (StrUtil.isBlank((CharSequence)bootUrl)) {
            return "\u673a\u5668\u4eba\u5730\u5740\u672a\u914d\u7f6e";
        }
        if (StrUtil.isNotBlank((CharSequence)msgTemplateTxtReplaceDTO.getExternalSignName())) {
            Long timestamp = System.currentTimeMillis();
            String secret = msgTemplateTxtReplaceDTO.getExternalSignName();
            String sign = null;
            try {
                String stringToSign = timestamp + "\n" + secret;
                Mac mac = Mac.getInstance("HmacSHA256");
                mac.init(new SecretKeySpec(secret.getBytes(StandardCharsets.UTF_8), "HmacSHA256"));
                byte[] signData = mac.doFinal(stringToSign.getBytes(StandardCharsets.UTF_8));
                sign = URLEncoder.encode(new String(Base64.encodeBase64((byte[])signData)), StandardCharsets.UTF_8);
            }
            catch (Exception e) {
                log.error("\u7b7e\u540d\u5f02\u5e38\uff1a", (Throwable)e);
                return "\u7b7e\u540d\u5f02\u5e38\uff1a" + e.getMessage();
            }
            bootUrl = (String)bootUrl + "&timestamp=" + timestamp + "&sign=" + sign;
        }
        String title = msgTemplateTxtReplaceDTO.getMesTitle();
        String mesText = msgTemplateTxtReplaceDTO.getMesText();
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.put("msgtype", "markdown");
        body.put("markdown", Map.of("title", title, "text", mesText));
        log.info("\u3010\u9489\u9489\u673a\u5668\u4eba\u3011\u53d1\u9001\u9884\u8b66\uff1a{}, {}", bootUrl, (Object)mesText);
        MsgSendStateEnum state = MsgSendStateEnum.FAILED;
        Object msg = "\u53d1\u9001\u5931\u8d25";
        String receipt = null;
        try {
            ResponseEntity resp = this.restTemplate.exchange((String)bootUrl, HttpMethod.POST, new HttpEntity(body), String.class, new Object[0]);
            receipt = (String)resp.getBody();
            if (resp.getStatusCode().is2xxSuccessful()) {
                state = MsgSendStateEnum.OK;
                msg = null;
            }
        }
        catch (RestClientException e) {
            log.error("\u53d1\u9001\u9489\u9489\u673a\u5668\u4eba\u6d88\u606f\u5f02\u5e38\uff1a", (Throwable)e);
            msg = "\u53d1\u9001\u5f02\u5e38\uff1a" + e.getMessage();
        }
        this.sysMsgSendRecordDtlRepository.updateByCondition(receipt, (String)msg, state.name(), LocalDateTime.now(), uuidBatch, MsgSendTypeEnum.DINGDING_BOOT.name());
        return msg;
    }

    public String sendBatchWecomMsg(String uuidBatch, List<MessageAccountVO> accountList, SysMsgTemplateConfigVO msgTemplateTxtReplaceDTO) {
        if (CollectionUtils.isEmpty(accountList)) {
            log.error("\u6d88\u606f\u670d\u52a1\uff1a\u6ca1\u6709\u4e00\u4e2a\u63a5\u6536\u4eba\u7684\u8d26\u53f7\uff0c\u4f01\u5fae\u6d88\u606f\u5c06\u4e0d\u4f1a\u53d1\u9001\uff01");
            return "\u63a5\u6536\u4eba\u6216\u767b\u5f55\u8d26\u53f7\u4e3a\u7a7a";
        }
        WecomMessageVO message = Messenger.wecomTextMessage().setReceiverList(accountList).setSubject(msgTemplateTxtReplaceDTO.getMesTitle()).setContent(msgTemplateTxtReplaceDTO.getMesText()).build();
        return this.executeSend((AbstractMessageSenderVO)message, MsgSendTypeEnum.WECOM, uuidBatch);
    }

    public String sendBatchSiteMsg(String uuidBatch, List<MessageAccountVO> accountList, SysMsgTemplateConfigVO msgTemplateTxtReplaceDTO) {
        if (CollectionUtils.isEmpty(accountList)) {
            log.error("\u6d88\u606f\u670d\u52a1\uff1a\u6ca1\u6709\u4e00\u4e2a\u63a5\u6536\u4eba\u7684\u8d26\u53f7\uff0c\u7ad9\u5185\u4fe1\u6d88\u606f\u5c06\u4e0d\u4f1a\u53d1\u9001\uff01");
            return "\u63a5\u6536\u4eba\u6216\u767b\u5f55\u8d26\u53f7\u4e3a\u7a7a";
        }
        SiteMessageVO message = Messenger.siteMessage().setReceiverList(accountList).setSubject(msgTemplateTxtReplaceDTO.getMesTitle()).setContent(msgTemplateTxtReplaceDTO.getMesText()).setBusinessType(CharSequenceUtil.blankToDefault((CharSequence)msgTemplateTxtReplaceDTO.getBusinessType(), (String)"default")).setBusinessParams(msgTemplateTxtReplaceDTO.getBusinessData()).build();
        return this.executeSend((AbstractMessageSenderVO)message, MsgSendTypeEnum.SYS_INTERIOR, uuidBatch);
    }

    public String sendBatchAppMsg(String uuidBatch, List<MessageAccountVO> accountList, SysMsgTemplateConfigVO msgTemplateTxtReplaceDTO) {
        if (CollectionUtils.isEmpty(accountList)) {
            log.error("\u6d88\u606f\u670d\u52a1\uff1a\u6ca1\u6709\u4e00\u4e2a\u63a5\u6536\u4eba\u7684\u8d26\u53f7\uff0cApp\u6d88\u606f\u5c06\u4e0d\u4f1a\u53d1\u9001\uff01");
            return "\u63a5\u6536\u4eba\u6216\u63a5\u6536\u4eba\u7684\u767b\u5f55\u8d26\u53f7\u4e3a\u7a7a";
        }
        AppMessageVO message = Messenger.appMessage().setReceiverList(accountList).setSubject(msgTemplateTxtReplaceDTO.getMesTitle()).setContent(msgTemplateTxtReplaceDTO.getMesText()).setBusinessType(CharSequenceUtil.blankToDefault((CharSequence)msgTemplateTxtReplaceDTO.getBusinessType(), (String)"default")).setBusinessParams(msgTemplateTxtReplaceDTO.getBusinessData()).build();
        return this.executeSend((AbstractMessageSenderVO)message, MsgSendTypeEnum.APP, uuidBatch);
    }

    public String sendBatchSmsMsg(String uuidBatch, List<MessageAccountVO> sendEmailList, SysMsgTemplateConfigVO msgTemplateTxtReplaceDTO, Map<String, String> templateParams) {
        if (CollectionUtils.isEmpty(sendEmailList)) {
            log.error("\u6d88\u606f\u670d\u52a1\uff1a\u6ca1\u6709\u4e00\u4e2a\u63a5\u6536\u4eba\u7684\u624b\u673a\u53f7\uff0c\u77ed\u4fe1\u6d88\u606f\u5c06\u4e0d\u4f1a\u53d1\u9001\uff01");
            return "\u63a5\u6536\u4eba\u6216\u63a5\u6536\u4eba\u7684\u624b\u673a\u53f7\u4e3a\u7a7a";
        }
        SmsMessageVO messageVO = null;
        messageVO = StringUtils.hasText((String)msgTemplateTxtReplaceDTO.getExternalTemplateId()) ? Messenger.templateSms().setTemplateCode(msgTemplateTxtReplaceDTO.getExternalTemplateId()).setSignName(CharSequenceUtil.blankToDefault((CharSequence)msgTemplateTxtReplaceDTO.getExternalSignName(), null)).setTemplateParam(templateParams).setReceiverList(sendEmailList).setSubject(msgTemplateTxtReplaceDTO.getMesTitle()).setContent(msgTemplateTxtReplaceDTO.getMesText()).build() : Messenger.sms().setReceiverList(sendEmailList).setSubject(msgTemplateTxtReplaceDTO.getMesTitle()).setContent(msgTemplateTxtReplaceDTO.getMesText()).setSignName(CharSequenceUtil.blankToDefault((CharSequence)msgTemplateTxtReplaceDTO.getExternalSignName(), null)).build();
        return this.executeSend((AbstractMessageSenderVO)messageVO, MsgSendTypeEnum.MOBILE_SMS, uuidBatch);
    }

    public String sendBatchEmailMsg(String uuidBatch, List<MessageAccountVO> receiverList, SysMsgTemplateConfigVO msgTemplateTxtReplaceDTO, List<EmployeePagedRespBean> carbonUserEmployeeList, List<String> fileCodes, String receiptAccount) {
        if (CollectionUtils.isEmpty(receiverList)) {
            log.error("\u6d88\u606f\u670d\u52a1\uff1a\u6ca1\u6709\u4e00\u4e2a\u90ae\u4ef6\u63a5\u6536\u4eba\u7684\u90ae\u7bb1\uff0c\u90ae\u4ef6\u6d88\u606f\u5c06\u4e0d\u4f1a\u53d1\u9001\uff01");
            return "\u63a5\u6536\u4eba\u6216\u63a5\u6536\u4eba\u7684\u90ae\u7bb1\u4e3a\u7a7a";
        }
        List ccList = CollUtil.isEmpty(carbonUserEmployeeList) ? Collections.emptyList() : carbonUserEmployeeList.stream().filter(t -> StringUtils.hasText((String)t.getEmail())).map(user -> {
            MessageAccountVO messageAccountVO = new MessageAccountVO();
            messageAccountVO.setAccount(user.getEmail());
            messageAccountVO.setNickName(user.getLastName());
            return messageAccountVO;
        }).collect(Collectors.toList());
        List messageAttachmentVOS = CollUtil.isEmpty(fileCodes) ? Collections.emptyList() : fileCodes.stream().map(s -> {
            FileMessageAttachmentVO fileMessageAttachmentVO = new FileMessageAttachmentVO();
            fileMessageAttachmentVO.setFileCode(s);
            return fileMessageAttachmentVO;
        }).collect(Collectors.toList());
        EmailMessageVO message = Messenger.email().setSubject(msgTemplateTxtReplaceDTO.getMesTitle()).setContent(msgTemplateTxtReplaceDTO.getMesText()).setReceiverList(receiverList).setCcList(ccList).setAttachments(messageAttachmentVOS).setRetryableOnFailure(Boolean.valueOf(true)).setReceiptAccount(receiptAccount).build();
        return this.executeSend((AbstractMessageSenderVO)message, MsgSendTypeEnum.EMAIL, uuidBatch);
    }

    private String executeSend(@NotNull AbstractMessageSenderVO messageSenderVO, @NotNull MsgSendTypeEnum sendTypeEnum, String uuidBatch) {
        try {
            String messageId = messageSenderVO.sendSync();
            MsgSendStateEnum status = MsgSendStateEnum.OK;
            String failMsg = "\u53d1\u9001\u6210\u529f";
            if (CharSequenceUtil.isNotBlank((CharSequence)messageId)) {
                MsgResultDTO sendResult = Messenger.querySendResult((String)messageId);
                if (MsgSendStateEnum.FAILED.name().equals(sendResult.getStatusName())) {
                    status = MsgSendStateEnum.FAILED;
                    failMsg = sendResult.getFailMsg();
                }
            }
            this.sysMsgSendRecordDtlRepository.updateByCondition(messageId, failMsg, status.name(), LocalDateTime.now(), uuidBatch, sendTypeEnum.name());
            return status == MsgSendStateEnum.FAILED ? failMsg : null;
        }
        catch (Exception e) {
            log.error("\u53d1\u9001{}\u5f02\u5e38\uff1a{}", new Object[]{sendTypeEnum.getDescription(), uuidBatch, e});
            this.sysMsgSendRecordDtlRepository.updateByCondition(null, e.getMessage(), MsgSendStateEnum.FAILED.name(), LocalDateTime.now(), uuidBatch, sendTypeEnum.name());
            return "\u53d1\u9001\u5f02\u5e38\uff1a" + e.getMessage();
        }
    }
}

