/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.modules.message.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.boot.auth.util.SecurityContextUtil;
import com.elitescloud.boot.common.param.IdNameParam;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.provider.TenantOrgDataIsolateProvider;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.messenger.model.MessageAccountVO;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitescloud.cloudt.system.common.MsgTemplateReceiverEnum;
import com.elitescloud.cloudt.system.constant.MsgSendTypeEnum;
import com.elitescloud.cloudt.system.constant.MsgTypeEnum;
import com.elitescloud.cloudt.system.dto.req.msg.MsgSendEmployeeUserDTO;
import com.elitescloud.cloudt.system.model.vo.resp.message.MsgTestRespVO;
import com.elitescloud.cloudt.system.model.vo.save.message.MsgTestSaveVO;
import com.elitescloud.cloudt.system.model.vo.sbean.EmployeePagedRespBean;
import com.elitescloud.cloudt.system.modules.message.bo.MsgTemplateReceiverBO;
import com.elitescloud.cloudt.system.modules.message.bo.SendTempLateMsgBO;
import com.elitescloud.cloudt.system.modules.message.convert.SysMsgTemplateConfigConvert;
import com.elitescloud.cloudt.system.modules.message.convert.SysMsgTemplateConvert;
import com.elitescloud.cloudt.system.modules.message.entity.QSysMsgTemplateConfigDO;
import com.elitescloud.cloudt.system.modules.message.entity.QSysMsgTemplateDO;
import com.elitescloud.cloudt.system.modules.message.entity.SysMsgTemplateConfigDO;
import com.elitescloud.cloudt.system.modules.message.entity.SysMsgTemplateDO;
import com.elitescloud.cloudt.system.modules.message.entity.SysMsgTemplateReceiverDO;
import com.elitescloud.cloudt.system.modules.message.repository.SysMsgTemplateConfigRepoProc;
import com.elitescloud.cloudt.system.modules.message.repository.SysMsgTemplateConfigRepository;
import com.elitescloud.cloudt.system.modules.message.repository.SysMsgTemplateReceiverRepoProc;
import com.elitescloud.cloudt.system.modules.message.repository.SysMsgTemplateRepoProc;
import com.elitescloud.cloudt.system.modules.message.repository.SysMsgTemplateRepository;
import com.elitescloud.cloudt.system.modules.message.service.SysMsgTemplateService;
import com.elitescloud.cloudt.system.modules.message.service.impl.SysMsgSendCommonService;
import com.elitescloud.cloudt.system.modules.message.vo.request.DefaultReceiverVO;
import com.elitescloud.cloudt.system.modules.message.vo.request.SysMsgTemplateQueryVO;
import com.elitescloud.cloudt.system.modules.message.vo.request.TemplateAndConfigSaveVO;
import com.elitescloud.cloudt.system.modules.message.vo.request.TemplateAndConfigUpdateVO;
import com.elitescloud.cloudt.system.modules.message.vo.request.TemplateConfigSaveVO;
import com.elitescloud.cloudt.system.modules.message.vo.request.TemplateDeleteVO;
import com.elitescloud.cloudt.system.modules.message.vo.respose.SysMsgTemplateConfigVO;
import com.elitescloud.cloudt.system.modules.message.vo.respose.SysMsgTemplatePageRespVO;
import com.elitescloud.cloudt.system.modules.message.vo.respose.SysMsgTemplateRespVO;
import com.elitescloud.cloudt.system.service.EmployeeQueryService;
import com.elitescloud.cloudt.system.service.RoleQueryService;
import com.elitescloud.cloudt.system.service.UserQueryService;
import com.elitescloud.cloudt.system.service.model.entity.SysEmployeeDO;
import com.elitescloud.cloudt.system.service.repo.EmployeeRepoProc;
import com.elitescloud.cloudt.system.service.repo.UserRoleRepoProc;
import com.elitescloud.cloudt.system.vo.SysUdcVO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanTemplate;
import com.querydsl.core.types.dsl.Expressions;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class SysMsgTemplateServiceImpl
implements SysMsgTemplateService {
    private static final Logger log = LoggerFactory.getLogger(SysMsgTemplateServiceImpl.class);
    private final EmployeeRepoProc employeeRepoProc;
    private final UserRoleRepoProc userRoleRepoProc;
    private final SysMsgTemplateRepository sysMsgTemplateRepository;
    private final SysMsgTemplateRepoProc sysMsgTemplateRepoProc;
    private final SysMsgTemplateConfigRepository sysMsgTemplateConfigRepository;
    private final SysMsgTemplateConfigRepoProc sysMsgTemplateConfigRepoProc;
    private final SysMsgTemplateReceiverRepoProc sysMsgTemplateReceiverRepoProc;
    private final SysMsgSendCommonService sysMsgSendCommonService;
    private final UserQueryService userQueryService;
    private final RoleQueryService roleQueryService;
    private final EmployeeQueryService employeeQueryService;
    private final TenantOrgDataIsolateProvider tenantOrgDataIsolateProvider;

    @Override
    public ApiResult<List<SysUdcVO>> getSysMsgSendType() {
        List sysUdcVOList = MsgSendTypeEnum.getSysUdcVOList();
        return ApiResult.ok((Object)sysUdcVOList);
    }

    @Override
    public ApiResult<PagingVO<SysMsgTemplatePageRespVO>> getSysMsgTemplateList(SysMsgTemplateQueryVO queryVO) {
        QSysMsgTemplateDO qSysMsgTemplateDO = QSysMsgTemplateDO.sysMsgTemplateDO;
        BooleanTemplate predicate = Expressions.booleanTemplate((String)"1=1", (Object[])new Object[0]);
        predicate = StringUtils.isBlank((CharSequence)queryVO.getTemplateName()) ? predicate : ExpressionUtils.and((Predicate)predicate, (Predicate)qSysMsgTemplateDO.templateName.eq((Object)queryVO.getTemplateName()));
        predicate = StringUtils.isBlank((CharSequence)queryVO.getTemplateCode()) ? predicate : ExpressionUtils.and((Predicate)predicate, (Predicate)qSysMsgTemplateDO.templateCode.eq((Object)queryVO.getTemplateCode()));
        Page page = this.sysMsgTemplateRepository.findAll((Predicate)predicate, (Pageable)queryVO.getPageRequest());
        if (queryVO.getQueryTemplateConfigFlag().booleanValue()) {
            QSysMsgTemplateConfigDO configQDO = QSysMsgTemplateConfigDO.sysMsgTemplateConfigDO;
            List tCodes = page.get().map(SysMsgTemplateDO::getTemplateCode).collect(Collectors.toList());
            ArrayList configVoList = new ArrayList();
            this.sysMsgTemplateConfigRepository.findAll((Predicate)configQDO.deleteFlag.eq((Object)0).and((Predicate)configQDO.templateCode.in(tCodes))).forEach(configDo -> configVoList.add(SysMsgTemplateConfigConvert.INSTANCE.doToVo((SysMsgTemplateConfigDO)((Object)configDo))));
            Map<String, List<SysMsgTemplateConfigVO>> configMapGroup = configVoList.stream().collect(Collectors.groupingBy(SysMsgTemplateConfigVO::getTemplateCode));
            List pageVo = page.get().map(msgTemplateDO -> {
                SysMsgTemplatePageRespVO vo = SysMsgTemplateConvert.INSTANCE.doToSysMsgTemplatePageRespVO((SysMsgTemplateDO)((Object)msgTemplateDO));
                vo.setTemplateConfigs((List)configMapGroup.get(vo.getTemplateCode()));
                return vo;
            }).collect(Collectors.toList());
            PagingVO pagingVo = PagingVO.builder().total(page.getTotalElements()).setRecords(pageVo);
            return ApiResult.ok((Object)pagingVo);
        }
        PagingVO pagingVo = PagingVO.builder().total(page.getTotalElements()).setRecords(page.get().map(SysMsgTemplateConvert.INSTANCE::doToSysMsgTemplatePageRespVO).collect(Collectors.toList()));
        return ApiResult.ok((Object)pagingVo);
    }

    @Override
    public ApiResult<SysMsgTemplateRespVO> getSysMsgTemplate(Long id, Boolean queryTemplateConfigFlag) {
        Assert.notNull((Object)id, (String)"ID\u4e3a\u7a7a");
        return this.sysMsgTemplateRepoProc.getOptional(id).map(template -> {
            SysMsgTemplateRespVO sysMsgTemplateRespVO = SysMsgTemplateConvert.INSTANCE.doToVo((SysMsgTemplateDO)((Object)template));
            if (queryTemplateConfigFlag != null && queryTemplateConfigFlag.booleanValue()) {
                List<SysMsgTemplateConfigVO> configVoList = this.getTemplateConfigList((SysMsgTemplateDO)((Object)template));
                sysMsgTemplateRespVO.setTemplateConfigs(configVoList);
            }
            return sysMsgTemplateRespVO;
        }).map(ApiResult::ok).orElseThrow(() -> new BusinessException("\u6570\u636e\u4e0d\u5b58\u5728"));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> templateAndConfigSave(TemplateAndConfigSaveVO vo) {
        Assert.hasText((String)vo.getTemplateCode(), (String)"\u6a21\u677f\u7f16\u7801\u4e3a\u7a7a");
        boolean existsCode = this.sysMsgTemplateRepoProc.existsTemplateCode(vo.getTemplateCode());
        if (existsCode) {
            return ApiResult.fail((String)"\u6a21\u677f\u7f16\u53f7\u4e0d\u80fd\u91cd\u590d");
        }
        SysMsgTemplateDO sysMsgTemplateDO = new SysMsgTemplateDO();
        sysMsgTemplateDO.setTemplateCode(vo.getTemplateCode());
        sysMsgTemplateDO.setTemplateName(vo.getTemplateName());
        sysMsgTemplateDO.setTemplateGroup(vo.getTemplateGroup());
        sysMsgTemplateDO.setTemplateDescribe(vo.getTemplateDescribe());
        this.sysMsgTemplateRepoProc.save((Serializable)((Object)sysMsgTemplateDO));
        Long id = sysMsgTemplateDO.getId();
        this.sysMsgTemplateConfigSaveAll(vo.getTemplateConfigs(), id, sysMsgTemplateDO.getTemplateCode(), sysMsgTemplateDO.getTemplateName());
        return ApiResult.ok((Object)id);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> templateAndConfigUpdate(Long id, TemplateAndConfigUpdateVO vo) {
        Assert.notNull((Object)id, (String)"ID\u4e3a\u7a7a");
        this.sysMsgTemplateRepoProc.getOptional(id).ifPresentOrElse(sysMsgTemplateDO -> {
            sysMsgTemplateDO.setTemplateName(vo.getTemplateName());
            sysMsgTemplateDO.setTemplateGroup(vo.getTemplateGroup());
            sysMsgTemplateDO.setTemplateDescribe(vo.getTemplateDescribe());
            this.sysMsgTemplateRepoProc.save((Serializable)((Object)sysMsgTemplateDO));
            this.sysMsgTemplateConfigRepository.deleteByTemplateId(id);
            this.sysMsgTemplateConfigSaveAll(vo.getTemplateConfigs(), id, sysMsgTemplateDO.getTemplateCode(), sysMsgTemplateDO.getTemplateName());
        }, () -> {
            throw new BusinessException("\u4fee\u6539\u7684\u6570\u636e\u4e0d\u5b58\u5728");
        });
        return ApiResult.ok((Object)id);
    }

    @Override
    public ApiResult<Boolean> sendTypeSwitchUpdate(Long id, Boolean flag) {
        this.sysMsgTemplateConfigRepository.findById(id).ifPresentOrElse(sysMsgTemplateConfigDO -> {
            sysMsgTemplateConfigDO.setSendTypeSwitch(flag);
            this.sysMsgTemplateConfigRepository.save(sysMsgTemplateConfigDO);
        }, () -> {
            throw new BusinessException("\u6570\u636e\u4e0d\u5b58\u5728");
        });
        return ApiResult.ok((Object)true);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Boolean> deleteSysMsgTemplate(TemplateDeleteVO templateDeleteVO) {
        List<Long> tlist = templateDeleteVO.getTemplateIdList();
        this.sysMsgTemplateRepository.deleteAllById(tlist);
        tlist.forEach(this.sysMsgTemplateConfigRepository::deleteByTemplateId);
        return ApiResult.ok((Object)true);
    }

    @Override
    public ApiResult<Map<MsgSendTypeEnum, Set<Long>>> queryDefaultReceivers(String templateCode) {
        Assert.hasText((String)templateCode, (String)"\u6a21\u677f\u7f16\u7801\u4e3a\u7a7a");
        Long templateId = this.sysMsgTemplateRepoProc.getIdByTemplateCode(templateCode);
        if (templateId == null) {
            return ApiResult.fail((String)"\u672a\u627e\u5230\u6a21\u677f\u914d\u7f6e\uff0c\u8bf7\u786e\u8ba4\u6a21\u677f\u7f16\u7801\u6b63\u786e");
        }
        Map<String, Long> configIdMap = this.sysMsgTemplateConfigRepoProc.getIdsByTemplateId(templateId, true);
        if (configIdMap.isEmpty()) {
            return ApiResult.fail((String)"\u6d88\u606f\u6a21\u677f\u914d\u7f6e\u5747\u672a\u542f\u7528\uff0c\u8bf7\u5148\u542f\u7528\u6d88\u606f\u6a21\u677f");
        }
        HashMap<MsgSendTypeEnum, Set<Long>> result = new HashMap<MsgSendTypeEnum, Set<Long>>(configIdMap.size());
        for (Map.Entry<String, Long> entry : configIdMap.entrySet()) {
            MsgSendTypeEnum sendType = MsgSendTypeEnum.parse((String)entry.getKey());
            if (sendType == null) {
                log.warn("\u672a\u77e5\u53d1\u9001\u7c7b\u578b\uff1a{}", (Object)entry.getKey());
                continue;
            }
            result.put(sendType, this.getTemplateReceiverUserIds(templateId, entry.getValue()));
        }
        return ApiResult.ok(result);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<List<MsgTestRespVO>> testSendMsg(MsgTestSaveVO saveVO) {
        if (saveVO == null || CharSequenceUtil.isBlank((CharSequence)saveVO.getTemplateCode())) {
            return ApiResult.fail((String)"\u6a21\u677f\u7f16\u7801\u4e3a\u7a7a");
        }
        SendTempLateMsgBO sendBO = this.convertMsgBO(saveVO);
        Map<MsgSendTypeEnum, List<MessageAccountVO>> sendPathMap = this.sysMsgSendCommonService.saveSendRecordToMsgSendTypeEnumListMap(sendBO, MsgTypeEnum.TEMPLATE, false);
        ArrayList<MsgTestRespVO> resultList = new ArrayList<MsgTestRespVO>();
        for (Map.Entry<MsgSendTypeEnum, SysMsgTemplateConfigVO> entry : sendBO.getGroupedSendMap().entrySet()) {
            String failMsg;
            long start = System.currentTimeMillis();
            resultList.add(new MsgTestRespVO(entry.getKey(), (failMsg = this.sysMsgSendCommonService.sendBatchMsg(null, sendPathMap.get(entry.getKey()), entry.getKey(), entry.getValue(), sendBO.getContentReplaceMap(), sendBO.getCarbonUserEmployeeList(), sendBO.getFileCodes(), sendBO.getReceiptAccount())) == null, failMsg, System.currentTimeMillis() - start));
        }
        return ApiResult.ok(resultList);
    }

    private SendTempLateMsgBO convertMsgBO(MsgTestSaveVO saveVO) {
        MsgSendEmployeeUserDTO sendUser = this.obtainSender(saveVO);
        List<EmployeePagedRespBean> recipientUserEmployeeList = this.convertReceiver(saveVO.getReceivers());
        List<EmployeePagedRespBean> carbonUserEmployeeList = this.convertReceiver(saveVO.getCarbonUsers());
        SendTempLateMsgBO sendBo = new SendTempLateMsgBO(saveVO.getContentParams(), saveVO.getTitleParams(), saveVO.getBusinessParams(), null, sendUser, recipientUserEmployeeList, carbonUserEmployeeList, saveVO.getFileCodes(), saveVO.getTemplateCode());
        if (saveVO.getReceiptAccount() != null) {
            sendBo.setReceiptUserId(saveVO.getReceiptAccount().getUserId());
        }
        this.tenantOrgDataIsolateProvider.byNoTenantOrg(() -> {
            SysMsgTemplateDO templateDO = this.sysMsgTemplateRepository.findByTemplateCode(sendBo.getTemplateCode());
            if (templateDO != null) {
                sendBo.setTemplateDo(templateDO);
                List<SysMsgTemplateConfigDO> configDoList = this.sysMsgTemplateConfigRepository.findAllByTemplateIdAndSendTypeSwitch(sendBo.getTemplateDo().getId(), true);
                Map<MsgSendTypeEnum, SysMsgTemplateConfigVO> configMap = configDoList.isEmpty() ? Collections.emptyMap() : this.sysMsgSendCommonService.sysMsgTemplateConfigDoToVoGroupBySendTypeCode(configDoList);
                sendBo.setGroupedSendMap(configMap);
                Map<MsgSendTypeEnum, List<EmployeePagedRespBean>> defaultReceiverMap = this.queryDefaultReceiver(sendBo.getTemplateCode());
                sendBo.setDefaultReceiverMap(defaultReceiverMap);
            }
            return null;
        });
        Assert.notNull((Object)((Object)sendBo.getTemplateDo()), (String)"\u6a21\u677f\u4fe1\u606f\u4e0d\u5b58\u5728");
        return sendBo;
    }

    private Map<MsgSendTypeEnum, List<EmployeePagedRespBean>> queryDefaultReceiver(String templateCode) {
        Map defaultReceiverMap = (Map)this.queryDefaultReceivers(templateCode).computeData();
        if (defaultReceiverMap.isEmpty()) {
            return Collections.emptyMap();
        }
        Set<Long> userIds = defaultReceiverMap.values().stream().flatMap(Collection::stream).filter(Objects::nonNull).collect(Collectors.toSet());
        if (userIds.isEmpty()) {
            return Collections.emptyMap();
        }
        Map<Long, EmployeePagedRespBean> employeeMap = this.sysMsgSendCommonService.getCheckEmployeePagedRespBeans(userIds).stream().collect(Collectors.toMap(SysEmployeeDO::getUserId, t -> t, (t1, t2) -> t1));
        HashMap<MsgSendTypeEnum, List<EmployeePagedRespBean>> result = new HashMap<MsgSendTypeEnum, List<EmployeePagedRespBean>>(defaultReceiverMap.size());
        for (Map.Entry entry : defaultReceiverMap.entrySet()) {
            List employeeList = ((Set)entry.getValue()).stream().map(employeeMap::get).filter(Objects::nonNull).collect(Collectors.toList());
            result.put((MsgSendTypeEnum)entry.getKey(), employeeList);
        }
        return result;
    }

    private List<EmployeePagedRespBean> convertReceiver(List<MsgTestSaveVO.UserAccount> userAccounts) {
        return CollUtil.isEmpty(userAccounts) ? Collections.emptyList() : userAccounts.stream().map(u -> {
            EmployeePagedRespBean emp = new EmployeePagedRespBean();
            emp.setUserId(u.getUserId());
            emp.setUsername(u.getUsername());
            emp.setLastName(u.getLastName());
            emp.setMobile(u.getMobile());
            emp.setPhone(u.getMobile());
            emp.setEmail(u.getEmail());
            return emp;
        }).collect(Collectors.toList());
    }

    private MsgSendEmployeeUserDTO obtainSender(MsgTestSaveVO saveVO) {
        MsgSendEmployeeUserDTO sendUser = new MsgSendEmployeeUserDTO();
        if (saveVO.getSendUser() != null) {
            sendUser.setUserId(saveVO.getSendUser().getUserId());
            sendUser.setUserName(saveVO.getSendUser().getUsername());
            sendUser.setUserStandby(saveVO.getSendUser().getLastName());
            sendUser.setUserCode(saveVO.getSendUser().getUsername());
            return sendUser;
        }
        GeneralUserDetails currentUser = SecurityContextUtil.currentUser();
        if (currentUser != null) {
            sendUser.setUserId(currentUser.getUserId());
            sendUser.setUserName(currentUser.getUsername());
            sendUser.setUserStandby(currentUser.getUser().getPrettyName());
            return sendUser;
        }
        sendUser.setUserId(Long.valueOf(-1L));
        sendUser.setUserName("\u7cfb\u7edf");
        sendUser.setUserStandby("\u7cfb\u7edf\u81ea\u52a8\u53d1\u9001");
        return sendUser;
    }

    private void sysMsgTemplateConfigSaveAll(List<TemplateConfigSaveVO> configList, Long tid, String tCode, String tName) {
        this.sysMsgTemplateReceiverRepoProc.deleteByTemplateId(tid);
        if (CollUtil.isEmpty(configList)) {
            log.warn("\u6a21\u677f\u914d\u7f6e\u4e3a\u7a7a");
            return;
        }
        SysMsgTemplateConfigDO configDO = null;
        List<SysMsgTemplateReceiverDO> receivers = null;
        for (TemplateConfigSaveVO configSaveVO : configList) {
            configDO = new SysMsgTemplateConfigDO();
            configDO.setTemplateId(tid);
            configDO.setTemplateCode(tCode);
            configDO.setTemplateName(tName);
            configDO.setSendTypeCode(configSaveVO.getSendType().name());
            configDO.setSendTypeSwitch(configSaveVO.getSendTypeSwitch());
            configDO.setSendTypeName(configSaveVO.getSendType().getDescription());
            configDO.setMesSubject(configSaveVO.getMesSubject());
            configDO.setMesTitle(configSaveVO.getMesTitle());
            configDO.setExternalTemplateId(configSaveVO.getExternalTemplateId());
            configDO.setExternalSignName(configSaveVO.getExternalSignName());
            configDO.setMesText(configSaveVO.getMesText());
            configDO.setMesRichContentSign(Boolean.TRUE.equals(configSaveVO.getMesRichContentSign()));
            this.sysMsgTemplateConfigRepoProc.save((Serializable)((Object)configDO));
            receivers = this.convertReceiver2DO(configSaveVO.getDefaultReceiver());
            if (!CollUtil.isNotEmpty(receivers)) continue;
            for (SysMsgTemplateReceiverDO receiver : receivers) {
                receiver.setTemplateId(tid);
                receiver.setTemplateConfigId(configDO.getId());
            }
            this.sysMsgTemplateReceiverRepoProc.save(receivers);
        }
    }

    private List<SysMsgTemplateReceiverDO> convertReceiver2DO(DefaultReceiverVO receiverVO) {
        SysMsgTemplateReceiverDO receiverDO;
        int i;
        if (receiverVO == null) {
            return Collections.emptyList();
        }
        ArrayList<SysMsgTemplateReceiverDO> receivers = new ArrayList<SysMsgTemplateReceiverDO>();
        if (CollUtil.isNotEmpty(receiverVO.getUsers())) {
            i = 0;
            for (IdNameParam user : receiverVO.getUsers()) {
                if (user.getId() == null) continue;
                receiverDO = new SysMsgTemplateReceiverDO();
                receiverDO.setReceiverType(MsgTemplateReceiverEnum.USER.name());
                receiverDO.setReceiverId(user.getId());
                receiverDO.setSortNo(i++);
                receivers.add(receiverDO);
            }
        }
        if (CollUtil.isNotEmpty(receiverVO.getRoles())) {
            i = 0;
            for (IdNameParam role : receiverVO.getRoles()) {
                if (role.getId() == null) continue;
                receiverDO = new SysMsgTemplateReceiverDO();
                receiverDO.setReceiverType(MsgTemplateReceiverEnum.ROLE.name());
                receiverDO.setReceiverId(role.getId());
                receiverDO.setSortNo(i++);
                receivers.add(receiverDO);
            }
        }
        return receivers;
    }

    private List<SysMsgTemplateConfigVO> getTemplateConfigList(SysMsgTemplateDO sysMsgTemplateDO) {
        List<SysMsgTemplateConfigDO> configList = this.sysMsgTemplateConfigRepoProc.listByTemplateId(sysMsgTemplateDO.getId());
        if (configList.isEmpty()) {
            return Collections.emptyList();
        }
        HashMap<Long, DefaultReceiverVO> receiverMap = new HashMap<Long, DefaultReceiverVO>(this.getTemplateReceiver(sysMsgTemplateDO.getId()));
        return configList.stream().map(t -> {
            SysMsgTemplateConfigVO config = SysMsgTemplateConfigConvert.INSTANCE.doToVo((SysMsgTemplateConfigDO)((Object)t));
            config.setDefaultReceiver(receiverMap.computeIfAbsent(t.getId(), configId -> this.emptyDefaultReceiver()));
            return config;
        }).collect(Collectors.toList());
    }

    private DefaultReceiverVO emptyDefaultReceiver() {
        DefaultReceiverVO defaultReceiverVO = new DefaultReceiverVO();
        defaultReceiverVO.setUsers(Collections.emptyList());
        defaultReceiverVO.setRoles(Collections.emptyList());
        return defaultReceiverVO;
    }

    private Map<Long, DefaultReceiverVO> getTemplateReceiver(long templateId) {
        List<MsgTemplateReceiverBO> receiverDoList = this.sysMsgTemplateReceiverRepoProc.listByTemplateId(templateId);
        if (receiverDoList.isEmpty()) {
            return Collections.emptyMap();
        }
        Set<Long> userIds = receiverDoList.stream().filter(t -> MsgTemplateReceiverEnum.USER.name().equals(t.getReceiverType())).map(MsgTemplateReceiverBO::getReceiverId).collect(Collectors.toSet());
        Map userMap = userIds.isEmpty() ? Collections.emptyMap() : ((List)this.userQueryService.queryUserName(userIds).computeData()).stream().collect(Collectors.toMap(IdNameParam::getId, t -> t, (t1, t2) -> t1));
        Set<Long> roleIds = receiverDoList.stream().filter(t -> MsgTemplateReceiverEnum.ROLE.name().equals(t.getReceiverType())).map(MsgTemplateReceiverBO::getReceiverId).collect(Collectors.toSet());
        Map roleMap = roleIds.isEmpty() ? Collections.emptyMap() : ((List)this.roleQueryService.listCodeNamesById(roleIds).computeData()).stream().map(t -> new IdNameParam(t.getId(), t.getName())).collect(Collectors.toMap(IdNameParam::getId, t -> t, (t1, t2) -> t1));
        Set<Long> employeeIds = receiverDoList.stream().filter(t -> MsgTemplateReceiverEnum.EMPLOYEE.name().equals(t.getReceiverType())).map(MsgTemplateReceiverBO::getReceiverId).collect(Collectors.toSet());
        Map employeeMap = employeeIds.isEmpty() ? Collections.emptyMap() : ((List)this.employeeQueryService.queryCodeName(employeeIds).computeData()).stream().map(t -> new IdNameParam(t.getId(), t.getName())).collect(Collectors.toMap(IdNameParam::getId, t -> t, (t1, t2) -> t1));
        return receiverDoList.stream().collect(Collectors.groupingBy(MsgTemplateReceiverBO::getTemplateConfigId, Collectors.collectingAndThen(Collectors.toList(), receivers -> {
            DefaultReceiverVO defaultReceiverVO = new DefaultReceiverVO();
            defaultReceiverVO.setUsers(new ArrayList<IdNameParam>());
            defaultReceiverVO.setRoles(new ArrayList<IdNameParam>());
            for (MsgTemplateReceiverBO receiverDO : receivers) {
                if (MsgTemplateReceiverEnum.USER.name().equals(receiverDO.getReceiverType())) {
                    defaultReceiverVO.getUsers().add(new IdNameParam(receiverDO.getReceiverId(), userMap.computeIfAbsent(receiverDO.getReceiverId(), k -> new IdNameParam()).getName()));
                    continue;
                }
                if (MsgTemplateReceiverEnum.ROLE.name().equals(receiverDO.getReceiverType())) {
                    defaultReceiverVO.getRoles().add(new IdNameParam(receiverDO.getReceiverId(), roleMap.computeIfAbsent(receiverDO.getReceiverId(), k -> new IdNameParam()).getName()));
                    continue;
                }
                log.error("\u4e0d\u652f\u6301\u7684\u7c7b\u578b\uff1a{}", (Object)receiverDO.getReceiverType());
            }
            return defaultReceiverVO;
        })));
    }

    private Set<Long> getTemplateReceiverUserIds(long templateId, long configId) {
        List<MsgTemplateReceiverBO> receiverDoList = this.sysMsgTemplateReceiverRepoProc.listByTemplateIdAndConfigId(templateId, configId);
        if (receiverDoList.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<Long> userIds = new HashSet<Long>();
        HashSet<Long> employeeIds = new HashSet<Long>();
        HashSet<Long> roleIds = new HashSet<Long>();
        for (MsgTemplateReceiverBO receiverBO : receiverDoList) {
            if (MsgTemplateReceiverEnum.USER.name().equals(receiverBO.getReceiverType())) {
                userIds.add(receiverBO.getReceiverId());
                continue;
            }
            if (MsgTemplateReceiverEnum.EMPLOYEE.name().equals(receiverBO.getReceiverType())) {
                employeeIds.add(receiverBO.getReceiverId());
                continue;
            }
            if (!MsgTemplateReceiverEnum.ROLE.name().equals(receiverBO.getReceiverType())) continue;
            roleIds.add(receiverBO.getReceiverId());
        }
        if (!employeeIds.isEmpty()) {
            Collection<Long> employeeUserIds = this.employeeRepoProc.getUserIdsIgnoreNoUser(employeeIds).values();
            userIds.addAll(employeeUserIds);
        }
        if (!roleIds.isEmpty()) {
            Set<Long> roleUserIds = this.userRoleRepoProc.getUserIdsByRole(roleIds);
            userIds.addAll(roleUserIds);
        }
        return userIds;
    }

    public SysMsgTemplateServiceImpl(EmployeeRepoProc employeeRepoProc, UserRoleRepoProc userRoleRepoProc, SysMsgTemplateRepository sysMsgTemplateRepository, SysMsgTemplateRepoProc sysMsgTemplateRepoProc, SysMsgTemplateConfigRepository sysMsgTemplateConfigRepository, SysMsgTemplateConfigRepoProc sysMsgTemplateConfigRepoProc, SysMsgTemplateReceiverRepoProc sysMsgTemplateReceiverRepoProc, SysMsgSendCommonService sysMsgSendCommonService, UserQueryService userQueryService, RoleQueryService roleQueryService, EmployeeQueryService employeeQueryService, TenantOrgDataIsolateProvider tenantOrgDataIsolateProvider) {
        this.employeeRepoProc = employeeRepoProc;
        this.userRoleRepoProc = userRoleRepoProc;
        this.sysMsgTemplateRepository = sysMsgTemplateRepository;
        this.sysMsgTemplateRepoProc = sysMsgTemplateRepoProc;
        this.sysMsgTemplateConfigRepository = sysMsgTemplateConfigRepository;
        this.sysMsgTemplateConfigRepoProc = sysMsgTemplateConfigRepoProc;
        this.sysMsgTemplateReceiverRepoProc = sysMsgTemplateReceiverRepoProc;
        this.sysMsgSendCommonService = sysMsgSendCommonService;
        this.userQueryService = userQueryService;
        this.roleQueryService = roleQueryService;
        this.employeeQueryService = employeeQueryService;
        this.tenantOrgDataIsolateProvider = tenantOrgDataIsolateProvider;
    }
}

