/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.modules.orgtree.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.modules.orgtree.common.OrgUdcEnum;
import com.elitescloud.cloudt.system.modules.orgtree.common.UtilEnum;
import com.elitescloud.cloudt.system.modules.orgtree.convert.OrgBuTreeConvert;
import com.elitescloud.cloudt.system.modules.orgtree.convert.OrgTreeConvert;
import com.elitescloud.cloudt.system.modules.orgtree.model.OrgBuTreeDDTO;
import com.elitescloud.cloudt.system.modules.orgtree.model.OrgBuTreeDTO;
import com.elitescloud.cloudt.system.modules.orgtree.model.OrgBuTreeDetailDTO;
import com.elitescloud.cloudt.system.modules.orgtree.model.OrgBuTreePagingDTO;
import com.elitescloud.cloudt.system.modules.orgtree.model.entity.OrgBuTreeDO;
import com.elitescloud.cloudt.system.modules.orgtree.model.param.OrgBuTreePagingParam;
import com.elitescloud.cloudt.system.modules.orgtree.model.param.OrgBuTreeParam;
import com.elitescloud.cloudt.system.modules.orgtree.model.param.OrgBuTreeSaveParam;
import com.elitescloud.cloudt.system.modules.orgtree.model.param.OrgBuTreeStatusParam;
import com.elitescloud.cloudt.system.modules.orgtree.model.param.OrgBuTreeVListParam;
import com.elitescloud.cloudt.system.modules.orgtree.model.param.OrgBuTreeVPagingParam;
import com.elitescloud.cloudt.system.modules.orgtree.service.OrgBuTreeDDomainService;
import com.elitescloud.cloudt.system.modules.orgtree.service.OrgBuTreeDomainService;
import com.elitescloud.cloudt.system.modules.orgtree.service.OrgBuTreeVersionDomainService;
import com.elitescloud.cloudt.system.modules.orgtree.service.repo.MultiOrgTreeRepoProc;
import com.elitescloud.cloudt.system.modules.orgtree.service.repo.OrgBuTreeDRepo;
import com.elitescloud.cloudt.system.modules.orgtree.service.repo.OrgBuTreeRepo;
import com.elitescloud.cloudt.system.modules.orgtree.service.repo.OrgBuTreeRepoProc;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class OrgBuTreeDomainServiceImpl
implements OrgBuTreeDomainService {
    private final OrgBuTreeRepo orgBuTreeRepo;
    private final OrgBuTreeDRepo orgBuTreeDRepo;
    private final OrgBuTreeRepoProc orgBuTreeRepoProc;
    private final MultiOrgTreeRepoProc multiOrgTreeRepoProc;
    private final OrgBuTreeDDomainService orgBuTreeDService;
    private final OrgBuTreeVersionDomainService orgBuTreeVersionService;

    @Override
    @CacheEvict(cacheNames={"ORG_BU_TREE"}, key="'BU_TREE_ID_' + #param.id", condition="#param.id != null && !#param.id.isEmpty()")
    @Transactional(rollbackFor={Exception.class})
    public Long orgBuTreeSaveOrUpdate(OrgBuTreeSaveParam param) {
        OrgBuTreeDO orgBuTreeDO;
        if ("default".equals(param.getBuTreeCode())) {
            throw new BusinessException("default\u662f\u5185\u7f6e\u7f16\u7801\uff0c\u4e0d\u53ef\u7528");
        }
        if (StringUtils.isNotBlank((CharSequence)param.getId())) {
            Long id = Long.valueOf(param.getId());
            if (this.orgBuTreeRepo.existsByBuTreeCodeAndNowVersionAndIdNot(param.getBuTreeCode(), param.getNowVersion(), id)) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u7ec4\u7ec7\u6811\u7f16\u53f7:" + param.getBuTreeCode() + "\uff0c\u5df2\u5b58\u5728\uff0c\u8bf7\u52ff\u91cd\u590d\u6dfb\u52a0");
            }
            Optional optional = this.orgBuTreeRepo.findById(id);
            if (optional.isEmpty()) {
                throw new BusinessException("\u7ec4\u7ec7\u6811id\uff1a" + param.getId() + ", \u4e0d\u5b58\u5728");
            }
            orgBuTreeDO = (OrgBuTreeDO)optional.get();
            OrgBuTreeConvert.INSTANCE.updateDoFromSaveParam(param, orgBuTreeDO);
        } else {
            if (this.orgBuTreeRepo.existsByBuTreeCode(param.getBuTreeCode())) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u7ec4\u7ec7\u6811\u7f16\u53f7:" + param.getBuTreeCode() + "\uff0c\u5df2\u5b58\u5728\uff0c\u8bf7\u52ff\u91cd\u590d\u6dfb\u52a0");
            }
            orgBuTreeDO = OrgBuTreeConvert.INSTANCE.saveParamToDo(param);
        }
        this.orgBuTreeRepo.save(orgBuTreeDO);
        return orgBuTreeDO.getId();
    }

    @Override
    public OrgBuTreeDetailDTO getOrgBuTreeDetailById(Long id) {
        OrgBuTreeDetailDTO orgBuTreeDetailVO = this.orgBuTreeRepoProc.findBuTreeDetailById(id);
        if (ObjectUtil.isNotNull((Object)orgBuTreeDetailVO)) {
            List<OrgBuTreeDDTO> orgBuTreeDVOList = this.orgBuTreeVersionService.getOrgBuTreeDFromSystem(id, UtilEnum.CODE_TYPE.getValue(), null);
            orgBuTreeDetailVO.setOrgBuTreeDVOList(orgBuTreeDVOList);
        }
        return orgBuTreeDetailVO;
    }

    @Override
    @SysCodeProc
    public PagingVO<OrgBuTreePagingDTO> queryOrgBuTreeByParams(OrgBuTreePagingParam param) {
        return this.orgBuTreeRepoProc.searchByParams(param);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateStatus(OrgBuTreeStatusParam param) {
        if (CollectionUtils.isEmpty(param.getIds())) {
            return;
        }
        List<Long> ids = param.getIds().stream().distinct().filter(Objects::nonNull).map(Long::valueOf).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        if (StringUtils.isBlank((CharSequence)param.getBuTreeStatus())) {
            return;
        }
        this.orgBuTreeRepoProc.updateStatusByIds(ids, param.getBuTreeStatus());
    }

    @Override
    public List<OrgBuTreeDTO> findOrgBuTreeDTOByParam(OrgBuTreeParam param) {
        return this.orgBuTreeRepoProc.findOrgBuTreeVoByParam(param);
    }

    @Override
    public PagingVO<OrgBuTreeDTO> getBuTreePagingByParam(OrgBuTreeVPagingParam param) {
        return this.orgBuTreeRepoProc.getBuTreePagingByParam(param);
    }

    @Override
    public Boolean getCreateNewVersionFlag(String buTreeCode) {
        List<OrgBuTreeDTO> buTreeVersionByBuTreeCode = this.orgBuTreeRepoProc.getBuTreeListByBuTreeCode(OrgBuTreeVListParam.builder().buTreeCode(buTreeCode).build());
        Map collect = buTreeVersionByBuTreeCode.stream().collect(HashMap::new, (m, v) -> m.put(Integer.valueOf(v.getNowVersion()), v.getBuTreeStatus()), HashMap::putAll);
        Optional max = collect.keySet().stream().max(Integer::compareTo);
        if (max.isPresent()) {
            String status = (String)collect.get(max.get());
            return !OrgUdcEnum.ORG_BUTREE_STATUS_DRAFT.getUdcVal().equals(status);
        }
        return true;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBuTreeById(Long id) {
        Optional byId = this.orgBuTreeRepo.findById(id);
        if (byId.isPresent()) {
            OrgBuTreeDO buTreeDO = (OrgBuTreeDO)byId.get();
            if (!OrgUdcEnum.ORG_BUTREE_STATUS_DRAFT.getUdcVal().equals(buTreeDO.getBuTreeStatus())) {
                throw new BusinessException("\u4ec5\u8349\u7a3f\u72b6\u6001\u7684\u7ec4\u7ec7\u6811\u53ef\u4ee5\u5220\u9664");
            }
        } else {
            throw new BusinessException("\u7ec4\u7ec7\u6811\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u6570\u636e");
        }
        this.orgBuTreeRepo.deleteById(id);
        this.orgBuTreeDRepo.deleteByBuTreeId(id);
        this.multiOrgTreeRepoProc.deleteEmployeeOfTree(id);
    }

    @Override
    public OrgBuTreeDTO findByBuTreeCodeAndNowVersion(String buTreeCode, String nowVersion) {
        Optional<OrgBuTreeDO> result = this.orgBuTreeRepo.findByBuTreeCodeAndNowVersion(buTreeCode, nowVersion);
        if (result.isPresent()) {
            OrgBuTreeDO orgBuTreeDO = result.get();
            return OrgTreeConvert.INSTANCE.doToDTO(orgBuTreeDO);
        }
        return null;
    }

    public OrgBuTreeDomainServiceImpl(OrgBuTreeRepo orgBuTreeRepo, OrgBuTreeDRepo orgBuTreeDRepo, OrgBuTreeRepoProc orgBuTreeRepoProc, MultiOrgTreeRepoProc multiOrgTreeRepoProc, OrgBuTreeDDomainService orgBuTreeDService, OrgBuTreeVersionDomainService orgBuTreeVersionService) {
        this.orgBuTreeRepo = orgBuTreeRepo;
        this.orgBuTreeDRepo = orgBuTreeDRepo;
        this.orgBuTreeRepoProc = orgBuTreeRepoProc;
        this.multiOrgTreeRepoProc = multiOrgTreeRepoProc;
        this.orgBuTreeDService = orgBuTreeDService;
        this.orgBuTreeVersionService = orgBuTreeVersionService;
    }
}

