/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.provider.imports;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.extra.pinyin.PinyinUtil;
import com.elitescloud.boot.excel.common.DataImport;
import com.elitescloud.cloudt.constant.AreaType;
import com.elitescloud.cloudt.system.provider.imports.param.ImportAreaBO;
import com.elitescloud.cloudt.system.service.AreaMngService;
import com.elitescloud.cloudt.system.service.AreaQueryService;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.function.Predicate;
import javax.validation.constraints.NotBlank;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AreaImportProvider
implements DataImport<ImportAreaBO> {
    private static final String COUNTRY_CHINA_CODE = "CN";
    @Autowired
    private AreaMngService mngService;
    @Autowired
    private AreaQueryService queryService;

    public String getTmplCode() {
        return "system_area_import";
    }

    public List<String> executeImport(List<ImportAreaBO> dataList, int startRowIndex) {
        ArrayList<String> errorMsg = new ArrayList<String>(dataList.size());
        int i = 0;
        HashSet<String> existsCode = new HashSet<String>();
        for (ImportAreaBO importAreaBO : dataList) {
            try {
                importAreaBO = this.fillAreaInfo(importAreaBO, t -> existsCode.contains(t) || Boolean.TRUE.equals(this.queryService.existsCode((String)t).getData()));
            }
            catch (Exception e) {
                ++i;
                errorMsg.add(e.getMessage());
                continue;
            }
            importAreaBO.setSortNo(startRowIndex + i++);
            existsCode.add(importAreaBO.getCode());
            try {
                this.mngService.save(importAreaBO);
            }
            catch (Exception e) {
                errorMsg.add(e.getMessage());
            }
        }
        return errorMsg;
    }

    public ImportAreaBO fillAreaInfo(ImportAreaBO areaBO, Predicate<String> predicateExistsArea) {
        return AreaImportProvider.parseCode(areaBO.getCode(), areaBO.getName(), predicateExistsArea);
    }

    public static ImportAreaBO parseCode(@NotBlank String code, String name, Predicate<String> predicateExistsArea) {
        Assert.notBlank((CharSequence)code, (String)"\u884c\u653f\u533a\u57df\u7f16\u7801\u4e3a\u7a7a", (Object[])new Object[0]);
        code = code.trim();
        String[] codeArray = AreaImportProvider.code2Array(code);
        Assert.isTrue((codeArray.length == 3 ? 1 : 0) != 0, (String)"\u6682\u4e0d\u652f\u6301\u7684\u884c\u653f\u533a\u57df\u7f16\u7801", (Object[])new Object[0]);
        ImportAreaBO areaBO = new ImportAreaBO();
        areaBO.setCode(code);
        areaBO.setName(name.strip().replaceAll("\\u00A0", ""));
        areaBO.setPinyin(PinyinUtil.getPinyin((String)areaBO.getName()));
        if ("00".equals(codeArray[1])) {
            areaBO.setAreaType(AreaType.PROVINCE.getValue());
            areaBO.setParentCode(COUNTRY_CHINA_CODE);
            return areaBO;
        }
        if ("00".equals(codeArray[2])) {
            areaBO.setAreaType(AreaType.CITY.getValue());
            areaBO.setParentCode(codeArray[0] + "0000");
            return areaBO;
        }
        String parentCode = codeArray[0] + codeArray[1] + "00";
        if (predicateExistsArea.test(parentCode)) {
            areaBO.setParentCode(parentCode);
            areaBO.setAreaType(AreaType.AREA.getValue());
            return areaBO;
        }
        parentCode = codeArray[0] + "0000";
        if (predicateExistsArea.test(parentCode)) {
            areaBO.setParentCode(parentCode);
            areaBO.setAreaType(AreaType.CITY.getValue());
            return areaBO;
        }
        throw new IllegalArgumentException("\u672a\u77e5\u4e0a\u7ea7\u884c\u653f\u533a\u57df");
    }

    private static String[] code2Array(String code) {
        String temp;
        ArrayList<String> codeList = new ArrayList<String>();
        int subIndex = 0;
        while (!CharSequenceUtil.isBlank((CharSequence)(temp = CharSequenceUtil.sub((CharSequence)code, (int)subIndex, (int)(subIndex + 2))))) {
            subIndex += 2;
            codeList.add(temp);
        }
        return (String[])codeList.toArray(String[]::new);
    }
}

