/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.provider.job.scheduler;

import com.elitescloud.cloudt.system.provider.job.scheduler.ClearExpiredMqMessageTask;
import com.elitescloud.cloudt.system.provider.job.scheduler.ClearExpiredResourcesTask;
import com.elitescloud.cloudt.system.provider.job.scheduler.ClearExpiredSysThirdApiLogTask;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.lang.NonNull;
import org.springframework.scheduling.annotation.SchedulingConfigurer;
import org.springframework.scheduling.config.ScheduledTaskRegistrar;
import org.springframework.stereotype.Component;

@Component
public class BaseSchedulerConfigurer
implements SchedulingConfigurer {
    private static final Logger logger = LoggerFactory.getLogger(BaseSchedulerConfigurer.class);
    @Autowired
    private ClearExpiredResourcesTask clearExpiredResourcesTask;
    @Autowired
    private ClearExpiredMqMessageTask clearExpiredMqMessageTask;
    @Autowired
    private ClearExpiredSysThirdApiLogTask clearExpiredSysThirdApiLogTask;

    public void configureTasks(@NonNull ScheduledTaskRegistrar taskRegistrar) {
        taskRegistrar.addFixedRateTask(() -> {
            try {
                CompletableFuture.runAsync(() -> this.clearExpiredResourcesTask.run());
            }
            catch (Exception e) {
                logger.info("\u5220\u9664\u8fc7\u671f\u6587\u4ef6\u5f02\u5e38", (Throwable)e);
            }
        }, Duration.ofDays(2L).toMillis());
        taskRegistrar.addFixedRateTask(() -> {
            try {
                CompletableFuture.runAsync(() -> this.clearExpiredMqMessageTask.run());
            }
            catch (Exception e) {
                logger.info("\u5220\u9664\u8fc7\u671fMQ\u6d88\u606f\u5f02\u5e38", (Throwable)e);
            }
        }, Duration.ofDays(1L).toMillis());
        taskRegistrar.addCronTask(() -> {
            try {
                CompletableFuture.runAsync(() -> this.clearExpiredSysThirdApiLogTask.run());
            }
            catch (Exception e) {
                logger.info("\u5220\u9664\u8fc7\u671f\u5916\u90e8\u63a5\u53e3\u65e5\u5fd7\u5f02\u5e38", (Throwable)e);
            }
        }, "0 0 1 * * ?");
    }
}

