/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.provider.job.scheduler;

import com.elitescloud.cloudt.system.config.SystemProperties;
import com.elitescloud.cloudt.system.service.ThirdApiLogService;
import java.time.LocalDateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ClearExpiredSysThirdApiLogTask
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(ClearExpiredSysThirdApiLogTask.class);
    @Autowired
    private SystemProperties systemProperties;
    @Autowired
    private ThirdApiLogService thirdApiLogService;

    @Override
    public void run() {
        Integer keepDays = this.systemProperties.getThirdApiLog().getLogKeepDays();
        if (keepDays == null || keepDays < 1) {
            logger.info("\u4e0d\u6e05\u7406\u8fc7\u671f\u65e5\u5fd7\uff1a{}", (Object)keepDays);
            return;
        }
        LocalDateTime expiredTime = LocalDateTime.now().minusDays(keepDays.intValue());
        this.thirdApiLogService.clearExpiredLogs(expiredTime);
    }
}

