/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.provider.orgsync;

import com.elitescloud.boot.SpringContextHolder;
import com.elitescloud.boot.constant.TenantConstant;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.provider.TenantClientProvider;
import com.elitescloud.boot.redis.util.RedisUtils;
import com.elitescloud.boot.util.ObjUtil;
import com.elitescloud.cloudt.constant.SysThirdPartyAccountBusinessType;
import com.elitescloud.cloudt.system.dto.SysTenantDTO;
import com.elitescloud.cloudt.system.modules.wecom.model.AccessToken;
import com.elitescloud.cloudt.system.modules.wecom.util.WeComTool;
import com.elitescloud.cloudt.system.service.ThirdPartAccountQueryService;
import com.elitescloud.cloudt.system.service.common.constant.ThirdPartAccountType;
import com.elitescloud.cloudt.system.service.model.bo.ThirdPartAccountBO;
import java.util.concurrent.TimeUnit;
import org.springframework.util.StringUtils;

abstract class BaseWecomSync {
    BaseWecomSync() {
    }

    static String getAccessTokenOfWecom(WecomConfig cfg) {
        String tokenKey;
        RedisUtils redisUtils = (RedisUtils)SpringContextHolder.getBean(RedisUtils.class);
        String token = (String)redisUtils.get(tokenKey = "wecom:accessToken:" + cfg.corpid + ":" + cfg.corpsecret);
        if (StringUtils.hasText((String)token)) {
            return token;
        }
        AccessToken accessToken = WeComTool.getToken(cfg.corpid, cfg.corpsecret);
        if (accessToken.isSuccess()) {
            token = accessToken.getAccess_token();
            redisUtils.set(tokenKey, (Object)token, (long)(accessToken.getExpires_in() - 60), TimeUnit.SECONDS);
            return token;
        }
        throw new BusinessException("\u4f01\u4e1a\u5fae\u4fe1\u6388\u6743\u5931\u8d25," + String.valueOf(ObjUtil.defaultIfNull((Object)accessToken.getErrcode(), (Object)-1)) + (String)ObjUtil.defaultIfNull((Object)accessToken.getErrmsg(), (Object)""));
    }

    static WecomConfig getConfig() {
        SysTenantDTO tenant = ((TenantClientProvider)SpringContextHolder.getBean(TenantClientProvider.class)).getSessionTenant();
        ThirdPartAccountBO accountCfg = (ThirdPartAccountBO)((ThirdPartAccountQueryService)SpringContextHolder.getBean(ThirdPartAccountQueryService.class)).get(tenant == null ? TenantConstant.DEFAULT_TENANT_ID : tenant.getId(), ThirdPartAccountType.WECOM, SysThirdPartyAccountBusinessType.DEFAULT).computeData();
        if (accountCfg == null) {
            return null;
        }
        WecomConfig cfg = new WecomConfig((String)accountCfg.getConfigValue("corpid"), (String)accountCfg.getConfigValue("corpsecret"));
        cfg.setToken((String)accountCfg.getConfigValue("token"));
        cfg.setEncodingAesKey((String)accountCfg.getConfigValue("encodingAESKey"));
        return cfg;
    }

    static class WecomConfig {
        private final String corpid;
        private final String corpsecret;
        private String token;
        private String encodingAesKey;

        protected WecomConfig(String corpid, String corpsecret) {
            this.corpid = corpid;
            this.corpsecret = corpsecret;
        }

        public String getCorpid() {
            return this.corpid;
        }

        public String getCorpsecret() {
            return this.corpsecret;
        }

        public String getToken() {
            return this.token;
        }

        public void setToken(String token) {
            this.token = token;
        }

        public String getEncodingAesKey() {
            return this.encodingAesKey;
        }

        public void setEncodingAesKey(String encodingAesKey) {
            this.encodingAesKey = encodingAesKey;
        }
    }
}

