/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.rest;

import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.param.SysSettingQParam;
import com.elitescloud.cloudt.system.service.ISysSettingService;
import com.elitescloud.cloudt.system.vo.SysSettingVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sys/settings"})
@Api(value="\u7cfb\u7edf\u914d\u7f6e\u7ef4\u62a4", tags={"\u7cfb\u7edf\u914d\u7f6e\u7ef4\u62a4"})
public class SysSettingController {
    private ISysSettingService sysSettingService;

    @Autowired
    public void setSysSettingService(ISysSettingService sysSettingService) {
        this.sysSettingService = sysSettingService;
    }

    @PostMapping(value={"/q"})
    @ApiOperation(value="\u68c0\u7d22\u914d\u7f6e\u4fe1\u606f")
    public ApiResult<?> search(@RequestBody SysSettingQParam param) {
        PagingVO ret = this.sysSettingService.search(param);
        return ApiResult.ok((Object)ret);
    }

    @GetMapping(value={"/byid/{id}"})
    @ApiOperation(value="\u6839\u636e\u8bb0\u5f55ID\u83b7\u53d6\u914d\u7f6e\u8bb0\u5f55")
    public ApiResult<?> oneById(@PathVariable Long id) {
        SysSettingVO ret = this.sysSettingService.oneById(id);
        if (Objects.isNull(ret)) {
            return ApiResult.fail((ApiCode)ApiCode.NOT_FOUND);
        }
        return ApiResult.ok((Object)ret);
    }

    @GetMapping(value={"/byno/{no}"})
    @ApiOperation(value="\u6839\u636e\u914d\u7f6e\u7f16\u7801\u83b7\u53d6\u914d\u7f6e\u8bb0\u5f55")
    public ApiResult<?> oneById(@PathVariable String no) {
        SysSettingVO ret = this.sysSettingService.oneByNo(no);
        if (Objects.isNull(ret)) {
            return ApiResult.fail((ApiCode)ApiCode.NOT_FOUND);
        }
        return ApiResult.ok((Object)ret);
    }

    @PostMapping
    @ApiOperation(value="\u521b\u5efa\u914d\u7f6e")
    public ApiResult<?> create(@RequestBody @Valid SysSettingVO setting) {
        Long id = this.sysSettingService.create(setting);
        return ApiResult.ok((Object)id);
    }

    @PutMapping
    @ApiOperation(value="\u66f4\u6539\u914d\u7f6e\u503c")
    public ApiResult<?> update(@RequestBody SysSettingVO setting) {
        this.sysSettingService.update(setting);
        return ApiResult.ok();
    }

    @DeleteMapping(value={"/byids"})
    @ApiOperation(value="\u6839\u636e\u8bb0\u5f55ID\u6279\u91cf\u5220\u9664\u914d\u7f6e")
    public ApiResult<?> removeByIds(@RequestBody List<Long> ids) {
        this.sysSettingService.removeByIds(ids);
        return ApiResult.ok();
    }

    @DeleteMapping(value={"/bynos"})
    @ApiOperation(value="\u6839\u636e\u914d\u7f6e\u7f16\u7801\uff0c\u6279\u91cf\u5220\u9664\u914d\u7f6e")
    public ApiResult<?> removeByNos(@RequestBody List<String> nos) {
        this.sysSettingService.removeByNos(nos);
        return ApiResult.ok();
    }
}

