/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.rest;

import com.elitescloud.cloudt.common.base.ApiResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import javax.validation.constraints.NotBlank;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.crypto.encrypt.TextEncryptor;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/mng/sys/support"}, produces={"application/json"})
@Validated
@Api(tags={"\u7cfb\u7edf\u5b89\u5168"})
public class SystemSupportController {
    private static final String ENCRYPTOR_PREFIX = "{cipher}";
    @Autowired(required=false)
    private TextEncryptor textEncryptor;

    @GetMapping(value={"/encrypt"})
    @ApiImplicitParam(name="plainText", value="\u52a0\u5bc6\u5185\u5bb9", required=true)
    @ApiOperation(value="\u52a0\u5bc6\u5b57\u7b26\u4e32")
    public ApiResult<String> encrypt(@NotBlank(message="\u52a0\u5bc6\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a") @RequestParam(name="plainText") @NotBlank(message="\u52a0\u5bc6\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a") String plainText) {
        if (this.textEncryptor == null) {
            return ApiResult.fail((String)"\u52a0\u5bc6\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        String ciphertext = this.textEncryptor.encrypt(plainText);
        return ApiResult.ok((Object)(ENCRYPTOR_PREFIX + ciphertext));
    }

    @ApiOperation(value="\u89e3\u5bc6\u5b57\u7b26\u4e32")
    @PostMapping(value={"/decrypt"})
    public ApiResult<String> decrypt(@RequestBody String ciphertext) {
        if (this.textEncryptor == null) {
            return ApiResult.fail((String)"\u89e3\u5bc6\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        if (ciphertext.startsWith(ENCRYPTOR_PREFIX)) {
            ciphertext = ciphertext.substring(ENCRYPTOR_PREFIX.length());
        }
        String plainText = this.textEncryptor.decrypt(ciphertext);
        return ApiResult.ok((Object)plainText);
    }
}

