/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.rpc;

import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.constant.UserSourceType;
import com.elitescloud.cloudt.system.param.SysPasswordUpdate;
import com.elitescloud.cloudt.system.param.SysUserBatchSwitchParam;
import com.elitescloud.cloudt.system.param.SysUserNewParam;
import com.elitescloud.cloudt.system.param.SysUserQueryParam;
import com.elitescloud.cloudt.system.param.SysUserUpdateParam;
import com.elitescloud.cloudt.system.provider.SysUserRpcService;
import com.elitescloud.cloudt.system.provider.dto.SysUserRpcDTO;
import com.elitescloud.cloudt.system.provider.param.SysUserRpcDtoParam;
import com.elitescloud.cloudt.system.provider.param.SysUserRpcSaveParam;
import com.elitescloud.cloudt.system.service.UserMngService;
import com.elitescloud.cloudt.system.service.UserQueryService;
import com.elitescloud.cloudt.system.service.old.ISysUserService;
import com.elitescloud.cloudt.system.vo.SysPermissionVO;
import com.elitescloud.cloudt.system.vo.SysRoleVO;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.elitescloud.cloudt.system.vo.SysUserVO;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rpc/cloudt/system/user"}, produces={"application/json"})
public class SysUserRpcServiceImpl
implements SysUserRpcService {
    private ISysUserService sysUserService;
    private UserMngService userMngService;
    private UserQueryService userQueryService;

    public PagingVO<SysUserVO> search(SysUserQueryParam param) {
        return this.sysUserService.search(param);
    }

    public SysUserDTO getById(Long id) {
        return this.sysUserService.getById(id);
    }

    public List<SysUserVO> getByIds(List<Long> ids) {
        return this.sysUserService.getByIds(ids);
    }

    public Long create(SysUserNewParam user) {
        return this.sysUserService.create(user, null);
    }

    public Long create(SysUserNewParam user, String password) {
        return this.sysUserService.create(user, password);
    }

    public void update(SysUserUpdateParam user) {
        this.sysUserService.update(user);
    }

    public Boolean switchUserStatus(Long id) {
        return this.sysUserService.switchUserStatus(id);
    }

    public void batchSwitchUserStatus(SysUserBatchSwitchParam param) {
        this.sysUserService.batchSwitchUserStatus(param);
    }

    public Set<SysRoleVO> listRolesByUsername(String username) {
        return this.sysUserService.listRolesByUsername(username);
    }

    public SysUserDTO current() {
        return this.sysUserService.current();
    }

    public List<SysPermissionVO> currentMenu() {
        return Collections.emptyList();
    }

    public Set<SysPermissionVO> currentActions() {
        return Collections.emptySet();
    }

    public Set<SysPermissionVO> currentMenuActions(Long menuId) {
        return Collections.emptySet();
    }

    public void deleteBatch(List<Long> idList) {
        this.sysUserService.deleteBatch(idList);
    }

    public void updatePassword(SysPasswordUpdate update) {
        this.userMngService.updatePassword(update);
    }

    public void changePasswordNoSec(Long userId, String pwd) {
        this.userMngService.updatePassword(userId, pwd);
    }

    public ApiResult<String> updateUserWechatOpenid(String userName, String openid) {
        return this.sysUserService.updateUserWechatOpenid(userName, openid);
    }

    public List<SysUserRpcDTO> findUserRpcDtoByParam(SysUserRpcDtoParam param) {
        return this.sysUserService.findUserRpcDtoByParam(param);
    }

    public ApiResult<Object> sysUserAccountCreate(SysUserRpcSaveParam param) {
        if (StringUtils.isBlank((CharSequence)param.getUsername())) {
            return ApiResult.fail((ApiCode)ApiCode.BUSINESS_EXCEPTION, (String)"\u7528\u6237\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)param.getPassword())) {
            return ApiResult.fail((ApiCode)ApiCode.FAIL, (String)"\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        SysUserNewParam newUser = new SysUserNewParam();
        newUser.setUsername(param.getUsername());
        newUser.setFirstName(param.getFirstName());
        newUser.setLastName(param.getLastName());
        newUser.setMobile(param.getMobile());
        newUser.setEmail(param.getEmail());
        newUser.setEnabled(param.getEnabled());
        newUser.setOuId(param.getOuId());
        newUser.setOuCode(param.getOuCode());
        newUser.setOuName(param.getOuName());
        newUser.setRoleIds(param.getRoleIds());
        newUser.setDataRoleIds(param.getDataRoleIds());
        newUser.setFlowRoleIds(param.getFlowRoleIds());
        newUser.setSourceType(CharSequenceUtil.blankToDefault((CharSequence)param.getSourceType(), (String)UserSourceType.OTHER.getValue()));
        newUser.setTerminals(param.getTerminals());
        newUser.setTenantId(param.getTenantId());
        Long userId = this.sysUserService.create(newUser, param.getPassword());
        return ApiResult.ok((Object)userId);
    }

    public ApiResult<Long> sysUserCreate(SysUserNewParam user, String password) {
        return ApiResult.ok((Object)this.sysUserService.create(user, password));
    }

    public ApiResult<Long> getUserIdByUsername(String username) {
        Long userId = this.sysUserService.getUserIdByUsername(username);
        return ApiResult.ok((Object)userId);
    }

    public ApiResult<SysUserDTO> getUserByUsername(String username) {
        SysUserDTO user = this.userQueryService.getUserByUsername(username);
        return ApiResult.ok((Object)user);
    }

    public ApiResult<SysUserDTO> getUserByMobile(String mobile) {
        SysUserDTO user = this.userQueryService.getUserByMobile(mobile);
        return ApiResult.ok((Object)user);
    }

    public ApiResult<SysUserDTO> getUserByEmail(String email) {
        SysUserDTO user = this.userQueryService.getUserByEmail(email);
        return ApiResult.ok((Object)user);
    }

    public ApiResult<SysUserDTO> getUserById(String userId) {
        SysUserDTO user = this.userQueryService.getUserById(Long.parseLong(userId));
        return ApiResult.ok((Object)user);
    }

    public ApiResult<SysUserDTO> getUserByWechatOpenid(String wechatOpenid) {
        SysUserDTO user = this.userQueryService.getUserByWechatOpenid(wechatOpenid);
        return ApiResult.ok((Object)user);
    }

    public ApiResult<SysUserDTO> getUserByAccount(String account) {
        SysUserDTO user = this.userQueryService.getUserByAccount(account);
        return ApiResult.ok((Object)user);
    }

    public Boolean existsByUserName(String userName) {
        return (Boolean)this.userQueryService.existsUsername(userName).getData();
    }

    public Boolean existsByUserMobile(String mobile) {
        return (Boolean)this.userQueryService.existsMobile(mobile).getData();
    }

    @Autowired
    public void setSysUserService(ISysUserService sysUserService) {
        this.sysUserService = sysUserService;
    }

    @Autowired
    public void setUserMngService(UserMngService userMngService) {
        this.userMngService = userMngService;
    }

    @Autowired
    public void setUserQueryService(UserQueryService userQueryService) {
        this.userQueryService = userQueryService;
    }
}

