/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.rpc.extend;

import cn.hutool.core.collection.CollUtil;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.dto.req.SysAreaNamesQueryDTO;
import com.elitescloud.cloudt.system.dto.req.SysAreaQueryDTO;
import com.elitescloud.cloudt.system.dto.resp.SysAreaNamesRespDTO;
import com.elitescloud.cloudt.system.dto.resp.SysAreaRespDTO;
import com.elitescloud.cloudt.system.provider.extend.SysAreaRpcService;
import com.elitescloud.cloudt.system.service.AreaQueryService;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rpc/cloudt/system/area"}, produces={"application/json"})
public class SysAreaRpcServiceImpl
implements SysAreaRpcService {
    private AreaQueryService queryService;

    public ApiResult<SysAreaRespDTO> getByAreaCode(String areaCode) {
        ApiResult<List<SysAreaRespDTO>> result = this.queryService.listByAreaCodes(Set.of(areaCode));
        if (result.isFailed()) {
            return ApiResult.fail((String)result.getMsg());
        }
        return ApiResult.ok(CollUtil.isEmpty((Collection)((Collection)result.getData())) ? null : (SysAreaRespDTO)((List)result.getData()).get(0));
    }

    public ApiResult<List<SysAreaRespDTO>> listByAreaCodes(Set<String> areaCodes) {
        return this.queryService.listByAreaCodes(areaCodes);
    }

    public ApiResult<List<SysAreaRespDTO>> listByParentAreaCode(String areaCode) {
        return this.queryService.listByParentAreaCode(areaCode);
    }

    public ApiResult<List<SysAreaRespDTO>> queryList(SysAreaQueryDTO queryDTO) {
        return this.queryService.queryList(queryDTO);
    }

    public ApiResult<List<SysAreaNamesRespDTO>> queryListByNames(SysAreaNamesQueryDTO queryDTO) {
        return this.queryService.queryListByNames(queryDTO);
    }

    public ApiResult<List<SysAreaRespDTO>> queryAll(Boolean tree) {
        return this.queryService.queryAll(tree);
    }

    @Autowired
    public void setQueryService(AreaQueryService queryService) {
        this.queryService = queryService;
    }
}

