/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.rpc.org;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.dto.SysEmployeeBasicDTO;
import com.elitescloud.cloudt.system.dto.SysEmployeeDetailDTO;
import com.elitescloud.cloudt.system.dto.req.EmployeePageQueryDTO;
import com.elitescloud.cloudt.system.dto.req.EmployeeQueryDTO;
import com.elitescloud.cloudt.system.dto.req.EmployeeUpsertDTO;
import com.elitescloud.cloudt.system.dto.resp.EmployeePageRespDTO;
import com.elitescloud.cloudt.system.dto.resp.EmployeeUnderlingDTO;
import com.elitescloud.cloudt.system.provider.org.EmployeeRpcService;
import com.elitescloud.cloudt.system.service.EmployeeMngService;
import com.elitescloud.cloudt.system.service.EmployeeQueryService;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rpc/cloudt/system/employee"}, produces={"application/json"})
public class EmployeeRpcServiceImpl
implements EmployeeRpcService {
    private static final Logger log = LogManager.getLogger(EmployeeRpcServiceImpl.class);
    private EmployeeQueryService employeeQueryService;
    private EmployeeMngService employeeMngService;

    public ApiResult<String> upsert(EmployeeUpsertDTO upsertDTO) {
        return this.employeeMngService.upsert(upsertDTO);
    }

    public ApiResult<List<String>> upsertBatch(List<EmployeeUpsertDTO> upsertDTOList) {
        ArrayList<String> codeList = new ArrayList<String>(128);
        for (EmployeeUpsertDTO upsertDTO : upsertDTOList) {
            try {
                ApiResult<String> result = this.employeeMngService.upsert(upsertDTO);
                codeList.add((String)result.getData());
            }
            catch (Exception e) {
                log.error("\u6dfb\u52a0\u5458\u5de5\u5f02\u5e38\uff1a", (Throwable)e);
                codeList.add(null);
            }
        }
        return ApiResult.ok(codeList);
    }

    public ApiResult<List<String>> checkBatch(List<EmployeeUpsertDTO> upsertDTOList) {
        return this.employeeMngService.checkForUpsert(upsertDTOList);
    }

    public ApiResult<String> updateEnabledByCode(String code, Boolean enabled) {
        return this.employeeMngService.updateEnabledByCode(code, enabled);
    }

    public ApiResult<Long> updateMobile(Long id, String mobile, Boolean updateUser) {
        return this.employeeMngService.updateMobile(id, mobile, updateUser);
    }

    public ApiResult<Long> updateEmail(Long id, String email, Boolean updateUser) {
        return this.employeeMngService.updateEmail(id, email, updateUser);
    }

    public ApiResult<SysEmployeeBasicDTO> getById(Long id) {
        return this.employeeQueryService.getById(id);
    }

    public ApiResult<String> getCode(Long id) {
        return this.employeeQueryService.getCode(id);
    }

    public ApiResult<Long> getUserId(Long id) {
        return this.employeeQueryService.getUserId(id);
    }

    public ApiResult<String> getUsername(Long id) {
        return this.employeeQueryService.getUsername(id);
    }

    public ApiResult<SysEmployeeBasicDTO> getByCode(String code) {
        return this.employeeQueryService.getByCode(code);
    }

    public ApiResult<SysEmployeeBasicDTO> getByUsername(String username) {
        return this.employeeQueryService.getByUsername(username);
    }

    public ApiResult<SysEmployeeBasicDTO> getByUserId(Long userId) {
        return this.employeeQueryService.getByUserId(userId);
    }

    public ApiResult<SysEmployeeDetailDTO> getDetailById(Long id) {
        return this.employeeQueryService.getDetailById(id);
    }

    public ApiResult<SysEmployeeDetailDTO> getDetailByCode(String code) {
        return this.employeeQueryService.getDetailByCode(code);
    }

    public ApiResult<SysEmployeeDetailDTO> getDetailByUserId(Long userId) {
        return this.employeeQueryService.getDetailByUserId(userId);
    }

    public ApiResult<SysEmployeeDetailDTO> getDetailByUsername(String username) {
        return this.employeeQueryService.getDetailByUsername(username);
    }

    public ApiResult<List<SysEmployeeDetailDTO>> getDetailListByCode(Set<String> codes) {
        return this.employeeQueryService.getDetailListByCode(codes);
    }

    public ApiResult<List<EmployeeUnderlingDTO>> getUnderlingByCode(String code, Boolean cascade, Boolean enabled) {
        return this.employeeQueryService.getUnderlingByCode(code, cascade, enabled);
    }

    public ApiResult<List<SysEmployeeBasicDTO>> queryList(EmployeeQueryDTO queryDTO) {
        return this.employeeQueryService.queryList(queryDTO);
    }

    public ApiResult<PagingVO<EmployeePageRespDTO>> queryByPage(EmployeePageQueryDTO queryDTO) {
        return this.employeeQueryService.queryByPage(queryDTO);
    }

    public ApiResult<Boolean> bindSalesman(Long id, String salesmanId) {
        return this.employeeMngService.bindSalesman(id, salesmanId);
    }

    public ApiResult<List<String>> getSalesmanId(Long id) {
        return this.employeeQueryService.getSalesmanId(id);
    }

    public ApiResult<List<String>> getSalesmanIdByUserId(Long userId) {
        return this.employeeQueryService.getSalesmanIdByUserId(userId);
    }

    @Autowired
    public void setEmployeeQueryService(EmployeeQueryService employeeQueryService) {
        this.employeeQueryService = employeeQueryService;
    }

    @Autowired
    public void setEmployeeMngService(EmployeeMngService employeeMngService) {
        this.employeeMngService = employeeMngService;
    }
}

