/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.service;

import cn.hutool.core.collection.CollUtil;
import com.elitescloud.cloudt.system.common.AuthMethod;
import com.elitescloud.cloudt.system.common.EnumValues;
import com.elitescloud.cloudt.system.service.AuthMethodService;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class AuthMethodServiceImpl
implements AuthMethodService {
    private static final Logger log = LoggerFactory.getLogger(AuthMethodServiceImpl.class);

    @Override
    public List<EnumValues> authMethod() {
        return Arrays.stream(AuthMethod.values()).map(name -> EnumValues.of(name.getCode(), name.getDesc())).collect(Collectors.toList());
    }

    @Override
    public Map<String, String> fromCode(List<String> authMethodCodes) {
        HashMap<String, String> authMethodNames = new HashMap<String, String>();
        if (CollUtil.isEmpty(authMethodCodes)) {
            return authMethodNames;
        }
        for (String authMethodCode : authMethodCodes) {
            authMethodNames.put(authMethodCode, AuthMethod.fromCode(authMethodCode));
        }
        return authMethodNames;
    }
}

