/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.service;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.ObjectUtil;
import com.elitescloud.boot.constant.TenantConstant;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.provider.TenantClientProvider;
import com.elitescloud.cloudt.core.annotation.TenantTransaction;
import com.elitescloud.cloudt.core.annotation.common.TenantIsolateType;
import com.elitescloud.cloudt.system.convert.InfinityApiConvert;
import com.elitescloud.cloudt.system.convert.InfinityFolderConvert;
import com.elitescloud.cloudt.system.dto.SysTenantDTO;
import com.elitescloud.cloudt.system.model.entity.InfinityApiDO;
import com.elitescloud.cloudt.system.model.entity.InfinityFolderDO;
import com.elitescloud.cloudt.system.model.vo.resp.extend.ApiQueryParamVO;
import com.elitescloud.cloudt.system.model.vo.resp.extend.ApiSaveParamVO;
import com.elitescloud.cloudt.system.model.vo.resp.extend.InfinityApiDetailVO;
import com.elitescloud.cloudt.system.model.vo.resp.extend.InfinityApiMergeVO;
import com.elitescloud.cloudt.system.model.vo.resp.extend.InfinityApiRespVO;
import com.elitescloud.cloudt.system.service.InfinityApiService;
import com.elitescloud.cloudt.system.service.repo.InfinityApiRepo;
import com.elitescloud.cloudt.system.service.repo.InfinityApiRepoProc;
import com.elitescloud.cloudt.system.service.repo.InfinityFolderRepoProc;
import com.elitescloud.cloudt.system.util.BeanUtils;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@TenantTransaction(isolateType=TenantIsolateType.TENANT)
public class InfinityApiServiceImpl
implements InfinityApiService {
    private static final Logger log = LoggerFactory.getLogger(InfinityApiServiceImpl.class);
    private final InfinityApiRepo infinityApiRepo;
    private final InfinityApiRepoProc infinityApiRepoProc;
    private final InfinityFolderRepoProc folderRepoProc;
    @Autowired
    private TenantClientProvider tenantClientProvider;

    private long currentTenantId() {
        SysTenantDTO tenant = this.tenantClientProvider.getSessionTenant();
        if (tenant == null) {
            tenant = this.tenantClientProvider.getCurrentTenant();
        }
        return tenant == null ? TenantConstant.DEFAULT_TENANT_ID : tenant.getId();
    }

    @Override
    public List<InfinityApiRespVO> infinityApiByParam(ApiQueryParamVO query) {
        List<InfinityApiRespVO> responseVO = this.infinityApiRepoProc.infinityApiByParam(query);
        Map<Long, InfinityApiRespVO> folderMap = this.queryFolderByParam(query);
        Map<Long, List<InfinityApiRespVO>> apiMap = responseVO.stream().filter(row -> row.getFolderId() != null).collect(Collectors.groupingBy(InfinityApiRespVO::getFolderId));
        responseVO.removeIf(row -> row.getFolderId() != null);
        apiMap.forEach((folderId, children) -> {
            InfinityApiRespVO curr = (InfinityApiRespVO)BeanUtils.toBean(folderMap.get(folderId), InfinityApiRespVO.class);
            children.sort(InfinityApiRespVO::compareTo);
            curr.setChildren((List<InfinityApiRespVO>)children);
            responseVO.add(curr);
            folderMap.remove(folderId);
        });
        folderMap.forEach((folderId, api) -> responseVO.add((InfinityApiRespVO)api));
        responseVO.sort(InfinityApiRespVO::compareTo);
        return responseVO;
    }

    private Map<Long, InfinityApiRespVO> queryFolderByParam(ApiQueryParamVO query) {
        List<InfinityFolderDO> folderRespVOS = this.folderRepoProc.infinityFolderByParam(query);
        List<InfinityApiRespVO> folders = InfinityFolderConvert.INSTANCE.toApiFolder(folderRespVOS);
        return folders.stream().collect(Collectors.toMap(InfinityApiRespVO::getFolderId, Function.identity()));
    }

    @Override
    public InfinityApiDetailVO infinityApiById(Long id) {
        Optional infinityApiDO = this.infinityApiRepo.findById(id);
        if (infinityApiDO.isEmpty()) {
            throw new BusinessException("Not Found Data");
        }
        return InfinityApiConvert.INSTANCE.doToVO((InfinityApiDO)infinityApiDO.get());
    }

    @Override
    public InfinityApiDetailVO infinityApiByApiCode(String apiCode) {
        InfinityApiMergeVO apiMergeVO = this.infinityApiRepoProc.findByApiCode(apiCode);
        if (ObjectUtil.isNull((Object)apiMergeVO)) {
            throw new BusinessException("Not Found Data");
        }
        return InfinityApiConvert.INSTANCE.mergeToDetailVO(apiMergeVO);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long save(ApiSaveParamVO saveParam) {
        boolean exists = this.infinityApiRepoProc.existsByCode(saveParam.getId(), saveParam.getApiCode());
        Assert.isFalse((boolean)exists, (String)"\u7f16\u7801\u5df2\u5b58\u5728", (Object[])new Object[0]);
        if (saveParam.isNew()) {
            InfinityApiDO infinityApiDO = InfinityApiConvert.INSTANCE.saveParamToDO(saveParam);
            infinityApiDO.setTenantId(this.currentTenantId());
            this.infinityApiRepo.save(infinityApiDO);
            return infinityApiDO.getId();
        }
        Optional infinityApiDO = this.infinityApiRepo.findById(saveParam.getId());
        if (infinityApiDO.isEmpty()) {
            throw new BusinessException("Not Found Data");
        }
        InfinityApiDO infinityApi = (InfinityApiDO)infinityApiDO.get();
        InfinityApiConvert.INSTANCE.saveParamMergeToDO(saveParam, infinityApi);
        infinityApi.setTenantId(this.currentTenantId());
        this.infinityApiRepo.save(infinityApi);
        return infinityApi.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateStatus(Long id, int status) {
        this.infinityApiRepoProc.updateStatus(id, status);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public long delete(List<Long> ids) {
        return this.infinityApiRepoProc.delete(ids);
    }

    public InfinityApiServiceImpl(InfinityApiRepo infinityApiRepo, InfinityApiRepoProc infinityApiRepoProc, InfinityFolderRepoProc folderRepoProc) {
        this.infinityApiRepo = infinityApiRepo;
        this.infinityApiRepoProc = infinityApiRepoProc;
        this.folderRepoProc = folderRepoProc;
    }
}

