/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.service.alert;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.elitescloud.boot.redis.util.RedisUtils;
import com.elitescloud.boot.util.JSONUtil;
import com.elitescloud.boot.util.RestTemplateFactory;
import com.elitescloud.cloudt.system.constant.SysAlertType;
import com.elitescloud.cloudt.system.model.vo.resp.extend.AlertConfigWxWorkRespVO;
import com.elitescloud.cloudt.system.model.vo.save.extend.AlertConfigWxWorkSaveVO;
import com.elitescloud.cloudt.system.service.alert.AbstractAlertProvider;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

public class WxWorkAlertProvider
extends AbstractAlertProvider<AlertConfigWxWorkSaveVO, AlertConfigWxWorkRespVO> {
    private static final Logger logger = LoggerFactory.getLogger(WxWorkAlertProvider.class);
    private static final String MSG_TYPE = "markdown";
    private final RestTemplate restTemplate = RestTemplateFactory.instance();

    public WxWorkAlertProvider(RedisUtils redisUtils) {
        super(redisUtils);
    }

    @Override
    public SysAlertType alertType() {
        return SysAlertType.WX_WORK;
    }

    @Override
    public String toString(AlertConfigWxWorkSaveVO saveVO) {
        if (saveVO == null) {
            return null;
        }
        Assert.notEmpty(saveVO.getWebhookUrls(), (String)"\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Cfg cfg = new Cfg(saveVO.getWebhookUrls(), saveVO.getTmplContent());
        boolean deduplicate = (Boolean)ObjectUtil.defaultIfNull((Object)saveVO.getDeduplicate(), (Object)false);
        cfg.setDeduplicate(deduplicate);
        cfg.setDeduplicateFields(saveVO.getDeduplicateFields());
        cfg.setDeduplicateIntervals((Integer)ObjectUtil.defaultIfNull((Object)saveVO.getDeduplicateIntervals(), (Object)0));
        if (deduplicate) {
            Assert.notEmpty(cfg.getDeduplicateFields(), (String)"\u8bf7\u9009\u62e9\u53bb\u91cd\u5b57\u6bb5", (Object[])new Object[0]);
            Assert.isTrue((cfg.getDeduplicateIntervals() > 0 ? 1 : 0) != 0, (String)"\u53bb\u91cd\u95f4\u9694\u5fc5\u987b\u5927\u4e8e0", (Object[])new Object[0]);
        }
        return JSONUtil.toJsonString((Object)cfg);
    }

    @Override
    public AlertConfigWxWorkRespVO parse(String cfgJson) {
        if (CharSequenceUtil.isBlank((CharSequence)cfgJson)) {
            return null;
        }
        Cfg cfg = this.parseCfg(cfgJson);
        AlertConfigWxWorkRespVO respVO = new AlertConfigWxWorkRespVO();
        respVO.setWebhookUrls(cfg.getWebhookUrlMap());
        respVO.setTmplContent(cfg.getTmplContent());
        boolean deduplicate = (Boolean)ObjectUtil.defaultIfNull((Object)cfg.getDeduplicate(), (Object)false);
        respVO.setDeduplicate(deduplicate);
        respVO.setDeduplicateFields((List)ObjectUtil.defaultIfNull(cfg.getDeduplicateFields(), Collections.emptyList()));
        respVO.setDeduplicateIntervals((Integer)ObjectUtil.defaultIfNull((Object)cfg.getDeduplicateIntervals(), (Object)0));
        return respVO;
    }

    @Override
    public boolean send(String cfgJson, String content, String category) {
        if (CharSequenceUtil.isBlank((CharSequence)cfgJson)) {
            logger.info("\u4f01\u4e1a\u5fae\u4fe1\u914d\u7f6e\u5185\u5bb9\u4e3a\u7a7a");
            return false;
        }
        Cfg cfg = this.parseCfg(cfgJson);
        return this.execute(cfg, content, category);
    }

    @Override
    public boolean sendByTmpl(String cfgJson, Map<String, Object> tmplParams, String category) {
        if (CharSequenceUtil.isBlank((CharSequence)cfgJson)) {
            logger.info("\u4f01\u4e1a\u5fae\u4fe1\u914d\u7f6e\u5185\u5bb9\u4e3a\u7a7a");
            return false;
        }
        Cfg cfg = this.parseCfg(cfgJson);
        String tmplContent = cfg.getTmplContent();
        if (CharSequenceUtil.isBlank((CharSequence)tmplContent)) {
            logger.info("\u6a21\u677f\u5185\u5bb9\u672a\u914d\u7f6e\uff1a{}", (Object)cfgJson);
            return false;
        }
        if (this.isDuplicate(cfg, tmplParams, category)) {
            logger.info("\u6d88\u606f\u91cd\u590d\uff1a{}", (Object)JSONUtil.toJsonString((Object)cfgJson));
            return false;
        }
        String content = StrUtil.format((CharSequence)tmplContent, tmplParams, (boolean)true);
        return this.execute(cfg, content, category);
    }

    private boolean execute(Cfg cfg, String content, String category) {
        List<String> urls;
        List<String> list = urls = CollUtil.isEmpty(cfg.getWebhookUrlMap()) ? null : cfg.getWebhookUrlMap().get(CharSequenceUtil.blankToDefault((CharSequence)category, (String)"default"));
        if (urls != null) {
            urls = urls.stream().filter(StringUtils::hasText).collect(Collectors.toList());
        }
        if (CollUtil.isEmpty((Collection)urls)) {
            logger.info("\u4f01\u4e1a\u5fae\u4fe1\u5730\u5740\u914d\u7f6e\u672a\u914d\u7f6e\uff1a{}\uff0c{}", (Object)category, (Object)JSONUtil.toJsonString((Object)cfg));
            return false;
        }
        content = CharSequenceUtil.sub((CharSequence)content, (int)0, (int)3000);
        for (String webhookUrl : urls) {
            this.execute(webhookUrl, content);
        }
        return true;
    }

    private void execute(String url, String content) {
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.put("msgtype", MSG_TYPE);
        body.put(MSG_TYPE, Map.of("content", content));
        logger.info("\u3010\u4f01\u4e1a\u5fae\u4fe1\u3011\u53d1\u9001\u9884\u8b66\uff1a{}, {}", (Object)url, (Object)content);
        ResponseEntity resp = null;
        try {
            resp = this.restTemplate.exchange(url, HttpMethod.POST, new HttpEntity(body), String.class, new Object[0]);
            if (resp.getStatusCode().is2xxSuccessful()) {
                logger.info("\u53d1\u9001\u6210\u529f\uff01");
                return;
            }
        }
        catch (RestClientException e) {
            logger.error("\u53d1\u9001\u9884\u8b66\u5f02\u5e38\uff1a", (Throwable)e);
            return;
        }
        logger.info("\u53d1\u9001\u5931\u8d25\uff1a{}, {}", (Object)resp.getStatusCodeValue(), resp.getBody());
    }

    private Cfg parseCfg(String cfgJson) {
        Cfg cfg = (Cfg)JSONUtil.json2Obj((String)cfgJson, Cfg.class);
        if (CollUtil.isEmpty(cfg.getWebhookUrlMap()) && CollUtil.isNotEmpty(cfg.getWebhookUrls())) {
            cfg.setWebhookUrlMap(Map.of("default", cfg.getWebhookUrls()));
        }
        return cfg;
    }

    static class Cfg
    extends AbstractAlertProvider.BaseCfg
    implements Serializable {
        private static final long serialVersionUID = 4537456626636877932L;
        private List<String> webhookUrls;
        private Map<String, List<String>> webhookUrlMap;

        public Cfg(Map<String, List<String>> webhookUrlMap, String tmplContent) {
            super(tmplContent);
            this.webhookUrlMap = webhookUrlMap;
        }

        public Cfg() {
            super(null);
        }

        public Map<String, List<String>> getWebhookUrlMap() {
            return this.webhookUrlMap;
        }

        public void setWebhookUrlMap(Map<String, List<String>> webhookUrlMap) {
            this.webhookUrlMap = webhookUrlMap;
        }

        public List<String> getWebhookUrls() {
            return this.webhookUrls;
        }

        public void setWebhookUrls(List<String> webhookUrls) {
            this.webhookUrls = webhookUrls;
        }
    }
}

