/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.service.devops.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.boot.common.param.CodeNameParam;
import com.elitescloud.boot.core.support.common.CacheableServiceClient;
import com.elitescloud.boot.core.support.common.param.CacheServiceInfo;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.openfeign.common.DynamicClientHelper;
import com.elitescloud.boot.provider.PlatformAppProvider;
import com.elitescloud.boot.wrapper.Isolatable;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.convert.CacheServiceConvert;
import com.elitescloud.cloudt.system.model.vo.resp.devops.CacheMethodRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.devops.CacheServiceRespVO;
import com.elitescloud.cloudt.system.service.devops.CacheMngService;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.validation.constraints.NotBlank;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class CacheMngServiceImpl
implements CacheMngService {
    private static final Logger logger = LoggerFactory.getLogger(CacheMngServiceImpl.class);
    @Autowired
    private PlatformAppProvider appProvider;
    @Autowired
    private Isolatable isolatable;

    @Override
    public ApiResult<List<CacheServiceRespVO>> queryCacheServices(String serviceId) {
        CacheableServiceClient client = this.buildServiceClient(serviceId, null);
        List cacheServiceInfos = null;
        try {
            cacheServiceInfos = (List)client.cacheServices(Boolean.valueOf(false)).computeData();
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u7f13\u5b58\u670d\u52a1\u5f02\u5e38\uff1a", (Throwable)e);
            return ApiResult.fail((String)"\u83b7\u53d6\u5931\u8d25\uff0c\u670d\u52a1\u4e0d\u652f\u6301\u6216\u67b6\u6784\u7248\u672c\u4f4e");
        }
        if (CollUtil.isEmpty((Collection)cacheServiceInfos)) {
            return ApiResult.ok(Collections.emptyList());
        }
        List appList = this.appProvider.all();
        Map appNameMap = CollUtil.isEmpty((Collection)appList) ? Collections.emptyMap() : appList.stream().collect(Collectors.toMap(CodeNameParam::getCode, CodeNameParam::getName, (t1, t2) -> t1));
        List respVoList = cacheServiceInfos.stream().map(t -> {
            CacheServiceRespVO respVO = CacheServiceConvert.INSTANCE.convert2RespVO((CacheServiceInfo)t);
            respVO.setAppName((String)appNameMap.get(t.getAppCode()));
            return respVO;
        }).collect(Collectors.toList());
        return ApiResult.ok(respVoList);
    }

    @Override
    public ApiResult<List<CacheMethodRespVO>> queryCacheMethods(String serviceId, String cacheServiceKey) {
        CacheableServiceClient client = this.buildServiceClient(serviceId, null);
        Assert.notBlank((CharSequence)cacheServiceKey, (String)"\u7f13\u5b58\u670d\u52a1\u6807\u8bc6\u4e3a\u7a7a", (Object[])new Object[0]);
        List methodInfos = null;
        try {
            methodInfos = (List)client.cacheMethods(cacheServiceKey).computeData();
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u7f13\u5b58\u65b9\u6cd5\u5f02\u5e38\uff1a", (Throwable)e);
            return ApiResult.fail((String)"\u83b7\u53d6\u5931\u8d25\uff0c\u670d\u52a1\u4e0d\u652f\u6301\u6216\u67b6\u6784\u7248\u672c\u4f4e");
        }
        if (CollUtil.isEmpty((Collection)methodInfos)) {
            return ApiResult.ok(Collections.emptyList());
        }
        List respVoList = methodInfos.stream().map(CacheServiceConvert.INSTANCE::convert2RespVO).collect(Collectors.toList());
        return ApiResult.ok(respVoList);
    }

    @Override
    public ApiResult<Object> queryCacheDataByCacheMethod(String serviceId, String cacheServiceKey, String method, Object[] params, String tenantCode) {
        CacheableServiceClient client = this.buildServiceClient(serviceId, null);
        Assert.notBlank((CharSequence)cacheServiceKey, (String)"\u7f13\u5b58\u670d\u52a1\u6807\u8bc6\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notBlank((CharSequence)method, (String)"\u7f13\u5b58\u65b9\u6cd5\u4e3a\u7a7a", (Object[])new Object[0]);
        if (params == null) {
            params = new Object[]{};
        }
        try {
            if (StringUtils.hasText((String)tenantCode)) {
                Object[] finalParams = params;
                return (ApiResult)this.isolatable.apply(() -> client.queryCacheDataByCacheMethod(cacheServiceKey, method, finalParams), (Object)tenantCode);
            }
            return client.queryCacheDataByCacheMethod(cacheServiceKey, method, params);
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u7f13\u5b58\u6570\u636e\u5f02\u5e38\uff1a", (Throwable)e);
            return ApiResult.fail((String)"\u83b7\u53d6\u5931\u8d25\uff0c\u670d\u52a1\u4e0d\u652f\u6301\u6216\u67b6\u6784\u7248\u672c\u4f4e");
        }
    }

    @Override
    public ApiResult<List<String>> queryCacheItems(String serviceId, String cacheServiceKey, String tenantCode) {
        CacheableServiceClient client = this.buildServiceClient(serviceId, null);
        Assert.notBlank((CharSequence)cacheServiceKey, (String)"\u7f13\u5b58\u670d\u52a1\u6807\u8bc6\u4e3a\u7a7a", (Object[])new Object[0]);
        try {
            if (StringUtils.hasText((String)tenantCode)) {
                return (ApiResult)this.isolatable.apply(() -> client.cacheItems(cacheServiceKey), (Object)tenantCode);
            }
            return client.cacheItems(cacheServiceKey);
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u7f13\u5b58\u9879\u5f02\u5e38\uff1a", (Throwable)e);
            return ApiResult.fail((String)"\u83b7\u53d6\u5931\u8d25\uff0c\u670d\u52a1\u4e0d\u652f\u6301\u6216\u67b6\u6784\u7248\u672c\u4f4e");
        }
    }

    @Override
    public ApiResult<Object> queryCacheItemData(String serviceId, String cacheServiceKey, String cacheItem, String tenantCode) {
        CacheableServiceClient client = this.buildServiceClient(serviceId, null);
        Assert.notBlank((CharSequence)cacheServiceKey, (String)"\u7f13\u5b58\u670d\u52a1\u6807\u8bc6\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notBlank((CharSequence)cacheItem, (String)"\u7f13\u5b58\u9879\u4e3a\u7a7a", (Object[])new Object[0]);
        try {
            if (StringUtils.hasText((String)tenantCode)) {
                return (ApiResult)this.isolatable.apply(() -> client.cacheItemValue(cacheServiceKey, cacheItem), (Object)tenantCode);
            }
            return client.cacheItemValue(cacheServiceKey, cacheItem);
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u7f13\u5b58\u6570\u636e\u5f02\u5e38\uff1a", (Throwable)e);
            return ApiResult.fail((String)"\u83b7\u53d6\u5931\u8d25\uff0c\u670d\u52a1\u4e0d\u652f\u6301\u6216\u67b6\u6784\u7248\u672c\u4f4e");
        }
    }

    @Override
    public ApiResult<Map<String, Object>> queryAllCacheItemData(@NotBlank String serviceId, @NotBlank String cacheServiceKey, String tenantCode) {
        CacheableServiceClient client = this.buildServiceClient(serviceId, null);
        Assert.notBlank((CharSequence)cacheServiceKey, (String)"\u7f13\u5b58\u670d\u52a1\u6807\u8bc6\u4e3a\u7a7a", (Object[])new Object[0]);
        try {
            if (StringUtils.hasText((String)tenantCode)) {
                return (ApiResult)this.isolatable.apply(() -> client.cacheItemValues(cacheServiceKey), (Object)tenantCode);
            }
            return client.cacheItemValues(cacheServiceKey);
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u7f13\u5b58\u6570\u636e\u5f02\u5e38\uff1a", (Throwable)e);
            return ApiResult.fail((String)"\u83b7\u53d6\u5931\u8d25\uff0c\u670d\u52a1\u4e0d\u652f\u6301\u6216\u67b6\u6784\u7248\u672c\u4f4e");
        }
    }

    @Override
    public ApiResult<Boolean> reload(String serviceId, String cacheServiceKey) {
        CacheableServiceClient client = this.buildServiceClient(serviceId, null);
        Assert.notBlank((CharSequence)cacheServiceKey, (String)"\u7f13\u5b58\u670d\u52a1\u6807\u8bc6\u4e3a\u7a7a", (Object[])new Object[0]);
        try {
            return client.reload(cacheServiceKey);
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u7f13\u5b58\u6570\u636e\u5f02\u5e38\uff1a", (Throwable)e);
            return ApiResult.fail((String)"\u83b7\u53d6\u5931\u8d25\uff0c\u670d\u52a1\u4e0d\u652f\u6301\u6216\u67b6\u6784\u7248\u672c\u4f4e");
        }
    }

    @Override
    public ApiResult<Boolean> clear(String serviceId, String cacheServiceKey) {
        CacheableServiceClient client = this.buildServiceClient(serviceId, null);
        try {
            return client.clearAll(cacheServiceKey);
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u7f13\u5b58\u6570\u636e\u5f02\u5e38\uff1a", (Throwable)e);
            return ApiResult.fail((String)"\u83b7\u53d6\u5931\u8d25\uff0c\u670d\u52a1\u4e0d\u652f\u6301\u6216\u67b6\u6784\u7248\u672c\u4f4e");
        }
    }

    private CacheableServiceClient buildServiceClient(@NotBlank String serviceId, String url) {
        Assert.notBlank((CharSequence)serviceId, (String)"\u670d\u52a1ID\u4e3a\u7a7a", (Object[])new Object[0]);
        try {
            if (CharSequenceUtil.isBlank((CharSequence)url)) {
                return (CacheableServiceClient)DynamicClientHelper.getClient((String)serviceId, CacheableServiceClient.class, (String)"/secRpc/cloudt/cacheServiceClient");
            }
            return (CacheableServiceClient)DynamicClientHelper.buildClient((String)serviceId, CacheableServiceClient.class, (String)"/secRpc/cloudt/cacheServiceClient", (String)url);
        }
        catch (Exception e) {
            throw new BusinessException("\u6784\u5efa\u5ba2\u6237\u7aef\u5931\u8d25", (Throwable)e);
        }
    }
}

