/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.service.devops.init;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import com.elitescloud.boot.common.param.CodeNameParam;
import com.elitescloud.cloudt.system.service.devops.init.AbstractBasicDataInitProvider;
import com.elitescloud.cloudt.system.service.devops.init.CurrencyRateInitProvider;
import com.elitescloud.cloudt.system.service.devops.init.MsgTemplateConfigInitProvider;
import com.elitescloud.cloudt.system.service.devops.init.MsgTemplateInitProvider;
import com.elitescloud.cloudt.system.service.devops.init.PlatformAdminMenusInitProvider;
import com.elitescloud.cloudt.system.service.devops.init.PlatformApiManageInitProvider;
import com.elitescloud.cloudt.system.service.devops.init.PlatformApiParameterInitProvider;
import com.elitescloud.cloudt.system.service.devops.init.PlatformAppInitProvider;
import com.elitescloud.cloudt.system.service.devops.init.PlatformAreaInitProvider;
import com.elitescloud.cloudt.system.service.devops.init.PlatformCurrencyInitProvider;
import com.elitescloud.cloudt.system.service.devops.init.PlatformMenusApiInitProvider;
import com.elitescloud.cloudt.system.service.devops.init.PlatformMenusInitProvider;
import com.elitescloud.cloudt.system.service.devops.init.PlatformNextNumberInitProvider;
import com.elitescloud.cloudt.system.service.devops.init.PlatformNumberRuleDtlInitProvider;
import com.elitescloud.cloudt.system.service.devops.init.PlatformNumberRuleInitProvider;
import com.elitescloud.cloudt.system.service.devops.init.PlatformUdcInitProvider;
import com.elitescloud.cloudt.system.service.devops.init.PlatformUdcValueInitProvider;
import com.elitescloud.cloudt.system.service.devops.init.SettingInitProvider;
import com.elitescloud.cloudt.system.service.devops.init.TaxRateInitProvider;
import com.elitescloud.cloudt.system.service.devops.init.TmplInitProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;

public class BasicDataInitProviderFactory {
    private static final List<Group> EXPORT_PROVIDER_GROUP = new ArrayList<Group>(16);
    private static final List<Group> IMPORT_PROVIDER_GROUP = new ArrayList<Group>(16);

    private BasicDataInitProviderFactory() {
    }

    public static List<CodeNameParam> getExportProviderGroupList() {
        return EXPORT_PROVIDER_GROUP.stream().map(group -> new CodeNameParam(group.getCode(), group.getName())).collect(Collectors.toList());
    }

    public static List<CodeNameParam> getImportProviderGroupList() {
        return IMPORT_PROVIDER_GROUP.stream().map(group -> new CodeNameParam(group.getCode(), group.getName())).collect(Collectors.toList());
    }

    public static List<List<AbstractBasicDataInitProvider>> getExportProviderList(Collection<String> groupCodes) {
        boolean isAllGroup = CollUtil.isEmpty(groupCodes);
        return EXPORT_PROVIDER_GROUP.stream().filter(t -> isAllGroup || groupCodes.contains(t.getCode())).map(t -> Collections.unmodifiableList(t.getProviderList())).collect(Collectors.toList());
    }

    public static List<List<AbstractBasicDataInitProvider>> getImportProviderList(Collection<String> groupCodes) {
        boolean isAllGroup = CollUtil.isEmpty(groupCodes);
        return IMPORT_PROVIDER_GROUP.stream().filter(t -> isAllGroup || groupCodes.contains(t.getCode())).map(t -> Collections.unmodifiableList(t.getProviderList())).collect(Collectors.toList());
    }

    static {
        EXPORT_PROVIDER_GROUP.add(new Group("app", "\u5e94\u7528\u4fe1\u606f", 1, new PlatformAppInitProvider()));
        EXPORT_PROVIDER_GROUP.add(new Group("menu", "\u7cfb\u7edf\u83dc\u5355", 2, new PlatformMenusInitProvider(), new PlatformAdminMenusInitProvider()));
        EXPORT_PROVIDER_GROUP.add(new Group("api", "API\u63a5\u53e3", 3, new PlatformApiManageInitProvider(), new PlatformApiParameterInitProvider(), new PlatformMenusApiInitProvider()));
        EXPORT_PROVIDER_GROUP.add(new Group("udc", "UDC", 4, new PlatformUdcInitProvider(), new PlatformUdcValueInitProvider()));
        EXPORT_PROVIDER_GROUP.add(new Group("nextNumberRule", "\u53d1\u53f7\u5668", 5, new PlatformNextNumberInitProvider(), new PlatformNumberRuleInitProvider(), new PlatformNumberRuleDtlInitProvider()));
        EXPORT_PROVIDER_GROUP.add(new Group("area", "\u884c\u653f\u533a\u57df", 6, new PlatformAreaInitProvider()));
        EXPORT_PROVIDER_GROUP.add(new Group("currency", "\u8d27\u5e01", 7, new PlatformCurrencyInitProvider()));
        EXPORT_PROVIDER_GROUP.add(new Group("currencyRate", "\u6c47\u7387", 8, new CurrencyRateInitProvider()));
        EXPORT_PROVIDER_GROUP.add(new Group("taxRate", "\u7a0e\u7387", 9, new TaxRateInitProvider()));
        EXPORT_PROVIDER_GROUP.add(new Group("setting", "\u7cfb\u7edf\u8bbe\u7f6e", 10, new SettingInitProvider()));
        EXPORT_PROVIDER_GROUP.add(new Group("msgTmpl", "\u6d88\u606f\u6a21\u677f", 11, new MsgTemplateInitProvider(), new MsgTemplateConfigInitProvider()));
        EXPORT_PROVIDER_GROUP.add(new Group("excelTmpl", "\u5bfc\u5165\u5bfc\u51fa\u6a21\u677f", 12, new TmplInitProvider()));
        IMPORT_PROVIDER_GROUP.add(new Group("app", "\u5e94\u7528\u4fe1\u606f", 1, new PlatformAppInitProvider()));
        IMPORT_PROVIDER_GROUP.add(new Group("menu", "\u7cfb\u7edf\u83dc\u5355", 2, new PlatformMenusInitProvider(), new PlatformAdminMenusInitProvider()));
        IMPORT_PROVIDER_GROUP.add(new Group("api", "API\u63a5\u53e3", 3, new PlatformApiManageInitProvider().thenImport(new PlatformApiParameterInitProvider(), new PlatformMenusApiInitProvider())));
        IMPORT_PROVIDER_GROUP.add(new Group("udc", "UDC", 4, new PlatformUdcInitProvider(), new PlatformUdcValueInitProvider()));
        IMPORT_PROVIDER_GROUP.add(new Group("nextNumberRule", "\u53d1\u53f7\u5668", 5, new PlatformNextNumberInitProvider(), new PlatformNumberRuleInitProvider().thenImport(new PlatformNumberRuleDtlInitProvider())));
        IMPORT_PROVIDER_GROUP.add(new Group("area", "\u884c\u653f\u533a\u57df", 6, new PlatformAreaInitProvider()));
        IMPORT_PROVIDER_GROUP.add(new Group("currency", "\u8d27\u5e01", 7, new PlatformCurrencyInitProvider()));
        IMPORT_PROVIDER_GROUP.add(new Group("currencyRate", "\u6c47\u7387", 8, new CurrencyRateInitProvider()));
        IMPORT_PROVIDER_GROUP.add(new Group("taxRate", "\u7a0e\u7387", 9, new TaxRateInitProvider()));
        IMPORT_PROVIDER_GROUP.add(new Group("setting", "\u7cfb\u7edf\u8bbe\u7f6e", 10, new SettingInitProvider()));
        IMPORT_PROVIDER_GROUP.add(new Group("msgTmpl", "\u6d88\u606f\u6a21\u677f", 11, new MsgTemplateInitProvider().thenImport(new MsgTemplateConfigInitProvider())));
        IMPORT_PROVIDER_GROUP.add(new Group("excelTmpl", "\u5bfc\u5165\u5bfc\u51fa\u6a21\u677f", 12, new TmplInitProvider()));
    }

    private static class Group {
        private final String code;
        private final String name;
        private final int order;
        private final List<AbstractBasicDataInitProvider> providerList;

        public Group(String code, String name, int order, AbstractBasicDataInitProvider ... provider) {
            this.code = code;
            this.name = name;
            this.order = order;
            Assert.notBlank((CharSequence)code, (String)"\u5206\u7ec4\u7f16\u7801\u4e3a\u7a7a", (Object[])new Object[0]);
            Assert.notBlank((CharSequence)name, (String)"\u5206\u7ec4\u540d\u79f0\u4e3a\u7a7a", (Object[])new Object[0]);
            Assert.notEmpty((Object[])provider, (String)"\u63d0\u4f9b\u8005\u4e3a\u7a7a", (Object[])new Object[0]);
            this.providerList = Arrays.stream(provider).collect(Collectors.toList());
            this.checkProviders();
        }

        public String getCode() {
            return this.code;
        }

        public String getName() {
            return this.name;
        }

        public int getOrder() {
            return this.order;
        }

        public List<AbstractBasicDataInitProvider> getProviderList() {
            return this.providerList;
        }

        private void checkProviders() {
            HashSet<String> existsNames = new HashSet<String>(this.providerList.size());
            for (AbstractBasicDataInitProvider provider : this.providerList) {
                if (existsNames.contains(provider.typeName())) {
                    throw new IllegalArgumentException("\u5206\u7ec4[" + this.code + "]\u4e0b\u5b58\u5728\u91cd\u590d\u7684\u7c7b\u578b[" + provider.typeName() + "]");
                }
                existsNames.add(provider.typeName());
            }
        }
    }
}

