/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.service.devops.init;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.ObjectUtil;
import com.elitescloud.cloudt.common.base.param.OrderItem;
import com.elitescloud.cloudt.constant.CurrencyRateCalcMethod;
import com.elitescloud.cloudt.system.service.devops.init.AbstractBasicDataInitProvider;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CurrencyRateInitProvider
extends AbstractBasicDataInitProvider {
    private static final Logger log = LoggerFactory.getLogger(CurrencyRateInitProvider.class);

    @Override
    public String typeName() {
        return "\u6c47\u7387";
    }

    @Override
    public String tableName() {
        return "sys_currency_rate";
    }

    @Override
    public List<String> fields() {
        return List.of("from_curr", "to_curr", "ratio", "cal_method", "enabled", "valid_from", "valid_to", "std_version", "create_time", "modify_time");
    }

    @Override
    public Map<String, String> fieldTitles() {
        LinkedHashMap<String, String> titles = new LinkedHashMap<String, String>(16);
        titles.put("from_curr", "\u81ea\u8d27\u5e01\u7801");
        titles.put("to_curr", "\u81f3\u8d27\u5e01\u7801");
        titles.put("ratio", "\u6c47\u7387");
        titles.put("cal_method", "\u8ba1\u7b97\u65b9\u6cd5");
        titles.put("cal_method_name", "\u8ba1\u7b97\u65b9\u6cd5\u540d\u79f0");
        titles.put("valid_from", "\u8d77\u59cb\u65f6\u95f4");
        titles.put("valid_to", "\u622a\u6b62\u65f6\u95f4");
        titles.put("enabled", "\u72b6\u6001");
        titles.put("create_time", "\u521b\u5efa\u65f6\u95f4");
        titles.put("modify_time", "\u6700\u540e\u4fee\u6539\u65f6\u95f4");
        return titles;
    }

    @Override
    public boolean isTenantData() {
        return true;
    }

    @Override
    public List<OrderItem> orderItems() {
        return List.of(OrderItem.desc((String)"create_time"));
    }

    @Override
    public String fieldAppCode() {
        return "";
    }

    @Override
    public Map<String, Object> convertForExport(Map<String, Object> data, List<Map<String, Object>> preData) {
        Boolean enabled = this.getBooleanValue(data.get("enabled"), null);
        if (enabled == null || !enabled.booleanValue()) {
            return null;
        }
        CurrencyRateCalcMethod type = CurrencyRateCalcMethod.parse((String)ObjectUtil.defaultIfNull((Object)data.get("call_method"), (Object)"").toString());
        if (type != null) {
            data.put("call_method_name", type.getDescription());
        }
        return data;
    }

    @Override
    public AbstractBasicDataInitProvider.UpdateType convertForImport(Map<String, Object> data, List<Map<String, Object>> currentData, List<Map<String, Object>> lastStepData) {
        String from_curr = this.getStringValue(data, "from_curr", null);
        Assert.notBlank((CharSequence)from_curr, (String)"\u7f3a\u5c11from_curr", (Object[])new Object[0]);
        String to_curr = this.getStringValue(data, "to_curr", null);
        Assert.notBlank((CharSequence)to_curr, (String)"\u7f3a\u5c11to_curr", (Object[])new Object[0]);
        this.normalizeBooleanValue(data, "enabled");
        if (currentData.isEmpty()) {
            return AbstractBasicDataInitProvider.UpdateType.ADD;
        }
        Map existsData = currentData.parallelStream().filter(t -> from_curr.equals(t.get("from_curr")) && to_curr.equals(t.get("to_curr"))).findFirst().orElse(null);
        if (existsData == null) {
            this.normalizeForAdd(data);
            return AbstractBasicDataInitProvider.UpdateType.ADD;
        }
        this.normalizeForUpdate(data, existsData);
        return AbstractBasicDataInitProvider.UpdateType.UPDATE;
    }

    private void normalizeForAdd(Map<String, Object> data) {
        data.put("app_state", this.getBooleanValue(data.get("app_state"), true));
    }

    private void normalizeForUpdate(Map<String, Object> data, Map<String, Object> dataExists) {
        data.put("id", dataExists.get("id"));
        data.put("app_state", ObjectUtil.defaultIfNull((Object)dataExists.get("app_state"), (Object)this.getBooleanValue(data.get("app_state"), true)));
    }
}

