/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.service.devops.init;

import cn.hutool.core.lang.Assert;
import com.elitescloud.cloudt.common.base.param.OrderItem;
import com.elitescloud.cloudt.system.service.devops.init.AbstractBasicDataInitProvider;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlatformApiManageInitProvider
extends AbstractBasicDataInitProvider {
    private static final Logger log = LoggerFactory.getLogger(PlatformApiManageInitProvider.class);

    @Override
    public String typeName() {
        return "API\u63a5\u53e3";
    }

    @Override
    public String tableName() {
        return "sys_platform_api_manage";
    }

    @Override
    public List<String> fields() {
        return List.of("id", "app_code", "api_name", "api_code", "request_type", "api_path", "api_describe", "std_version", "create_time", "modify_time");
    }

    @Override
    public Map<String, String> fieldTitles() {
        LinkedHashMap<String, String> titles = new LinkedHashMap<String, String>(16);
        titles.put("id", "ID");
        titles.put("app_code", "\u5e94\u7528\u7f16\u7801");
        titles.put("api_code", "API\u7f16\u7801");
        titles.put("api_name", "API\u540d\u79f0");
        titles.put("request_type", "\u8bf7\u6c42\u7c7b\u578b");
        titles.put("api_path", "\u63a5\u53e3\u8def\u5f84");
        titles.put("api_describe", "\u63a5\u53e3\u63cf\u8ff0");
        titles.put("create_time", "\u521b\u5efa\u65f6\u95f4");
        titles.put("modify_time", "\u6700\u540e\u4fee\u6539\u65f6\u95f4");
        return titles;
    }

    @Override
    public List<OrderItem> orderItems() {
        return List.of(OrderItem.desc((String)"create_time"));
    }

    @Override
    public String fieldAppCode() {
        return "app_code";
    }

    @Override
    public AbstractBasicDataInitProvider.UpdateType convertForImport(Map<String, Object> data, List<Map<String, Object>> currentData, List<Map<String, Object>> lastStepData) {
        String apiCode = this.getStringValue(data, "api_code", null);
        Assert.notBlank((CharSequence)apiCode, (String)"\u63a5\u53e3\u7f16\u7801\u4e3a\u7a7a", (Object[])new Object[0]);
        data.put("original_id", this.getLongValue(data, "id", null));
        if (currentData.isEmpty()) {
            return AbstractBasicDataInitProvider.UpdateType.ADD;
        }
        Object id = currentData.stream().filter(t -> apiCode.equals(t.get("api_code"))).findFirst().map(t -> t.get("id")).orElse(null);
        data.put("id", id);
        return id == null ? AbstractBasicDataInitProvider.UpdateType.ADD : AbstractBasicDataInitProvider.UpdateType.UPDATE;
    }
}

