/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.service.devops.init;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.cloudt.common.base.param.OrderItem;
import com.elitescloud.cloudt.system.service.devops.init.AbstractBasicDataInitProvider;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlatformApiParameterInitProvider
extends AbstractBasicDataInitProvider {
    private static final Logger log = LoggerFactory.getLogger(PlatformApiParameterInitProvider.class);

    @Override
    public String typeName() {
        return "API\u63a5\u53e3\u53c2\u6570";
    }

    @Override
    public String tableName() {
        return "sys_platform_api_parameter";
    }

    @Override
    public List<String> fields() {
        return List.of("api_id", "api_code", "field_name", "field_type", "field_is_null", "field_explain", "in_out_type", "std_version", "remark", "create_time", "modify_time");
    }

    @Override
    public Map<String, String> fieldTitles() {
        LinkedHashMap<String, String> titles = new LinkedHashMap<String, String>(16);
        titles.put("api_id", "API ID");
        titles.put("api_code", "API\u7f16\u7801");
        titles.put("field_name", "\u5b57\u6bb5\u540d\u79f0");
        titles.put("field_type", "\u5b57\u6bb5\u7c7b\u578b");
        titles.put("field_is_null", "\u662f\u5426\u53ef\u4ee5\u4e3a\u7a7a");
        titles.put("field_explain", "\u5b57\u6bb5\u63cf\u8ff0");
        titles.put("in_out_type", "\u53c2\u6570\u7c7b\u578b");
        titles.put("create_time", "\u521b\u5efa\u65f6\u95f4");
        titles.put("modify_time", "\u6700\u540e\u4fee\u6539\u65f6\u95f4");
        return titles;
    }

    @Override
    public List<OrderItem> orderItems() {
        return List.of(OrderItem.desc((String)"create_time"));
    }

    @Override
    public String fieldAppCode() {
        return "";
    }

    @Override
    public AbstractBasicDataInitProvider.UpdateType convertForImport(Map<String, Object> data, List<Map<String, Object>> currentData, List<Map<String, Object>> lastStepData) {
        if (CollUtil.isEmpty(lastStepData)) {
            return AbstractBasicDataInitProvider.UpdateType.IGNORE;
        }
        String apiCode = this.getStringValue(data, "api_code", null);
        if (CharSequenceUtil.isBlank((CharSequence)apiCode)) {
            Long originalApiId = this.getLongValue(data, "api_id", null);
            Assert.notNull((Object)originalApiId, (String)"\u7f3a\u5c11api_id", (Object[])new Object[0]);
            Map<String, Object> originalApiMap = lastStepData.parallelStream().filter(t -> Objects.equals(originalApiId, t.get("original_id"))).findFirst().orElse(Collections.emptyMap());
            apiCode = this.getStringValue(originalApiMap, "api_code", null);
            if (CharSequenceUtil.isBlank((CharSequence)apiCode)) {
                log.info("\u672a\u67e5\u8be2\u5230API\uff1a{}", (Object)originalApiId);
                return AbstractBasicDataInitProvider.UpdateType.IGNORE;
            }
        }
        String fieldName = this.getStringValue(data, "field_name", null);
        Assert.notBlank((CharSequence)fieldName, (String)"\u53c2\u6570\u540d\u79f0\u4e3a\u7a7a", (Object[])new Object[0]);
        String type = this.getStringValue(data, "in_out_type", null);
        Assert.notBlank((CharSequence)type, (String)"\u53c2\u6570\u7c7b\u578b\u4e3a\u7a7a", (Object[])new Object[0]);
        this.normalizeBooleanValue(data, "field_is_null");
        if (currentData.isEmpty()) {
            return AbstractBasicDataInitProvider.UpdateType.ADD;
        }
        String finalApiCode = apiCode;
        Object id = currentData.stream().filter(t -> finalApiCode.equals(t.get("api_code")) && fieldName.equals(t.get("field_name")) && type.equals(t.get("in_out_type"))).findFirst().map(t -> t.get("id")).orElse(null);
        data.put("id", id);
        Long currentApiId = lastStepData.parallelStream().filter(t -> finalApiCode.equals(this.getStringValue((Map<String, Object>)t, "api_code", ""))).findFirst().map(t -> this.getLongValue((Map<String, Object>)t, "id", null)).orElse(null);
        if (currentApiId == null) {
            return AbstractBasicDataInitProvider.UpdateType.IGNORE;
        }
        data.put("api_id", currentApiId);
        return id == null ? AbstractBasicDataInitProvider.UpdateType.ADD : AbstractBasicDataInitProvider.UpdateType.UPDATE;
    }
}

