/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.service.devops.init;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ArrayUtil;
import com.el.coordinator.boot.fsm.service.FileService;
import com.elitescloud.boot.SpringContextHolder;
import com.elitescloud.boot.common.constant.MimeTypeConstant;
import com.elitescloud.boot.constant.TenantConstant;
import com.elitescloud.boot.provider.CloudtIdCreator;
import com.elitescloud.boot.util.FileUtil;
import com.elitescloud.cloudt.common.base.param.OrderItem;
import com.elitescloud.cloudt.system.service.devops.init.AbstractBasicDataInitProvider;
import com.elitescloud.cloudt.system.service.impl.SystemDataServiceImpl;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.web.servlet.mvc.method.annotation.StreamingResponseBody;

public class TmplInitProvider
extends AbstractBasicDataInitProvider {
    private static final Logger log = LoggerFactory.getLogger(TmplInitProvider.class);
    private static final String DIR = "tmpl";
    private Map<String, ResourceInfo> tmplData = new HashMap<String, ResourceInfo>();
    private File workDir;
    private FileService fileService;
    private CloudtIdCreator idCreator;
    private NamedParameterJdbcTemplate jdbcTemplate;
    private SystemDataServiceImpl.ImportedData importedData;

    @Override
    public String typeName() {
        return "\u5bfc\u5165\u5bfc\u51fa\u6a21\u677f";
    }

    @Override
    public String tableName() {
        return "sys_tmpl";
    }

    @Override
    public List<String> fields() {
        return List.of("name", "code_", "file_code", "file_name", "export", "head_row", "field_type_row", "enabled", "data_limit_per", "async_threshold", "concurrent_limit", "attribute_list", "export_sheet_limit", "export_sheet_strategy", "app_code", "std_version", "create_time", "modify_time");
    }

    @Override
    public Map<String, String> fieldTitles() {
        LinkedHashMap<String, String> titles = new LinkedHashMap<String, String>(16);
        titles.put("app_code", "\u5e94\u7528\u7f16\u7801");
        titles.put("name", "\u6a21\u677f\u540d\u79f0");
        titles.put("code_", "\u7f16\u7801");
        titles.put("file_name", "\u6587\u4ef6\u540d\u79f0");
        titles.put("export", "\u662f\u5426\u662f\u5bfc\u51fa\u6a21\u677f");
        titles.put("head_row", "\u5934\u90e8\u884c\u6570");
        titles.put("field_type_row", "\u5b57\u6bb5\u7c7b\u578b\u6240\u5728\u884c");
        titles.put("data_limit_per", "\u6570\u636e\u91cf\u9650\u5236");
        titles.put("async_threshold", "\u5f02\u6b65\u9600\u503c");
        titles.put("concurrent_limit", "\u5e76\u53d1\u91cf\u9650\u5236");
        titles.put("export_sheet_limit", "\u5bfc\u51fa\u65f6sheet\u6570\u636e\u91cf\u9650\u5236");
        titles.put("export_sheet_strategy", "\u5bfc\u51fa\u65f6\u8d85\u51fasheet\u540e\u7b56\u7565");
        titles.put("attribute_list", "\u5c5e\u6027");
        titles.put("file_code", "\u6a21\u677f\u6587\u4ef6");
        titles.put("create_time", "\u521b\u5efa\u65f6\u95f4");
        titles.put("modify_time", "\u6700\u540e\u4fee\u6539\u65f6\u95f4");
        return titles;
    }

    @Override
    public void prepareExport(File workDir) {
        this.workDir = workDir;
        this.fileService = (FileService)SpringContextHolder.getBean(FileService.class);
        NamedParameterJdbcTemplate jdbcTemplate = (NamedParameterJdbcTemplate)SpringContextHolder.getBean(NamedParameterJdbcTemplate.class);
        HashMap<String, Object> sqlParams = new HashMap<String, Object>();
        sqlParams.put("delete_flag", 0);
        sqlParams.put("tenant_id", TenantConstant.DEFAULT_TENANT_ID);
        sqlParams.put("resource_type", DIR);
        List tmplResourceList = jdbcTemplate.query("select resource_key, resource, mime_type, suffix, resource_name, size from sys_resource_byte where delete_flag = :delete_flag and tenant_id = :tenant_id and resource_type = :resource_type", sqlParams, (RowMapper)new BeanPropertyRowMapper(ResourceInfo.class));
        if (CollUtil.isNotEmpty((Collection)tmplResourceList)) {
            for (ResourceInfo resource : tmplResourceList) {
                this.tmplData.put(resource.getResourceKey(), resource);
            }
        }
    }

    @Override
    public List<OrderItem> orderItems() {
        return List.of(OrderItem.asc((String)"app_code"), OrderItem.desc((String)"create_time"));
    }

    @Override
    public String fieldAppCode() {
        return "app_code";
    }

    @Override
    public Map<String, Object> convertForExport(Map<String, Object> data, List<Map<String, Object>> preData) {
        Boolean enabled = this.getBooleanValue(data.get("enabled"), null);
        if (enabled == null || !enabled.booleanValue()) {
            return null;
        }
        String fileCode = data.get("file_code").toString();
        ResourceInfo resourceInfo = this.tmplData.get(fileCode);
        byte[] resourceBytes = null;
        if (resourceInfo != null) {
            resourceBytes = resourceInfo.resource;
        } else {
            HttpEntity body = this.fileService.download(fileCode, null);
            if (body.hasBody() && body.getBody() != null) {
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                try {
                    ((StreamingResponseBody)body.getBody()).writeTo((OutputStream)outputStream);
                }
                catch (IOException e) {
                    log.error("\u4e0b\u8f7d\u6a21\u677f\u6587\u4ef6{}\u5f02\u5e38\uff1a", (Object)fileCode, (Object)e);
                }
                resourceBytes = outputStream.toByteArray();
            }
        }
        if (ArrayUtil.isNotEmpty((byte[])resourceBytes)) {
            File tmplDir = new File(this.workDir, DIR);
            if (!tmplDir.exists()) {
                tmplDir.mkdirs();
            }
            File tmplFile = new File(tmplDir, fileCode + ".xlsx");
            FileUtil.writeBytes((byte[])resourceBytes, (File)tmplFile);
        }
        return data;
    }

    @Override
    public void prepareForImport(SystemDataServiceImpl.ImportedData importData, Long tenantId) {
        this.idCreator = (CloudtIdCreator)SpringContextHolder.getBean(CloudtIdCreator.class);
        this.importedData = importData;
        this.jdbcTemplate = (NamedParameterJdbcTemplate)SpringContextHolder.getBean(NamedParameterJdbcTemplate.class);
    }

    @Override
    public AbstractBasicDataInitProvider.UpdateType convertForImport(Map<String, Object> data, List<Map<String, Object>> currentData, List<Map<String, Object>> lastStepData) {
        String code = this.getStringValue(data, "code_", null);
        Assert.notBlank((CharSequence)code, (String)"\u6a21\u677f\u7f16\u7801\u4e3a\u7a7a", (Object[])new Object[0]);
        String fileCode = this.getStringValue(data, "file_code", null);
        Assert.notBlank((CharSequence)fileCode, (String)"\u6a21\u677f\u6587\u4ef6\u7f16\u7801\u4e3a\u7a7a", (Object[])new Object[0]);
        File tmplFile = this.saveResource(fileCode, data);
        if (tmplFile == null) {
            return AbstractBasicDataInitProvider.UpdateType.IGNORE;
        }
        this.normalizeBooleanValue(data, "export");
        this.normalizeIntegerValue(data, "head_row");
        this.normalizeIntegerValue(data, "field_type_row");
        this.normalizeIntegerValue(data, "data_limit_per");
        this.normalizeIntegerValue(data, "async_threshold");
        this.normalizeIntegerValue(data, "concurrent_limit");
        this.normalizeIntegerValue(data, "export_sheet_limit");
        this.normalizeIntegerValue(data, "export_sheet_limit");
        if (currentData.isEmpty()) {
            return AbstractBasicDataInitProvider.UpdateType.ADD;
        }
        Map existsData = currentData.stream().filter(t -> code.equals(t.get("code_"))).findFirst().orElse(null);
        if (existsData == null) {
            return AbstractBasicDataInitProvider.UpdateType.ADD;
        }
        this.normalizeForUpdate(data, existsData);
        return AbstractBasicDataInitProvider.UpdateType.UPDATE;
    }

    private void normalizeForUpdate(Map<String, Object> data, Map<String, Object> dataExists) {
        data.put("id", dataExists.get("id"));
    }

    private File saveResource(String fileCode, Map<String, Object> data) {
        Object filename = this.getStringValue(data, "file_name", null);
        if (CharSequenceUtil.isBlank((CharSequence)filename)) {
            filename = this.getStringValue(data, "name", fileCode) + ".xlsx";
        }
        String suffix = FileUtil.getSuffix((String)filename);
        File file = this.importedData.getOtherFiles().get(DIR + File.separator + fileCode + "." + suffix);
        if (file == null || !file.exists()) {
            log.info("\u6a21\u677f\u6587\u4ef6\u4e0d\u5b58\u5728\uff1a{}", (Object)fileCode);
            return null;
        }
        this.jdbcTemplate.update("delete from sys_resource_byte where resource_key = :resource_key and resource_type = :resource_type", Map.of("resource_key", fileCode, "resource_type", DIR));
        String sql = "insert into sys_resource_byte(id, resource_type, resource_key, resource, mime_type, suffix, resource_name, show_name, size, temp, create_time) values (:id, :resource_type, :resource_key, :resource, :mime_type,:suffix, :resource_name, :show_name, :size, :temp, :create_time);";
        HashMap<String, Object> sqlParams = new HashMap<String, Object>(32);
        sqlParams.put("id", this.idCreator.create());
        sqlParams.put("resource_type", DIR);
        sqlParams.put("resource_key", fileCode);
        sqlParams.put("resource", FileUtil.readBytes((File)file));
        sqlParams.put("mime_type", "xlsx".equals(suffix) ? MimeTypeConstant.XLSX.toString() : MimeTypeConstant.XLS.toString());
        sqlParams.put("suffix", suffix);
        sqlParams.put("resource_name", filename);
        sqlParams.put("show_name", filename);
        sqlParams.put("size", file.length());
        sqlParams.put("temp", super.normalizeSqlParam(false));
        sqlParams.put("create_time", LocalDateTime.now());
        this.jdbcTemplate.update(sql, sqlParams);
        return file;
    }

    static class ResourceInfo {
        private String resourceKey;
        private byte[] resource;
        private String mimeType;
        private String suffix;
        private String resourceName;
        private Long size;

        ResourceInfo() {
        }

        public String getResourceKey() {
            return this.resourceKey;
        }

        public void setResourceKey(String resourceKey) {
            this.resourceKey = resourceKey;
        }

        public byte[] getResource() {
            return this.resource;
        }

        public void setResource(byte[] resource) {
            this.resource = resource;
        }

        public String getMimeType() {
            return this.mimeType;
        }

        public void setMimeType(String mimeType) {
            this.mimeType = mimeType;
        }

        public String getSuffix() {
            return this.suffix;
        }

        public void setSuffix(String suffix) {
            this.suffix = suffix;
        }

        public String getResourceName() {
            return this.resourceName;
        }

        public void setResourceName(String resourceName) {
            this.resourceName = resourceName;
        }

        public Long getSize() {
            return this.size;
        }

        public void setSize(Long size) {
            this.size = size;
        }
    }
}

