/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.boot.util.ObjUtil;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.context.util.TreeDataUtil;
import com.elitescloud.cloudt.core.annotation.TenantOrgTransaction;
import com.elitescloud.cloudt.core.annotation.TenantTransaction;
import com.elitescloud.cloudt.core.annotation.common.TenantIsolateType;
import com.elitescloud.cloudt.system.config.SystemProperties;
import com.elitescloud.cloudt.system.convert.AreaConvert;
import com.elitescloud.cloudt.system.dto.req.SysAreaNamesQueryDTO;
import com.elitescloud.cloudt.system.dto.req.SysAreaQueryDTO;
import com.elitescloud.cloudt.system.dto.resp.SysAreaNamesRespDTO;
import com.elitescloud.cloudt.system.dto.resp.SysAreaRespDTO;
import com.elitescloud.cloudt.system.service.AreaQueryService;
import com.elitescloud.cloudt.system.service.manager.AreaManager;
import com.elitescloud.cloudt.system.service.model.entity.SysPlatformAreaDO;
import com.elitescloud.cloudt.system.service.model.vo.CommonAreaQueryVO;
import com.elitescloud.cloudt.system.service.model.vo.CommonAreaTreeQueryVO;
import com.elitescloud.cloudt.system.service.model.vo.CommonAreaTreeRespVO;
import com.elitescloud.cloudt.system.service.repo.AreaRepoProc;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
@TenantTransaction(isolateType=TenantIsolateType.TENANT)
@TenantOrgTransaction(useTenantOrg=false)
public class AreaQueryServiceImpl
extends BaseServiceImpl
implements AreaQueryService {
    private static final AreaConvert CONVERT = AreaConvert.INSTANCE;
    @Autowired
    private AreaRepoProc areaRepoProc;
    @Autowired
    private SystemProperties systemProperties;
    @Autowired
    private AreaManager areaManager;

    @Override
    public ApiResult<List<CommonAreaTreeRespVO>> listArea(CommonAreaQueryVO queryVO) {
        if (queryVO.getPid() == null && CharSequenceUtil.isAllBlank((CharSequence[])new CharSequence[]{queryVO.getPcode(), queryVO.getName(), queryVO.getAreaType()})) {
            if (Boolean.TRUE.equals(queryVO.getCn())) {
                queryVO.setPcode(this.systemProperties.getArea().getChinaCode());
            } else {
                queryVO.setPid(Long.valueOf(-1L));
            }
        }
        List dataList = this.areaManager.areaTemplate(() -> this.areaRepoProc.queryList(queryVO));
        return ApiResult.ok((Object)dataList);
    }

    @Override
    public ApiResult<List<CommonAreaTreeRespVO>> treeArea(CommonAreaTreeQueryVO queryVO) {
        if (queryVO.getPid() == null && CharSequenceUtil.isAllBlank((CharSequence[])new CharSequence[]{queryVO.getPcode()})) {
            if (Boolean.TRUE.equals(queryVO.getCn())) {
                queryVO.setPcode(this.systemProperties.getArea().getChinaCode());
            } else {
                queryVO.setPid(Long.valueOf(-1L));
            }
        }
        List dataList = this.areaManager.areaTemplate(() -> this.areaManager.listTree(queryVO.getPid(), queryVO.getPcode(), (Boolean)ObjUtil.defaultIfNull((Object)queryVO.getTree(), (Object)true)));
        return ApiResult.ok((Object)dataList);
    }

    @Override
    public ApiResult<Map<String, String>> queryNamesByAreaCode(Collection<String> areaCodes) {
        Set codes = areaCodes.stream().filter(Objects::nonNull).collect(Collectors.toSet());
        if (codes.isEmpty()) {
            return ApiResult.ok(Collections.emptyMap());
        }
        Map nameMap = this.areaManager.areaTemplate(() -> this.areaRepoProc.getCodeAndName((Collection)codes));
        return ApiResult.ok((Object)nameMap);
    }

    @Override
    public ApiResult<List<SysAreaRespDTO>> listByAreaCodes(Set<String> areaCodes) {
        Set codes = areaCodes.stream().filter(Objects::nonNull).collect(Collectors.toSet());
        if (codes.isEmpty()) {
            return ApiResult.ok(Collections.emptyList());
        }
        List areaList = this.areaManager.areaTemplate(() -> this.areaRepoProc.listByCode((Collection)codes)).stream().map(CONVERT::do2DTO).collect(Collectors.toList());
        return ApiResult.ok(areaList);
    }

    @Override
    public ApiResult<List<SysAreaRespDTO>> listByParentAreaCode(String areaCode) {
        if (CharSequenceUtil.isBlank((CharSequence)areaCode)) {
            return ApiResult.ok(Collections.emptyList());
        }
        List areaList = this.areaManager.areaTemplate(() -> this.areaRepoProc.listByParentAreaCode(areaCode)).stream().map(CONVERT::do2DTO).collect(Collectors.toList());
        return ApiResult.ok(areaList);
    }

    @Override
    public ApiResult<List<SysAreaRespDTO>> queryList(SysAreaQueryDTO queryDTO) {
        List areaList = this.areaManager.areaTemplate(() -> this.areaRepoProc.queryList(queryDTO)).stream().map(CONVERT::do2DTO).collect(Collectors.toList());
        return ApiResult.ok(areaList);
    }

    @Override
    public ApiResult<Boolean> existsCode(String code) {
        Assert.notBlank((CharSequence)code, (String)"\u7f16\u7801\u4e3a\u7a7a", (Object[])new Object[0]);
        boolean exists = this.areaRepoProc.existsCode(code);
        return ApiResult.ok((Object)exists);
    }

    @Override
    public ApiResult<List<SysAreaNamesRespDTO>> queryListByNames(SysAreaNamesQueryDTO queryDTO) {
        List codeOrNames = queryDTO.getCodeOrNames();
        boolean fuzzy = Boolean.TRUE.equals(queryDTO.getFuzzy());
        Assert.notEmpty((Iterable)codeOrNames, (String)"\u884c\u653f\u533a\u57df\u7f16\u7801\u6216\u540d\u79f0\u4e3a\u7a7a", (Object[])new Object[0]);
        List<SysAreaNamesRespDTO> dtoList = codeOrNames.stream().map(t -> {
            SysAreaNamesRespDTO respDTO = new SysAreaNamesRespDTO();
            respDTO.setMatched(Boolean.valueOf(false));
            respDTO.setCodes(new ArrayList(8));
            respDTO.setNames(new ArrayList(8));
            respDTO.setParam(t);
            return respDTO;
        }).collect(Collectors.toList());
        List<TreeData> treeDataList = this.queryTreeData(codeOrNames, fuzzy);
        if (treeDataList.isEmpty()) {
            return ApiResult.ok(dtoList);
        }
        Map<String, List<TreeData>> candidateTreeDataMap = this.obtainCandidateTreeData(dtoList, treeDataList, fuzzy);
        if (candidateTreeDataMap.isEmpty()) {
            return ApiResult.ok(dtoList);
        }
        for (SysAreaNamesRespDTO respDTO : dtoList) {
            TreeData treeData;
            boolean matched;
            List<TreeData> candidateList;
            if (CollUtil.isEmpty((Collection)respDTO.getParam()) || CollUtil.isEmpty(candidateList = candidateTreeDataMap.get(respDTO.getParam().get(0)))) continue;
            Iterator<TreeData> iterator = candidateList.iterator();
            while (iterator.hasNext() && !(matched = this.fillTreeData(respDTO, treeData = iterator.next(), respDTO.getParam(), 0, fuzzy))) {
                respDTO.setMatched(Boolean.valueOf(false));
                respDTO.getNames().clear();
                respDTO.getCodes().clear();
            }
        }
        return ApiResult.ok(dtoList);
    }

    @Override
    public ApiResult<List<SysAreaRespDTO>> queryAll(Boolean tree) {
        List<SysAreaRespDTO> dataList = this.areaManager.allTree(tree == null || tree != false);
        return ApiResult.ok(dataList);
    }

    private Map<String, List<TreeData>> obtainCandidateTreeData(List<SysAreaNamesRespDTO> dtoList, List<TreeData> treeDataList, boolean fuzzy) {
        if (CollUtil.isEmpty(dtoList) || CollUtil.isEmpty(treeDataList)) {
            return Collections.emptyMap();
        }
        Set<String> codeOrNames = dtoList.stream().map(t -> CollUtil.isEmpty((Collection)t.getParam()) ? null : (String)t.getParam().get(0)).filter(StringUtils::hasText).collect(Collectors.toSet());
        HashMap<String, List<TreeData>> candidateTreeDataMap = new HashMap<String, List<TreeData>>(codeOrNames.size());
        this.filterCandidateTreeData(codeOrNames, treeDataList, fuzzy, candidateTreeDataMap);
        return candidateTreeDataMap;
    }

    private void filterCandidateTreeData(Set<String> codeOrNames, List<TreeData> treeDataList, boolean fuzzy, Map<String, List<TreeData>> candidateTreeDataMap) {
        if (CollUtil.isEmpty(treeDataList)) {
            return;
        }
        for (TreeData treeData : treeDataList) {
            SysPlatformAreaDO area = treeData.getAreaDO();
            for (String codeOrName : codeOrNames) {
                if (this.isMatchTreeData(area.getAreaName(), codeOrName, fuzzy) || this.isMatchTreeData(area.getAreaCode(), codeOrName, fuzzy)) {
                    candidateTreeDataMap.computeIfAbsent(codeOrName, k -> new ArrayList()).add(treeData);
                }
                this.filterCandidateTreeData(codeOrNames, treeData.getChildren(), fuzzy, candidateTreeDataMap);
            }
        }
    }

    private boolean fillTreeData(SysAreaNamesRespDTO respDTO, TreeData treeData, List<String> params, int paramIndex, boolean fuzzy) {
        SysPlatformAreaDO area = treeData.getAreaDO();
        if (paramIndex > params.size()) {
            return false;
        }
        String param = params.get(paramIndex);
        if (CharSequenceUtil.isBlank((CharSequence)param)) {
            return false;
        }
        if (this.isMatchTreeData(area.getAreaName(), param, fuzzy) || this.isMatchTreeData(area.getAreaCode(), param, fuzzy)) {
            respDTO.setMatched(Boolean.valueOf(true));
            respDTO.getCodes().add(area.getAreaCode());
            respDTO.getNames().add(area.getAreaName());
            int nextIndex = paramIndex + 1;
            if (params.size() == nextIndex) {
                return true;
            }
            if (CollUtil.isNotEmpty(treeData.getChildren())) {
                for (TreeData child : treeData.getChildren()) {
                    if (!this.fillTreeData(respDTO, child, params, nextIndex, fuzzy)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean isMatchTreeData(String matcher, String target, boolean fuzzy) {
        return fuzzy ? matcher.startsWith(target) : matcher.equals(target);
    }

    private List<TreeData> queryTreeData(List<List<String>> codeOrNames, boolean fuzzy) {
        Set paramList = codeOrNames.stream().flatMap(Collection::stream).filter(StringUtils::hasText).collect(Collectors.toSet());
        if (paramList.isEmpty()) {
            return Collections.emptyList();
        }
        List areaDoList = this.areaManager.areaTemplate(() -> {
            if (paramList.size() <= 50) {
                return fuzzy ? this.areaRepoProc.listByCodeOrNameFuzzily((Collection)paramList) : this.areaRepoProc.listByCodeOrName((Collection)paramList);
            }
            return this.areaRepoProc.all();
        });
        if (areaDoList.isEmpty()) {
            return Collections.emptyList();
        }
        List areaList = areaDoList.stream().map(TreeData::new).collect(Collectors.toList());
        return new TreeDataUtil(areaList, TreeData::getCode, TreeData::getParentCode, TreeData::setChildren).getRoots();
    }

    static class TreeData {
        private final SysPlatformAreaDO areaDO;
        private List<TreeData> children;

        public TreeData(SysPlatformAreaDO areaDO) {
            this.areaDO = areaDO;
        }

        public SysPlatformAreaDO getAreaDO() {
            return this.areaDO;
        }

        public List<TreeData> getChildren() {
            return this.children;
        }

        public void setChildren(List<TreeData> children) {
            this.children = children;
        }

        public String getCode() {
            return this.areaDO.getAreaCode();
        }

        public String getParentCode() {
            return this.areaDO.getParentAreaCode();
        }
    }
}

