/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.service.impl;

import com.elitescloud.boot.SpringContextHolder;
import com.elitescloud.boot.auth.config.AuthorizationSdkProperties;
import com.elitescloud.boot.auth.model.OAuthToken;
import com.elitescloud.boot.auth.provider.security.grant.InternalAuthenticationGranter;
import com.elitescloud.boot.auth.provider.sso2.common.TicketProvider;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.util.JwtUtil;
import com.elitescloud.boot.util.RsaUtil;
import com.elitescloud.boot.util.encrypt.BaseEncrypt;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.context.util.HttpServletUtil;
import com.elitescloud.cloudt.system.common.IdEncodedTypeEnum;
import com.elitescloud.cloudt.system.service.AuthUserService;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.bootstrap.encrypt.KeyProperties;
import org.springframework.core.io.Resource;
import org.springframework.security.crypto.encrypt.TextEncryptor;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@Service
public class AuthUserServiceImpl
extends BaseServiceImpl
implements AuthUserService {
    private static final Logger log = LoggerFactory.getLogger(AuthUserServiceImpl.class);
    @Autowired
    private InternalAuthenticationGranter authenticationGranter;
    @Autowired
    private AuthorizationSdkProperties authorizationSdkProperties;
    @Autowired
    private TextEncryptor encryptor;
    @Autowired
    private KeyProperties keyProperties;
    private PrivateKey privateKey;

    @Override
    public ApiResult<OAuthToken> authenticate(HttpServletRequest request, HttpServletResponse response, String idType, String id) {
        Assert.hasText((String)id, (String)"\u8d26\u6237\u6807\u8bc6\u4e3a\u7a7a");
        InternalAuthenticationGranter.IdType idTypeValue = InternalAuthenticationGranter.IdType.USERNAME;
        if (StringUtils.hasText((String)idType)) {
            try {
                idTypeValue = InternalAuthenticationGranter.IdType.valueOf((String)idType);
            }
            catch (IllegalArgumentException e) {
                return ApiResult.fail((String)("\u4e0d\u652f\u6301\u7684\u8d26\u53f7\u6807\u8bc6\u7c7b\u578b\uff1a" + idType));
            }
        }
        InternalAuthenticationGranter.InternalAuthenticationToken authenticationToken = new InternalAuthenticationGranter.InternalAuthenticationToken(idTypeValue, id);
        if (request == null) {
            request = HttpServletUtil.currentRequest();
        }
        if (request != null) {
            String clientId = this.authorizationSdkProperties.getCasClient().getOauth2Client().getClientId();
            request.setAttribute("cloudtClientId", (Object)clientId);
        }
        try {
            OAuthToken token = this.authenticationGranter.authenticate(request, response, authenticationToken);
            return ApiResult.ok((Object)token);
        }
        catch (Exception e) {
            log.info("\u8ba4\u8bc1\u5f02\u5e38\uff1a", (Throwable)e);
            return ApiResult.fail((String)("\u8ba4\u8bc1\u5931\u8d25\uff0c" + e.getMessage()));
        }
    }

    @Override
    public ApiResult<OAuthToken> authenticateForEncoded(HttpServletRequest request, HttpServletResponse response, String idType, String idEncoded, String cipherType) {
        Assert.hasText((String)idEncoded, (String)"\u8d26\u6237\u6807\u8bc6\u4e3a\u7a7a");
        String id = null;
        try {
            id = this.decode(idEncoded, cipherType);
        }
        catch (Exception e) {
            log.info("\u89e3\u5bc6\u8ba4\u8bc1\u5f02\u5e38\uff1a{}\uff0c{}", new Object[]{idEncoded, cipherType, e});
            return ApiResult.fail((String)("\u89e3\u5bc6\u5931\u8d25\uff0c" + e.getMessage()));
        }
        return this.authenticate(request, response, idType, id);
    }

    @Override
    public ApiResult<String> ticket2Token(String ticket) {
        if (!StringUtils.hasText((String)ticket)) {
            return ApiResult.fail((String)"ticket\u4e3a\u7a7a");
        }
        String token = (String)((TicketProvider)SpringContextHolder.getBean(TicketProvider.class)).exchangeTicket(ticket);
        return ApiResult.ok((Object)token);
    }

    private String decode(String idEncoded, String cipherType) throws Exception {
        IdEncodedTypeEnum encodedType = IdEncodedTypeEnum.RSA;
        if (StringUtils.hasText((String)cipherType)) {
            try {
                encodedType = IdEncodedTypeEnum.valueOf(cipherType);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("\u4e0d\u652f\u6301\u7684\u89e3\u5bc6\u7b97\u6cd5" + cipherType);
            }
        }
        String idDecoded = null;
        switch (encodedType) {
            case NOOP: {
                idDecoded = idEncoded;
                break;
            }
            case CONFIG: {
                idDecoded = this.encryptor.decrypt(idEncoded);
                break;
            }
            case RSA: {
                PrivateKey privateKey = this.loadPrivateKey();
                idDecoded = RsaUtil.decrypt((PrivateKey)privateKey, null, (String)idEncoded);
                break;
            }
            case BASE64: {
                idDecoded = new String(BaseEncrypt.decodeBase64((String)idEncoded));
                break;
            }
            default: {
                throw new BusinessException("\u6682\u4e0d\u652f\u6301\u7684\u52a0\u5bc6\u65b9\u5f0f" + cipherType);
            }
        }
        String[] ids = idDecoded.split("&");
        if (ids.length < 2) {
            throw new IllegalArgumentException("\u8d26\u53f7\u6807\u8bc6\u7684\u683c\u5f0f\u4e0d\u6b63\u786e");
        }
        long timestamp = Long.parseLong(ids[1]);
        if (Math.abs(System.currentTimeMillis() - timestamp) > 300000L) {
            throw new IllegalArgumentException("\u8ba4\u8bc1\u5df2\u8d85\u65f6");
        }
        return ids[0];
    }

    private PrivateKey loadPrivateKey() throws UnrecoverableKeyException, KeyStoreException, NoSuchAlgorithmException {
        if (this.privateKey != null) {
            return this.privateKey;
        }
        KeyProperties.KeyStore props = this.keyProperties.getKeyStore();
        KeyStore keystore = JwtUtil.loadKeystore((Resource)props.getLocation(), (String)props.getType(), (String)props.getPassword(), (String)props.getAlias(), (String)props.getSecret());
        this.privateKey = (PrivateKey)keystore.getKey(props.getAlias(), props.getSecret().toCharArray());
        return this.privateKey;
    }
}

