/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.boot.common.annotation.businessobject.OperationScopeEnum;
import com.elitescloud.boot.common.annotation.businessobject.OperationStateEnum;
import com.elitescloud.boot.common.annotation.businessobject.OperationTypeEnum;
import com.elitescloud.boot.common.param.CodeNameParam;
import com.elitescloud.boot.common.param.IdCodeNameParam;
import com.elitescloud.boot.datasecurity.config.DataSecurityProperties;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.model.dto.SysBusinessOperationDTO;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.boot.provider.PlatformAppProvider;
import com.elitescloud.boot.redis.util.RedisUtils;
import com.elitescloud.boot.swagger.openapi.model.BusinessObjectInfo;
import com.elitescloud.boot.swagger.openapi.model.BusinessObjectOperationInfo;
import com.elitescloud.boot.swagger.openapi.model.BusinessObjectParamInfo;
import com.elitescloud.boot.swagger.openapi.swagger3.models.Operation;
import com.elitescloud.boot.swagger.openapi.swagger3.models.media.Content;
import com.elitescloud.boot.swagger.openapi.swagger3.models.media.MediaType;
import com.elitescloud.boot.swagger.openapi.swagger3.models.media.Schema;
import com.elitescloud.boot.swagger.openapi.swagger3.models.parameters.Parameter;
import com.elitescloud.boot.swagger.openapi.swagger3.models.parameters.RequestBody;
import com.elitescloud.boot.swagger.openapi.swagger3.models.responses.ApiResponse;
import com.elitescloud.boot.swagger.openapi.swagger3.models.responses.ApiResponses;
import com.elitescloud.boot.util.ArrayUtil;
import com.elitescloud.boot.util.JSONUtil;
import com.elitescloud.boot.util.LockUtil;
import com.elitescloud.boot.util.ObjUtil;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.annotation.TenantOrgTransaction;
import com.elitescloud.cloudt.core.annotation.TenantTransaction;
import com.elitescloud.cloudt.core.annotation.common.TenantIsolateType;
import com.elitescloud.cloudt.platform.service.repo.MenuOperationRepoProc;
import com.elitescloud.cloudt.system.cacheable.SysCacheBusinessObjectRpcService;
import com.elitescloud.cloudt.system.convert.BusinessObjectConvert;
import com.elitescloud.cloudt.system.model.bo.BusinessObjectConvertBO;
import com.elitescloud.cloudt.system.model.bo.BusinessOperationParamBO;
import com.elitescloud.cloudt.system.model.vo.query.businessobject.BusinessObjectPageQueryVO;
import com.elitescloud.cloudt.system.model.vo.query.businessobject.BusinessOperationPageQueryVO;
import com.elitescloud.cloudt.system.model.vo.resp.businessobject.BusinessObjectDetailRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.businessobject.BusinessObjectPageRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.businessobject.BusinessObjectParamRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.businessobject.BusinessOperationPageRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.businessobject.BusinessOperationRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.businessobject.BusinessPermissionParamRespVO;
import com.elitescloud.cloudt.system.model.vo.save.businessobject.BusinessObjectSaveVO;
import com.elitescloud.cloudt.system.model.vo.save.businessobject.BusinessOperationSaveVO;
import com.elitescloud.cloudt.system.model.vo.save.businessobject.UpdateFieldPermissionFilterParam;
import com.elitescloud.cloudt.system.service.BusinessObjectMngService;
import com.elitescloud.cloudt.system.service.common.constant.BusinessObjectParamInEnum;
import com.elitescloud.cloudt.system.service.common.constant.BusinessObjectRefTypeEnum;
import com.elitescloud.cloudt.system.service.common.constant.JavaTypeEnum;
import com.elitescloud.cloudt.system.service.common.constant.OpenApiSourceEnum;
import com.elitescloud.cloudt.system.service.common.constant.OpenApiStatusEnum;
import com.elitescloud.cloudt.system.service.manager.BusinessObjectManager;
import com.elitescloud.cloudt.system.service.model.entity.SysBusinessObjectDO;
import com.elitescloud.cloudt.system.service.model.entity.SysBusinessObjectRefDO;
import com.elitescloud.cloudt.system.service.model.entity.SysBusinessOperationDO;
import com.elitescloud.cloudt.system.service.model.entity.SysBusinessOperationParamDO;
import com.elitescloud.cloudt.system.service.model.entity.SysBusinessParamDO;
import com.elitescloud.cloudt.system.service.model.entity.SysOpenApiInfoDO;
import com.elitescloud.cloudt.system.service.model.entity.SysOpenApiOperationDO;
import com.elitescloud.cloudt.system.service.repo.BusinessObjectRefRepoProc;
import com.elitescloud.cloudt.system.service.repo.BusinessObjectRepoProc;
import com.elitescloud.cloudt.system.service.repo.BusinessOperationParamRepoProc;
import com.elitescloud.cloudt.system.service.repo.BusinessOperationRepoProc;
import com.elitescloud.cloudt.system.service.repo.BusinessParamRepoProc;
import com.elitescloud.cloudt.system.service.repo.OpenApiInfoRepoProc;
import com.elitescloud.cloudt.system.service.repo.OpenApiOperationRepoProc;
import com.elitescloud.cloudt.system.service.repo.OpenApiResourceRepoProc;
import com.elitescloud.cloudt.system.service.repo.OpenApiSchemaRepoProc;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.task.TaskExecutor;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@Service
@TenantTransaction(isolateType=TenantIsolateType.DEFAULT)
@TenantOrgTransaction(useTenantOrg=false)
public class BusinessObjectMngServiceImpl
implements BusinessObjectMngService {
    private static final Logger log = LoggerFactory.getLogger(BusinessObjectMngServiceImpl.class);
    @Autowired
    private OpenApiInfoRepoProc openApiInfoRepoProc;
    @Autowired
    private OpenApiOperationRepoProc openApiOperationRepoProc;
    @Autowired
    private OpenApiResourceRepoProc resourceRepoProc;
    @Autowired
    private OpenApiSchemaRepoProc openApiSchemaRepoProc;
    @Autowired
    private BusinessObjectRepoProc businessObjectRepoProc;
    @Autowired
    private BusinessObjectRefRepoProc refRepoProc;
    @Autowired
    private BusinessOperationRepoProc businessOperationRepoProc;
    @Autowired
    private BusinessOperationParamRepoProc businessOperationParamRepoProc;
    @Autowired
    private BusinessParamRepoProc businessParamRepoProc;
    @Autowired
    private PlatformAppProvider appProvider;
    @Autowired
    private MenuOperationRepoProc menuOperationRepoProc;
    @Autowired
    private BusinessObjectManager businessObjectManager;
    @Autowired
    private TaskExecutor taskExecutor;
    @Autowired
    private DataSecurityProperties dataSecurityProperties;
    @Autowired
    private PlatformTransactionManager transactionManager;
    @Autowired
    private RedisUtils redisUtils;
    @Autowired
    private SysCacheBusinessObjectRpcService cacheBusinessObjectRpcService;

    @Override
    public ApiResult<List<BusinessOperationParamBO>> queryBusinessOperationParam(String operationCode, BusinessObjectParamInEnum businessObjectParamInEnum) {
        List<BusinessOperationParamBO> operationParams = this.businessOperationParamRepoProc.listBoByOperationCode(operationCode, businessObjectParamInEnum);
        if (operationParams.isEmpty()) {
            return ApiResult.ok(Collections.emptyList());
        }
        List<BusinessOperationParamBO> paramVoList = this.businessObjectManager.convertParam(operationParams, null);
        return ApiResult.ok(this.filterResponseData(paramVoList));
    }

    private List<BusinessOperationParamBO> filterResponseData(List<BusinessOperationParamBO> paramList) {
        if (CollUtil.isEmpty(paramList)) {
            return Collections.emptyList();
        }
        for (BusinessOperationParamBO operationParam : paramList) {
            if (!operationParam.isApiResultData()) continue;
            List<BusinessOperationParamBO> pageData = this.businessObjectManager.attemptObtainPagingData(operationParam.getChildrenParams());
            return (List)CollUtil.defaultIfEmpty(pageData, operationParam.getChildrenParams());
        }
        return paramList;
    }

    @Override
    public ApiResult<Boolean> updateBusinessOperationFieldPermissionFilter(UpdateFieldPermissionFilterParam param) {
        SysBusinessOperationParamDO businessOperationParamDO = (SysBusinessOperationParamDO)this.businessOperationParamRepoProc.get(param.getBusinessOperationParamId());
        businessOperationParamDO.setFieldPermissionFilter(param.getFieldPermissionFilterEnabled());
        this.businessOperationParamRepoProc.save((Serializable)businessOperationParamDO);
        return ApiResult.ok((Object)param.getFieldPermissionFilterEnabled());
    }

    @Override
    public ApiResult<Boolean> testAnalyzeOpenApi(Long openApiId, Long openApiOperationId, Boolean save) {
        SysOpenApiInfoDO openApiDO = (SysOpenApiInfoDO)this.openApiInfoRepoProc.get(openApiId);
        if (openApiDO == null) {
            return ApiResult.fail((String)"OpenApi\u8bb0\u5f55\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u540e\u518d\u8bd5");
        }
        if (openApiOperationId == null) {
            List<BusinessObjectConvertBO> result = this.convertOpenApi2BusinessObject(openApiDO);
            log.info("\u7ed3\u679c\uff1a{}", (Object)result.size());
        } else {
            SysOpenApiOperationDO operationDO = (SysOpenApiOperationDO)this.openApiOperationRepoProc.get(openApiOperationId);
            if (operationDO == null) {
                return ApiResult.fail((String)"OpenApi\u7684\u64cd\u4f5c\u4e0d\u5b58\u5728");
            }
            RootContext context = new RootContext(openApiDO);
            this.analyzeBusinessObject(context, operationDO);
            log.info("\u7ed3\u679c\uff1a{}", (Object)context.businessObjects.size());
            if (Boolean.TRUE.equals(save)) {
                this.saveBusinessObject(openApiDO, OpenApiSourceEnum.GATHER_PULL, new ArrayList<BusinessObjectConvertBO>(context.businessObjects.values()));
            }
        }
        return ApiResult.ok((Object)true);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> generateByOpenApi(Long openApiId) {
        Assert.notNull((Object)openApiId, (String)"OpenApiId\u4e3a\u7a7a");
        SysOpenApiInfoDO openApiDO = (SysOpenApiInfoDO)this.openApiInfoRepoProc.get(openApiId);
        if (openApiDO == null) {
            return ApiResult.fail((String)"OpenApi\u8bb0\u5f55\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u540e\u518d\u8bd5");
        }
        this.generateBusinessObject(openApiDO);
        return ApiResult.ok((Object)openApiId);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> saveBusinessObject(BusinessObjectSaveVO saveVO) {
        if (saveVO == null || saveVO.getId() == null) {
            return ApiResult.fail((String)"\u4e1a\u52a1\u5bf9\u8c61ID\u4e3a\u7a7a");
        }
        SysBusinessObjectDO businessObjectDO = (SysBusinessObjectDO)this.businessObjectRepoProc.get(saveVO.getId());
        if (businessObjectDO == null) {
            return ApiResult.fail((String)"\u4e1a\u52a1\u5bf9\u8c61\u4e0d\u5b58\u5728");
        }
        BusinessObjectConvert.INSTANCE.copySaveVO(saveVO, businessObjectDO);
        this.businessObjectRepoProc.save((Serializable)businessObjectDO);
        this.taskExecutor.execute(this::cacheBusinessObjects);
        return ApiResult.ok((Object)saveVO.getId());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> saveBusinessOperation(BusinessOperationSaveVO saveVO) {
        if (saveVO == null || saveVO.getId() == null) {
            return ApiResult.fail((String)"\u4e1a\u52a1\u5bf9\u8c61ID\u4e3a\u7a7a");
        }
        SysBusinessOperationDO businessOperationDO = (SysBusinessOperationDO)this.businessOperationRepoProc.get(saveVO.getId());
        if (businessOperationDO == null) {
            return ApiResult.fail((String)"\u529f\u80fd\u64cd\u4f5c\u4e0d\u5b58\u5728");
        }
        BusinessObjectConvert.INSTANCE.copySaveVO(saveVO, businessOperationDO);
        this.businessOperationRepoProc.save((Serializable)businessOperationDO);
        this.taskExecutor.execute(this::cacheBusinessObjects);
        return ApiResult.ok((Object)saveVO.getId());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Set<Long>> saveBusinessOperation(List<BusinessOperationSaveVO> saveVOList) {
        if (CollUtil.isEmpty(saveVOList)) {
            return ApiResult.fail((String)"\u4fdd\u5b58\u4fe1\u606f\u4e3a\u7a7a");
        }
        Map saveVoMap = saveVOList.stream().filter(t -> t.getId() != null).collect(Collectors.toMap(BusinessOperationSaveVO::getId, Function.identity(), (t1, t2) -> t1));
        if (saveVoMap.isEmpty()) {
            return ApiResult.fail((String)"\u4fdd\u5b58\u4fe1\u606f\u7684ID\u4e3a\u7a7a");
        }
        List businessOperations = this.businessOperationRepoProc.get(saveVoMap.keySet());
        for (SysBusinessOperationDO businessOperation : businessOperations) {
            BusinessObjectConvert.INSTANCE.copySaveVO((BusinessOperationSaveVO)saveVoMap.get(businessOperation.getId()), businessOperation);
        }
        this.businessOperationRepoProc.save(businessOperations);
        return ApiResult.ok(saveVoMap.keySet());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> updateDataPermissionEnabledOfParam(Long businessParamId, Boolean enabled) {
        Assert.notNull((Object)businessParamId, (String)"\u4e1a\u52a1\u53c2\u6570ID\u4e3a\u7a7a");
        if (enabled == null) {
            enabled = false;
        }
        this.businessParamRepoProc.updateDataPermissionEnabled(businessParamId, enabled);
        return ApiResult.ok((Object)businessParamId);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> updateFieldPermissionEnabledOfParam(Long businessParamId, Boolean enabled) {
        Assert.notNull((Object)businessParamId, (String)"\u4e1a\u52a1\u53c2\u6570ID\u4e3a\u7a7a");
        if (enabled == null) {
            enabled = false;
        }
        this.businessParamRepoProc.updateFieldPermissionEnabled(businessParamId, enabled);
        return ApiResult.ok((Object)businessParamId);
    }

    @Override
    public ApiResult<PagingVO<BusinessObjectPageRespVO>> pageObject(BusinessObjectPageQueryVO queryVO) {
        PagingVO pageData = this.businessObjectRepoProc.pageMng(queryVO).map(t -> {
            BusinessObjectPageRespVO vo = BusinessObjectConvert.INSTANCE.do2PageRespVO((SysBusinessObjectDO)t);
            vo.setName(CharSequenceUtil.blankToDefault((CharSequence)t.getCustomName(), (String)t.getName()));
            return vo;
        });
        if (pageData.isEmpty()) {
            return ApiResult.ok((Object)pageData);
        }
        List<Long> businessObjectIds = pageData.stream().map(BusinessObjectPageRespVO::getId).collect(Collectors.toList());
        Map<Long, Long> businessOperationCountMap = this.businessOperationRepoProc.countByBusinessObject(businessObjectIds);
        Map<String, String> appMap = this.appProvider.all().stream().collect(Collectors.toMap(CodeNameParam::getCode, CodeNameParam::getName, (t1, t2) -> t1));
        pageData.each(t -> {
            t.setAppName((String)appMap.get(t.getAppCode()));
            t.setOperationNum(businessOperationCountMap.getOrDefault(t.getId(), 0L));
        });
        return ApiResult.ok((Object)pageData);
    }

    @Override
    public ApiResult<BusinessObjectDetailRespVO> getDetail(Long id) {
        Assert.notNull((Object)id, (String)"ID\u4e3a\u7a7a");
        SysBusinessObjectDO businessObjectDO = (SysBusinessObjectDO)this.businessObjectRepoProc.get(id);
        if (businessObjectDO == null) {
            return ApiResult.fail((String)"\u4e1a\u52a1\u5bf9\u8c61\u4e0d\u5b58\u5728");
        }
        BusinessObjectDetailRespVO respVO = BusinessObjectConvert.INSTANCE.do2DetailVO(businessObjectDO);
        respVO.setName(CharSequenceUtil.blankToDefault((CharSequence)businessObjectDO.getCustomName(), (String)businessObjectDO.getName()));
        Map<String, String> appMap = this.appProvider.all().stream().collect(Collectors.toMap(CodeNameParam::getCode, CodeNameParam::getName, (t1, t2) -> t1));
        respVO.setAppName(appMap.get(respVO.getAppCode()));
        respVO.setParamList(this.listBusinessParams(id, this::convert2Vo));
        List<IdCodeNameParam> operationList = this.businessOperationRepoProc.listByBusinessObjectId(id);
        respVO.setOperationList(operationList);
        return ApiResult.ok((Object)respVO);
    }

    @Override
    public ApiResult<BusinessOperationRespVO> getBusinessOperation(Long businessOperationId) {
        Assert.notNull((Object)businessOperationId, (String)"ID\u4e3a\u7a7a");
        SysBusinessOperationDO operationDO = (SysBusinessOperationDO)this.businessOperationRepoProc.get(businessOperationId);
        if (operationDO == null) {
            return ApiResult.fail((String)"\u4e1a\u52a1\u64cd\u4f5c\u4e0d\u5b58\u5728");
        }
        BusinessOperationRespVO respVO = BusinessObjectConvert.INSTANCE.do2DetailVO(operationDO);
        respVO.setOperationName(CharSequenceUtil.blankToDefault((CharSequence)operationDO.getCustomName(), (String)operationDO.getOperationDescription()));
        respVO.setDefaultName(operationDO.getOperationDescription());
        if (StringUtils.hasText((String)respVO.getOperationType())) {
            OperationTypeEnum operationType = OperationTypeEnum.parse((String)respVO.getOperationType());
            respVO.setOperationTypeName(operationType == null ? null : operationType.getDescription());
        }
        if (StringUtils.hasText((String)respVO.getScope())) {
            OperationScopeEnum scope = OperationScopeEnum.parse((String)respVO.getScope());
            respVO.setScopeName(scope == null ? null : scope.getDescription());
        }
        if (StringUtils.hasText((String)respVO.getState())) {
            OperationStateEnum state = OperationStateEnum.parse((String)respVO.getState());
            respVO.setStateName(state == null ? null : state.getDescription());
        }
        List<BusinessOperationParamBO> paramList = this.businessOperationParamRepoProc.listBoByOperationId(businessOperationId, null);
        respVO.setRequestParams(this.obtainRequestParams(paramList));
        respVO.setResponseParams(this.obtainResponseParams(paramList));
        List<BusinessObjectParamRespVO> businessParams = this.listBusinessParams(operationDO.getBusinessObjectId(), this::convert2Vo);
        respVO.setBusinessParamList(businessParams);
        return ApiResult.ok((Object)respVO);
    }

    @Override
    public ApiResult<PagingVO<BusinessOperationPageRespVO>> pageOperation(BusinessOperationPageQueryVO queryVO) {
        PagingVO pageData = this.businessOperationRepoProc.pageMng(queryVO).map(t -> {
            BusinessOperationPageRespVO respVO = BusinessObjectConvert.INSTANCE.do2PageRespVO((SysBusinessOperationDO)t);
            respVO.setOperationName(CharSequenceUtil.blankToDefault((CharSequence)t.getCustomName(), (String)t.getOperationDescription()));
            respVO.setDefaultName(t.getOperationDescription());
            return respVO;
        });
        if (pageData.isEmpty()) {
            return ApiResult.ok((Object)pageData);
        }
        List businessObjectIds = pageData.stream().map(BusinessOperationPageRespVO::getBusinessObjectId).collect(Collectors.toList());
        Map menuNumMap = this.menuOperationRepoProc.countMenuOfOperationByBusinessObjectId(businessObjectIds);
        pageData.each(t -> {
            if (StringUtils.hasText((String)t.getOperationType())) {
                OperationTypeEnum operationType = OperationTypeEnum.parse((String)t.getOperationType());
                t.setOperationTypeName(operationType == null ? null : operationType.getDescription());
            }
            t.setMenuNum(menuNumMap.getOrDefault(t.getOperationCode(), 0L));
        });
        return ApiResult.ok((Object)pageData);
    }

    @Override
    public ApiResult<List<BusinessPermissionParamRespVO>> listPermissionFields(Long id) {
        List<SysBusinessParamDO> params = this.businessParamRepoProc.listByBusinessObjectId(id, null);
        if (params.isEmpty()) {
            return ApiResult.ok(Collections.emptyList());
        }
        List<BusinessPermissionParamRespVO> permissionParamList = this.listBusinessParams(id, this::convert2PermissionVo);
        return ApiResult.ok(permissionParamList);
    }

    @Override
    public ApiResult<List<BusinessPermissionParamRespVO>> listOperationPermissionFields(Long operationId) {
        if (operationId == null) {
            return ApiResult.fail((String)"\u4e1a\u52a1\u64cd\u4f5cID\u4e3a\u7a7a");
        }
        SysBusinessOperationDO operationDO = (SysBusinessOperationDO)this.businessOperationRepoProc.get(operationId);
        if (operationDO == null) {
            return ApiResult.fail((String)"\u4e1a\u52a1\u64cd\u4f5c\u4e0d\u5b58\u5728");
        }
        return this.listPermissionFields(operationDO.getBusinessObjectId());
    }

    private void cacheBusinessObjects() {
        Map businessMap = this.businessOperationRepoProc.allDtoList(true).stream().collect(Collectors.toMap(SysBusinessOperationDTO::getOperationCode, Function.identity(), (t1, t2) -> t1));
        this.redisUtils.del(new String[]{"system:businessOperation:all"});
        this.redisUtils.del(new String[]{"system:businessObject:all"});
        if (!businessMap.isEmpty()) {
            this.redisUtils.hmset("system:businessOperation:all", businessMap);
        }
        this.cacheBusinessObjectRpcService.clearCache();
    }

    private boolean filterBusinessParam(SysBusinessParamDO paramDO) {
        if (Boolean.FALSE.equals(paramDO.getBaseField())) {
            return true;
        }
        return this.dataSecurityProperties.getBaseFields().contains(paramDO.getFieldName()) || this.dataSecurityProperties.getFieldPermission().getBaseFields().contains(paramDO.getFieldName());
    }

    private <T> List<T> listBusinessParams(long businessObjectId, Function<SysBusinessParamDO, T> mapper) {
        return this.businessParamRepoProc.listByBusinessObjectId(businessObjectId).stream().filter(t -> -1L == t.getBusinessOperationId() && this.filterBusinessParam((SysBusinessParamDO)t)).sorted(Comparator.comparing(SysBusinessParamDO::getSortNo, Comparator.nullsLast(Integer::compareTo))).map(mapper).collect(Collectors.toList());
    }

    private BusinessObjectParamRespVO convert2Vo(SysBusinessParamDO paramDO) {
        BusinessObjectParamRespVO respVO = BusinessObjectConvert.INSTANCE.do2DetailVO(paramDO);
        if (StringUtils.hasText((String)respVO.getFieldJavaType())) {
            ObjUtil.ifNotNull((Object)JavaTypeEnum.parse((String)respVO.getFieldJavaType()), t -> respVO.setFieldJavaType(t.getDescription()));
        }
        if (Boolean.TRUE.equals(paramDO.getBaseField())) {
            respVO.setDataPermissionEnabled(Boolean.TRUE.equals(respVO.getDataPermissionEnabled()) || this.dataSecurityProperties.getBaseFields().contains(paramDO.getFieldName()));
            respVO.setFieldPermissionEnabled(Boolean.TRUE.equals(respVO.getFieldPermissionEnabled()) || this.dataSecurityProperties.getFieldPermission().getBaseFields().contains(paramDO.getFieldName()));
        }
        return respVO;
    }

    private BusinessPermissionParamRespVO convert2PermissionVo(SysBusinessParamDO paramDO) {
        BusinessPermissionParamRespVO respVO = BusinessObjectConvert.INSTANCE.do2PermissionVO(paramDO);
        JavaTypeEnum javaType = JavaTypeEnum.parse((String)paramDO.getFieldJavaType());
        respVO.setFieldType(javaType == null ? "\u5bf9\u8c61" : javaType.getDescription());
        if (Boolean.TRUE.equals(paramDO.getBaseField())) {
            respVO.setDataPermissionEnabled(Boolean.TRUE.equals(respVO.getDataPermissionEnabled()) || this.dataSecurityProperties.getBaseFields().contains(paramDO.getFieldName()));
            respVO.setFieldPermissionEnabled(Boolean.TRUE.equals(respVO.getFieldPermissionEnabled()) || this.dataSecurityProperties.getFieldPermission().getBaseFields().contains(paramDO.getFieldName()));
        }
        String[] values = StringUtils.hasText((String)paramDO.getValuesJson()) ? (String[])JSONUtil.json2Obj((String)paramDO.getValuesJson(), (TypeReference)new TypeReference<String[]>(){}) : new String[]{};
        respVO.setValues(values);
        return respVO;
    }

    private List<BusinessOperationRespVO.OperationParam> obtainRequestParams(List<BusinessOperationParamBO> paramList) {
        Set<BusinessObjectParamInEnum> supportParamIn = Set.of(BusinessObjectParamInEnum.PATH, BusinessObjectParamInEnum.QUERY, BusinessObjectParamInEnum.REQUEST_BODY);
        return this.businessObjectManager.convertParam(paramList, t -> {
            BusinessObjectParamInEnum paramIn = BusinessObjectParamInEnum.parse((String)t.getParamIn());
            return paramIn != null && supportParamIn.contains(paramIn);
        }, BusinessObjectConvert.INSTANCE::bo2DetailVO, BusinessOperationRespVO.OperationParam::setChildren);
    }

    private List<BusinessOperationRespVO.OperationParam> obtainResponseParams(List<BusinessOperationParamBO> paramList) {
        return this.businessObjectManager.convertParam(paramList, t -> {
            BusinessObjectParamInEnum paramIn = BusinessObjectParamInEnum.parse((String)t.getParamIn());
            return paramIn == BusinessObjectParamInEnum.RESPONSE_BODY;
        }, BusinessObjectConvert.INSTANCE::bo2DetailVO, BusinessOperationRespVO.OperationParam::setChildren);
    }

    private void generateBusinessObject(SysOpenApiInfoDO openApiDO) {
        String lockKey = "CloudtSystem:BusinessObject:Update:" + openApiDO.getId();
        LockUtil.executeByLock((String)lockKey, () -> {
            this.checkForGenerate(openApiDO);
            this.openApiInfoRepoProc.updateBusinessObjectStart(openApiDO.getId());
            return null;
        });
        CompletableFuture.runAsync(() -> {
            log.info("\u5f00\u59cb\u8f6c\u6362OpenApi\u81f3\u4e1a\u52a1\u5bf9\u8c61\uff1a{}", (Object)openApiDO.getId());
            List<BusinessObjectConvertBO> businessObjectBoList = this.convertOpenApi2BusinessObject(openApiDO);
            log.info("OpenApi\u8f6c\u6362\u81f3\u4e1a\u52a1\u5bf9\u8c61\u6210\u529f\uff0c\u5f00\u59cb\u6301\u4e45\u5316");
            DefaultTransactionDefinition transactionDefinition = new DefaultTransactionDefinition(3);
            transactionDefinition.setName("OpenApi2BusinessObject");
            TransactionStatus transaction = this.transactionManager.getTransaction((TransactionDefinition)transactionDefinition);
            try {
                this.saveBusinessObject(openApiDO, OpenApiSourceEnum.GATHER_PULL, businessObjectBoList);
                this.transactionManager.commit(transaction);
            }
            catch (Exception e) {
                if (!transaction.isCompleted()) {
                    this.transactionManager.rollback(transaction);
                }
                throw e;
            }
            this.taskExecutor.execute(this::cacheBusinessObjects);
        }, (Executor)this.taskExecutor).whenComplete((v, e) -> {
            if (e == null) {
                this.openApiInfoRepoProc.updateBusinessObjectEnd(openApiDO.getId(), OpenApiStatusEnum.FINISHED, null);
                return;
            }
            log.error("OpenApi\u8f6c\u6362\u4e1a\u52a1\u5bf9\u8c61\u5f02\u5e38\uff1a{}", (Object)openApiDO.getId(), e);
            this.openApiInfoRepoProc.updateBusinessObjectEnd(openApiDO.getId(), OpenApiStatusEnum.FAILED, e.getMessage());
        });
    }

    private void saveBusinessObject(@NotNull SysOpenApiInfoDO apiInfoDO, @NotNull OpenApiSourceEnum source, List<BusinessObjectConvertBO> businessObjectBoList) {
        if (CollUtil.isEmpty(businessObjectBoList)) {
            this.deleteGatherForGatherByOpenApiCode(apiInfoDO.getOpenApiCode());
            return;
        }
        Map<String, SysBusinessObjectDO> businessObjectMap = this.businessObjectRepoProc.listByOpenApiCode(apiInfoDO.getOpenApiCode()).stream().collect(Collectors.toMap(SysBusinessObjectDO::getCode, t -> t, (t1, t2) -> t1));
        Map<String, Map<String, SysBusinessObjectRefDO>> businessObjectRefMap = this.refRepoProc.listByOpenApiCode(apiInfoDO.getOpenApiCode()).stream().collect(Collectors.groupingBy(SysBusinessObjectRefDO::getBusinessObjectCode, Collectors.mapping(Function.identity(), Collectors.toMap(t -> t.getRefType() + ":" + t.getRef(), Function.identity()))));
        Map<String, Map<String, SysBusinessParamDO>> businessParamMap = this.businessParamRepoProc.listByOpenApiCode(apiInfoDO.getOpenApiCode()).stream().collect(Collectors.groupingBy(SysBusinessParamDO::getBusinessObjectCode, Collectors.mapping(Function.identity(), Collectors.toMap(SysBusinessParamDO::getFieldName, Function.identity()))));
        Map<String, Map<String, SysBusinessOperationDO>> businessOperationMap = this.businessOperationRepoProc.listByOpenApiCode(apiInfoDO.getOpenApiCode()).stream().collect(Collectors.groupingBy(SysBusinessOperationDO::getBusinessObjectCode, Collectors.mapping(Function.identity(), Collectors.toMap(SysBusinessOperationDO::getOperationCode, Function.identity()))));
        Map<String, Map<String, SysBusinessOperationParamDO>> businessOperationParamMap = this.businessOperationParamRepoProc.listByOpenApiCode(apiInfoDO.getOpenApiCode()).stream().collect(Collectors.groupingBy(SysBusinessOperationParamDO::getOpenApiOperationCode, Collectors.mapping(Function.identity(), Collectors.toMap(t -> t.getParamIn() + ":" + t.getParamPath(), Function.identity()))));
        HashSet<String> businessObjectSaved = new HashSet<String>(businessObjectBoList.size());
        for (BusinessObjectConvertBO businessObjectBO : businessObjectBoList) {
            this.saveOrUpdateBusinessObject(businessObjectBO, businessObjectMap, businessObjectRefMap, businessParamMap, businessOperationMap, businessOperationParamMap, source);
            businessObjectSaved.add(businessObjectBO.getCode());
        }
        List<Long> toDelBusinessObjectIds = businessObjectMap.values().stream().filter(t -> !businessObjectSaved.contains(t.getCode())).map(BaseModel::getId).collect(Collectors.toList());
        if (!toDelBusinessObjectIds.isEmpty()) {
            this.businessObjectRepoProc.delete(toDelBusinessObjectIds);
            this.refRepoProc.deleteByBusinessObjectIds(toDelBusinessObjectIds);
            this.businessOperationRepoProc.deleteByBusinessObjectId(toDelBusinessObjectIds);
            this.businessOperationParamRepoProc.deleteByBusinessObjectId(toDelBusinessObjectIds);
            this.businessParamRepoProc.deleteByBusinessObject(toDelBusinessObjectIds);
        }
    }

    private void saveOrUpdateBusinessObject(BusinessObjectConvertBO businessObjectBO, Map<String, SysBusinessObjectDO> businessObjectMap, Map<String, Map<String, SysBusinessObjectRefDO>> businessObjectRefMap, Map<String, Map<String, SysBusinessParamDO>> businessParamMap, Map<String, Map<String, SysBusinessOperationDO>> businessOperationMap, Map<String, Map<String, SysBusinessOperationParamDO>> businessOperationParamMap, OpenApiSourceEnum source) {
        Assert.hasText((String)businessObjectBO.getCode(), (String)"\u4e1a\u52a1\u5bf9\u8c61\u7f16\u7801\u4e3a\u7a7a");
        SysBusinessObjectDO businessObjectDO = businessObjectMap.getOrDefault(businessObjectBO.getCode(), new SysBusinessObjectDO());
        BusinessObjectConvert.INSTANCE.bo2Do(businessObjectBO, businessObjectDO);
        if (businessObjectDO.getId() == null) {
            businessObjectDO.setDataSource(source.name());
        }
        try {
            this.businessObjectRepoProc.save((Serializable)businessObjectDO);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("\u4fdd\u5b58\u4e1a\u52a1\u5bf9\u8c61[" + businessObjectBO.getCode() + "]\u5931\u8d25\uff0c" + e.getMessage(), e);
        }
        this.saveOrUpdateBusinessParam(businessObjectBO.getBusinessParamMap(), businessObjectDO, businessParamMap);
        this.saveOrUpdateBusinessObjectRef(businessObjectBO.getRefBusinessObjectOperations(), businessObjectDO, businessObjectRefMap, source);
        this.saveOrUpdateBusinessOperation(businessObjectBO.getOperationMap(), businessObjectDO, businessParamMap, businessOperationMap, businessOperationParamMap, source);
    }

    private void saveOrUpdateBusinessObjectRef(String[] refBos, SysBusinessObjectDO businessObjectDO, Map<String, Map<String, SysBusinessObjectRefDO>> businessObjectRefMap, OpenApiSourceEnum source) {
        if (ArrayUtil.isEmpty((Object[])refBos)) {
            this.refRepoProc.deleteByBusinessObjectIds(businessObjectDO.getId());
            return;
        }
        Map refDoMap = businessObjectRefMap.getOrDefault(businessObjectDO.getCode(), Collections.emptyMap());
        HashSet<CallSite> refSaved = new HashSet<CallSite>();
        int i = 0;
        BusinessObjectRefTypeEnum type = BusinessObjectRefTypeEnum.BUSINESS_OPERATION;
        for (String ref : refBos) {
            if (!StringUtils.hasText((String)ref) || refSaved.contains(type.name() + ":" + ref)) continue;
            refSaved.add((CallSite)((Object)(type.name() + ":" + ref)));
            SysBusinessObjectRefDO refDO = refDoMap.getOrDefault(type.name() + ":" + ref, new SysBusinessObjectRefDO());
            refDO.setOpenApiCode(businessObjectDO.getOpenApiCode());
            refDO.setBusinessObjectId(businessObjectDO.getId());
            refDO.setBusinessObjectCode(businessObjectDO.getCode());
            refDO.setRef(ref);
            refDO.setRefType(type.name());
            refDO.setSortNo(Integer.valueOf(i++));
            if (refDO.getId() == null) {
                refDO.setDataSource(source.name());
            }
            try {
                this.refRepoProc.save((Serializable)refDO);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("\u4fdd\u5b58\u4e1a\u52a1\u5bf9\u8c61[" + businessObjectDO.getCode() + "]\u7684\u5173\u8054\u64cd\u4f5c" + ref + "\u5931\u8d25\uff0c" + e.getMessage(), e);
            }
        }
        List toDelRefIds = refDoMap.values().stream().filter(t -> !refSaved.contains(t.getRefType() + ":" + t.getRef())).map(BaseModel::getId).collect(Collectors.toList());
        if (!toDelRefIds.isEmpty()) {
            this.refRepoProc.delete(toDelRefIds);
        }
    }

    private void saveOrUpdateBusinessParam(Map<String, BusinessObjectConvertBO.BusinessParam> businessParamBoMap, SysBusinessObjectDO businessObjectDO, Map<String, Map<String, SysBusinessParamDO>> businessParamMap) {
        if (CollUtil.isEmpty(businessParamBoMap)) {
            this.businessParamRepoProc.deleteByBusinessObject(businessObjectDO.getId(), -1L);
            return;
        }
        Map businessParamDoMap = businessParamMap.getOrDefault(businessObjectDO.getCode(), Collections.emptyMap());
        HashSet<String> businessParamSaved = new HashSet<String>(businessParamBoMap.size());
        int i = 0;
        for (BusinessObjectConvertBO.BusinessParam businessParamBO : businessParamBoMap.values()) {
            Assert.hasText((String)businessParamBO.getFieldName(), () -> "\u4e1a\u52a1\u5bf9\u8c61[" + businessObjectDO.getCode() + "]\u5b58\u5728\u53c2\u6570\u540d\u79f0\u4e3a\u7a7a");
            SysBusinessParamDO businessParamDO = businessParamDoMap.getOrDefault(businessParamBO.getFieldName(), new SysBusinessParamDO());
            BusinessObjectConvert.INSTANCE.bo2Do(businessParamBO, businessParamDO);
            businessParamDO.setValuesJson(ArrayUtil.isEmpty((Object[])businessParamBO.getValues()) ? null : JSONUtil.toJsonString((Object)businessParamBO.getValues()));
            businessParamDO.setBusinessObjectId(businessObjectDO.getId());
            businessParamDO.setBusinessOperationId(Long.valueOf(-1L));
            businessParamDO.setBusinessOperationParamId(Long.valueOf(-1L));
            businessParamDO.setSubTable(Boolean.valueOf(businessParamBO.isSub()));
            businessParamDO.setEnabled(Boolean.valueOf(true));
            businessParamDO.setEntityField(Boolean.valueOf(true));
            businessParamDO.setSortNo(Integer.valueOf(i++));
            businessParamSaved.add(businessParamBO.getFieldName());
            try {
                this.businessParamRepoProc.save((Serializable)businessParamDO);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("\u4fdd\u5b58\u4e1a\u52a1\u5bf9\u8c61[" + businessObjectDO.getCode() + "]\u7684\u53c2\u6570" + businessParamBO.getFieldName() + "\u5931\u8d25\uff0c" + e.getMessage(), e);
            }
        }
        List toDelBusinessParamIds = businessParamDoMap.values().stream().filter(t -> !businessParamSaved.contains(t.getFieldName())).map(BaseModel::getId).collect(Collectors.toList());
        if (!toDelBusinessParamIds.isEmpty()) {
            this.businessParamRepoProc.delete(toDelBusinessParamIds);
        }
    }

    private void saveOrUpdateBusinessOperation(Map<String, BusinessObjectConvertBO.Operation> operationBoMap, SysBusinessObjectDO businessObjectDO, Map<String, Map<String, SysBusinessParamDO>> businessParamMap, Map<String, Map<String, SysBusinessOperationDO>> businessOperationMap, Map<String, Map<String, SysBusinessOperationParamDO>> businessOperationParamMap, OpenApiSourceEnum source) {
        if (CollUtil.isEmpty(operationBoMap) && businessOperationMap.containsKey(businessObjectDO.getCode())) {
            this.businessOperationRepoProc.deleteByBusinessObjectId(businessObjectDO.getId());
            this.businessOperationParamRepoProc.deleteByBusinessObjectId(businessObjectDO.getId());
            this.businessParamRepoProc.deleteForOperation(businessObjectDO.getId());
            return;
        }
        Map businessOperationDoMap = businessOperationMap.getOrDefault(businessObjectDO.getCode(), Collections.emptyMap());
        HashSet<String> businessOperationSaved = new HashSet<String>(businessOperationMap.size());
        for (BusinessObjectConvertBO.Operation operationBO : operationBoMap.values()) {
            String operationCode = operationBO.getOperationCode();
            Assert.hasText((String)operationCode, () -> "[" + businessObjectDO.getCode() + "]\u5b58\u5728\u64cd\u4f5c\u7684\u7f16\u7801\u4e3a\u7a7a");
            SysBusinessOperationDO businessOperationDO = (SysBusinessOperationDO)businessOperationDoMap.get(operationCode);
            if (businessOperationDO == null) {
                businessOperationDO = businessOperationMap.values().stream().flatMap(t -> t.values().stream()).filter(t -> operationCode.equals(t.getOperationCode())).findAny().orElse(new SysBusinessOperationDO());
            }
            BusinessObjectConvert.INSTANCE.bo2Do(operationBO, businessOperationDO);
            businessOperationDO.setBusinessObjectId(businessObjectDO.getId());
            if (businessOperationDO.getId() == null) {
                businessOperationDO.setDataSource(source.name());
            }
            try {
                this.businessOperationRepoProc.save((Serializable)businessOperationDO);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("\u4fdd\u5b58\u4e1a\u52a1\u5bf9\u8c61\u64cd\u4f5c[" + operationCode + "]\u5931\u8d25," + e.getMessage(), e);
            }
            this.saveOrUpdateBusinessOperationParam(operationBO.getParamList(), businessOperationDO, businessParamMap, businessOperationParamMap, source);
            businessOperationSaved.add(operationBO.getOperationCode());
        }
        List<Long> toDelBusinessOperationIds = businessOperationDoMap.values().stream().filter(t -> !businessOperationSaved.contains(t.getOperationCode())).map(BaseModel::getId).collect(Collectors.toList());
        if (!toDelBusinessOperationIds.isEmpty()) {
            this.businessOperationRepoProc.delete(toDelBusinessOperationIds);
            this.businessOperationParamRepoProc.deleteByBusinessOperationId(toDelBusinessOperationIds);
            this.businessParamRepoProc.deleteForOperation(toDelBusinessOperationIds);
        }
    }

    private void saveOrUpdateBusinessOperationParam(List<BusinessObjectConvertBO.OperationParam> paramBoList, SysBusinessOperationDO operationDO, Map<String, Map<String, SysBusinessParamDO>> businessParamMap, Map<String, Map<String, SysBusinessOperationParamDO>> businessOperationParamMap, OpenApiSourceEnum source) {
        Map businessParamDoMap;
        if (CollUtil.isEmpty(paramBoList) && businessOperationParamMap.containsKey(operationDO.getOperationCode())) {
            this.businessOperationParamRepoProc.deleteByBusinessOperationId(operationDO.getId());
            this.businessParamRepoProc.deleteByBusinessObject(operationDO.getBusinessObjectId(), operationDO.getId());
            return;
        }
        Map businessOperationParamDoMap = businessOperationParamMap.getOrDefault(operationDO.getOperationCode(), Collections.emptyMap());
        paramBoList = this.expandOperationParam(new ArrayList<BusinessObjectConvertBO.OperationParam>(), paramBoList);
        HashSet paramSaved = new HashSet(64);
        List paramDoList = paramBoList.stream().map(opp -> {
            Assert.hasText((String)opp.getParamIn(), () -> "[" + operationDO.getOperationCode() + "]\u5b58\u5728\u53c2\u6570paramIn\u4e3a\u7a7a");
            Assert.notNull((Object)opp.getParamPath(), () -> "[" + operationDO.getOperationCode() + "]\u5b58\u5728\u53c2\u6570paramPath\u4e3a\u7a7a");
            SysBusinessOperationParamDO paramDO = businessOperationParamDoMap.getOrDefault(opp.getParamIn() + ":" + opp.getParamPath(), new SysBusinessOperationParamDO());
            BusinessObjectConvert.INSTANCE.bo2Do((BusinessObjectConvertBO.OperationParam)opp, paramDO);
            paramDO.setBusinessObjectId(operationDO.getBusinessObjectId());
            paramDO.setBusinessOperationId(operationDO.getId());
            if (paramDO.getId() == null) {
                paramDO.setDataSource(source.name());
            }
            paramSaved.add(opp.getParamIn() + ":" + opp.getParamPath());
            return paramDO;
        }).collect(Collectors.toList());
        try {
            this.businessOperationParamRepoProc.save(paramDoList);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("\u4fdd\u5b58\u4e1a\u52a1\u64cd\u4f5c[" + operationDO.getOperationCode() + "]\u7684\u53c2\u6570\u5f02\u5e38\uff0c" + e.getMessage(), e);
        }
        List toDelBusinessOperationParamIds = businessOperationParamDoMap.values().stream().filter(t -> !paramSaved.contains(t.getParamIn() + ":" + t.getParamPath())).map(BaseModel::getId).collect(Collectors.toList());
        if (!toDelBusinessOperationParamIds.isEmpty()) {
            this.businessOperationParamRepoProc.delete(toDelBusinessOperationParamIds);
        }
        if (!(businessParamDoMap = businessParamMap.getOrDefault(operationDO.getBusinessObjectCode(), Collections.emptyMap())).isEmpty()) {
            for (SysBusinessParamDO businessParamDO : businessParamDoMap.values()) {
                if (!toDelBusinessOperationParamIds.contains(businessParamDO.getBusinessOperationParamId())) continue;
                this.businessParamRepoProc.delete(businessParamDO.getId());
            }
        }
    }

    private void deleteGatherForGatherByOpenApiCode(String openApiCode) {
        log.info("\u6839\u636eOpenApiId\u5220\u9664\u81ea\u52a8\u6293\u53d6\u7684\u4e1a\u52a1\u5bf9\u8c61\uff1a{}", (Object)openApiCode);
        this.businessObjectRepoProc.deleteForGatherByOpenApiCode(openApiCode);
        this.businessOperationRepoProc.deleteForGatherByOpenApiCode(openApiCode);
        this.businessOperationParamRepoProc.deleteForGatherByOpenApiCode(openApiCode);
        this.businessParamRepoProc.deleteForGatherByOpenApiCode(openApiCode);
    }

    private List<BusinessObjectConvertBO.OperationParam> expandOperationParam(List<BusinessObjectConvertBO.OperationParam> paramAll, List<BusinessObjectConvertBO.OperationParam> paramRoot) {
        if (paramAll == null) {
            paramAll = new ArrayList<BusinessObjectConvertBO.OperationParam>();
        }
        if (paramRoot != null) {
            for (BusinessObjectConvertBO.OperationParam param : paramRoot) {
                paramAll.add(param);
                this.expandOperationParam(paramAll, param.getItemList());
            }
        }
        return paramAll;
    }

    private List<BusinessObjectConvertBO> convertOpenApi2BusinessObject(SysOpenApiInfoDO openApi) {
        List<SysOpenApiOperationDO> openApiOperationDoList = this.openApiOperationRepoProc.listByOpenApiId(openApi.getId()).stream().filter(t -> {
            if (Boolean.FALSE.equals(t.getEnabled())) {
                return false;
            }
            if (!Boolean.TRUE.equals(t.getBusinessOperation())) {
                return false;
            }
            return OpenApiSourceEnum.GATHER_PULL.name().equals(t.getDataSource()) || OpenApiSourceEnum.GATHER_PUSH.name().equals(t.getDataSource());
        }).collect(Collectors.toList());
        if (openApiOperationDoList.isEmpty()) {
            return Collections.emptyList();
        }
        RootContext context = new RootContext(openApi);
        openApiOperationDoList.forEach(t -> this.analyzeBusinessObject(context, (SysOpenApiOperationDO)t));
        return new ArrayList<BusinessObjectConvertBO>(context.businessObjects.values());
    }

    private void analyzeBusinessObject(@NotNull RootContext context, @NotNull SysOpenApiOperationDO apiOperationDO) {
        if (context.businessObjects.isEmpty()) {
            context.businessObjects.putAll(this.queryBusinessObject(context.openApiDO));
        }
        if (context.businessObjects.isEmpty()) {
            return;
        }
        Operation apiOperation = apiOperationDO.getResourceId() == null ? null : (Operation)JSONUtil.jsonBytes2Obj((byte[])this.resourceRepoProc.getResourceBytes(apiOperationDO.getResourceId()), Operation.class);
        BusinessOperationContext businessObjectContext = new BusinessOperationContext(context, apiOperationDO, apiOperation);
        this.obtainBusinessOperation(businessObjectContext);
    }

    private Map<String, BusinessObjectConvertBO> queryBusinessObject(SysOpenApiInfoDO openApiDO) {
        if (openApiDO.getBusinessResourceId() == null) {
            return Collections.emptyMap();
        }
        byte[] resources = this.resourceRepoProc.getResourceBytes(openApiDO.getBusinessResourceId());
        if (ArrayUtil.isEmpty((byte[])resources)) {
            throw new BusinessException("\u672a\u67e5\u8be2\u5230\u4e1a\u52a1\u5bf9\u8c61\u8d44\u6e90\uff1a" + openApiDO.getId());
        }
        Map businessObjectInfoMap = (Map)JSONUtil.jsonBytes2Obj((byte[])resources, (TypeReference)new TypeReference<Map<String, BusinessObjectInfo>>(){}, (boolean)false, () -> "\u4eceOpenAPI\u4e2d\u8bfb\u53d6\u4e1a\u52a1\u5bf9\u8c61\u4fe1\u606f\u5931\u8d25");
        if (CollUtil.isEmpty((Map)businessObjectInfoMap)) {
            return Collections.emptyMap();
        }
        HashMap<String, BusinessObjectConvertBO> result = new HashMap<String, BusinessObjectConvertBO>(businessObjectInfoMap.size());
        BusinessObjectConvertBO businessObjectBO = null;
        String businessObjectCode = null;
        for (Map.Entry entry : businessObjectInfoMap.entrySet()) {
            businessObjectCode = ((String)entry.getKey()).split(":")[0];
            if (result.containsKey(businessObjectCode)) continue;
            businessObjectBO = new BusinessObjectConvertBO();
            businessObjectBO.setOpenApiCode(openApiDO.getOpenApiCode());
            businessObjectBO.setAppCode(openApiDO.getAppCode());
            businessObjectBO.setCode(businessObjectCode);
            String[] tempArray = ((BusinessObjectInfo)entry.getValue()).getBusinessType().split(":");
            if (tempArray.length > 1) {
                businessObjectBO.setName(tempArray[1]);
            }
            businessObjectBO.setDescription(((BusinessObjectInfo)entry.getValue()).getBusinessDescription());
            businessObjectBO.setDomain(((BusinessObjectInfo)entry.getValue()).getDomain());
            businessObjectBO.setEnabled(true);
            businessObjectBO.setRefBusinessObjectOperations(((BusinessObjectInfo)entry.getValue()).getRefBusinessObjectOperations());
            businessObjectBO.setPublicResource(((BusinessObjectInfo)entry.getValue()).getPublicResource());
            businessObjectBO.setSupportTenant(((BusinessObjectInfo)entry.getValue()).getSupportTenant());
            Map<String, BusinessObjectConvertBO.BusinessParam> businessParams = this.convertBusinessParam(openApiDO.getOpenApiCode(), businessObjectBO.getCode(), ((BusinessObjectInfo)entry.getValue()).getParamInfoList());
            businessObjectBO.setBusinessParamMap(businessParams);
            if (!businessParams.isEmpty()) {
                businessObjectBO.setEntityClassName(businessParams.values().stream().findFirst().map(BusinessObjectConvertBO.BusinessParam::getEntityClassName).orElse(null));
            }
            businessObjectBO.setOperationMap(new HashMap<String, BusinessObjectConvertBO.Operation>(32));
            result.put(businessObjectCode, businessObjectBO);
        }
        return result;
    }

    private Map<String, BusinessObjectConvertBO.BusinessParam> convertBusinessParam(String openApiCode, String businessObjectCode, List<BusinessObjectParamInfo> paramInfoList) {
        if (CollUtil.isEmpty(paramInfoList)) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, BusinessObjectConvertBO.BusinessParam> paramMap = new LinkedHashMap<String, BusinessObjectConvertBO.BusinessParam>(64);
        BusinessObjectConvertBO.BusinessParam paramBO = null;
        for (BusinessObjectParamInfo paramInfo : paramInfoList) {
            if (CollUtil.isEmpty((Collection)paramInfo.getParamList())) continue;
            for (BusinessObjectParamInfo.Param param : paramInfo.getParamList()) {
                Assert.hasText((String)param.getFieldName(), () -> "OpenApi[" + openApiCode + "]\u7684\u4e1a\u52a1\u5bf9\u8c61\u5b58\u5728\u53c2\u6570\u540d\u79f0\u4e3a\u7a7a");
                if (paramMap.containsKey(param.getFieldName())) continue;
                paramBO = new BusinessObjectConvertBO.BusinessParam();
                paramBO.setOpenApiCode(openApiCode);
                paramBO.setBusinessObjectCode(businessObjectCode);
                paramBO.setEntityClassName(paramInfo.getClassName());
                paramBO.setTableName(paramInfo.getTableName());
                paramBO.setFieldName(param.getFieldName());
                paramBO.setColumnName(param.getColumnName());
                paramBO.setFieldDescription(param.getFieldComment());
                paramBO.setFieldJavaType(param.getJavaType());
                paramBO.setSub(paramInfo.isSub());
                paramBO.setRelatedMasField(paramInfo.getRelatedField());
                paramBO.setMasField(paramInfo.getMasField());
                paramBO.setSingle(param.isSingle());
                paramBO.setEnumeration(param.isEnumeration());
                paramBO.setEnumType(param.getEnumType());
                paramBO.setRelatedBusinessObject(param.getRelatedBusinessObject());
                paramBO.setRelatedField(param.getRelatedField());
                paramBO.setValues(param.getValues());
                paramBO.setUserType(param.getUserType());
                paramBO.setDataPermissionEnabled(param.isDataPermissionEnabled());
                paramBO.setFieldPermissionEnabled(param.isFieldPermissionEnabled());
                paramBO.setBaseField(param.isBaseField());
                paramBO.setDeprecated(param.isDeprecated());
                paramMap.put(param.getFieldName(), paramBO);
            }
        }
        return paramMap;
    }

    private BusinessObjectConvertBO.Operation obtainBusinessOperation(@NotNull BusinessOperationContext operationContext) {
        BusinessObjectOperationInfo businessObjectOperationInfo = (BusinessObjectOperationInfo)JSONUtil.convertObj((Object)operationContext.openApiOperationExtensions.get("x-BusinessObject-Operation"), BusinessObjectOperationInfo.class, (boolean)true);
        SysOpenApiOperationDO apiOperationDO = operationContext.openApiOperationDO;
        Assert.notNull((Object)businessObjectOperationInfo, () -> "OpenApi\u7684\u64cd\u4f5c[" + apiOperationDO.getId() + "]\u7684\u6269\u5c55\u4fe1\u606f\u4e2d\u4e1a\u52a1\u64cd\u4f5c\u4e0d\u5b58\u5728");
        String operationCode = apiOperationDO.getOperationCode();
        Assert.hasText((String)operationCode, () -> "OpenApi\u7684\u64cd\u4f5c[" + apiOperationDO.getId() + "]\u7684\u4e1a\u52a1\u5bf9\u8c61\u64cd\u4f5c\u7f16\u7801\u4e3a\u7a7a");
        String businessObjectCode = businessObjectOperationInfo.getBusinessObjectType().split(":")[0];
        BusinessObjectConvertBO businessObjectBO = operationContext.rootContext.businessObjects.get(businessObjectCode);
        Assert.notNull((Object)businessObjectBO, (String)("\u4e1a\u52a1\u5bf9\u8c61[" + businessObjectCode + "]\u4e0d\u5b58\u5728"));
        operationContext.businessObjectBO = businessObjectBO;
        Assert.isTrue((!businessObjectBO.getOperationMap().containsKey(operationCode) ? 1 : 0) != 0, () -> "\u5728\u4e1a\u52a1\u5bf9\u8c61[" + businessObjectBO.getCode() + "]\u5b58\u5728\u91cd\u590d\u7684\u4e1a\u52a1\u64cd\u4f5c\u7f16\u7801:" + businessObjectOperationInfo.getOperationCode());
        BusinessObjectConvertBO.Operation operationBO = new BusinessObjectConvertBO.Operation();
        operationBO.setOpenApiCode(businessObjectBO.getOpenApiCode());
        operationBO.setBusinessObjectCode(businessObjectCode);
        operationBO.setAppCode(businessObjectBO.getAppCode());
        operationBO.setOperationCode(operationCode);
        operationBO.setOperationDescription(businessObjectOperationInfo.getOperationDescription());
        operationBO.setDetail(businessObjectOperationInfo.getDetail());
        ObjUtil.ifNotNull((Object)businessObjectOperationInfo.getOperationType(), t -> operationBO.setOperationType(t.name()));
        ObjUtil.ifNotNull((Object)businessObjectOperationInfo.getOperationScopeEnum(), t -> operationBO.setScope(t.name()));
        ObjUtil.ifNotNull((Object)businessObjectOperationInfo.getOperationStateEnum(), t -> operationBO.setState(t.name()));
        operationBO.setPermissionEnabled(businessObjectOperationInfo.isDataPermissionEnabled());
        operationBO.setFieldPermissionAutoFilter(businessObjectOperationInfo.isFieldPermissionAutoFilter());
        operationBO.setApiName(apiOperationDO.getSummary());
        operationBO.setApiDescription(apiOperationDO.getDescription());
        operationBO.setApiUrl(apiOperationDO.getUrl());
        operationBO.setApiMethod(apiOperationDO.getMethod());
        operationBO.setEnabled(businessObjectOperationInfo.isEnabled());
        operationBO.setParamList(new ArrayList<BusinessObjectConvertBO.OperationParam>());
        operationBO.setPermissionRef(businessObjectOperationInfo.getPermissionRef());
        operationContext.businessOperationBO = operationBO;
        this.fillBusinessOperationParams(operationContext, operationBO);
        businessObjectBO.getOperationMap().put(operationBO.getOperationCode(), operationBO);
        return operationBO;
    }

    private void fillBusinessOperationParams(@NotNull BusinessOperationContext operationContext, BusinessObjectConvertBO.Operation businessOperationBO) {
        List<BusinessObjectConvertBO.OperationParam> paramBO;
        Schema<?> body;
        Operation apiOperation = operationContext.openApiOperation;
        SysOpenApiOperationDO apiOperationDO = operationContext.openApiOperationDO;
        if (CollUtil.isNotEmpty((Collection)apiOperation.getParameters())) {
            for (Parameter apiParam : apiOperation.getParameters()) {
                BusinessObjectConvertBO.OperationParam paramBO2 = new BusinessObjectConvertBO.OperationParam();
                paramBO2.setOpenApiCode(operationContext.businessObjectBO.getOpenApiCode());
                paramBO2.setBusinessObjectCode(operationContext.businessObjectBO.getCode());
                paramBO2.setOpenApiOperationCode(apiOperationDO.getOperationCode());
                paramBO2.setBusinessOperationCode(businessOperationBO.getOperationCode());
                paramBO2.setFieldName(apiParam.getName());
                paramBO2.setFieldDescription(apiParam.getDescription());
                paramBO2.setRequest(true);
                Assert.hasText((String)apiParam.getIn(), () -> "OpenApi\u7684\u64cd\u4f5c[" + apiOperationDO.getId() + "]\u7684\u53c2\u6570[" + apiParam.getName() + "]\u7684\u7c7b\u578b\u4e3a\u7a7a");
                paramBO2.setFieldType(this.convert2FieldType(apiParam.getSchema()));
                paramBO2.setFieldJavaType(this.convert2JavaType(paramBO2.getFieldType()));
                paramBO2.setRef(false);
                paramBO2.setRefValue(null);
                paramBO2.setDepth(1);
                paramBO2.setParamPath(paramBO2.getFieldName() == null ? "" : paramBO2.getFieldName());
                paramBO2.setApiResult(false);
                paramBO2.setRequired(Boolean.TRUE.equals(apiParam.getRequired()));
                paramBO2.setDeprecated(Boolean.TRUE.equals(apiParam.getDeprecated()));
                paramBO2.setParamIn(apiParam.getIn());
                paramBO2.setSingle(true);
                paramBO2.setCollectionType(null);
                paramBO2.setEnabled(true);
                businessOperationBO.getParamList().add(paramBO2);
            }
        }
        if (apiOperation.getRequestBody() != null) {
            body = this.obtainRequestBody(apiOperation);
            Assert.notNull(body, () -> "OpenApi\u7684\u64cd\u4f5c[" + apiOperationDO.getId() + "]\u8bf7\u6c42\u4f53\u4e3a\u7a7a");
            paramBO = this.convertBody(operationContext, body, BusinessObjectParamInEnum.REQUEST_BODY, true, false, false, null, null, null);
            businessOperationBO.getParamList().addAll(paramBO);
        }
        if (apiOperation.getResponses() != null && (body = this.obtainResponseBody(apiOperation)) != null) {
            paramBO = this.convertBody(operationContext, body, BusinessObjectParamInEnum.RESPONSE_BODY, false, false, false, null, null, null);
            businessOperationBO.getParamList().addAll(paramBO);
        }
    }

    private List<BusinessObjectConvertBO.OperationParam> convertBody(@NotNull BusinessOperationContext operationContext, Schema<?> schema, BusinessObjectParamInEnum paramIn, boolean isRequestParam, boolean isApiResult, boolean isPagingVO, String parentRef, String parentPath, Integer depth) {
        BusinessObjectConvertBO.OperationParam param;
        Map properties;
        Operation operation = operationContext.openApiOperation;
        if (schema == null) {
            log.debug("{}\u51fa\u73b0schema\u4e3a\u7a7a", (Object)operation.getOperationId());
            return Collections.emptyList();
        }
        if ("object".equals(schema.getType()) && CollUtil.isNotEmpty((Map)(properties = schema.getProperties()))) {
            boolean finalIsApiResult = isApiResult || this.isApiResult(schema);
            boolean finalIsPagingVO = isPagingVO || this.isPagingVO(schema);
            return properties.entrySet().stream().map(entry -> this.convertSchema2Param(operationContext, (Schema)entry.getValue(), (String)entry.getKey(), paramIn, isRequestParam, finalIsApiResult, finalIsPagingVO, parentRef, parentPath, depth)).filter(Objects::nonNull).collect(Collectors.toList());
        }
        if ("array".equals(schema.getType())) {
            param = this.convertSchema2Param(operationContext, schema, schema.getName(), paramIn, isRequestParam, isApiResult, isPagingVO, parentRef, parentPath, depth);
            return param == null ? Collections.emptyList() : List.of(param);
        }
        param = this.convertSchema2Param(operationContext, schema, schema.getName(), paramIn, isRequestParam, isApiResult, isPagingVO, parentRef, parentPath, depth);
        return param == null ? Collections.emptyList() : List.of(param);
    }

    private BusinessObjectConvertBO.OperationParam convertSchema2Param(@NotNull BusinessOperationContext operationContext, Schema<?> schema, String schemaName, BusinessObjectParamInEnum paramIn, boolean isRequestParam, boolean isApiResult, boolean isPagingVO, String parentRef, String parentPath, Integer depth) {
        if (schema == null) {
            return null;
        }
        boolean isArray = "array".equals(schema.getType());
        BusinessObjectConvertBO.OperationParam param = new BusinessObjectConvertBO.OperationParam();
        param.setOpenApiCode(operationContext.businessObjectBO.getOpenApiCode());
        param.setOpenApiOperationCode(operationContext.openApiOperationDO.getOperationCode());
        param.setBusinessObjectCode(operationContext.businessObjectBO.getCode());
        param.setBusinessOperationCode(operationContext.businessOperationBO.getOperationCode());
        param.setFieldName(schemaName);
        param.setFieldDescription(schema.getDescription());
        param.setRequest(isRequestParam);
        param.setFieldType(this.convert2FieldType(schema));
        param.setFieldJavaType(this.convert2JavaType(param.getFieldType()));
        param.setRef(StringUtils.hasText((String)schema.get$ref()));
        param.setRefValue(schema.get$ref());
        param.setDepth(depth == null ? 1 : depth + 1);
        String pathName = CharSequenceUtil.blankToDefault((CharSequence)param.getFieldName(), (String)"");
        param.setParamPath((String)(parentPath == null ? pathName : parentPath + ":" + pathName));
        param.setApiResult(isApiResult);
        param.setPagingResult(isPagingVO);
        param.setRequired(Boolean.FALSE.equals(schema.getNullable()));
        param.setDeprecated(Boolean.TRUE.equals(schema.getDeprecated()));
        param.setParamIn(paramIn.toString());
        param.setSingle(!isArray);
        if (StringUtils.hasText((String)schema.get$ref())) {
            if (operationContext.resolvedComponents.contains(schema.get$ref())) {
                return null;
            }
            operationContext.resolvedComponents.add(schema.get$ref());
            if (schema.get$ref().equals(parentRef)) {
                return null;
            }
            SysOpenApiInfoDO openApiDO = operationContext.rootContext.openApiDO;
            Schema refSchema = operationContext.rootContext.componentSchemaCache.computeIfAbsent(schema.get$ref(), ref -> {
                Long resourceId = this.openApiSchemaRepoProc.getResourceId(openApiDO.getId(), (String)ref);
                Assert.notNull((Object)resourceId, () -> "OpenApi[" + openApiDO.getId() + "]\u5b58\u5728ComponentSchema\u7684\u8d44\u6e90ID\u4e3a\u7a7a\uff0cref=" + schema.get$ref());
                byte[] resource = this.resourceRepoProc.getResourceBytes(resourceId);
                Assert.isTrue((resource != null && resource.length > 0 ? 1 : 0) != 0, () -> "OpenApi[" + openApiDO.getId() + "]\u5b58\u5728ComponentSchema\u7684\u8d44\u6e90\u4e3a\u7a7a\uff0cref=" + schema.get$ref());
                return (Schema)JSONUtil.jsonBytes2Obj((byte[])resource, Schema.class);
            });
            if (refSchema != null && CharSequenceUtil.isBlank((CharSequence)param.getFieldDescription())) {
                param.setFieldDescription(refSchema.getDescription());
            }
            param.setItemList(this.convertBody(operationContext, refSchema, paramIn, isRequestParam, false, false, schema.get$ref(), param.getParamPath(), param.getDepth()));
        } else {
            param.setItemList(this.convertBody(operationContext, schema.getItems(), paramIn, isRequestParam, false, false, parentRef, param.getParamPath(), param.getDepth()));
        }
        param.setCollectionType(null);
        param.setEnabled(true);
        return param;
    }

    private boolean isApiResult(Schema<?> schema) {
        if (CollUtil.isEmpty((Map)schema.getProperties())) {
            return false;
        }
        Map properties = schema.getProperties();
        return properties.containsKey("code") && properties.containsKey("msg") && properties.containsKey("success") && properties.containsKey("errorNo") && properties.containsKey("data") && properties.containsKey("time");
    }

    public boolean isPagingVO(Schema<?> schema) {
        if (CollUtil.isEmpty((Map)schema.getProperties())) {
            return false;
        }
        Map properties = schema.getProperties();
        return properties.containsKey("total") && properties.containsKey("records");
    }

    private Schema<?> obtainRequestBody(Operation operation) {
        Assert.notNull((Object)operation, (String)"\u64cd\u4f5c\u4e3a\u7a7a");
        RequestBody requestBody = operation.getRequestBody();
        Assert.notNull((Object)requestBody, (String)"\u8bf7\u6c42\u5934\u4e3a\u7a7a");
        MediaType content = (MediaType)requestBody.getContent().get((Object)"application/json");
        return content == null ? null : content.getSchema();
    }

    private Schema<?> obtainResponseBody(Operation operation) {
        Assert.notNull((Object)operation, (String)"\u64cd\u4f5c\u4e3a\u7a7a");
        ApiResponses responses = operation.getResponses();
        if (responses.isEmpty()) {
            return null;
        }
        ApiResponse responseOk = (ApiResponse)responses.get((Object)("" + HttpStatus.OK.value()));
        if (responseOk == null) {
            return null;
        }
        Content responseContent = responseOk.getContent();
        if (responseContent == null) {
            return null;
        }
        MediaType mediaType = (MediaType)responseContent.get((Object)"application/json");
        return mediaType == null ? null : mediaType.getSchema();
    }

    private String convert2FieldType(Schema<?> schema) {
        if (schema == null) {
            return "";
        }
        if (CharSequenceUtil.isNotBlank((CharSequence)schema.get$ref())) {
            return "ref";
        }
        Object type = schema.getType();
        if (CharSequenceUtil.isBlank((CharSequence)type)) {
            return "string";
        }
        if (CharSequenceUtil.isNotBlank((CharSequence)schema.getFormat())) {
            type = (String)type + ":" + schema.getFormat();
        }
        return type;
    }

    private String convert2JavaType(String fieldType) {
        switch (fieldType) {
            case "string": {
                return String.class.getName();
            }
            case "integer:int64": {
                return Long.class.getName();
            }
            case "integer:int32": {
                return Integer.class.getName();
            }
            case "string:date-time": {
                return LocalDateTime.class.getName();
            }
            case "string:date": {
                return LocalDate.class.getName();
            }
            case "boolean": {
                return Boolean.class.getName();
            }
        }
        return null;
    }

    private void checkForGenerate(SysOpenApiInfoDO openApiDO) {
        OpenApiStatusEnum state = OpenApiStatusEnum.parse((String)openApiDO.getState());
        if (state != OpenApiStatusEnum.FINISHED) {
            throw new BusinessException("\u8bf7\u7b49\u5f85OpenApi\u66f4\u65b0\u5b8c\u6210\u540e\u518d\u64cd\u4f5c");
        }
        OpenApiStatusEnum businessObjectState = OpenApiStatusEnum.parse((String)openApiDO.getBusinessObjectState());
        if (businessObjectState == OpenApiStatusEnum.UPDATING) {
            throw new BusinessException("\u6b63\u5728\u66f4\u65b0\u4e2d\uff0c\u8bf7\u7a0d\u540e\u540e\u518d\u64cd\u4f5c");
        }
    }

    static class RootContext {
        private final SysOpenApiInfoDO openApiDO;
        private final Map<String, Schema<?>> componentSchemaCache;
        private final Map<String, BusinessObjectConvertBO> businessObjects;

        public RootContext(@NotNull SysOpenApiInfoDO openApiDO) {
            Assert.notNull((Object)openApiDO, (String)"OpenApiDO\u4fe1\u606f\u4e3a\u7a7a");
            this.openApiDO = openApiDO;
            this.componentSchemaCache = new HashMap();
            this.businessObjects = new HashMap<String, BusinessObjectConvertBO>();
        }
    }

    static class BusinessOperationContext {
        private final RootContext rootContext;
        private final SysOpenApiOperationDO openApiOperationDO;
        private final Operation openApiOperation;
        private final Map<String, Object> openApiOperationExtensions;
        private final Set<String> resolvedComponents;
        private BusinessObjectConvertBO businessObjectBO;
        private BusinessObjectConvertBO.Operation businessOperationBO;

        public BusinessOperationContext(@NotNull RootContext rootContext, @NotNull SysOpenApiOperationDO openApiOperationDO, @NotNull Operation openApiOperation) {
            Assert.notNull((Object)openApiOperation, () -> "OpenApi\u7684\u64cd\u4f5c[" + openApiOperationDO.getId() + "]\u7684\u8d44\u6e90\u4e3a\u7a7a");
            this.openApiOperationExtensions = openApiOperation.getExtensions();
            Assert.notNull(this.openApiOperationExtensions, () -> "OpenApi\u7684\u64cd\u4f5c[" + openApiOperationDO.getId() + "]\u7684\u6269\u5c55\u4fe1\u606f\u4e3a\u7a7a");
            this.rootContext = rootContext;
            this.openApiOperationDO = openApiOperationDO;
            this.openApiOperation = openApiOperation;
            this.resolvedComponents = new HashSet<String>();
        }
    }
}

