/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.service.impl;

import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.annotation.TenantOrgTransaction;
import com.elitescloud.cloudt.core.annotation.TenantTransaction;
import com.elitescloud.cloudt.core.annotation.common.TenantIsolateType;
import com.elitescloud.cloudt.platform.convert.SysPlatformCurrencyConvert;
import com.elitescloud.cloudt.platform.model.vo.extend.query.CurrencyPageQueryVO;
import com.elitescloud.cloudt.platform.model.vo.extend.resp.CurrencyPageRespVO;
import com.elitescloud.cloudt.platform.service.repo.SysPlatformCurrencyRepoProc;
import com.elitescloud.cloudt.system.cacheable.SysCacheCurrencyRpcService;
import com.elitescloud.cloudt.system.service.CurrencyMngService;
import com.elitescloud.cloudt.system.service.model.entity.SysTenantCurrencyDO;
import com.elitescloud.cloudt.system.service.repo.CurrencyRepoProc;
import com.elitescloud.cloudt.system.service.repo.TenantCurrencyRepo;
import com.elitescloud.cloudt.system.service.repo.TenantCurrencyRepoProc;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@TenantTransaction(isolateType=TenantIsolateType.TENANT)
@TenantOrgTransaction(useTenantOrg=false)
public class CurrencyMngServiceImpl
extends BaseServiceImpl
implements CurrencyMngService {
    private static final SysPlatformCurrencyConvert CONVERT = SysPlatformCurrencyConvert.INSTANCE;
    @Autowired
    private TenantCurrencyRepo tenantCurrencyRepo;
    @Autowired
    private TenantCurrencyRepoProc tenantCurrencyRepoProc;
    @Autowired
    private CurrencyRepoProc currencyRepoProc;
    @Autowired
    private SysPlatformCurrencyRepoProc platformCurrencyRepoProc;
    @Autowired
    private SysCacheCurrencyRpcService cacheCurrencyRpcService;

    @Override
    public ApiResult<PagingVO<CurrencyPageRespVO>> page(CurrencyPageQueryVO queryVO) {
        if (Boolean.FALSE.equals(queryVO.getEnabled())) {
            Long tenantId = super.currentTenantId();
            List<String> currCodes = this.tenantCurrencyRepoProc.queryCurrCodesOfDisabled(tenantId);
            PagingVO result = ((PagingVO)this.tenantDataIsolateProvider.byDefaultDirectly(() -> this.currencyRepoProc.pageMng(queryVO, currCodes))).map(arg_0 -> ((SysPlatformCurrencyConvert)CONVERT).do2PageRespVO(arg_0));
            return ApiResult.ok((Object)result);
        }
        PagingVO result = ((PagingVO)this.tenantDataIsolateProvider.byDefaultDirectly(() -> this.currencyRepoProc.pageMng(queryVO, null))).map(arg_0 -> ((SysPlatformCurrencyConvert)CONVERT).do2PageRespVO(arg_0));
        if (result.isNotEmpty()) {
            Long tenantId = super.currentTenantId();
            List<String> currCodes = this.tenantCurrencyRepoProc.queryCurrCodesOfDisabled(tenantId);
            result.each(t -> {
                if (currCodes.contains(t.getCurrCode())) {
                    t.setEnabled(Boolean.valueOf(false));
                }
            });
        }
        return ApiResult.ok((Object)result);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> execSwitchEnabled(Long id) {
        String currCode = (String)this.tenantDataIsolateProvider.byDefaultDirectly(() -> this.platformCurrencyRepoProc.getCurrCode(id.longValue()));
        if (CharSequenceUtil.isBlank((CharSequence)currCode)) {
            return ApiResult.fail((String)"\u8d27\u5e01\u4e0d\u5b58\u5728");
        }
        this.cacheCurrencyRpcService.clearCache();
        Long tenantId = super.currentTenantId();
        Long recordId = this.tenantCurrencyRepoProc.getId(tenantId, currCode);
        if (recordId != null) {
            this.tenantCurrencyRepoProc.delete(recordId);
            return ApiResult.ok((Object)id);
        }
        SysTenantCurrencyDO tenantCurrencyDO = new SysTenantCurrencyDO();
        tenantCurrencyDO.setSysTenantId(tenantId);
        tenantCurrencyDO.setCurrCode(currCode);
        tenantCurrencyDO.setEnabled(Boolean.valueOf(false));
        this.tenantCurrencyRepo.save(tenantCurrencyDO);
        return ApiResult.ok((Object)id);
    }
}

