/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.boot.common.param.CodeNameParam;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.core.annotation.TenantOrgTransaction;
import com.elitescloud.cloudt.core.annotation.TenantTransaction;
import com.elitescloud.cloudt.core.annotation.common.TenantIsolateType;
import com.elitescloud.cloudt.platform.service.repo.SysPlatformCurrencyRepoProc;
import com.elitescloud.cloudt.system.convert.CurrencyConvert;
import com.elitescloud.cloudt.system.dto.req.SysCurrencyQueryDTO;
import com.elitescloud.cloudt.system.dto.resp.SysCurrencyRespDTO;
import com.elitescloud.cloudt.system.service.CurrencyQueryService;
import com.elitescloud.cloudt.system.service.model.entity.SysPlatformCurrencyDO;
import com.elitescloud.cloudt.system.service.repo.CurrencyRepoProc;
import com.elitescloud.cloudt.system.service.repo.TenantCurrencyRepoProc;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@TenantTransaction(isolateType=TenantIsolateType.TENANT)
@TenantOrgTransaction(useTenantOrg=false)
public class CurrencyQueryServiceImpl
extends BaseServiceImpl
implements CurrencyQueryService {
    private static final CurrencyConvert CONVERT = CurrencyConvert.INSTANCE;
    @Autowired
    private SysPlatformCurrencyRepoProc platformCurrencyRepoProc;
    @Autowired
    private CurrencyRepoProc repoProc;
    @Autowired
    private TenantCurrencyRepoProc tenantCurrencyRepoProc;

    @Override
    public ApiResult<List<CodeNameParam>> listCurrency() {
        List dataList = this.currencyTemplate(() -> this.platformCurrencyRepoProc.listAll());
        if (dataList.isEmpty()) {
            return ApiResult.ok((Object)dataList);
        }
        List<String> codesDisabled = this.disabledOfTenant();
        if (!codesDisabled.isEmpty()) {
            dataList = dataList.stream().filter(t -> !codesDisabled.contains(t.getCode())).collect(Collectors.toList());
        }
        return ApiResult.ok((Object)dataList);
    }

    @Override
    public ApiResult<SysCurrencyRespDTO> getByCode(String currCode) {
        if (CharSequenceUtil.isBlank((CharSequence)currCode)) {
            return ApiResult.fail((String)"\u7f16\u7801\u4e3a\u7a7a");
        }
        SysPlatformCurrencyDO currencyDo = this.currencyTemplate(() -> this.repoProc.getByCode(currCode));
        if (currencyDo == null) {
            return ApiResult.noData();
        }
        SysCurrencyRespDTO dto = CONVERT.vo2Dto(currencyDo);
        if (Boolean.TRUE.equals(dto.getEnabled())) {
            List<String> disabledCodes = this.disabledOfTenant();
            dto.setEnabled(Boolean.valueOf(!disabledCodes.contains(currencyDo.getCurrCode())));
        }
        return ApiResult.ok((Object)dto);
    }

    @Override
    public ApiResult<List<SysCurrencyRespDTO>> listByCodes(Set<String> currCodes) {
        Set codes;
        Set set = codes = currCodes == null ? null : currCodes.stream().filter(Objects::nonNull).collect(Collectors.toSet());
        if (CollUtil.isEmpty(codes)) {
            return ApiResult.ok(Collections.emptyList());
        }
        List currencyDoList = this.currencyTemplate(() -> this.repoProc.getByCodes(codes));
        List<SysCurrencyRespDTO> dtoList = this.do2Dto(currencyDoList);
        return ApiResult.ok(dtoList);
    }

    @Override
    public ApiResult<List<SysCurrencyRespDTO>> queryList(SysCurrencyQueryDTO queryDTO) {
        List currencyDoList = this.currencyTemplate(() -> this.repoProc.queryList(queryDTO));
        List<SysCurrencyRespDTO> dtoList = this.do2Dto(currencyDoList);
        return ApiResult.ok(dtoList);
    }

    private <T> T currencyTemplate(Supplier<T> supplier) {
        return (T)this.tenantDataIsolateProvider.byDefaultDirectly(supplier);
    }

    private List<String> disabledOfTenant() {
        Long tenantId = super.currentTenantId();
        return this.tenantCurrencyRepoProc.queryCurrCodesOfDisabled(tenantId);
    }

    private List<SysCurrencyRespDTO> do2Dto(List<SysPlatformCurrencyDO> currencyDoList) {
        if (CollUtil.isEmpty(currencyDoList)) {
            return Collections.emptyList();
        }
        List<String> disabledCodes = this.disabledOfTenant();
        return currencyDoList.stream().map(t -> {
            SysCurrencyRespDTO dto = CONVERT.vo2Dto((SysPlatformCurrencyDO)t);
            dto.setEnabled(Boolean.valueOf(Boolean.TRUE.equals(t.getEnabled()) && !disabledCodes.contains(t.getCurrCode())));
            return dto;
        }).collect(Collectors.toList());
    }
}

