/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.service.impl;

import cn.hutool.core.collection.CollUtil;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.constant.CurrencyRateCalcMethod;
import com.elitescloud.cloudt.core.annotation.TenantOrgTransaction;
import com.elitescloud.cloudt.core.annotation.TenantTransaction;
import com.elitescloud.cloudt.core.annotation.common.TenantIsolateType;
import com.elitescloud.cloudt.system.convert.CurrencyRateConvert;
import com.elitescloud.cloudt.system.model.vo.query.extend.CurrencyRatePageQueryVO;
import com.elitescloud.cloudt.system.model.vo.resp.extend.CurrencyRateDetailRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.extend.CurrencyRatePageRespVO;
import com.elitescloud.cloudt.system.model.vo.save.extend.CurrencyRateSaveVO;
import com.elitescloud.cloudt.system.service.CurrencyRateMngService;
import com.elitescloud.cloudt.system.service.model.entity.SysCurrencyRateDO;
import com.elitescloud.cloudt.system.service.repo.CurrencyRateRepoProc;
import com.elitescloud.cloudt.system.service.repo.CurrencyRepoProc;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
@TenantTransaction(isolateType=TenantIsolateType.TENANT)
@TenantOrgTransaction(useTenantOrg=false)
public class CurrencyRateMngServiceImpl
extends BaseServiceImpl
implements CurrencyRateMngService {
    private static final CurrencyRateConvert CONVERT = CurrencyRateConvert.INSTANCE;
    @Autowired
    private CurrencyRateRepoProc currencyRateRepoProc;
    @Autowired
    private CurrencyRepoProc currencyRepoProc;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> save(CurrencyRateSaveVO saveVO) {
        SysCurrencyRateDO rateDO;
        try {
            rateDO = saveVO.getId() == null ? this.convertForInsert(saveVO) : this.convertForUpdate(saveVO);
        }
        catch (IllegalArgumentException e) {
            return ApiResult.fail((String)("\u4fdd\u5b58\u5931\u8d25\uff0c" + e.getMessage()));
        }
        this.currencyRateRepoProc.save((Serializable)rateDO);
        return ApiResult.ok((Object)rateDO.getId());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> delete(Long id) {
        this.currencyRateRepoProc.delete(id);
        return ApiResult.ok((Object)id);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> updateEnabled(Long id) {
        Boolean enabled = this.currencyRateRepoProc.getEnabled(id);
        enabled = enabled == null || enabled == false;
        this.currencyRateRepoProc.updateEnabled(id, enabled);
        return ApiResult.ok((Object)id);
    }

    @Override
    public ApiResult<PagingVO<CurrencyRatePageRespVO>> page(CurrencyRatePageQueryVO queryVO) {
        PagingVO pageData = this.currencyRateRepoProc.pageMng(queryVO).map(CONVERT::do2PageRespVO);
        if (pageData.isEmpty()) {
            return ApiResult.ok((Object)pageData);
        }
        Set<String> currCodes = pageData.stream().flatMap(t -> Stream.of(t.getFromCurr(), t.getToCurr())).collect(Collectors.toSet());
        if (!currCodes.isEmpty()) {
            Map<String, String> nameMap = this.queryCurrName(currCodes);
            pageData.each(t -> {
                t.setFromCurrName((String)nameMap.get(t.getFromCurr()));
                t.setToCurrName((String)nameMap.get(t.getToCurr()));
                t.setCalMethodName(this.convertCalcMethodName(t.getCalMethod()));
            });
        }
        return ApiResult.ok((Object)pageData);
    }

    @Override
    public ApiResult<CurrencyRateDetailRespVO> get(Long id) {
        return this.currencyRateRepoProc.getOptional(id).map(t -> {
            CurrencyRateDetailRespVO respVO = CONVERT.do2DetailRespVO((SysCurrencyRateDO)t);
            Map<String, String> nameMap = this.queryCurrName(List.of(t.getFromCurr(), t.getToCurr()));
            respVO.setFromCurrName(nameMap.get(t.getFromCurr()));
            respVO.setToCurrName(nameMap.get(t.getToCurr()));
            respVO.setCalMethodName(this.convertCalcMethodName(t.getCalMethod()));
            return respVO;
        }).map(ApiResult::ok).orElse(ApiResult.noData());
    }

    private SysCurrencyRateDO convertForInsert(CurrencyRateSaveVO saveVO) {
        Long existsId = this.currencyRateRepoProc.getIdByFromAndTo(saveVO.getFromCurr(), saveVO.getToCurr());
        Assert.isNull((Object)existsId, (String)("\u5df2\u5b58\u5728" + saveVO.getFromCurrName() + "\u81f3" + saveVO.getToCurrName() + "\u7684\u8f6c\u6362\u914d\u7f6e"));
        Assert.isTrue((saveVO.getRatio().compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)"\u6c47\u7387\u4e0d\u53ef\u5c0f\u4e8e0");
        CurrencyRateCalcMethod calcMethod = CurrencyRateCalcMethod.parse((String)saveVO.getCalMethod());
        Assert.notNull((Object)calcMethod, (String)"\u672a\u77e5\u7b97\u6cd5");
        if (saveVO.getEnabled() == null) {
            saveVO.setEnabled(true);
        }
        return CONVERT.saveVo2Do(saveVO);
    }

    private SysCurrencyRateDO convertForUpdate(CurrencyRateSaveVO saveVO) {
        SysCurrencyRateDO rateDO = (SysCurrencyRateDO)this.currencyRateRepoProc.get(saveVO.getId());
        Assert.notNull((Object)rateDO, (String)"\u4fee\u6539\u7684\u6570\u636e\u4e0d\u5b58\u5728");
        if (!rateDO.getFromCurr().equals(saveVO.getFromCurr()) || !rateDO.getToCurr().equals(saveVO.getToCurr())) {
            Long existsId = this.currencyRateRepoProc.getIdByFromAndTo(saveVO.getFromCurr(), saveVO.getToCurr());
            Assert.isNull((Object)existsId, (String)("\u5df2\u5b58\u5728" + saveVO.getFromCurrName() + "\u81f3" + saveVO.getToCurrName() + "\u7684\u8f6c\u6362\u914d\u7f6e"));
        }
        Assert.isTrue((saveVO.getRatio().compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)"\u6c47\u7387\u4e0d\u53ef\u5c0f\u4e8e0");
        CurrencyRateCalcMethod calcMethod = CurrencyRateCalcMethod.parse((String)saveVO.getCalMethod());
        Assert.notNull((Object)calcMethod, (String)"\u672a\u77e5\u7b97\u6cd5");
        if (saveVO.getEnabled() == null) {
            saveVO.setEnabled(true);
        }
        CONVERT.copySaveVo2Do(saveVO, rateDO);
        return rateDO;
    }

    private Map<String, String> queryCurrName(Collection<String> currCodes) {
        if (CollUtil.isEmpty(currCodes)) {
            return Collections.emptyMap();
        }
        return (Map)this.tenantDataIsolateProvider.byDefaultDirectly(() -> this.currencyRepoProc.getNameByCurrCode(currCodes));
    }

    private String convertCalcMethodName(String calcMethod) {
        CurrencyRateCalcMethod method = CurrencyRateCalcMethod.parse((String)calcMethod);
        return method == null ? null : method.getDescription();
    }
}

