/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.service.impl;

import cn.hutool.core.collection.CollUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.util.ObjUtil;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.annotation.TenantOrgTransaction;
import com.elitescloud.cloudt.core.annotation.TenantTransaction;
import com.elitescloud.cloudt.core.annotation.common.TenantIsolateType;
import com.elitescloud.cloudt.system.convert.DataRelationConvert;
import com.elitescloud.cloudt.system.model.bo.DataSelectorSimpleBO;
import com.elitescloud.cloudt.system.model.vo.query.datarelation.DataRelationPageQueryVO;
import com.elitescloud.cloudt.system.model.vo.resp.datarelation.DataRelationEditRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.datarelation.DataRelationPagedRespVO;
import com.elitescloud.cloudt.system.model.vo.save.datarelation.DataRelationSaveVO;
import com.elitescloud.cloudt.system.service.DataRelationMngService;
import com.elitescloud.cloudt.system.service.model.entity.SysDataRelationCategoryDO;
import com.elitescloud.cloudt.system.service.model.entity.SysDataRelationDO;
import com.elitescloud.cloudt.system.service.repo.BusinessObjectRepoProc;
import com.elitescloud.cloudt.system.service.repo.DataRelationCategoryRepoProc;
import com.elitescloud.cloudt.system.service.repo.DataRelationRepoProc;
import com.elitescloud.cloudt.system.service.repo.DataSelectorRepoProc;
import com.google.common.base.Functions;
import io.jsonwebtoken.lang.Assert;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Service
@TenantTransaction(isolateType=TenantIsolateType.DEFAULT)
@TenantOrgTransaction(useTenantOrg=false)
public class DataRelationMngServiceImpl
implements DataRelationMngService {
    @Autowired
    private DataRelationRepoProc repoProc;
    @Autowired
    private DataRelationCategoryRepoProc categoryRepoProc;
    @Autowired
    private BusinessObjectRepoProc businessObjectRepoProc;
    @Autowired
    private DataSelectorRepoProc dataSelectorRepoProc;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> save(DataRelationSaveVO saveVO) {
        try {
            this.checkForSave(saveVO);
        }
        catch (Exception e) {
            return ApiResult.fail((String)("\u4fdd\u5b58\u5931\u8d25\uff0c" + e.getMessage()));
        }
        SysDataRelationDO data = this.saveDataRelation(saveVO);
        this.saveCat(data, saveVO.getCats());
        return ApiResult.ok((Object)data.getId());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<List<Long>> delete(List<Long> ids) {
        Assert.notEmpty(ids, (String)"ID\u4e3a\u7a7a");
        this.categoryRepoProc.deleteByDrIds(ids);
        this.repoProc.delete(ids);
        return ApiResult.ok(ids);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> updateEnabled(Long id, Boolean enabled) {
        Assert.notNull((Object)id, (String)"ID\u4e3a\u7a7a");
        Assert.notNull((Object)enabled, (String)"\u542f\u7528\u72b6\u6001\u4e3a\u7a7a");
        this.repoProc.updateEnabled(id, enabled);
        return ApiResult.ok((Object)id);
    }

    @Override
    public ApiResult<DataRelationEditRespVO> get(Long id) {
        Assert.notNull((Object)id, (String)"ID\u4e3a\u7a7a");
        SysDataRelationDO drDO = (SysDataRelationDO)this.repoProc.get(id);
        if (drDO == null) {
            return ApiResult.fail((String)"\u6570\u636e\u4e0d\u5b58\u5728");
        }
        DataRelationEditRespVO respVO = DataRelationConvert.INSTANCE.do2EditRespVO(drDO);
        Set<String> boCodes = Stream.of(respVO.getBoCode(), respVO.getRefBoCode()).filter(StringUtils::hasText).collect(Collectors.toSet());
        if (!boCodes.isEmpty()) {
            Map<String, String> boCodeNameMap = this.businessObjectRepoProc.getCodeAndNames(boCodes);
            respVO.setBoName(boCodeNameMap.get(respVO.getBoCode()));
            respVO.setRefBoName(boCodeNameMap.get(respVO.getRefBoCode()));
        }
        List<DataRelationEditRespVO.Cat> catList = this.categoryRepoProc.listByDrCode(drDO.getCode()).stream().map(DataRelationConvert.INSTANCE::do2EditRespVO).collect(Collectors.toList());
        respVO.setCats(catList);
        if (StringUtils.hasText((String)respVO.getDataSelectorCode())) {
            respVO.setDataSelectorName(this.dataSelectorRepoProc.getName(respVO.getDataSelectorCode()));
        }
        return ApiResult.ok((Object)respVO);
    }

    @Override
    public ApiResult<PagingVO<DataRelationPagedRespVO>> page(DataRelationPageQueryVO queryVO) {
        PagingVO<DataRelationPagedRespVO> pageData = this.repoProc.pageMng(queryVO);
        if (pageData.isEmpty()) {
            return ApiResult.ok(pageData);
        }
        Set<String> boCodes = pageData.getRecords().stream().flatMap(t -> Stream.of(t.getBoCode(), t.getRefBoCode())).filter(StringUtils::hasText).collect(Collectors.toSet());
        Map boCodeNameMap = boCodes.isEmpty() ? Collections.emptyMap() : this.businessObjectRepoProc.getCodeAndNames(boCodes);
        Set<String> dataSelectorsCodes = pageData.getRecords().stream().map(DataRelationPagedRespVO::getDataSelectorCode).filter(StringUtils::hasText).collect(Collectors.toSet());
        Map dataSelectorMap = dataSelectorsCodes.isEmpty() ? Collections.emptyMap() : this.dataSelectorRepoProc.listByCodes(dataSelectorsCodes).stream().collect(Collectors.toMap(DataSelectorSimpleBO::getSelectorCode, Functions.identity(), (t1, t2) -> t1));
        pageData.each(t -> {
            t.setBoName((String)boCodeNameMap.get(t.getBoCode()));
            t.setRefBoName((String)boCodeNameMap.get(t.getRefBoCode()));
            ObjUtil.ifNotNull((Object)((DataSelectorSimpleBO)dataSelectorMap.get(t.getDataSelectorCode())), ds -> {
                t.setDataSelectorName(ds.getSelectorName());
                t.setComponent(ds.getComponent());
                t.setComponentCode(ds.getComponentCode());
                t.setDataApi(ds.getDataApi());
                t.setDataApiMethod(ds.getDataApiMethod());
            });
        });
        return ApiResult.ok(pageData);
    }

    private void saveCat(SysDataRelationDO drDO, List<DataRelationSaveVO.Cat> cats) {
        if (CollUtil.isEmpty(cats)) {
            this.categoryRepoProc.deleteByDrCode(drDO.getCode());
            return;
        }
        Map existsMap = this.categoryRepoProc.listByDrCode(drDO.getCode()).stream().collect(Collectors.toMap(SysDataRelationCategoryDO::getCatCode, Function.identity(), (t1, t2) -> t1));
        ArrayList<SysDataRelationCategoryDO> categoryDoList = new ArrayList<SysDataRelationCategoryDO>();
        HashSet<String> savedCodes = new HashSet<String>(cats.size());
        SysDataRelationCategoryDO categoryDO = null;
        int i = 0;
        for (DataRelationSaveVO.Cat cat : cats) {
            savedCodes.add(cat.getCatCode());
            categoryDO = (SysDataRelationCategoryDO)existsMap.get(cat.getCatCode());
            if (categoryDO == null) {
                categoryDO = new SysDataRelationCategoryDO();
                categoryDO.setDrCode(drDO.getCode());
                categoryDO.setCatCode(cat.getCatCode());
            }
            categoryDO.setCatName(cat.getCatName());
            categoryDO.setEnabled(cat.getEnabled());
            categoryDO.setSortNo(Integer.valueOf(i++));
            categoryDoList.add(categoryDO);
        }
        this.categoryRepoProc.save(categoryDoList);
        ArrayList<Long> toDelIds = new ArrayList<Long>(cats.size());
        for (Map.Entry entry : existsMap.entrySet()) {
            if (savedCodes.contains(entry.getKey())) continue;
            toDelIds.add(((SysDataRelationCategoryDO)entry.getValue()).getId());
        }
        if (!toDelIds.isEmpty()) {
            this.categoryRepoProc.delete(toDelIds);
        }
    }

    private SysDataRelationDO saveDataRelation(DataRelationSaveVO saveVO) {
        SysDataRelationDO relationDO = null;
        if (saveVO.getId() == null) {
            relationDO = new SysDataRelationDO();
        } else {
            relationDO = (SysDataRelationDO)this.repoProc.get(saveVO.getId());
            Assert.notNull((Object)relationDO, (String)"\u4fee\u6539\u7684\u6570\u636e\u4e0d\u5b58\u5728");
        }
        DataRelationConvert.INSTANCE.copy(saveVO, relationDO);
        this.repoProc.save((Serializable)relationDO);
        return relationDO;
    }

    private void checkForSave(DataRelationSaveVO saveVO) {
        List<String> existsBusinessCodes;
        Assert.hasText((String)saveVO.getCode(), (String)"\u6570\u636e\u5173\u7cfb\u7f16\u7801\u4e3a\u7a7a");
        if (saveVO.getId() == null) {
            if (this.repoProc.existsCode(saveVO.getCode(), null)) {
                throw new BusinessException("\u7f16\u7801" + saveVO.getCode() + "\u5df2\u5b58\u5728");
            }
        } else {
            String code = this.repoProc.getCode(saveVO.getId());
            Assert.isTrue((boolean)code.equals(saveVO.getCode()), (String)"\u7f16\u7801\u4e0d\u53ef\u4fee\u6539");
        }
        ObjUtil.ifNull((Object)saveVO.getEnabled(), (Object)true, saveVO::setEnabled);
        Set boCodes = Stream.of(saveVO.getBoCode(), saveVO.getRefBoCode()).filter(StringUtils::hasText).collect(Collectors.toSet());
        if (!boCodes.isEmpty() && (existsBusinessCodes = this.businessObjectRepoProc.filterCodes(Set.of(saveVO.getBoCode(), saveVO.getRefBoCode()))).size() != boCodes.size()) {
            if (StringUtils.hasText((String)saveVO.getBoCode())) {
                Assert.isTrue((boolean)existsBusinessCodes.contains(saveVO.getBoCode()), (String)"\u4e1a\u52a1\u5bf9\u8c61\u7f16\u7801\u4e0d\u5b58\u5728");
            }
            if (StringUtils.hasText((String)saveVO.getRefBoCode())) {
                Assert.isTrue((boolean)existsBusinessCodes.contains(saveVO.getRefBoCode()), (String)"\u5173\u8054\u7684\u4e1a\u52a1\u5bf9\u8c61\u7f16\u7801\u4e0d\u5b58\u5728");
            }
        }
        if (CollUtil.isNotEmpty(saveVO.getCats())) {
            HashSet<String> existsCodes = new HashSet<String>(saveVO.getCats().size());
            ArrayList<DataRelationSaveVO.Cat> cats = new ArrayList<DataRelationSaveVO.Cat>(saveVO.getCats().size());
            for (DataRelationSaveVO.Cat cat : saveVO.getCats()) {
                if (existsCodes.contains(cat.getCatCode())) {
                    throw new BusinessException(cat.getCatCode() + "\u5df2\u5b58\u5728");
                }
                existsCodes.add(cat.getCatCode());
                ObjUtil.ifNull((Object)cat.getEnabled(), (Object)true, cat::setEnabled);
                cats.add(cat);
            }
            saveVO.setCats(cats);
        }
    }
}

