/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.service.impl;

import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.boot.common.BaseUdc;
import com.elitescloud.boot.common.param.IdCodeNameParam;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.annotation.TenantTransaction;
import com.elitescloud.cloudt.core.annotation.common.TenantIsolateType;
import com.elitescloud.cloudt.system.constant.SysEmpGroupType;
import com.elitescloud.cloudt.system.convert.EmpGroupConvert;
import com.elitescloud.cloudt.system.model.vo.query.org.EmpGroupPageQueryVO;
import com.elitescloud.cloudt.system.model.vo.resp.org.EmpGroupListRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.org.EmpGroupPageRespVO;
import com.elitescloud.cloudt.system.provider.dto.SysEmpGroupDTO;
import com.elitescloud.cloudt.system.service.EmpGroupQueryService;
import com.elitescloud.cloudt.system.service.model.entity.SysEmpGroupDO;
import com.elitescloud.cloudt.system.service.repo.EmpGroupEmpRepoProc;
import com.elitescloud.cloudt.system.service.repo.EmpGroupRepoProc;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@Service
@TenantTransaction(isolateType=TenantIsolateType.TENANT)
public class EmpGroupQueryServiceImpl
extends BaseServiceImpl
implements EmpGroupQueryService {
    @Autowired
    private EmpGroupRepoProc repoProc;
    @Autowired
    private EmpGroupEmpRepoProc empGroupEmpRepoProc;

    @Override
    public ApiResult<PagingVO<EmpGroupPageRespVO>> pageQuery(EmpGroupPageQueryVO queryVO) {
        PagingVO<SysEmpGroupDO> pageData = this.repoProc.pageMng(queryVO);
        if (pageData.isEmpty()) {
            return ApiResult.ok((Object)pageData.map(EmpGroupConvert.INSTANCE::do2PageRespVO));
        }
        Map typeNames = super.udcMap((BaseUdc)new SysEmpGroupType());
        PagingVO result = pageData.map(t -> {
            EmpGroupPageRespVO vo = EmpGroupConvert.INSTANCE.do2PageRespVO((SysEmpGroupDO)t);
            vo.setTypeName((String)typeNames.get(t.getType()));
            return vo;
        });
        return ApiResult.ok((Object)result);
    }

    @Override
    public ApiResult<List<EmpGroupListRespVO>> listQuery(String type, Boolean enabled) {
        List<SysEmpGroupDO> dataList = this.repoProc.listQuery(type, enabled);
        if (dataList.isEmpty()) {
            return ApiResult.ok(Collections.emptyList());
        }
        Map typeNames = super.udcMap((BaseUdc)new SysEmpGroupType());
        List result = dataList.stream().map(t -> {
            EmpGroupListRespVO vo = EmpGroupConvert.INSTANCE.do2ListRespVO((SysEmpGroupDO)t);
            vo.setTypeName((String)typeNames.get(t.getType()));
            return vo;
        }).collect(Collectors.toList());
        return ApiResult.ok(result);
    }

    @Override
    public ApiResult<SysEmpGroupDTO> getByCode(String groupCode) {
        if (CharSequenceUtil.isBlank((CharSequence)groupCode)) {
            return ApiResult.fail((String)"\u5458\u5de5\u7ec4\u7f16\u7801\u4e3a\u7a7a");
        }
        SysEmpGroupDTO groupDTO = this.repoProc.getDtoByCode(groupCode);
        return ApiResult.ok((Object)groupDTO);
    }

    @Override
    public ApiResult<SysEmpGroupDTO> get(Long groupId) {
        if (groupId == null) {
            return ApiResult.fail((String)"\u5458\u5de5\u7ec4ID\u4e3a\u7a7a");
        }
        SysEmpGroupDTO groupDTO = this.repoProc.getDto(groupId);
        return ApiResult.ok((Object)groupDTO);
    }

    @Override
    public ApiResult<List<SysEmpGroupDTO>> listAll() {
        List<SysEmpGroupDTO> groupList = this.repoProc.getDtoList(true);
        return ApiResult.ok(groupList);
    }

    @Override
    public ApiResult<List<Long>> getUserIdsByGroupCode(String groupCode) {
        Assert.hasText((String)groupCode, (String)"\u5458\u5de5\u7ec4\u7f16\u53f7\u4e3a\u7a7a");
        List<Long> userIds = this.empGroupEmpRepoProc.queryUserIdOfGroup(groupCode);
        return ApiResult.ok(userIds);
    }

    @Override
    public ApiResult<Map<String, List<Long>>> queryUserIdsByGroupCodes(Set<String> groupCodes) {
        if (groupCodes != null) {
            groupCodes = groupCodes.stream().filter(StringUtils::hasText).collect(Collectors.toSet());
        }
        Map<String, List<Long>> groupCodeUserIdMap = this.empGroupEmpRepoProc.queryUserIdOfGroup(groupCodes);
        return ApiResult.ok(groupCodeUserIdMap);
    }

    @Override
    public ApiResult<Map<String, List<IdCodeNameParam>>> queryUsersByGroupCodes(Set<String> groupCodes) {
        if (groupCodes != null) {
            groupCodes = groupCodes.stream().filter(StringUtils::hasText).collect(Collectors.toSet());
        }
        Map<String, List<IdCodeNameParam>> groupCodeUserIdMap = this.empGroupEmpRepoProc.queryUserOfGroup(groupCodes);
        return ApiResult.ok(groupCodeUserIdMap);
    }
}

