/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.exceptions.ExceptionUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ObjUtil;
import cn.hutool.core.util.ObjectUtil;
import com.elitescloud.boot.common.BaseUdc;
import com.elitescloud.boot.common.param.IdCodeNameCheckParam;
import com.elitescloud.boot.common.param.IdCodeNameParam;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.constant.Terminal;
import com.elitescloud.cloudt.core.annotation.TenantOrgTransaction;
import com.elitescloud.cloudt.core.annotation.TenantTransaction;
import com.elitescloud.cloudt.core.annotation.common.TenantIsolateType;
import com.elitescloud.cloudt.system.constant.EmployeeType;
import com.elitescloud.cloudt.system.constant.UserSourceType;
import com.elitescloud.cloudt.system.constant.UserType;
import com.elitescloud.cloudt.system.convert.AreaConvert;
import com.elitescloud.cloudt.system.convert.EmployeeConvert;
import com.elitescloud.cloudt.system.dto.SysUserBasicDTO;
import com.elitescloud.cloudt.system.dto.SysUserTypeDTO;
import com.elitescloud.cloudt.system.dto.req.EmployeeUpsertDTO;
import com.elitescloud.cloudt.system.dto.req.UserQueryDTO;
import com.elitescloud.cloudt.system.model.entity.SysPositionDO;
import com.elitescloud.cloudt.system.model.vo.query.org.EmployeePageQueryVO;
import com.elitescloud.cloudt.system.model.vo.query.position.SysPositionConvert;
import com.elitescloud.cloudt.system.model.vo.resp.org.EmpOrgRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.org.EmployeeDetailRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.org.EmployeeOrgInfoRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.org.EmployeePagedRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.user.UserDetailRespVO;
import com.elitescloud.cloudt.system.model.vo.save.org.EmployeeOrgInfoSaveVO;
import com.elitescloud.cloudt.system.model.vo.save.org.EmployeeOrgSaveVO;
import com.elitescloud.cloudt.system.model.vo.save.org.EmployeeSaveVO;
import com.elitescloud.cloudt.system.model.vo.save.user.UserSaveVO;
import com.elitescloud.cloudt.system.provider.imports.param.ImportEmployeeBO;
import com.elitescloud.cloudt.system.service.EmployeeMngService;
import com.elitescloud.cloudt.system.service.UserMngService;
import com.elitescloud.cloudt.system.service.impl.EmployeeBaseServiceImpl;
import com.elitescloud.cloudt.system.service.manager.EmployeeMngManager;
import com.elitescloud.cloudt.system.service.manager.EmployeeQueryManager;
import com.elitescloud.cloudt.system.service.manager.PermissionMngManager;
import com.elitescloud.cloudt.system.service.manager.PermissionQueryManager;
import com.elitescloud.cloudt.system.service.model.bo.AreaBO;
import com.elitescloud.cloudt.system.service.model.bo.SysEmployeeOrgSaveBO;
import com.elitescloud.cloudt.system.service.model.bo.SysEmployeeSaveBO;
import com.elitescloud.cloudt.system.service.model.bo.SysUserSaveBO;
import com.elitescloud.cloudt.system.service.model.bo.SysUserTypeBO;
import com.elitescloud.cloudt.system.service.model.entity.SysEmployeeDO;
import com.elitescloud.cloudt.system.service.model.entity.SysEmployeeOrgDO;
import com.elitescloud.cloudt.system.service.model.entity.SysUserDO;
import com.elitescloud.cloudt.system.service.repo.EmployeeOrgRepoProc;
import com.elitescloud.cloudt.system.service.repo.EmployeeRepoProc;
import com.elitescloud.cloudt.system.service.repo.PositionRepoProc;
import com.google.common.base.Functions;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
@TenantTransaction(isolateType=TenantIsolateType.TENANT)
@TenantOrgTransaction(useTenantOrg=false)
public class EmployeeMngServiceImpl
extends EmployeeBaseServiceImpl
implements EmployeeMngService {
    private static final Logger log = LogManager.getLogger(EmployeeMngServiceImpl.class);
    @Autowired
    private EmployeeOrgRepoProc employeeOrgRepoProc;
    @Autowired
    private EmployeeMngManager employeeMngManager;
    @Autowired
    private EmployeeQueryManager employeeQueryManager;
    @Autowired
    private PermissionMngManager permissionManager;
    @Autowired
    private PermissionQueryManager permissionQueryManager;
    @Autowired
    private EmployeeRepoProc employeeRepoProc;
    @Autowired
    private PositionRepoProc positionRepoProc;
    @Autowired
    private UserMngService userMngService;

    @Override
    public ApiResult testUpdate(EmployeeSaveVO saveVO) {
        HashMap<String, String> map = null;
        if (saveVO.getExtensionAll().booleanValue()) {
            map = new HashMap<String, String>();
            map.put("test", "test");
            map.put("22", "33");
        }
        SysEmployeeDO sysEmployeeDO = new SysEmployeeDO();
        sysEmployeeDO.setUserId(Long.valueOf(0L));
        sysEmployeeDO.setRootOrgId(Long.valueOf(0L));
        sysEmployeeDO.setUsername("");
        sysEmployeeDO.setLastName("");
        sysEmployeeDO.setFirstName("");
        sysEmployeeDO.setGender("");
        sysEmployeeDO.setNickName("");
        sysEmployeeDO.setBirthDate(LocalDate.now());
        sysEmployeeDO.setCode("222test123");
        sysEmployeeDO.setType("");
        sysEmployeeDO.setDuty("");
        sysEmployeeDO.setPhoto("");
        sysEmployeeDO.setContractStartTime(LocalDateTime.now());
        sysEmployeeDO.setContractEndTime(LocalDateTime.now());
        sysEmployeeDO.setJoinTime(LocalDateTime.now());
        sysEmployeeDO.setPhone("");
        sysEmployeeDO.setEmailWork("");
        sysEmployeeDO.setMobile("");
        sysEmployeeDO.setEmail("");
        sysEmployeeDO.setIdCard("");
        sysEmployeeDO.setLeaveTime(LocalDateTime.now());
        sysEmployeeDO.setServed(Boolean.valueOf(false));
        sysEmployeeDO.setEnabled(Boolean.valueOf(false));
        sysEmployeeDO.setSortNo(Integer.valueOf(0));
        sysEmployeeDO.setCountryCode("");
        sysEmployeeDO.setProvinceCode("");
        sysEmployeeDO.setCityCode("");
        sysEmployeeDO.setCountyCode("");
        sysEmployeeDO.setAddress("");
        sysEmployeeDO.setPersonalSign("");
        sysEmployeeDO.setAvatarUrl("");
        sysEmployeeDO.setAvatarCode("");
        sysEmployeeDO.setExtensionInfo(map);
        this.employeeRepoProc.save((Serializable)sysEmployeeDO);
        Optional<SysEmployeeDO> d = this.employeeRepoProc.getByCode(sysEmployeeDO.getCode());
        System.out.println(d.get());
        this.employeeRepoProc.delete(d.get().getId());
        return ApiResult.ok();
    }

    private void updateMergeExtensionInfo(Map<String, String> sourceParamInfo, Map<String, String> targetDoInfo) {
        targetDoInfo.putAll(sourceParamInfo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> upsert(EmployeeSaveVO saveVO) {
        Long employeeId = (Long)ObjectUtil.defaultIfNull((Object)saveVO.getId(), (Object)saveVO.getEmployeeOrgInfo().getId());
        SysEmployeeSaveBO saveBO = this.toEmployeeSaveBO(saveVO.getEmployeeOrgInfo(), employeeId);
        saveBO.setWithoutLoginAccount(saveVO.getWithoutLoginAccount());
        SysUserSaveBO userSaveBO = this.toUserSaveBO(saveVO.getUserInfo(), employeeId);
        saveBO.setUserSaveBO(userSaveBO);
        saveBO.setUserId(userSaveBO.getId());
        saveBO.setEnabled((Boolean)ObjectUtil.defaultIfNull((Object)userSaveBO.getEnabled(), (Object)true));
        saveBO.setExtensionInfo(saveVO.getExtensionInfo());
        SysEmployeeDO employeeDO = this.employeeMngManager.upsert(saveBO);
        return ApiResult.ok((Object)employeeDO.getId());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<String> upsert(EmployeeUpsertDTO upsertDTO) {
        SysEmployeeSaveBO saveBO = this.toEmployeeSaveBO(upsertDTO);
        SysUserSaveBO userSaveBO = this.toUserSaveBO(upsertDTO);
        saveBO.setUserSaveBO(userSaveBO);
        saveBO.setUserId(userSaveBO.getId());
        saveBO.setEnabled((Boolean)ObjectUtil.defaultIfNull((Object)userSaveBO.getEnabled(), (Object)true));
        SysEmployeeDO employeeDO = this.employeeMngManager.upsert(saveBO);
        return ApiResult.ok((Object)employeeDO.getCode());
    }

    @Override
    public ApiResult<List<String>> checkForUpsert(List<EmployeeUpsertDTO> upsertDTOList) {
        ArrayList<String> msgList = new ArrayList<String>();
        for (EmployeeUpsertDTO upsertDto : upsertDTOList) {
            try {
                SysEmployeeSaveBO saveBO = this.toEmployeeSaveBO(upsertDto);
                SysUserSaveBO userSaveBO = this.toUserSaveBO(upsertDto);
                saveBO.setUserSaveBO(userSaveBO);
                saveBO.setUserId(userSaveBO.getId());
                this.employeeMngManager.check(saveBO);
                msgList.add(null);
            }
            catch (Exception e) {
                msgList.add(ExceptionUtil.getRootCauseMessage((Throwable)e));
            }
        }
        return ApiResult.ok(msgList);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> importEmployee(ImportEmployeeBO employeeBO) {
        SysEmployeeSaveBO saveBO = this.toEmployeeSaveBO(employeeBO);
        SysUserSaveBO userSaveBO = this.toUserSaveBO(employeeBO);
        saveBO.setUserSaveBO(userSaveBO);
        saveBO.setWithoutLoginAccount(employeeBO.getWithoutLoginAccount());
        SysEmployeeDO employeeDO = this.employeeMngManager.upsert(saveBO);
        if (CollUtil.isNotEmpty(employeeBO.getRoleIds()) && Boolean.FALSE.equals(employeeBO.getWithoutLoginAccount())) {
            this.permissionManager.saveUserRole(employeeDO.getUserId(), new ArrayList<Long>(employeeBO.getRoleIds()));
        }
        return ApiResult.ok((Object)employeeDO.getId());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> upsertUser(Long orgId, UserSaveVO saveVO) {
        SysUserSaveBO userSaveBO = this.toUserSaveBO(saveVO, null);
        SysEmployeeDO employeeDO = this.employeeMngManager.upsert(userSaveBO, orgId);
        return ApiResult.ok((Object)employeeDO.getId());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> upsertOrg(EmployeeOrgInfoSaveVO saveVO) {
        SysEmployeeSaveBO saveBO = this.toEmployeeSaveBO(saveVO, null);
        SysEmployeeDO employeeDO = this.employeeMngManager.upsert(saveBO);
        return ApiResult.ok((Object)employeeDO.getId());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> updateEnabled(Long id) {
        Boolean enabled = this.employeeRepoProc.getEnabled(id);
        enabled = enabled == null || enabled == false;
        this.employeeMngManager.updateEnabled(id, enabled);
        return ApiResult.ok((Object)id);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<String> updateEnabledByCode(String code, Boolean enabled) {
        Long id = this.employeeRepoProc.getIdByCode(code);
        if (id == null) {
            return ApiResult.fail((String)"\u5458\u5de5\u4e0d\u5b58\u5728");
        }
        enabled = enabled != null && enabled != false;
        this.employeeMngManager.updateEnabled(id, enabled);
        return ApiResult.ok((Object)code);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> updateMobile(Long id, String mobile, Boolean updateUser) {
        this.employeeMngManager.updateMobile(id, mobile, updateUser);
        return ApiResult.ok((Object)id);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> updateEmail(Long id, String email, Boolean updateUser) {
        this.employeeMngManager.updateEmail(id, email, updateUser);
        return ApiResult.ok((Object)id);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> saveEmployeeOrg(Long id, List<EmployeeOrgSaveVO> orgSaveVoList) {
        List<SysEmployeeOrgSaveBO> orgSaveBoList = orgSaveVoList.stream().filter(t -> t.getOrgId() != null).map(t -> {
            SysEmployeeOrgSaveBO saveBO = new SysEmployeeOrgSaveBO();
            saveBO.setOrgId(t.getOrgId());
            saveBO.setLeaderUserId(t.getLeaderUserId());
            saveBO.setPositionId(t.getPositionId());
            return saveBO;
        }).collect(Collectors.toList());
        this.employeeMngManager.saveEmployeeOrg(id, orgSaveBoList);
        return ApiResult.ok((Object)id);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> delete(Long id, Boolean keepUser) {
        this.employeeMngManager.deleteEmployee(id, keepUser);
        return ApiResult.ok((Object)id);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> saveRole(Long id, List<Long> roleIds) {
        Long userId = this.employeeRepoProc.getUserId(id);
        if (userId == null) {
            return ApiResult.fail((String)"\u672a\u77e5\u5458\u5de5\u8d26\u53f7\u4fe1\u606f");
        }
        this.permissionManager.saveUserRole(userId, roleIds);
        return ApiResult.ok((Object)id);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Boolean> bindSalesman(Long id, String salesmanId) {
        if (id == null) {
            return ApiResult.fail((String)"\u5458\u5de5ID\u4e3a\u7a7a");
        }
        Long userId = this.employeeRepoProc.getUserId(id);
        if (userId == null) {
            return ApiResult.fail((String)"\u5458\u5de5\u8d26\u53f7\u4e0d\u5b58\u5728");
        }
        if (CharSequenceUtil.isBlank((CharSequence)salesmanId)) {
            ApiResult<Long> res = this.userMngService.removeUserType(userId, UserType.SALESMAN.getValue(), salesmanId);
            return res.isSuccess() ? ApiResult.ok((Object)true) : ApiResult.fail((String)res.getMsg());
        }
        ApiResult<Long> res = this.userMngService.addUserType(userId, UserType.SALESMAN.getValue(), salesmanId);
        return res.isSuccess() ? ApiResult.ok((Object)true) : ApiResult.fail((String)res.getMsg());
    }

    @Override
    public ApiResult<EmployeeDetailRespVO> getDetail(Long id) {
        SysEmployeeDO employeeDO = (SysEmployeeDO)this.employeeRepoProc.get(id);
        if (employeeDO == null) {
            return ApiResult.noData();
        }
        EmployeeDetailRespVO respVO = new EmployeeDetailRespVO();
        respVO.setWithoutLoginAccount(employeeDO.getUserId() == null || employeeDO.getUserId() == -1L);
        UserDetailRespVO userInfo = null;
        if (!respVO.getWithoutLoginAccount().booleanValue()) {
            userInfo = (UserDetailRespVO)this.userMngService.get(employeeDO.getUserId()).getData();
        }
        if (userInfo == null) {
            userInfo = EmployeeConvert.INSTANCE.convertUserInfo(employeeDO);
            userInfo.setId(null);
        } else {
            userInfo.setEnabled(employeeDO.getEnabled());
        }
        respVO.setUserInfo(userInfo);
        respVO.setEmployeeOrgInfo(this.getEmployeeOrgInfo(employeeDO));
        return ApiResult.ok((Object)respVO);
    }

    @Override
    public ApiResult<List<EmpOrgRespVO>> getEmployeeOrgs(Long id) {
        Map orgWithParentMap = this.employeeQueryManager.getEmployeeOrgsWithParent(id).stream().collect(Collectors.toMap(t -> ((IdCodeNameParam)t.get(t.size() - 1)).getId(), Functions.identity(), (t1, t2) -> t1));
        if (orgWithParentMap.isEmpty()) {
            return ApiResult.ok(Collections.emptyList());
        }
        List<SysEmployeeOrgDO> employeeOrgList = this.employeeOrgRepoProc.getEmployeeOrgByEmployeeId(id);
        Set<Long> leaderEmpIds = employeeOrgList.stream().map(SysEmployeeOrgDO::getLeaderEmployeeId).filter(ObjectUtil::isNotNull).collect(Collectors.toSet());
        Set postIds = employeeOrgList.stream().map(SysEmployeeOrgDO::getPositionId).filter(ObjectUtil::isNotNull).collect(Collectors.toSet());
        Map leaderMap = leaderEmpIds.isEmpty() ? Collections.emptyMap() : this.employeeRepoProc.queryEmployeeName(leaderEmpIds).stream().collect(Collectors.toMap(IdCodeNameParam::getId, Function.identity(), (t1, t2) -> t1));
        Map positionMap = postIds.isEmpty() ? Collections.emptyMap() : this.positionRepoProc.get(postIds).stream().collect(Collectors.toMap(BaseModel::getId, Functions.identity(), (t1, t2) -> t1));
        List respVOList = employeeOrgList.stream().filter(t -> orgWithParentMap.containsKey(t.getOrgId())).map(t -> {
            SysPositionDO position;
            IdCodeNameParam leader;
            EmpOrgRespVO respVO = new EmpOrgRespVO();
            respVO.setDetails((List)orgWithParentMap.get(t.getOrgId()));
            respVO.setDef(Boolean.TRUE.equals(t.getDef()));
            respVO.setAssignee(Boolean.TRUE.equals(t.getAssignee()));
            IdCodeNameParam idCodeNameParam = leader = t.getLeaderEmployeeId() == null ? null : (IdCodeNameParam)leaderMap.get(t.getLeaderEmployeeId());
            if (leader != null) {
                respVO.setLeaderUserId(t.getLeaderUserId());
                respVO.setLeaderUserName(leader.getName());
            }
            SysPositionDO sysPositionDO = position = t.getPositionId() == null ? null : (SysPositionDO)((Object)((Object)positionMap.get(t.getPositionId())));
            if (position != null) {
                respVO.setPositionVo(SysPositionConvert.INSTANCE.doToVo(position));
            }
            return respVO;
        }).collect(Collectors.toList());
        return ApiResult.ok(respVOList);
    }

    @Override
    public ApiResult<Map<Long, List<IdCodeNameParam>>> getEmployeeOrgs(List<Long> ids) {
        if (CollUtil.isEmpty(ids)) {
            return ApiResult.ok(Collections.emptyMap());
        }
        Map<Long, List<IdCodeNameParam>> data = this.employeeOrgRepoProc.getEmployeeOrgs(ids, true);
        return ApiResult.ok(data);
    }

    @Override
    public ApiResult<Map<Long, List<IdCodeNameParam>>> getEmployeeRolesByUserIds(List<Long> userIds) {
        if (CollUtil.isEmpty(userIds)) {
            return ApiResult.ok(Collections.emptyMap());
        }
        Map<Long, List<IdCodeNameParam>> data = this.permissionQueryManager.queryUserRoles(new HashSet<Long>(userIds));
        return ApiResult.ok(data);
    }

    @Override
    public ApiResult<List<IdCodeNameCheckParam>> getRole(Long id) {
        Long userId = this.employeeRepoProc.getUserId(id);
        if (userId == null) {
            return ApiResult.fail((String)"\u672a\u77e5\u5458\u5de5\u8d26\u53f7\u4fe1\u606f");
        }
        List<IdCodeNameCheckParam> roleList = this.permissionManager.getUserRole(userId, false);
        return ApiResult.ok(roleList);
    }

    @Override
    public ApiResult<PagingVO<EmployeePagedRespVO>> page(EmployeePageQueryVO queryVO) {
        PagingVO<EmployeePagedRespVO> pageData = this.employeeRepoProc.pageMng(queryVO, null);
        if (pageData.isEmpty()) {
            return ApiResult.ok((Object)PagingVO.empty());
        }
        this.fillPage(pageData.getRecords(), null, queryVO.getWithRole());
        return ApiResult.ok(pageData);
    }

    @Override
    public void fillPage(List<EmployeePagedRespVO> pageData, Map<Long, SysUserBasicDTO> userMap, Boolean withRole) {
        if (CollUtil.isEmpty(pageData)) {
            return;
        }
        Map employeeTypeMap = this.udcMap((BaseUdc)new EmployeeType());
        Set<Long> userIds = pageData.stream().map(EmployeePagedRespVO::getUserId).filter(t -> t != null && t != -1L).collect(Collectors.toSet());
        Map roleMap = Boolean.TRUE.equals(withRole) ? this.permissionQueryManager.queryUserRoles(userIds) : Collections.emptyMap();
        pageData.forEach(t -> {
            if (StringUtils.hasText((String)t.getType())) {
                t.setTypeName((String)employeeTypeMap.get(t.getType()));
            }
            t.setWithoutLoginAccount(t.getUserId() == null || t.getUserId() == -1L);
            t.setRoleNameList(roleMap.getOrDefault(t.getUserId(), Collections.emptyList()).stream().map(IdCodeNameParam::getName).collect(Collectors.toList()));
        });
        this.fillUserInfo(pageData, userMap);
    }

    private SysUserSaveBO toUserSaveBO(UserSaveVO saveVO, Long employeeId) {
        Long userId = saveVO.getId();
        if (userId == null && employeeId != null) {
            userId = this.employeeRepoProc.getRealUserId(employeeId);
            Assert.notNull((Object)userId, (String)"\u672a\u77e5\u5458\u5de5\u6240\u5c5e\u8d26\u53f7");
            saveVO.setId(userId);
        }
        SysUserSaveBO userSaveBO = null;
        if (userId == null || userId == -1L) {
            userSaveBO = CONVERT_USER.vo2SaveBo(saveVO);
        } else {
            Long finalUserId = userId;
            SysUserDO userDO = this.userRepoCall(proc -> (SysUserDO)proc.get(finalUserId));
            Assert.notNull((Object)userDO, (String)"\u5458\u5de5\u6240\u5c5e\u8d26\u53f7\u4e0d\u5b58\u5728");
            userSaveBO = CONVERT_USER.do2SaveBo(userDO);
            CONVERT_USER.copy2SaveBo(saveVO, userSaveBO);
        }
        AreaBO areaBO = AreaConvert.INSTANCE.vo2Bo(saveVO.getAreaVO());
        userSaveBO.setAreaBO(areaBO);
        if (!StringUtils.hasText((String)userSaveBO.getSourceType())) {
            userSaveBO.setSourceType(UserSourceType.CREATE.getValue());
        }
        if (CollectionUtils.isEmpty((Collection)userSaveBO.getTerminals())) {
            userSaveBO.setTerminalsAdd(Set.of(Terminal.BACKEND.name()));
        }
        HashSet<SysUserTypeBO> typesAdd = new HashSet<SysUserTypeBO>();
        typesAdd.add(new SysUserTypeBO(UserType.EMPLOYEE.getValue(), employeeId == null ? null : employeeId.toString()));
        userSaveBO.setUserTypesAdd(typesAdd);
        if (CollUtil.isNotEmpty(saveVO.getUserTypes())) {
            userSaveBO.setUserTypes(saveVO.getUserTypes().stream().map(t -> new SysUserTypeBO(t.getType(), t.getIdentityId())).collect(Collectors.toSet()));
        }
        return userSaveBO;
    }

    private SysUserSaveBO toUserSaveBO(EmployeeUpsertDTO upsertDTO) {
        Long userId = upsertDTO.getUserId();
        if (userId == null && StringUtils.hasText((String)upsertDTO.getUsername())) {
            userId = this.userRepoCall(proc -> proc.getIdByUsername(upsertDTO.getUsername()));
        }
        SysUserSaveBO userSaveBO = null;
        if (userId == null) {
            userSaveBO = CONVERT.upsertDTO2UserSaveBo(upsertDTO);
            if (CharSequenceUtil.isBlank((CharSequence)upsertDTO.getUsername()) && !((Boolean)ObjectUtil.defaultIfNull((Object)upsertDTO.getWithoutLoginAccount(), (Object)false)).booleanValue()) {
                String username = super.generateRandomCode(u -> this.userRepoCall(proc -> proc.existsUsername((String)u)) == false);
                userSaveBO.setUsername(username);
            }
        } else {
            Assert.hasText((String)upsertDTO.getUsername(), (String)"\u767b\u5f55\u53f7\u4e3a\u7a7a");
            Long finalUserId = userId;
            SysUserDO userDO = this.userRepoCall(proc -> (SysUserDO)proc.get(finalUserId));
            Assert.notNull((Object)userDO, (String)"\u5458\u5de5\u6240\u5c5e\u8d26\u53f7\u4e0d\u5b58\u5728");
            userSaveBO = CONVERT_USER.do2SaveBo(userDO);
            CONVERT.copyUpserDTO2UserSaveBO(upsertDTO, userSaveBO);
            userSaveBO.setId(userId);
            userSaveBO.setMobile(upsertDTO.getPhone());
        }
        userSaveBO.setAreaBO(CONVERT_AREA.vo2Bo(upsertDTO.getAreaVO()));
        if (!StringUtils.hasText((String)userSaveBO.getSourceType())) {
            userSaveBO.setSourceType(UserSourceType.CREATE.getValue());
        }
        if (CollectionUtils.isEmpty((Collection)userSaveBO.getTerminals())) {
            userSaveBO.setTerminalsAdd(Set.of(Terminal.BACKEND.name()));
        }
        HashSet<SysUserTypeBO> typesAdd = new HashSet<SysUserTypeBO>();
        typesAdd.add(new SysUserTypeBO(UserType.EMPLOYEE.getValue(), upsertDTO.getId() == null ? null : upsertDTO.getId().toString()));
        if (CollUtil.isNotEmpty((Collection)upsertDTO.getUserTypeList())) {
            for (SysUserTypeDTO sysUserTypeDTO : upsertDTO.getUserTypeList()) {
                typesAdd.add(new SysUserTypeBO(sysUserTypeDTO.getUserType(), sysUserTypeDTO.getIdentityId()));
            }
        }
        userSaveBO.setUserTypesAdd(typesAdd);
        return userSaveBO;
    }

    private SysUserSaveBO toUserSaveBO(ImportEmployeeBO employeeBO) {
        SysUserSaveBO userSaveBO = CONVERT.importBo2UserSaveBo(employeeBO);
        if (!employeeBO.getWithoutLoginAccount().booleanValue()) {
            boolean existsUsername = this.userRepoCall(userRepoProc -> userRepoProc.existsUsername(userSaveBO.getUsername()));
            Assert.isTrue((!existsUsername ? 1 : 0) != 0, (String)"\u767b\u5f55\u53f7\u5df2\u5b58\u5728");
        }
        if (!StringUtils.hasText((String)userSaveBO.getSourceType())) {
            userSaveBO.setSourceType(UserSourceType.CREATE.getValue());
        }
        if (CollectionUtils.isEmpty((Collection)userSaveBO.getTerminals())) {
            userSaveBO.setTerminalsAdd(Set.of(Terminal.BACKEND.name()));
        }
        HashSet<SysUserTypeBO> typesAdd = new HashSet<SysUserTypeBO>();
        typesAdd.add(new SysUserTypeBO(UserType.EMPLOYEE.getValue()));
        userSaveBO.setUserTypesAdd(typesAdd);
        return userSaveBO;
    }

    private SysEmployeeSaveBO toEmployeeSaveBO(EmployeeOrgInfoSaveVO saveVO, Long employeeId) {
        if (employeeId == null) {
            employeeId = saveVO.getId();
        }
        SysEmployeeSaveBO saveBO = null;
        if (employeeId == null) {
            saveBO = CONVERT.saveVO2BO(saveVO);
        } else {
            SysEmployeeDO employeeDO = (SysEmployeeDO)this.employeeRepoProc.get(employeeId);
            Assert.notNull((Object)employeeDO, (String)"\u5458\u5de5\u4fe1\u606f\u4e0d\u5b58\u5728");
            saveBO = CONVERT.do2SaveBO(employeeDO);
            CONVERT.copy2SaveBO(saveVO, saveBO);
            saveBO.setId(employeeId);
        }
        List<Object> orgInfos = new ArrayList(0);
        if (CollUtil.isNotEmpty(saveVO.getOrgList())) {
            orgInfos = saveVO.getOrgList().stream().filter(t -> t.getOrgId() != null).map(t -> {
                SysEmployeeOrgSaveBO orgInfo = new SysEmployeeOrgSaveBO();
                orgInfo.setOrgId(t.getOrgId());
                orgInfo.setLeaderUserId(t.getLeaderUserId());
                orgInfo.setDef(Boolean.valueOf(t.getDef() != null && t.getDef() != false));
                orgInfo.setAssignee(Boolean.valueOf(t.getAssignee() != null && t.getAssignee() != false));
                orgInfo.setPositionId(t.getPositionId());
                return orgInfo;
            }).collect(Collectors.toList());
            long defSize = orgInfos.stream().filter(t -> Boolean.TRUE.equals(t.getDef())).count();
            Assert.isTrue((defSize < 2L ? 1 : 0) != 0, (String)"\u9ed8\u8ba4\u7ec4\u7ec7\u53ea\u80fd\u6709\u4e00\u4e2a");
        }
        Assert.notEmpty(orgInfos, (String)"\u7ec4\u7ec7\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        saveBO.setOrgInfoList(orgInfos);
        saveBO.setEmailWork(saveVO.getEmailWork());
        saveBO.setPhone(saveVO.getPhoneWork());
        return saveBO;
    }

    private SysEmployeeSaveBO toEmployeeSaveBO(EmployeeUpsertDTO upsertDTO) {
        Long employeeId = upsertDTO.getId();
        if (employeeId == null && StringUtils.hasText((String)upsertDTO.getCode())) {
            employeeId = this.employeeRepoProc.getIdByCode(upsertDTO.getCode());
            upsertDTO.setId(employeeId);
        }
        SysEmployeeSaveBO saveBO = null;
        if (employeeId == null) {
            saveBO = CONVERT.saveDto2BO(upsertDTO);
            if (CharSequenceUtil.isBlank((CharSequence)saveBO.getCode())) {
                String code = super.generateRandomCode(t -> !this.employeeRepoProc.existsCode((String)t));
                saveBO.setCode(code);
            }
        } else {
            Assert.hasText((String)upsertDTO.getCode(), (String)"\u5458\u5de5\u7f16\u53f7\u4e3a\u7a7a");
            SysEmployeeDO employeeDO = (SysEmployeeDO)this.employeeRepoProc.get(employeeId);
            Assert.notNull((Object)employeeDO, (String)"\u5458\u5de5\u4fe1\u606f\u4e0d\u5b58\u5728");
            saveBO = CONVERT.do2SaveBO(employeeDO);
            CONVERT.copy2SaveBO(upsertDTO, saveBO);
            saveBO.setId(employeeId);
            upsertDTO.setUserId(employeeDO.getUserId());
        }
        ArrayList<SysEmployeeOrgSaveBO> orgInfos = new ArrayList<SysEmployeeOrgSaveBO>(0);
        HashSet<Long> existsOrgIds = new HashSet<Long>();
        if (CollUtil.isNotEmpty((Collection)upsertDTO.getOrgList())) {
            for (EmployeeUpsertDTO.EmployeeOrg t3 : upsertDTO.getOrgList()) {
                if (t3.getOrgId() == null || existsOrgIds.contains(t3.getOrgId())) continue;
                existsOrgIds.add(t3.getOrgId());
                SysEmployeeOrgSaveBO orgInfo = new SysEmployeeOrgSaveBO();
                orgInfo.setOrgId(t3.getOrgId());
                orgInfo.setLeaderUserId(t3.getLeaderUserId());
                orgInfo.setDef((Boolean)ObjUtil.defaultIfNull((Object)t3.getDef(), (Object)false));
                orgInfo.setAssignee((Boolean)ObjUtil.defaultIfNull((Object)t3.getAssignee(), (Object)false));
                orgInfo.setPositionId(t3.getPositionId());
                orgInfos.add(orgInfo);
            }
        }
        if (CollUtil.isNotEmpty((Collection)upsertDTO.getOrgIdList())) {
            Map empOrgOldMap = employeeId == null ? Collections.emptyMap() : this.employeeOrgRepoProc.getEmployeeOrgByEmployeeId(employeeId).stream().collect(Collectors.toMap(SysEmployeeOrgDO::getOrgId, Function.identity(), (t1, t2) -> t1));
            for (Long t4 : upsertDTO.getOrgIdList()) {
                if (t4 == null || existsOrgIds.contains(t4)) continue;
                existsOrgIds.add(t4);
                SysEmployeeOrgSaveBO orgInfo = new SysEmployeeOrgSaveBO();
                orgInfo.setOrgId(t4);
                SysEmployeeOrgDO old = (SysEmployeeOrgDO)empOrgOldMap.get(t4);
                if (old == null) {
                    orgInfo.setDef(Boolean.valueOf(false));
                    orgInfo.setAssignee(Boolean.valueOf(false));
                } else {
                    orgInfo.setDef(old.getDef());
                    orgInfo.setAssignee(old.getAssignee());
                }
                orgInfos.add(orgInfo);
            }
        }
        Assert.notEmpty(orgInfos, (String)"\u7ec4\u7ec7\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        saveBO.setOrgInfoList(orgInfos);
        return saveBO;
    }

    private SysEmployeeSaveBO toEmployeeSaveBO(ImportEmployeeBO employeeBO) {
        SysEmployeeSaveBO saveBO = CONVERT.importBo2SaveBo(employeeBO);
        boolean existsCode = this.employeeRepoProc.existsCode(saveBO.getCode());
        Assert.isTrue((!existsCode ? 1 : 0) != 0, (String)"\u5458\u5de5\u7f16\u53f7\u5df2\u5b58\u5728");
        List<Object> orgInfos = new ArrayList(0);
        if (CollUtil.isNotEmpty(employeeBO.getOrgIds())) {
            orgInfos = employeeBO.getOrgIds().stream().filter(Objects::nonNull).map(t -> {
                SysEmployeeOrgSaveBO orgInfo = new SysEmployeeOrgSaveBO();
                orgInfo.setOrgId(t);
                orgInfo.setDef(Boolean.valueOf(false));
                orgInfo.setAssignee(Boolean.valueOf(false));
                return orgInfo;
            }).collect(Collectors.toList());
        }
        Assert.notEmpty(orgInfos, (String)"\u7ec4\u7ec7\u4fe1\u606f\u4e3a\u7a7a");
        saveBO.setOrgInfoList(orgInfos);
        return saveBO;
    }

    private EmployeeOrgInfoRespVO getEmployeeOrgInfo(SysEmployeeDO employeeDO) {
        EmployeeOrgInfoRespVO respVO = CONVERT.do2RespVO(employeeDO);
        respVO.setEmailWork(employeeDO.getEmail());
        if (StringUtils.hasText((String)respVO.getType())) {
            Map employeeTypeMap = super.udcMap((BaseUdc)new EmployeeType());
            respVO.setTypeName((String)employeeTypeMap.get(respVO.getType()));
        }
        respVO.setExtensionInfo(employeeDO.getExtensionInfo());
        List orgList = (List)this.getEmployeeOrgs(employeeDO.getId()).getData();
        respVO.setOrgList(orgList);
        return respVO;
    }

    private Map<Long, SysUserBasicDTO> queryUser(EmployeePageQueryVO queryVO) {
        UserQueryDTO queryDTO = new UserQueryDTO();
        boolean flag = false;
        if (StringUtils.hasText((String)queryVO.getUsername())) {
            queryDTO.setUsernames(Set.of(queryVO.getUsername()));
            flag = true;
        }
        if (!flag) {
            return null;
        }
        List users = this.userRepoCall(repo -> repo.queryBasicDto(queryDTO));
        if (users.isEmpty()) {
            return Collections.emptyMap();
        }
        return users.stream().collect(Collectors.toMap(SysUserBasicDTO::getId, t -> t, (t1, t2) -> t1));
    }
}

