/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.service.impl;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.constant.Terminal;
import com.elitescloud.cloudt.core.annotation.TenantOrgTransaction;
import com.elitescloud.cloudt.core.annotation.TenantTransaction;
import com.elitescloud.cloudt.core.annotation.common.TenantIsolateType;
import com.elitescloud.cloudt.system.dto.SysUserBasicDTO;
import com.elitescloud.cloudt.system.dto.req.UserCreateDTO;
import com.elitescloud.cloudt.system.model.entity.SysUserTerminalDO;
import com.elitescloud.cloudt.system.service.IUserService;
import com.elitescloud.cloudt.system.service.UserMngService;
import com.elitescloud.cloudt.system.service.manager.UserQueryManager;
import com.elitescloud.cloudt.system.service.model.entity.SysUserTypeDO;
import com.elitescloud.cloudt.system.service.repo.SysUserTerminalRepo;
import com.elitescloud.cloudt.system.service.repo.SysUserTerminalRepoProc;
import com.elitescloud.cloudt.system.service.repo.UserRepoProc;
import com.elitescloud.cloudt.system.service.repo.UserTypeRepoProc;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@Service
@TenantTransaction(isolateType=TenantIsolateType.DEFAULT)
@TenantOrgTransaction(useTenantOrg=false)
public class IUserServiceImpl
extends BaseServiceImpl
implements IUserService {
    private static final Logger log = LoggerFactory.getLogger(IUserServiceImpl.class);
    @Autowired
    private UserRepoProc userRepoProc;
    @Autowired
    private UserTypeRepoProc userTypeRepoProc;
    @Autowired
    private SysUserTerminalRepo userTerminalRepo;
    @Autowired
    private SysUserTerminalRepoProc userTerminalRepoProc;
    @Autowired
    private UserQueryManager userQueryManager;
    @Autowired
    private UserMngService userMngService;

    @Transactional(rollbackFor={Exception.class})
    public Long insertUser(UserCreateDTO createDTO) {
        ApiResult<Long> saveResult = this.userMngService.save(createDTO);
        if (!saveResult.isSuccess()) {
            throw new BusinessException(saveResult.getMsg());
        }
        return (Long)saveResult.getData();
    }

    @Transactional(rollbackFor={Exception.class})
    public Long addUserType(Long id, Set<String> userTypes) {
        Assert.notNull((Object)id, (String)"\u7528\u6237ID\u4e3a\u7a7a");
        Assert.notEmpty(userTypes, (String)"\u65b0\u589e\u7528\u6237\u7c7b\u578b\u4e3a\u7a7a");
        Long tenantId = super.currentTenantId();
        Set<String> existsTypes = this.userTypeRepoProc.getUserType(id, tenantId);
        List typesToAdd = userTypes.stream().filter(t -> !existsTypes.contains(t)).map(t -> {
            SysUserTypeDO typeDO = new SysUserTypeDO();
            typeDO.setUserId(id);
            typeDO.setType(t);
            typeDO.setSysTenantId(tenantId);
            return typeDO;
        }).collect(Collectors.toList());
        if (!typesToAdd.isEmpty()) {
            this.userTypeRepoProc.save(typesToAdd);
        }
        return id;
    }

    @Transactional(rollbackFor={Exception.class})
    public Long removeUserType(Long id, Set<String> userTypes) {
        Assert.notNull((Object)id, (String)"\u7528\u6237ID\u4e3a\u7a7a");
        Assert.notEmpty(userTypes, (String)"\u7528\u6237\u7c7b\u578b\u4e3a\u7a7a");
        this.userTypeRepoProc.delete(id, userTypes, super.currentTenantId());
        return id;
    }

    @Transactional(rollbackFor={Exception.class})
    public Long addUserTerminal(Long id, Set<String> terminals) {
        Assert.notNull((Object)id, (String)"\u7528\u6237ID\u4e3a\u7a7a");
        Assert.notEmpty(terminals, (String)"\u65b0\u589e\u7528\u6237\u7ec8\u7aef\u4e3a\u7a7a");
        List<String> existsTerminals = this.userTerminalRepoProc.getTerminalStrByUserId(id);
        LocalDateTime timeNow = LocalDateTime.now();
        List terminalsToAdd = terminals.stream().filter(t -> {
            if (existsTerminals.contains(t)) {
                return false;
            }
            return Terminal.parse((String)t) != null;
        }).map(t -> {
            SysUserTerminalDO terminalDO = new SysUserTerminalDO();
            terminalDO.setUserId(id);
            terminalDO.setTerminalCode((String)t);
            terminalDO.setTimeBind(timeNow);
            return terminalDO;
        }).collect(Collectors.toList());
        if (!terminalsToAdd.isEmpty()) {
            this.userTerminalRepo.saveAll(terminalsToAdd);
        }
        return id;
    }

    @Transactional(rollbackFor={Exception.class})
    public Long removeUserTerminal(Long id, Set<String> terminals) {
        Assert.notNull((Object)id, (String)"\u7528\u6237ID\u4e3a\u7a7a");
        Assert.notEmpty(terminals, (String)"\u7528\u6237\u7ec8\u7aef\u4e3a\u7a7a");
        this.userTerminalRepoProc.delete(id, terminals);
        return id;
    }

    @Transactional(rollbackFor={Exception.class})
    public boolean updateCasSyncResult(Map<String, Long> userMap) {
        for (Map.Entry<String, Long> entry : userMap.entrySet()) {
            if (!StringUtils.hasText((String)entry.getKey())) continue;
            this.userRepoProc.updateCasSyncResult(entry.getKey(), entry.getValue());
        }
        return true;
    }

    public boolean existsUsername(String username, Long id) {
        Assert.hasText((String)username, (String)"\u8d26\u53f7\u4e3a\u7a7a");
        return this.userRepoProc.existsUsername(username, id);
    }

    public boolean existsMobile(String mobile, Long id) {
        Assert.hasText((String)mobile, (String)"\u624b\u673a\u53f7\u4e3a\u7a7a");
        return this.userRepoProc.existsMobile(mobile, id);
    }

    public boolean existsEmail(String email, Long id) {
        Assert.hasText((String)email, (String)"\u90ae\u7bb1\u4e3a\u7a7a");
        return this.userRepoProc.existsMobile(email, id);
    }

    public Long getUniqueIdByUsername(String username) {
        Assert.hasText((String)username, (String)"\u8d26\u53f7\u4e3a\u7a7a");
        return this.userQueryManager.getUniqueIdByUsername(username);
    }

    public Long getUniqueIdByMobile(String mobile) {
        Assert.hasText((String)mobile, (String)"\u624b\u673a\u53f7\u4e3a\u7a7a");
        return this.userQueryManager.getUniqueIdByMobile(mobile);
    }

    public Long getUniqueIdByEmail(String email) {
        Assert.hasText((String)email, (String)"\u90ae\u7bb1\u4e3a\u7a7a");
        return this.userQueryManager.getUniqueIdByEmail(email);
    }

    public SysUserBasicDTO getById(Long id) {
        Assert.notNull((Object)id, (String)"ID\u4e3a\u7a7a");
        return this.userRepoProc.getBasicDto(id);
    }
}

