/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.StrUtil;
import com.elitescloud.boot.auth.client.config.AuthorizationProperties;
import com.elitescloud.boot.auth.client.config.support.AuthenticationCache;
import com.elitescloud.boot.auth.util.SecurityContextUtil;
import com.elitescloud.boot.common.BaseUdc;
import com.elitescloud.boot.common.param.IdCodeNameParam;
import com.elitescloud.boot.common.param.SysSendVerifyCodeVO;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.boot.core.support.verifycode.common.VerifyCodeManager;
import com.elitescloud.boot.datasecurity.common.DataSecurityUtil;
import com.elitescloud.boot.datasecurity.dpr.content.DprRuleConditionEnum;
import com.elitescloud.boot.datasecurity.dpr.content.DprRuleRelationEnum;
import com.elitescloud.boot.datasecurity.dpr.content.DprRuleValueTypeEnum;
import com.elitescloud.boot.util.ObjUtil;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.context.util.HttpServletUtil;
import com.elitescloud.cloudt.core.annotation.TenantOrgTransaction;
import com.elitescloud.cloudt.core.annotation.TenantTransaction;
import com.elitescloud.cloudt.core.annotation.common.TenantIsolateType;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitescloud.cloudt.system.config.SystemProperties;
import com.elitescloud.cloudt.system.constant.DataPermissionType;
import com.elitescloud.cloudt.system.constant.EmployeeType;
import com.elitescloud.cloudt.system.constant.OrgType;
import com.elitescloud.cloudt.system.convert.EmployeeConvert;
import com.elitescloud.cloudt.system.convert.PermissionConverter;
import com.elitescloud.cloudt.system.dto.BaseDataSecurityRuleDTO;
import com.elitescloud.cloudt.system.dto.SysDpcRoleApiFieldsDTO;
import com.elitescloud.cloudt.system.dto.SysDprRoleApiDataRuleListQueryDTO;
import com.elitescloud.cloudt.system.dto.SysDprRoleApiRowColumnRuleDTO;
import com.elitescloud.cloudt.system.dto.SysOrgBasicDTO;
import com.elitescloud.cloudt.system.dto.SysOuBasicDTO;
import com.elitescloud.cloudt.system.dto.SysTenantDTO;
import com.elitescloud.cloudt.system.model.bo.BusinessObjectBO;
import com.elitescloud.cloudt.system.model.bo.BusinessOperationBO;
import com.elitescloud.cloudt.system.model.bo.EmployeeOrgBO;
import com.elitescloud.cloudt.system.model.bo.MenuSimpleBO;
import com.elitescloud.cloudt.system.model.bo.UserOrgBO;
import com.elitescloud.cloudt.system.model.vo.resp.index.AuthedUserFieldRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.index.CurrentEmployeeRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.index.UserDataPermissionRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.index.UserFieldRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.index.UserMenuRespVO;
import com.elitescloud.cloudt.system.model.vo.save.index.ModifyPasswordSaveVO;
import com.elitescloud.cloudt.system.model.vo.save.index.PasswordUpdateSaveVO;
import com.elitescloud.cloudt.system.service.FrontTableCfgService;
import com.elitescloud.cloudt.system.service.IndexUserService;
import com.elitescloud.cloudt.system.service.UserOuterappQueryService;
import com.elitescloud.cloudt.system.service.manager.EmployeeOrgManager;
import com.elitescloud.cloudt.system.service.manager.OuQueryManager;
import com.elitescloud.cloudt.system.service.manager.PermissionQueryManager;
import com.elitescloud.cloudt.system.service.manager.UserMngManager;
import com.elitescloud.cloudt.system.service.model.entity.SysEmployeeDO;
import com.elitescloud.cloudt.system.service.repo.AppRepoProc;
import com.elitescloud.cloudt.system.service.repo.BusinessObjectRepoProc;
import com.elitescloud.cloudt.system.service.repo.BusinessOperationRepoProc;
import com.elitescloud.cloudt.system.service.repo.EmployeeOrgRepoProc;
import com.elitescloud.cloudt.system.service.repo.EmployeeRepoProc;
import com.elitescloud.cloudt.system.service.repo.MenuRepoProc;
import com.elitescloud.cloudt.system.service.repo.OrgRepoProc;
import com.elitescloud.cloudt.system.service.repo.UserRepoProc;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
@TenantTransaction(isolateType=TenantIsolateType.TENANT)
@TenantOrgTransaction(useTenantOrg=false)
public class IndexUserServiceImpl
extends BaseServiceImpl
implements IndexUserService {
    private static final Logger log = LoggerFactory.getLogger(IndexUserServiceImpl.class);
    @Autowired
    private UserRepoProc userRepoProc;
    @Autowired
    private EmployeeRepoProc employeeRepoProc;
    @Autowired
    private EmployeeOrgManager employeeOrgManager;
    @Autowired
    private EmployeeOrgRepoProc employeeOrgRepoProc;
    @Autowired
    private UserMngManager userMngManager;
    @Autowired
    private OuQueryManager ouQueryManager;
    @Autowired
    private OrgRepoProc orgRepoProc;
    @Autowired
    private PermissionQueryManager permissionQueryManager;
    @Autowired
    private AuthorizationProperties authorizationProperties;
    @Autowired
    private AuthenticationCache authenticationCache;
    @Autowired
    private SystemProperties systemProperties;
    @Autowired
    private VerifyCodeManager verifyCodeManager;
    @Autowired
    private FrontTableCfgService frontTableCfgService;
    @Autowired
    private AppRepoProc appRepoProc;
    @Autowired
    private MenuRepoProc menuRepoProc;
    @Autowired
    private BusinessObjectRepoProc businessObjectRepoProc;
    @Autowired
    private BusinessOperationRepoProc businessOperationRepoProc;
    @Autowired
    private UserOuterappQueryService userOuterappQueryService;

    @Override
    public ApiResult<CurrentEmployeeRespVO> getEmployeeInfo() {
        GeneralUserDetails currentUser = super.currentUser(true);
        return this.employeeRepoProc.getByUserId(currentUser.getUserId()).map(t -> {
            CurrentEmployeeRespVO respVO = EmployeeConvert.INSTANCE.do2CurrentRespVO((SysEmployeeDO)t);
            if (CharSequenceUtil.isNotBlank((CharSequence)respVO.getType())) {
                respVO.setTypeName(super.udcValue((BaseUdc)new EmployeeType(respVO.getType())));
            }
            respVO.setUsername(currentUser.getUsername());
            respVO.setFullName(currentUser.getUser().getPrettyName());
            if (currentUser.getOrgId() != null) {
                List<EmployeeOrgBO> leaders;
                CurrentEmployeeRespVO.EmployeeOrg org = new CurrentEmployeeRespVO.EmployeeOrg();
                respVO.setOrgInfo(org);
                org.setOrgId(currentUser.getOrgId());
                org.setOrgCode(currentUser.getUser().getOrg().getCode());
                org.setOrgName(currentUser.getUser().getOrg().getName());
                IdCodeNameParam company = this.orgRepoProc.queryParentNameForType(List.of(currentUser.getOrgId()), OrgType.COMPANY.getValue(), true).get(currentUser.getOrgId());
                if (company != null) {
                    org.setCompanyOrgId(company.getId());
                    org.setCompanyOrgCode(company.getCode());
                    org.setCompanyOrgName(company.getName());
                }
                if (!(leaders = this.employeeOrgRepoProc.getLeaders(List.of(t.getId()))).isEmpty()) {
                    for (EmployeeOrgBO leader : leaders) {
                        if (!leader.getOrgId().equals(currentUser.getOrgId())) continue;
                        org.setLeaderId(leader.getEmployeeId());
                        org.setLeaderCode(leader.getEmployeeCode());
                        org.setLeaderUserId(leader.getUserId());
                        org.setLeaderUsername(leader.getUsername());
                        org.setLeaderFullName(leader.getFullName());
                    }
                }
            }
            return respVO;
        }).map(ApiResult::ok).orElse(ApiResult.ok());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Boolean> updatePassword(ModifyPasswordSaveVO saveVO) {
        if (!CharSequenceUtil.equals((CharSequence)saveVO.getPdRepeat(), (CharSequence)saveVO.getPdNew())) {
            return ApiResult.fail((String)"\u4e24\u6b21\u8f93\u5165\u5bc6\u7801\u4e0d\u4e00\u81f4");
        }
        GeneralUserDetails currentUser = super.currentUser(true);
        this.userMngManager.updatePassword(currentUser.getUserId(), saveVO.getPdNew(), saveVO.getPd(), false);
        String token = SecurityContextUtil.currentToken();
        if (StringUtils.hasText((String)token)) {
            this.authenticationCache.removeUserDetail(token);
        }
        return ApiResult.ok((Object)true);
    }

    @Override
    @TenantTransaction(isolateType=TenantIsolateType.DEFAULT)
    @TenantOrgTransaction(useTenantOrg=false)
    public ApiResult<String> sendVerifyCodeForUpdatePwd(boolean retrieve, SysSendVerifyCodeVO verifyCodeParam) {
        String type;
        String verifyCode;
        if (retrieve) {
            boolean exists = false;
            if (CharSequenceUtil.isBlank((CharSequence)verifyCodeParam.getAccountType()) || "mobile".equals(verifyCodeParam.getAccountType())) {
                exists = this.userRepoProc.existsMobile(verifyCodeParam.getAccount());
                Assert.isTrue((boolean)exists, (String)"\u672a\u67e5\u8be2\u5230\u7528\u6237\u4fe1\u606f\uff0c\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u624b\u673a\u53f7");
            } else if ("email".equals(verifyCodeParam.getAccountType())) {
                exists = this.userRepoProc.existsEmail(verifyCodeParam.getAccount());
                Assert.isTrue((boolean)exists, (String)"\u672a\u67e5\u8be2\u5230\u7528\u6237\u4fe1\u606f\uff0c\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u90ae\u7bb1");
            }
        } else {
            GeneralUserDetails currentUser = SecurityContextUtil.currentUserIfUnauthorizedThrow();
            if ("mobile".equals(verifyCodeParam.getAccountType())) {
                Assert.isTrue((boolean)Objects.equals(currentUser.getUser().getMobile(), verifyCodeParam.getAccount()), (String)"\u624b\u673a\u53f7\u8f93\u5165\u9519\u8bef");
            } else if ("email".equals(verifyCodeParam.getAccountType())) {
                Assert.isTrue((boolean)Objects.equals(currentUser.getUser().getEmail(), verifyCodeParam.getAccount()), (String)"\u90ae\u7bb1\u8f93\u5165\u9519\u8bef");
            }
        }
        if (StrUtil.isBlank((CharSequence)verifyCodeParam.getAccountType())) {
            verifyCodeParam.setAccountType("mobile");
        }
        if ((verifyCode = this.verifyCodeManager.send(type = retrieve ? "cloudt_system_retrieve_pwd" : "cloudt_system_update_pwd", verifyCodeParam)) == null) {
            return ApiResult.ok();
        }
        return ApiResult.ok((Object)("\u6a21\u62df\u53d1\u9001\u9a8c\u8bc1\u7801\uff0c\u9a8c\u8bc1\u7801\u662f" + verifyCode));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @TenantTransaction(isolateType=TenantIsolateType.DEFAULT)
    @TenantOrgTransaction(useTenantOrg=false)
    public ApiResult<Long> updatePwdByVerifyCode(boolean retrieve, PasswordUpdateSaveVO saveVO) {
        String type;
        String verifyMsg;
        GeneralUserDetails currentUser;
        GeneralUserDetails generalUserDetails = currentUser = retrieve ? null : SecurityContextUtil.currentUserIfUnauthorizedThrow();
        if (StrUtil.isBlank((CharSequence)saveVO.getAccountType())) {
            saveVO.setAccountType("mobile");
        }
        if ((verifyMsg = this.verifyCodeManager.verify(type = retrieve ? "cloudt_system_retrieve_pwd" : "cloudt_system_update_pwd", saveVO.getAccount(), saveVO.getVerifyCode())) != null) {
            return ApiResult.fail((String)verifyMsg);
        }
        List<Long> userIds = null;
        switch (saveVO.getAccountType()) {
            case "mobile": {
                userIds = this.userRepoProc.getIdByMobile(saveVO.getAccount());
                break;
            }
            case "email": {
                userIds = this.userRepoProc.getIdByEmail(saveVO.getAccount());
                break;
            }
            default: {
                throw new IllegalArgumentException("\u6682\u4e0d\u652f\u6301\u7684\u8d26\u53f7\u7c7b\u578b");
            }
        }
        if (CollectionUtils.isEmpty(userIds)) {
            return ApiResult.fail((String)"\u672a\u67e5\u8be2\u5230\u7528\u6237\u4fe1\u606f\uff0c\u8bf7\u786e\u8ba4\u8d26\u53f7\u8f93\u5165\u6b63\u786e");
        }
        if (currentUser != null) {
            if (userIds.contains(currentUser.getUserId())) {
                this.userMngManager.updatePassword(currentUser.getUserId(), saveVO.getPassword(), null, false);
                return ApiResult.ok((Object)currentUser.getUserId());
            }
            return ApiResult.fail((String)"\u4fee\u6539\u5931\u8d25\uff0c\u60a8\u5c1a\u672a\u7ed1\u5b9a\u8be5\u8d26\u53f7");
        }
        if (userIds.size() > 1) {
            return ApiResult.fail((String)"\u8d26\u53f7\u4e0d\u552f\u4e00\uff0c\u65e0\u6cd5\u786e\u5b9a\u552f\u4e00\u7528\u6237");
        }
        this.userMngManager.updatePassword(userIds.get(0), saveVO.getPassword(), null, false);
        return ApiResult.ok((Object)userIds.get(0));
    }

    @Override
    public ApiResult<List<UserMenuRespVO>> getUserMenu(String terminal, Boolean includeAction, Boolean tree, Boolean cacheable) {
        if (includeAction == null) {
            includeAction = false;
        }
        if (tree == null) {
            tree = true;
        }
        if (cacheable == null) {
            cacheable = true;
        }
        List<UserMenuRespVO> menuList = cacheable != false ? this.permissionQueryManager.queryUserMenusCacheable(terminal, includeAction, tree) : this.permissionQueryManager.queryUserMenus(terminal, includeAction, tree);
        return ApiResult.ok(menuList);
    }

    @Override
    public ApiResult<List<UserMenuRespVO>> getUserAction(String menuCode) {
        List<UserMenuRespVO> actionList = StringUtils.hasText((String)menuCode) ? this.permissionQueryManager.queryUserActionByMenu(menuCode) : this.permissionQueryManager.queryAllUserAction();
        return ApiResult.ok(actionList);
    }

    @Override
    public ApiResult<List<UserFieldRespVO>> getUserField(String menuCode, String apiCode) {
        List<UserFieldRespVO> fieldList = this.permissionQueryManager.queryUserField(menuCode, apiCode);
        return ApiResult.ok(fieldList);
    }

    @Override
    public ApiResult<String> getFrontTableCfg(String tableCode) {
        return this.frontTableCfgService.getUserCfg(tableCode);
    }

    @Override
    public ApiResult<SysUserDTO> switchTenant(Long tenantId) {
        GeneralUserDetails currentUser = SecurityContextUtil.currentUserIfUnauthorizedThrow();
        if (currentUser.getTenantId() != null && currentUser.getTenantId().longValue() == tenantId.longValue()) {
            return ApiResult.fail((String)("\u5df2\u5728[" + currentUser.getTenant().getTenantName() + "]\uff0c\u65e0\u9700\u5207\u6362"));
        }
        SysUserDTO user = currentUser.getUser();
        if (CollectionUtils.isEmpty((Collection)user.getSysTenantDTOList())) {
            return ApiResult.fail((String)"\u5f53\u524d\u7528\u6237\u65e0\u79df\u6237");
        }
        Optional<SysTenantDTO> tenant = user.getSysTenantDTOList().stream().filter(t -> t.getId().longValue() == tenantId.longValue()).findAny();
        if (tenant.isEmpty()) {
            return ApiResult.fail((String)"\u5207\u6362\u5931\u8d25\uff0c\u4e0d\u5728\u6307\u5b9a\u79df\u6237\u4e0b");
        }
        this.switchCurrentTenant(currentUser, tenant.get());
        return ApiResult.ok((Object)user);
    }

    @Override
    public ApiResult<SysUserDTO> switchOrg(Long orgId) {
        GeneralUserDetails currentUser = SecurityContextUtil.currentUserIfUnauthorizedThrow();
        if (currentUser.getOrgId() != null && currentUser.getOrgId().longValue() == orgId.longValue()) {
            return ApiResult.fail((String)("\u5df2\u5728[" + currentUser.getUser().getOrg().getName() + "]\uff0c\u65e0\u9700\u5207\u6362"));
        }
        List orgList = currentUser.getUser().getOrgList();
        if (CollectionUtils.isEmpty((Collection)orgList)) {
            return ApiResult.fail((String)"\u5f53\u524d\u7528\u6237\u65e0\u7ec4\u7ec7");
        }
        Optional<SysOrgBasicDTO> org = orgList.stream().filter(t -> t.getId().longValue() == orgId.longValue()).findAny();
        if (org.isEmpty()) {
            return ApiResult.fail((String)"\u5207\u6362\u5931\u8d25\uff0c\u4e0d\u5728\u6307\u5b9a\u7ec4\u7ec7\u4e0b");
        }
        this.switchCurrentOrg(currentUser, org.get());
        return ApiResult.ok((Object)currentUser.getUser());
    }

    @Override
    public ApiResult<UserDataPermissionRespVO> getDataPermission(Boolean all, Boolean reload) {
        all = all != null && all != false;
        reload = reload != null && reload != false;
        UserDataPermissionRespVO respVO = new UserDataPermissionRespVO();
        GeneralUserDetails currentUser = SecurityContextUtil.currentUserIfUnauthorizedThrow();
        respVO.setUsername(currentUser.getUsername());
        respVO.setFullName(currentUser.getUser().getPrettyName());
        respVO.setRoles(currentUser.getUser().getRoles());
        HttpServletRequest request = HttpServletUtil.currentRequest();
        if (request == null) {
            return ApiResult.ok((Object)respVO);
        }
        SysDprRoleApiRowColumnRuleDTO roleRule = all.booleanValue() ? (reload.booleanValue() ? this.permissionQueryManager.getDataPermissionOfCurrentUser() : DataSecurityUtil.getAllDataPermission()) : DataSecurityUtil.getDataPermission();
        respVO.setRowRuleList(this.convert2VO(roleRule == null ? null : roleRule.getSysDprRoleApiDataRuleListQueryDTO(), this::convert2VO));
        respVO.setApiFieldList(this.convert2VO(roleRule == null ? null : roleRule.getSysDpcRoleApiFieldsDTOList(), this::convert2VO));
        return ApiResult.ok((Object)respVO);
    }

    @Override
    public ApiResult<List<AuthedUserFieldRespVO>> getFieldPermission() {
        List respVoList = DataSecurityUtil.getFieldPermission().stream().map(PermissionConverter.INSTANCE::convertApiFieldRespVO).collect(Collectors.toList());
        return ApiResult.ok(respVoList);
    }

    @Override
    public ApiResult<String> getOpenId(HttpServletRequest request, String outerAppId) {
        return this.userOuterappQueryService.getOpenId(request, outerAppId);
    }

    @Override
    public ApiResult<String> unbindOpenId(String outerAppId) {
        return this.userOuterappQueryService.unbind(outerAppId);
    }

    private <T extends BaseDataSecurityRuleDTO, R extends UserDataPermissionRespVO.Base> List<R> convert2VO(List<T> permissionList, Function<T, R> convert) {
        if (CollUtil.isEmpty(permissionList)) {
            return Collections.emptyList();
        }
        Map<String, String> roleMap = SecurityContextUtil.currentUserIfUnauthorizedThrow().getUser().getRoles().stream().collect(Collectors.toMap(IdCodeNameParam::getCode, IdCodeNameParam::getName, (t1, t2) -> t1));
        Set businessObjectCodes = permissionList.stream().map(BaseDataSecurityRuleDTO::getBusinessObjectCode).filter(StringUtils::hasText).collect(Collectors.toSet());
        Set businessOperationCodes = permissionList.stream().flatMap(t -> Stream.of(t.getApiPermissionCode(), t.getPermissionRef())).filter(StringUtils::hasText).collect(Collectors.toSet());
        Set menuCodes = permissionList.stream().map(BaseDataSecurityRuleDTO::getMenusCode).filter(StringUtils::hasText).collect(Collectors.toSet());
        HashMap appMap = new HashMap(32);
        HashMap menuMap = new HashMap(menuCodes.size());
        HashMap businessObjectMap = new HashMap(menuCodes.size());
        HashMap businessOperationMap = new HashMap(menuCodes.size());
        this.tenantDataIsolateProvider.byDefaultDirectly(() -> {
            for (IdCodeNameParam allParam : this.appRepoProc.allParams(null)) {
                appMap.put(allParam.getCode(), allParam.getName());
            }
            if (!menuCodes.isEmpty()) {
                for (MenuSimpleBO menuSimpleBO : this.menuRepoProc.listSimpleByMenuCode(menuCodes)) {
                    menuMap.put(menuSimpleBO.getMenusCode(), menuSimpleBO);
                }
            }
            if (!businessObjectCodes.isEmpty()) {
                for (BusinessObjectBO businessObjectSimpleBO : this.businessObjectRepoProc.listSimple(businessObjectCodes)) {
                    businessObjectMap.put(businessObjectSimpleBO.getCode(), businessObjectSimpleBO);
                }
            }
            if (!businessOperationCodes.isEmpty()) {
                for (BusinessOperationBO businessOperationSimpleBO : this.businessOperationRepoProc.listSimple(businessOperationCodes, null)) {
                    businessOperationMap.put(businessOperationSimpleBO.getOperationCode(), businessOperationSimpleBO);
                }
            }
            return null;
        });
        return permissionList.stream().map(t -> {
            UserDataPermissionRespVO.Base permission = (UserDataPermissionRespVO.Base)convert.apply(t);
            ObjUtil.ifNotNull((Object)DataPermissionType.fromValue((String)permission.getPermissionType()), p -> permission.setPermissionTypeName(p.getDescription()));
            ObjUtil.ifNotNull((Object)((BusinessOperationBO)businessOperationMap.get(permission.getPermissionRef())), p -> permission.setPermissionRefName(CharSequenceUtil.blankToDefault((CharSequence)p.getCustomName(), (String)p.getOperationDescription())));
            permission.setRoleName((String)roleMap.get(permission.getRoleCode()));
            permission.setAppName((String)appMap.get(permission.getAppCode()));
            ObjUtil.ifNotNull((Object)((BusinessObjectBO)businessObjectMap.get(t.getBusinessObjectCode())), p -> permission.setBusinessObjectName(CharSequenceUtil.blankToDefault((CharSequence)p.getCustomName(), (String)p.getName())));
            ObjUtil.ifNotNull((Object)((BusinessOperationBO)businessOperationMap.get(permission.getApiPermissionCode())), p -> {
                permission.setApiPermissionName(CharSequenceUtil.blankToDefault((CharSequence)p.getCustomName(), (String)p.getOperationDescription()));
                permission.setApiPermissionPath(p.getApiUrl());
                permission.setApiPermissionRequestType(p.getApiMethod());
            });
            ObjUtil.ifNotNull((Object)((MenuSimpleBO)menuMap.get(permission.getMenusCode())), p -> {
                permission.setMenusName(p.getMenusName());
                permission.setMenusRoute(p.getMenusRoute());
            });
            return permission;
        }).collect(Collectors.toList());
    }

    private UserDataPermissionRespVO.RowRule convert2VO(SysDprRoleApiDataRuleListQueryDTO rule) {
        UserDataPermissionRespVO.RowRule permission = PermissionConverter.INSTANCE.convertRowRule(rule);
        ObjUtil.ifNotBlank((String)DprRuleRelationEnum.getValue((String)permission.getDprRuleRelation()), permission::setDprRuleRelationName);
        ObjUtil.ifNotBlank((String)DprRuleConditionEnum.getValue((String)permission.getDprRuleCondition()), permission::setDprRuleConditionName);
        ObjUtil.ifNotBlank((String)DprRuleValueTypeEnum.getValue((String)permission.getDprRuleValueType()), permission::setDprRuleValueTypeName);
        return permission;
    }

    private UserDataPermissionRespVO.ApiField convert2VO(SysDpcRoleApiFieldsDTO rule) {
        return PermissionConverter.INSTANCE.convertApiField(rule);
    }

    private void switchCurrentTenant(GeneralUserDetails currentUser, SysTenantDTO tenantDTO) {
        SysUserDTO user = currentUser.getUser();
        currentUser.getUser().setSysTenantVO(tenantDTO);
        UserOrgBO userOrg = this.employeeOrgManager.queryOrgByUser(currentUser.getUserId());
        user.setOrgList(userOrg.getOrgList());
        user.setOrg(userOrg.getOrg());
        user.setTenantOrg(userOrg.getTenantOrg());
        user.setTenantOrgAdminId(userOrg.getTenantOrgAdminId());
        Set<String> roleCodes = this.permissionQueryManager.queryRoleByUser(user);
        user.setRoleCodes(this.normalizeLoginUserRole(roleCodes));
        SecurityContextUtil.updateCurrentUser((GeneralUserDetails)currentUser);
    }

    private void switchCurrentOrg(GeneralUserDetails currentUser, SysOrgBasicDTO org) {
        SysOuBasicDTO ou;
        SysUserDTO user = currentUser.getUser();
        user.setOrg(org);
        Map<SysOrgBasicDTO, Long> tenantOrgAdminMap = this.employeeOrgManager.getTenantOrg(org.getId());
        if (!tenantOrgAdminMap.isEmpty()) {
            for (Map.Entry<SysOrgBasicDTO, Long> entry : tenantOrgAdminMap.entrySet()) {
                user.setTenantOrg(entry.getKey());
                user.setTenantOrgAdminId(entry.getValue());
            }
        } else {
            user.setTenantOrg(null);
            user.setTenantOrgAdminId(null);
        }
        Set<String> roleCodes = this.permissionQueryManager.queryRoleByUser(user);
        user.setRoleCodes(this.normalizeLoginUserRole(roleCodes));
        boolean ouFlag = false;
        if (Boolean.TRUE.equals(this.systemProperties.getUseCompanyOrgAsOu())) {
            IdCodeNameParam company = this.orgRepoProc.queryParentNameForType(List.of(user.getOrg().getId()), OrgType.COMPANY.getValue(), true).get(user.getOrg().getId());
            if (company != null) {
                ouFlag = true;
                user.setOuId(company.getId());
                user.setOuCode(company.getCode());
                user.setOuName(company.getName());
            }
        } else if (user.getOrg().getOuId() != null && (ou = this.ouQueryManager.getOuBasicDTO(org.getOuId())) != null && Boolean.TRUE.equals(ou.getEnabled())) {
            ouFlag = true;
            user.setOuId(ou.getId());
            user.setOuCode(ou.getOuCode());
            user.setOuName(ou.getOuName());
        }
        if (!ouFlag) {
            user.setOuId(null);
            user.setOuCode(null);
            user.setOuName(null);
        }
        IdCodeNameParam position = this.employeeOrgManager.getPositionOfUser(user.getId(), user.getOrg().getId());
        user.setPosition(position);
        SecurityContextUtil.updateCurrentUser((GeneralUserDetails)currentUser);
    }

    private Set<String> normalizeLoginUserRole(Set<String> roleCodes) {
        if (CollectionUtils.isEmpty(roleCodes)) {
            return Collections.emptySet();
        }
        if (!StringUtils.hasText((String)this.authorizationProperties.getRolePrefix())) {
            return roleCodes;
        }
        String prefix = this.authorizationProperties.getRolePrefix();
        return roleCodes.stream().map(t -> t.indexOf(prefix) < 0 ? prefix + t : t).collect(Collectors.toSet());
    }
}

