/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.service.impl;

import com.elitescloud.boot.constant.TenantConstant;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.provider.TenantClientProvider;
import com.elitescloud.cloudt.core.annotation.TenantTransaction;
import com.elitescloud.cloudt.core.annotation.common.TenantIsolateType;
import com.elitescloud.cloudt.system.convert.InfinityFolderConvert;
import com.elitescloud.cloudt.system.dto.SysTenantDTO;
import com.elitescloud.cloudt.system.model.entity.InfinityFolderDO;
import com.elitescloud.cloudt.system.model.vo.resp.extend.FolderSaveParamVO;
import com.elitescloud.cloudt.system.service.InfinityFolderService;
import com.elitescloud.cloudt.system.service.repo.InfinityFolderRepo;
import com.elitescloud.cloudt.system.service.repo.InfinityFolderRepoProc;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@TenantTransaction(isolateType=TenantIsolateType.TENANT)
public class InfinityFolderServiceImpl
implements InfinityFolderService {
    private static final Logger log = LoggerFactory.getLogger(InfinityFolderServiceImpl.class);
    private final InfinityFolderRepo folderRepo;
    private final InfinityFolderRepoProc folderRepoProc;
    @Autowired
    private TenantClientProvider tenantClientProvider;

    private long currentTenantId() {
        SysTenantDTO tenant = this.tenantClientProvider.getSessionTenant();
        if (tenant == null) {
            tenant = this.tenantClientProvider.getCurrentTenant();
        }
        return tenant == null ? TenantConstant.DEFAULT_TENANT_ID : tenant.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long save(FolderSaveParamVO saveParam) {
        if (saveParam.isNew()) {
            InfinityFolderDO infinityFolderDO = InfinityFolderConvert.INSTANCE.saveParamToDO(saveParam);
            infinityFolderDO.setTenantId(this.currentTenantId());
            this.folderRepo.save(infinityFolderDO);
            return infinityFolderDO.getId();
        }
        Optional infinityFolderDO = this.folderRepo.findById(saveParam.getId());
        if (infinityFolderDO.isEmpty()) {
            throw new BusinessException("Not Found Data");
        }
        InfinityFolderDO infinityFolder = (InfinityFolderDO)infinityFolderDO.get();
        InfinityFolderConvert.INSTANCE.saveParamMergeToDO(saveParam, infinityFolder);
        infinityFolder.setTenantId(this.currentTenantId());
        this.folderRepo.save(infinityFolder);
        return infinityFolder.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public long delete(List<Long> ids) {
        return this.folderRepoProc.delete(ids);
    }

    public InfinityFolderServiceImpl(InfinityFolderRepo folderRepo, InfinityFolderRepoProc folderRepoProc) {
        this.folderRepo = folderRepo;
        this.folderRepoProc = folderRepoProc;
    }
}

