/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.spring.SpringUtil;
import cn.hutool.json.JSONUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.system.model.vo.resp.extend.FormColumnDefinition;
import com.elitescloud.cloudt.system.model.vo.resp.extend.HttpParam;
import com.elitescloud.cloudt.system.model.vo.resp.extend.InfinityLogVO;
import com.elitescloud.cloudt.system.model.vo.resp.extend.InfinityResult;
import com.elitescloud.cloudt.system.service.InfinityApiService;
import com.elitescloud.cloudt.system.service.SecurityAuthService;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.http.MediaType;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.BodyInserter;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.util.UriComponentsBuilder;

public class InfinityRestClient {
    private static final Logger log = LoggerFactory.getLogger(InfinityRestClient.class);
    private WebClient webClient;
    @Lazy
    @Resource
    private InfinityApiService infinityApiService;
    @Lazy
    @Resource
    private SecurityAuthService securityAuthService;
    public static Map<String, SecurityAuthService> consumerMap = new HashMap<String, SecurityAuthService>();

    public InfinityRestClient(WebClient webClient) {
        this.webClient = webClient;
    }

    @PostConstruct
    public void initHandlerMap() {
        Map consumers = SpringUtil.getBeansOfType(SecurityAuthService.class);
        consumers.forEach((k, v) -> consumerMap.put(v.getAuthType(), (SecurityAuthService)v));
        log.info("\u8ba4\u8bc1\u65b9\u5f0f\u5904\u7406\u5668:{}", (Object)JSONUtil.toJsonStr(consumerMap));
    }

    public InfinityResult<String> exchange(String apiCode) {
        return this.exchange(apiCode, String.class, null);
    }

    public <R> InfinityResult<R> exchange(String apiCode, Class<R> responseType) {
        return this.exchange(apiCode, responseType, null);
    }

    public InfinityResult<String> exchange(String apiCode, Function<HttpParam.HttpParamBuilder, HttpParam> func) {
        return this.exchange(apiCode, String.class, func);
    }

    public <R> InfinityResult<R> exchange(String apiCode, Class<R> responseType, Function<HttpParam.HttpParamBuilder, HttpParam> fn) {
        InfinityLogVO logVO = new InfinityLogVO();
        HttpParam.HttpParamBuilder builder = HttpParam.builder().apiConfig(this.infinityApiService.infinityApiByApiCode(apiCode));
        HttpParam param = fn != null ? fn.apply(builder) : builder.build();
        UriComponentsBuilder uriBuilder = UriComponentsBuilder.fromHttpUrl((String)param.getUrl());
        logVO.setServerUrl(param.getApiConfig().getServerUrl());
        logVO.setApiUrl(param.getApiConfig().getApiUrl());
        logVO.setUri(param.getUrl());
        List<FormColumnDefinition> queryConfig = param.getApiConfig().getQueryParam();
        if (CollUtil.isNotEmpty(queryConfig)) {
            queryConfig.stream().filter(def -> StrUtil.isNotBlank((CharSequence)def.getFixedValue())).forEach(def -> {
                uriBuilder.queryParam(def.getColumnKey(), new Object[]{def.getFixedValue()});
                logVO.addQueryParam(def.getColumnKey(), def.getFixedValue());
            });
        }
        if (MapUtil.isNotEmpty(param.getQueryParam())) {
            uriBuilder.queryParams(param.getQueryParam());
            logVO.addQueryParams(param.getQueryParam());
        }
        Map<String, Object> pathVariables = InfinityRestClient.extractPathVariables(param.getUrl());
        List<FormColumnDefinition> pathParam = param.getApiConfig().getPathParam();
        if (CollUtil.isNotEmpty(pathParam)) {
            pathParam.stream().filter(def -> StrUtil.isNotBlank((CharSequence)def.getFixedValue())).forEach(def -> {
                if (pathVariables.containsKey(def.getColumnKey())) {
                    pathVariables.put(def.getColumnKey(), def.getFixedValue());
                    logVO.addQueryParam(def.getColumnKey(), def.getFixedValue());
                }
            });
        }
        String finalUri = uriBuilder.toUriString();
        if (MapUtil.isEmpty(param.getPathParam())) {
            finalUri = uriBuilder.buildAndExpand(pathVariables).toUriString();
        }
        WebClient.RequestBodyUriSpec method = this.webClient.method(param.getRequestMethod());
        WebClient.RequestBodySpec uri = MapUtil.isEmpty(param.getPathParam()) ? (WebClient.RequestBodySpec)method.uri(new URI(finalUri)) : (WebClient.RequestBodySpec)method.uri(uriBuilder.build(false).toUriString(), param.getPathParam());
        uri.acceptCharset(new Charset[]{StandardCharsets.UTF_8});
        logVO.setRequestMethod(param.getRequestMethod());
        SecurityAuthService securityAuthService = consumerMap.get(param.getAuthMethod());
        if (securityAuthService == null) {
            throw new BusinessException("\u672a\u627e\u5230\u8ba4\u8bc1\u65b9\u5f0f\u7ed1\u5b9a\u7684\u8ba4\u8bc1\u5904\u7406\u5668");
        }
        log.info("\u547d\u4e2d\u7684\u8ba4\u8bc1\u65b9\u5f0f\u5904\u7406\u5668\u7f16\u7801:{}", (Object)securityAuthService.getAuthType());
        securityAuthService.authentication(uri, param);
        uri.headers(headers -> {
            MultiValueMap<String, String> headerParam;
            List<FormColumnDefinition> headerConfig = param.getApiConfig().getHeaderParam();
            if (CollUtil.isNotEmpty(headerConfig)) {
                headerConfig.stream().filter(def -> StrUtil.isNotBlank((CharSequence)def.getFixedValue())).forEach(def -> headers.set(def.getColumnKey(), def.getFixedValue()));
            }
            if (MapUtil.isNotEmpty(headerParam = param.getHeaderParam())) {
                for (String key : headerParam.keySet()) {
                    headers.set(key, (String)headerParam.getFirst((Object)key));
                }
            }
            logVO.setHeaderParam((MultiValueMap<String, String>)headers);
        });
        if (param.needBodyParam()) {
            uri.contentType(MediaType.parseMediaType((String)param.getMediaType()));
            if (param.formData()) {
                uri.body((BodyInserter)param.getBodyFormData());
                logVO.setBodyParam(param.getBodyFormData());
            } else if (param.objectData()) {
                uri.bodyValue(param.getBodyParam());
                logVO.setBodyParam(param.getBodyParam());
            }
        }
        return InfinityResult.of(responseType, param, logVO, uri);
    }

    private static Map<String, Object> extractPathVariables(String url) {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        Pattern pattern = Pattern.compile("\\{(\\w+)}");
        Matcher matcher = pattern.matcher(url);
        while (matcher.find()) {
            String variableName = matcher.group(1);
            variables.put(variableName, null);
        }
        return variables;
    }
}

