/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.service.impl;

import com.elitescloud.cloudt.system.common.LoggingProperties;
import com.elitescloud.cloudt.system.common.TrackType;
import com.elitescloud.cloudt.system.model.vo.resp.extend.InfinityLogVO;
import com.elitescloud.cloudt.system.service.InfinityLogListener;
import com.elitescloud.cloudt.system.service.InfinityTrackService;
import com.elitescloud.cloudt.system.service.PersistenceService;
import com.elitescloud.cloudt.system.util.HttpServletUtil;
import com.elitescloud.cloudt.system.util.ResponseWrapper;
import com.elitescloud.cloudt.system.util.TenantSpiUtil;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.stereotype.Service;

@Service
public class InfinityTrackServiceImpl
implements InfinityTrackService {
    private static final Logger log = LoggerFactory.getLogger(InfinityTrackServiceImpl.class);
    private final PersistenceService persistenceService;
    @Autowired(required=false)
    private InfinityLogListener infinityLogListener;

    @Override
    public void record(ServerHttpRequest request, ServerHttpResponse response, Object responseBody) {
        ResponseWrapper responseWrapper = HttpServletUtil.wrapper(response);
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("CURRENT_TENANT", TenantSpiUtil.currentTenantCode());
        param.put("RESPONSE_STATUS", responseWrapper.getStatus());
        param.put("RESPONSE_BODY", responseBody);
        this.persistenceService.addSystemLog(LoggingProperties.LOG_INFINITY_CFG, HttpServletUtil.wrapper(request), TrackType.LOG_INFINITY_PASSIVE.getCode(), "[INFINITY] \u63a5\u53e3(\u88ab\u52a8)\u8c03\u7528\u65e5\u5fd7", param, "");
    }

    @Override
    public void record(InfinityLogVO requestParam) {
        this.persistenceService.addSystemLog(LoggingProperties.LOG_INFINITY_CFG, TrackType.LOG_INFINITY_INVOKE.getCode(), "[INFINITY] \u63a5\u53e3(\u4e3b\u52a8)\u8c03\u7528\u65e5\u5fd7", requestParam, null);
        if (this.infinityLogListener != null) {
            try {
                boolean result = this.infinityLogListener.createLog(requestParam);
                if (!result) {
                    log.error("[INFINITY] log listener record failed");
                }
            }
            catch (Exception e) {
                log.error("[INFINITY] log listener record error: ", (Throwable)e);
            }
        }
    }

    public InfinityTrackServiceImpl(PersistenceService persistenceService) {
        this.persistenceService = persistenceService;
    }
}

