/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.BooleanUtil;
import cn.hutool.core.util.ObjUtil;
import cn.hutool.core.util.ObjectUtil;
import com.elitescloud.boot.auth.util.SecurityContextUtil;
import com.elitescloud.boot.common.constant.MimeTypeConstant;
import com.elitescloud.boot.common.param.CodeNameParam;
import com.elitescloud.boot.common.param.IdCodeNameParam;
import com.elitescloud.boot.common.param.TreeRespParam;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.boot.excel.common.param.ExportColumnParam;
import com.elitescloud.boot.excel.util.ExcelExportUtil;
import com.elitescloud.boot.excel.util.ExcelImportUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.provider.PlatformAppProvider;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.context.util.CollectionUtil;
import com.elitescloud.cloudt.context.util.TreeDataUtil;
import com.elitescloud.cloudt.core.annotation.TenantOrgTransaction;
import com.elitescloud.cloudt.core.annotation.TenantTransaction;
import com.elitescloud.cloudt.core.annotation.common.TenantIsolateType;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitescloud.cloudt.system.cacheable.SysCacheMenuRpcService;
import com.elitescloud.cloudt.system.constant.PlatformAppMenusTypeEnum;
import com.elitescloud.cloudt.system.constant.PlatformMenusNodeEnum;
import com.elitescloud.cloudt.system.convert.TenantMenuTreeConvert;
import com.elitescloud.cloudt.system.dto.SysTenantDTO;
import com.elitescloud.cloudt.system.model.bo.MenuBO;
import com.elitescloud.cloudt.system.model.bo.TenantMenuBO;
import com.elitescloud.cloudt.system.model.vo.resp.menu.CustomMenuBoundRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.menu.CustomMenuEditRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.menu.CustomMenuNodeDetailRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.menu.CustomMenuTreeRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.menu.MenuTreeCustomRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.menu.MenuTreeRespVO;
import com.elitescloud.cloudt.system.model.vo.save.menu.CustomMenuBoundSaveVO;
import com.elitescloud.cloudt.system.model.vo.save.menu.CustomMenuGroupSaveVO;
import com.elitescloud.cloudt.system.model.vo.save.menu.MenuTreeSaveVO;
import com.elitescloud.cloudt.system.provider.dto.save.SysMenuSaveDTO;
import com.elitescloud.cloudt.system.service.MenuMngService;
import com.elitescloud.cloudt.system.service.common.constant.MenuTreeNodeType;
import com.elitescloud.cloudt.system.service.manager.PermissionQueryManager;
import com.elitescloud.cloudt.system.service.model.bo.AppBO;
import com.elitescloud.cloudt.system.service.model.entity.SysPlatformMenusDO;
import com.elitescloud.cloudt.system.service.model.entity.SysTenantMenuDO;
import com.elitescloud.cloudt.system.service.model.entity.SysTenantMenuTreeDO;
import com.elitescloud.cloudt.system.service.repo.MenuRepoProc;
import com.elitescloud.cloudt.system.service.repo.TenantAppRepoProc;
import com.elitescloud.cloudt.system.service.repo.TenantMenuRepo;
import com.elitescloud.cloudt.system.service.repo.TenantMenuRepoProc;
import com.elitescloud.cloudt.system.service.repo.TenantMenuTreeRepo;
import com.elitescloud.cloudt.system.service.repo.TenantMenuTreeRepoProc;
import com.google.common.base.Functions;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ContentDisposition;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MimeType;
import org.springframework.util.StreamUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.mvc.method.annotation.StreamingResponseBody;

@Service
@TenantTransaction(isolateType=TenantIsolateType.TENANT)
@TenantOrgTransaction(useTenantOrg=false)
public class MenuMngServiceImpl
extends BaseServiceImpl
implements MenuMngService {
    private static final Logger log = LogManager.getLogger(MenuMngServiceImpl.class);
    private static final TenantMenuTreeConvert CONVERT = TenantMenuTreeConvert.INSTANCE;
    @Autowired
    private TenantMenuRepo tenantMenuRepo;
    @Autowired
    private TenantMenuRepoProc tenantMenuRepoProc;
    @Autowired
    private TenantMenuTreeRepo tenantMenuTreeRepo;
    @Autowired
    private TenantMenuTreeRepoProc tenantMenuTreeRepoProc;
    @Autowired
    private MenuRepoProc menusRepoProc;
    @Autowired
    private TenantAppRepoProc tenantAppRepoProc;
    @Autowired
    private PermissionQueryManager permissionQueryManager;
    @Autowired
    private PlatformAppProvider appProvider;
    @Autowired
    private SysCacheMenuRpcService cacheMenuRpcService;

    @Override
    @TenantTransaction(isolateType=TenantIsolateType.DEFAULT)
    public ApiResult<Long> addMenu(SysMenuSaveDTO saveDTO) {
        SysPlatformMenusDO menuDO = CONVERT.dto2do(saveDTO);
        Assert.hasText((String)menuDO.getMenusCode(), (String)"\u83dc\u5355\u7f16\u7801\u4e3a\u7a7a");
        boolean exists = this.menusRepoProc.existsMenuCode(saveDTO.getMenusCode());
        Assert.isTrue((!exists ? 1 : 0) != 0, (String)"\u83dc\u5355\u7f16\u7801\u5df2\u5b58\u5728");
        if (StringUtils.hasText((String)saveDTO.getMenusParentCode())) {
            exists = this.menusRepoProc.existsMenuCode(saveDTO.getMenusParentCode());
            Assert.isTrue((boolean)exists, (String)"\u4e0a\u7ea7\u83dc\u5355\u4e0d\u5b58\u5728");
            menuDO.setMenusAppCode(this.menusRepoProc.getAppCodeByMenuCode(saveDTO.getMenusParentCode()));
        } else {
            Assert.hasText((String)menuDO.getMenusAppCode(), (String)"\u672a\u77e5\u83dc\u5355\u6240\u5c5e\u5e94\u7528");
        }
        menuDO.setMenusType(((PlatformAppMenusTypeEnum)ObjUtil.defaultIfNull((Object)saveDTO.getMenusTypeEnum(), (Object)PlatformAppMenusTypeEnum.MENUS_TYPE_BUS)).name());
        menuDO.setNodeType(((PlatformMenusNodeEnum)ObjUtil.defaultIfNull((Object)saveDTO.getNodeTypeEnum(), (Object)PlatformMenusNodeEnum.MENUS)).name());
        menuDO.setMenusOrder(Integer.valueOf(0));
        menuDO.setMenusState(Boolean.valueOf(true));
        menuDO.setDisplay(Boolean.valueOf(true));
        menuDO.setOuterLink((Boolean)ObjUtil.defaultIfNull((Object)saveDTO.getOuterLink(), (Object)false));
        menuDO.setOuterLinkType(saveDTO.getOuterLinkTypeEnum());
        if (menuDO.getOuterLink().booleanValue()) {
            Assert.notNull((Object)menuDO.getOuterLinkType(), (String)"\u672a\u77e5\u5916\u90e8\u94fe\u63a5\u7c7b\u578b");
            Assert.hasText((String)menuDO.getMenusRoute(), (String)"\u5916\u90e8\u94fe\u63a5\u65f6\u8def\u7531\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.menusRepoProc.save((Serializable)menuDO);
        this.clearCache();
        return ApiResult.ok((Object)menuDO.getId());
    }

    @Override
    @TenantTransaction(isolateType=TenantIsolateType.DEFAULT)
    public ApiResult<String> removeMenu(String menuCode) {
        Assert.hasText((String)menuCode, (String)"\u83dc\u5355\u7f16\u7801\u4e3a\u7a7a");
        this.menusRepoProc.deleteByMenuCode(menuCode);
        this.clearCache();
        return ApiResult.ok((Object)menuCode);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> saveCustomMenuGroup(CustomMenuGroupSaveVO saveVO) {
        SysTenantMenuTreeDO menuTreeDO = null;
        try {
            menuTreeDO = this.convert(saveVO);
        }
        catch (Exception e) {
            return ApiResult.fail((String)("\u4fdd\u5b58\u5931\u8d25\uff0c" + e.getMessage()));
        }
        this.tenantMenuTreeRepoProc.save((Serializable)menuTreeDO);
        this.clearCache();
        return ApiResult.ok((Object)menuTreeDO.getId());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> updateCustomEnabled(Long id, Boolean enabled) {
        Assert.notNull((Object)id, (String)"ID\u4e3a\u7a7a");
        Assert.notNull((Object)enabled, (String)"\u542f\u7528\u72b6\u6001\u4e3a\u7a7a");
        this.tenantMenuTreeRepoProc.updateEnabled(id, enabled);
        this.clearCache();
        return ApiResult.ok((Object)id);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Boolean> removeAllCustom() {
        this.tenantMenuTreeRepoProc.deleteAll();
        this.clearCache();
        return ApiResult.ok((Object)true);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<List<Long>> removeCustom(List<Long> ids, Boolean cascade) {
        Assert.notEmpty(ids, (String)"ID\u4e3a\u7a7a");
        this.clearCache();
        if (cascade.booleanValue()) {
            this.deleteCascade(ids);
            return ApiResult.ok(ids);
        }
        List<String> existsNames = this.tenantMenuTreeRepoProc.existsChildren(ids);
        if (existsNames.isEmpty()) {
            this.tenantMenuTreeRepoProc.delete(ids);
            return ApiResult.ok(ids);
        }
        return ApiResult.fail((String)("[" + String.join((CharSequence)",", existsNames) + "]\u5b58\u5728\u4e0b\u7ea7\u8282\u70b9\uff0c\u8bf7\u5148\u5220\u9664\u4e0b\u7ea7"));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> removeCustomChildren(Long id, Boolean withSelf) {
        Assert.notNull((Object)id, (String)"ID\u4e3a\u7a7a");
        if (Boolean.TRUE.equals(withSelf)) {
            this.deleteCascade(List.of(id));
        } else {
            List<Long> childrenIds = this.tenantMenuTreeRepoProc.listChildrenIds(Set.of(id));
            this.deleteCascade(childrenIds);
        }
        this.clearCache();
        return ApiResult.ok((Object)id);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> moveCustom(Long id, Long newParentId, Integer sortNo) {
        Assert.notNull((Object)id, (String)"ID\u4e3a\u7a7a");
        String nodeType = this.tenantMenuTreeRepoProc.getNodeType(id);
        if (!StringUtils.hasText((String)nodeType)) {
            return ApiResult.fail((String)"\u4fee\u6539\u7684\u6570\u636e\u4e0d\u5b58\u5728");
        }
        if (MenuTreeNodeType.MENU.getValue().equals(nodeType) && newParentId == null) {
            return ApiResult.fail((String)"\u83dc\u5355\u5fc5\u987b\u5728\u5206\u7ec4\u4e0b");
        }
        if (newParentId != null) {
            String parentNodeType = this.tenantMenuTreeRepoProc.getNodeType(newParentId);
            if (!StringUtils.hasText((String)parentNodeType)) {
                return ApiResult.fail((String)"\u5206\u7ec4\u6570\u636e\u4e0d\u5b58\u5728");
            }
            if (MenuTreeNodeType.MENU.getValue().equals(parentNodeType)) {
                return ApiResult.fail((String)"\u4e0d\u80fd\u79fb\u52a8\u5230\u83dc\u5355\u4e0b\u9762");
            }
        }
        String parentCode = newParentId == null ? null : this.tenantMenuTreeRepoProc.getMenuCode(newParentId);
        this.tenantMenuTreeRepoProc.updateParent(id, parentCode, (Integer)ObjUtil.defaultIfNull((Object)sortNo, (Object)0));
        this.clearCache();
        return ApiResult.ok((Object)id);
    }

    @Override
    public ApiResult<CustomMenuEditRespVO> getCustomEdit(Long id) {
        Assert.notNull((Object)id, (String)"ID\u4e3a\u7a7a");
        SysTenantMenuTreeDO menuGroupDO = (SysTenantMenuTreeDO)this.tenantMenuTreeRepoProc.get(id);
        if (menuGroupDO == null) {
            return ApiResult.fail((String)"\u6570\u636e\u4e0d\u5b58\u5728");
        }
        CustomMenuEditRespVO respVO = TenantMenuTreeConvert.INSTANCE.do2EditRespVO(menuGroupDO);
        if (StringUtils.hasText((String)respVO.getParentMenuCode())) {
            respVO.setParentMenuName(this.tenantMenuTreeRepoProc.getMenuNameByMenuCode(respVO.getParentMenuCode()));
        }
        if (MenuTreeNodeType.MENU.getValue().equals(menuGroupDO.getNodeType())) {
            respVO.setCustomName(menuGroupDO.getMenuName());
            this.tenantDataIsolateProvider.byDefaultDirectly(() -> {
                respVO.setMenuName(this.menusRepoProc.getMenuNameByMenuCode(menuGroupDO.getMenuCode()));
                return null;
            });
            if (CharSequenceUtil.isBlank((CharSequence)respVO.getMenuName())) {
                return ApiResult.fail((String)"\u83dc\u5355\u5df2\u4e0d\u5b58\u5728");
            }
        }
        return ApiResult.ok((Object)respVO);
    }

    @Override
    public ApiResult<CustomMenuNodeDetailRespVO> getCustomNodeDetail(Long id) {
        Assert.notNull((Object)id, (String)"ID\u4e3a\u7a7a");
        SysTenantMenuTreeDO menuGroupDO = (SysTenantMenuTreeDO)this.tenantMenuTreeRepoProc.get(id);
        if (menuGroupDO == null) {
            return ApiResult.fail((String)"\u6570\u636e\u4e0d\u5b58\u5728");
        }
        CustomMenuNodeDetailRespVO respVO = TenantMenuTreeConvert.INSTANCE.do2NodeDetailRespVO(menuGroupDO);
        if (StringUtils.hasText((String)respVO.getParentMenuCode())) {
            respVO.setParentMenuName(this.tenantMenuTreeRepoProc.getMenuNameByMenuCode(respVO.getParentMenuCode()));
        }
        if (MenuTreeNodeType.MENU.getValue().equals(menuGroupDO.getNodeType())) {
            respVO.setCustomName(menuGroupDO.getMenuName());
            this.tenantDataIsolateProvider.byDefaultDirectly(() -> {
                respVO.setMenuName(this.menusRepoProc.getMenuNameByMenuCode(menuGroupDO.getMenuCode()));
                return null;
            });
            if (CharSequenceUtil.isBlank((CharSequence)respVO.getMenuName())) {
                return ApiResult.fail((String)"\u83dc\u5355\u5df2\u4e0d\u5b58\u5728");
            }
            respVO.setChildren(Collections.emptyList());
            respVO.setChildrenNum(0L);
        } else {
            Set menuCodes;
            List<CustomMenuNodeDetailRespVO> children = this.tenantMenuTreeRepoProc.queryByParentMenuCode(menuGroupDO.getMenuCode());
            Set set = menuCodes = children.isEmpty() ? Collections.emptySet() : children.stream().filter(t -> MenuTreeNodeType.MENU.getValue().equals(t.getNodeType())).map(CustomMenuNodeDetailRespVO::getMenuCode).collect(Collectors.toSet());
            if (!menuCodes.isEmpty()) {
                Map menuCodeNameMap = (Map)this.tenantDataIsolateProvider.byDefaultDirectly(() -> this.menusRepoProc.getMenuNameByMenuCode(menuCodes));
                children = children.stream().peek(t -> {
                    t.setCustomName(t.getMenuName());
                    t.setMenuName(menuCodeNameMap.getOrDefault(t.getMenuCode(), t.getMenuName()));
                    t.setParentMenuCode(respVO.getMenuCode());
                    t.setParentMenuName(respVO.getMenuName());
                }).collect(Collectors.toList());
            } else {
                children = children.stream().peek(t -> {
                    t.setParentMenuCode(respVO.getMenuCode());
                    t.setParentMenuName(respVO.getMenuName());
                }).collect(Collectors.toList());
            }
            respVO.setChildren(children);
            respVO.setChildrenNum(Long.valueOf(children.size()));
        }
        return ApiResult.ok((Object)respVO);
    }

    @Override
    public ApiResult<List<IdCodeNameParam>> listGroup() {
        List<IdCodeNameParam> dataList = this.tenantMenuTreeRepoProc.listGroup();
        return ApiResult.ok(dataList);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<String> saveBoundMenus(CustomMenuBoundSaveVO saveVO) {
        Assert.hasText((String)saveVO.getGroupCode(), (String)"\u5206\u7ec4\u7f16\u7801\u4e3a\u7a7a");
        SysTenantMenuTreeDO menuGroup = this.tenantMenuTreeRepoProc.getByMenuCode(saveVO.getGroupCode());
        if (menuGroup == null) {
            return ApiResult.fail((String)"\u5206\u7ec4\u4e0d\u5b58\u5728");
        }
        boolean all = (Boolean)ObjectUtil.defaultIfNull((Object)saveVO.getAll(), (Object)true);
        List menuTreeDoList = null;
        if (CollUtil.isEmpty(saveVO.getBoundMenus())) {
            menuTreeDoList = Collections.emptyList();
        } else {
            HashSet<String> existsCodes = new HashSet<String>(32);
            if (!all) {
                List<String> boundCodes = this.tenantMenuTreeRepoProc.getBoundMenuCodes(menuGroup.getMenuCode());
                existsCodes.addAll(boundCodes);
            }
            menuTreeDoList = new ArrayList(saveVO.getBoundMenus().size());
            int i = 0;
            for (CustomMenuBoundSaveVO.Menu menu : saveVO.getBoundMenus()) {
                if (existsCodes.contains(menu.getMenuCode())) continue;
                existsCodes.add(menu.getMenuCode());
                SysTenantMenuTreeDO menuTreeDO = new SysTenantMenuTreeDO();
                menuTreeDO.setMenuCode(menu.getMenuCode());
                menuTreeDO.setMenuName(menu.getCustomName());
                menuTreeDO.setNodeType(MenuTreeNodeType.MENU.getValue());
                menuTreeDO.setParentMenuCode(menuGroup.getMenuCode());
                menuTreeDO.setCustom(Boolean.valueOf(true));
                menuTreeDO.setSortNo(Integer.valueOf(i++));
                menuTreeDO.setEnabled(Boolean.valueOf(true));
                menuTreeDoList.add(menuTreeDO);
            }
        }
        if (all) {
            this.tenantMenuTreeRepoProc.deleteBoundMenuCodes(menuGroup.getMenuCode());
        }
        if (!menuTreeDoList.isEmpty()) {
            this.tenantMenuTreeRepoProc.save(menuTreeDoList);
        }
        return ApiResult.ok((Object)saveVO.getGroupCode());
    }

    @Override
    public ApiResult<List<CustomMenuBoundRespVO>> getBoundMenus(String groupCode) {
        List<CodeNameParam> customMenuList = this.tenantMenuTreeRepoProc.getBoundMenu(groupCode);
        if (customMenuList.isEmpty()) {
            return ApiResult.ok(Collections.emptyList());
        }
        Set menuCodes = customMenuList.stream().map(CodeNameParam::getCode).filter(StringUtils::hasText).collect(Collectors.toSet());
        Map menuMap = ((List)this.tenantDataIsolateProvider.byDefaultDirectly(() -> this.menusRepoProc.getMenuCodeAndNames(menuCodes))).stream().collect(Collectors.toMap(IdCodeNameParam::getCode, Functions.identity(), (t1, t2) -> t1));
        List respVoList = customMenuList.stream().filter(t -> menuMap.containsKey(t.getCode())).map(t -> {
            IdCodeNameParam menu = (IdCodeNameParam)menuMap.get(t.getCode());
            CustomMenuBoundRespVO respVO = new CustomMenuBoundRespVO();
            respVO.setId(menu.getId());
            respVO.setCode(menu.getCode());
            respVO.setName(menu.getName());
            respVO.setCustomName(t.getName());
            return respVO;
        }).collect(Collectors.toList());
        return ApiResult.ok(respVoList);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Boolean> saveTree(List<MenuTreeSaveVO> saveVOList) {
        Long tenantId = this.currentTenantId();
        List<SysTenantMenuTreeDO> menuTreeDoList = this.convertAndCheck(tenantId, saveVOList);
        this.tenantMenuTreeRepoProc.deleteByTenantId();
        this.tenantMenuTreeRepo.saveAll(menuTreeDoList);
        return ApiResult.ok((Object)true);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Boolean> updateEnabledCustom() {
        Long tenantId = this.currentTenantId();
        Boolean enabledCurrent = this.tenantMenuRepoProc.getEnabledByTenant(tenantId);
        if (enabledCurrent == null) {
            SysTenantMenuDO tenantMenuDO = new SysTenantMenuDO();
            tenantMenuDO.setSysTenantId(tenantId);
            tenantMenuDO.setEnabled(Boolean.valueOf(true));
            this.tenantMenuRepo.save(tenantMenuDO);
            return ApiResult.ok((Object)true);
        }
        boolean enabled = enabledCurrent == false;
        this.tenantMenuRepoProc.updateEnabledByTenant(tenantId, enabled);
        return ApiResult.ok((Object)true);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> updateCustomName(Long id, String customName) {
        Assert.notNull((Object)id, (String)"\u83dc\u5355ID\u4e3a\u7a7a");
        this.tenantMenuTreeRepoProc.updateMenuName(id, customName);
        return ApiResult.ok((Object)id);
    }

    @Override
    public ApiResult<List<CustomMenuTreeRespVO>> getCustomMenuTree(Boolean tree) {
        List<CustomMenuTreeRespVO> respVoList = this.queryCustomMenuTree();
        if (respVoList.isEmpty()) {
            return ApiResult.ok(respVoList);
        }
        TreeDataUtil treeDataUtil = new TreeDataUtil(respVoList, TreeRespParam::getId, TreeRespParam::getParentId, TreeRespParam::setChildren, Comparator.comparingInt(TreeRespParam::getSortNo));
        respVoList = treeDataUtil.getRoots().stream().filter(t -> MenuTreeNodeType.MENU_GROUP.getValue().equals(t.getNodeType())).collect(Collectors.toList());
        this.setDepth(respVoList, TreeRespParam::getChildren, 0, CustomMenuTreeRespVO::setDepth);
        if (tree == null || tree.booleanValue()) {
            return ApiResult.ok(respVoList);
        }
        respVoList = CollectionUtil.expandTree(respVoList, TreeRespParam::getChildren);
        return ApiResult.ok((Object)respVoList);
    }

    @Override
    public ApiResult<List<MenuTreeRespVO>> getTreeDefault(Boolean tree) {
        Set appCodes;
        GeneralUserDetails currentUser = SecurityContextUtil.currentUserIfUnauthorizedThrow();
        Set set = appCodes = currentUser.getTenant() == null ? null : (Set)this.tenantDataIsolateProvider.byDefaultDirectly(() -> this.tenantAppRepoProc.getAppCode(currentUser.getTenantId()));
        if (!currentUser.isOperation() && CollectionUtils.isEmpty((Collection)appCodes)) {
            return ApiResult.ok(Collections.emptyList());
        }
        List<MenuTreeRespVO> respVOList = this.convertMenuTreeRespVO(appCodes);
        if (respVOList.isEmpty()) {
            return ApiResult.ok(Collections.emptyList());
        }
        List<MenuTreeRespVO> finalRespVOList = respVOList;
        ((List)this.tenantDataIsolateProvider.byDefaultDirectly(() -> this.menusRepoProc.queryMenu(appCodes, true, true, true, true))).stream().filter(t -> PlatformAppMenusTypeEnum.MENUS_TYPE_BUS.name().equals(t.getMenusType())).forEach(t -> {
            MenuTreeRespVO respVO = new MenuTreeRespVO();
            respVO.setMenuCode(t.getMenusCode());
            respVO.setMenuName(t.getMenusName());
            respVO.setMenusType(t.getMenusType());
            respVO.setNodeType(MenuTreeNodeType.MENU.getValue());
            respVO.setParentMenuCode(t.getMenusParentCode());
            if (CharSequenceUtil.isBlank((CharSequence)t.getMenusParentCode())) {
                respVO.setParentMenuCode(t.getMenusAppCode());
            }
            respVO.setMenusIcon(t.getMenusIcon());
            respVO.setHidden(t.getDisplay() != null && t.getDisplay() == false);
            respVO.setEnabled(t.getMenusState() == null || t.getMenusState() != false);
            respVO.setSortNo((Integer)ObjectUtil.defaultIfNull((Object)t.getMenusOrder(), (Object)1));
            respVO.setHasChildren(false);
            respVO.setChildren(new ArrayList<MenuTreeRespVO>(128));
            finalRespVOList.add(respVO);
        });
        if (BooleanUtil.isFalse((Boolean)tree)) {
            return ApiResult.ok(respVOList);
        }
        TreeDataUtil treeDataUtil = new TreeDataUtil(respVOList, MenuTreeRespVO::getMenuCode, MenuTreeRespVO::getParentMenuCode, MenuTreeRespVO::setChildren, Comparator.comparingInt(MenuTreeRespVO::getSortNo));
        respVOList = treeDataUtil.getRoots().stream().filter(t -> MenuTreeNodeType.APP.getValue().equals(t.getNodeType())).collect(Collectors.toList());
        return ApiResult.ok(respVOList);
    }

    @Override
    public ApiResult<List<MenuTreeCustomRespVO>> getTreeCustom(Boolean tree) {
        SysTenantDTO currentTenant = this.tenantClientProvider.getCurrentTenant();
        List<SysTenantMenuTreeDO> menuTreeDOList = this.tenantMenuTreeRepoProc.queryByTenantId();
        if (menuTreeDOList.isEmpty()) {
            return ApiResult.ok(Collections.emptyList());
        }
        Map<String, MenuBO> menuDOMap = ((List)this.tenantDataIsolateProvider.byDefaultDirectly(() -> this.menusRepoProc.queryMenu(null, true, true, true, true))).stream().filter(t -> PlatformAppMenusTypeEnum.MENUS_TYPE_BUS.name().equals(t.getMenusType())).collect(Collectors.toMap(MenuBO::getMenusCode, t -> t, (t1, t2) -> t1));
        Map<String, CodeNameParam> allApps = this.appProvider.all().stream().collect(Collectors.toMap(CodeNameParam::getCode, t -> t, (t1, t2) -> t1));
        ArrayList<MenuTreeCustomRespVO> menuVOList = new ArrayList<MenuTreeCustomRespVO>(menuTreeDOList.size());
        MenuTreeCustomRespVO menuVO = null;
        for (SysTenantMenuTreeDO menuTreeDO : menuTreeDOList) {
            menuVO = new MenuTreeCustomRespVO();
            menuVO.setMenuCode(menuTreeDO.getMenuCode());
            menuVO.setCustom(menuTreeDO.getCustom());
            menuVO.setMenuName(menuTreeDO.getMenuName());
            MenuTreeNodeType nodeType = MenuTreeNodeType.valueOf((String)menuTreeDO.getNodeType());
            if (nodeType == null) {
                log.error("\u672a\u77e5\u83dc\u5355\u8282\u70b9\u7c7b\u578b\uff1a" + menuTreeDO.getNodeType());
                continue;
            }
            if (MenuTreeNodeType.MENU == nodeType) {
                MenuBO menuBO = menuDOMap.get(menuTreeDO.getMenuCode());
                if (menuBO == null) {
                    if (!menuTreeDO.getCustom().booleanValue()) {
                        log.info("\u83dc\u5355\u4e0d\u5b58\u5728\uff1a" + menuTreeDO.getMenuCode());
                        continue;
                    }
                    menuVO.setHidden(false);
                    menuVO.setEnabled(true);
                } else {
                    if (CharSequenceUtil.isBlank((CharSequence)menuVO.getMenuName())) {
                        menuVO.setMenuName(menuBO.getMenusName());
                    }
                    menuVO.setOriginalMenuName(menuBO.getMenusName());
                    menuVO.setOriginalMenusIcon(menuBO.getMenusIcon());
                    menuVO.setHidden(menuBO.getDisplay() != null && menuBO.getDisplay() == false);
                    menuVO.setEnabled(menuBO.getMenusState() == null || menuBO.getMenusState() != false);
                }
            } else if (MenuTreeNodeType.APP == nodeType) {
                CodeNameParam app = allApps.get(menuTreeDO.getMenuCode());
                if (app == null) {
                    log.info("\u79df\u6237\u5e94\u7528\u5df2\u4e0d\u5b58\u5728\uff1a{}", (Object)menuTreeDO.getMenuCode());
                    continue;
                }
                if (CharSequenceUtil.isBlank((CharSequence)menuVO.getMenuName())) {
                    menuVO.setMenuName(app.getName());
                }
                menuVO.setOriginalMenuName(app.getName());
                menuVO.setOriginalMenusIcon("");
                menuVO.setHidden(false);
                menuVO.setEnabled(true);
            } else {
                log.error("\u6682\u4e0d\u652f\u6301\u7684\u8282\u70b9\u7c7b\u578b\uff1a{}", (Object)nodeType.getValue());
                continue;
            }
            menuVO.setNodeType(menuTreeDO.getNodeType());
            menuVO.setParentMenuCode(menuTreeDO.getParentMenuCode());
            menuVO.setMenusIcon(menuTreeDO.getIcon());
            menuVO.setSortNo(menuTreeDO.getSortNo());
            menuVO.setHasChildren(false);
            menuVO.setChildren(new ArrayList<MenuTreeCustomRespVO>(128));
            menuVOList.add(menuVO);
        }
        if (BooleanUtil.isFalse((Boolean)tree)) {
            return ApiResult.ok(menuVOList);
        }
        TreeDataUtil treeDataUtil = new TreeDataUtil(menuVOList, MenuTreeCustomRespVO::getMenuCode, MenuTreeCustomRespVO::getParentMenuCode, MenuTreeCustomRespVO::setChildren, Comparator.comparing(MenuTreeCustomRespVO::getSortNo, Comparator.nullsLast(Integer::compareTo)));
        return ApiResult.ok((Object)treeDataUtil.getRoots());
    }

    @Override
    public ApiResult<Boolean> getCustomEnabled() {
        Long tenantId = this.currentTenantId();
        Boolean enabled = this.tenantMenuRepoProc.getEnabledByTenant(tenantId);
        return ApiResult.ok((Object)((Boolean)ObjectUtil.defaultIfNull((Object)enabled, (Object)false)));
    }

    @Override
    public ResponseEntity<StreamingResponseBody> export() {
        List<TenantMenuBO> menuList = this.tenantMenuTreeRepoProc.queryMenuBos();
        if (menuList.isEmpty()) {
            byte[] notFound = "\u672a\u914d\u7f6e\u81ea\u5b9a\u4e49\u83dc\u5355".getBytes(StandardCharsets.UTF_8);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().contentType(MediaType.APPLICATION_OCTET_STREAM).header("Content-Disposition", new String[]{ContentDisposition.builder((String)"attachment").filename("\u672a\u914d\u7f6e\u81ea\u5b9a\u4e49\u83dc\u5355.xlsx", StandardCharsets.UTF_8).build().toString()})).contentLength((long)notFound.length).body(outputStream -> {
                try {
                    StreamUtils.copy((byte[])notFound, (OutputStream)outputStream);
                }
                catch (Exception e) {
                    log.error("\u4e0b\u8f7d\u8d44\u6e90\u6587\u4ef6\u5f02\u5e38\uff1a", (Throwable)e);
                }
            });
        }
        byte[] bytes = this.export2Bytes(menuList);
        ContentDisposition contentDisposition = ContentDisposition.builder((String)"attachment").filename("\u81ea\u5b9a\u4e49\u83dc\u5355.xlsx", StandardCharsets.UTF_8).build();
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().contentType(MimeTypeConstant.parseMediaType((MimeType)MimeTypeConstant.XLSX)).header("Content-Disposition", new String[]{contentDisposition.toString()})).contentLength((long)bytes.length).body(outputStream -> {
            try {
                StreamUtils.copy((byte[])bytes, (OutputStream)outputStream);
            }
            catch (Exception e) {
                log.error("\u5bfc\u51fa\u81ea\u5b9a\u4e49\u83dc\u5355\u5f02\u5e38\uff1a", (Throwable)e);
            }
        });
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Boolean> importByFile(MultipartFile file, Boolean increment) {
        if (file == null || file.isEmpty()) {
            return ApiResult.fail((String)"\u5bfc\u5165\u6587\u4ef6\u4e3a\u7a7a");
        }
        List<TenantMenuBO> dataList = null;
        try {
            dataList = this.analyzeImportFile(file);
        }
        catch (Exception e) {
            log.error("\u89e3\u6790\u5bfc\u5165\u6570\u636e\u5f02\u5e38", (Throwable)e);
            return ApiResult.fail((String)"\u89e3\u6790\u5bfc\u5165\u6570\u636e\u5f02\u5e38");
        }
        this.saveImportData(dataList, (Boolean)ObjUtil.defaultIfNull((Object)increment, (Object)false));
        this.clearCache();
        return ApiResult.ok((Object)true);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Boolean> importByPlatformMenu() {
        Map appMap = this.permissionQueryManager.tenantApps(null);
        if (appMap != null && appMap.isEmpty()) {
            return ApiResult.fail((String)"\u672a\u627e\u5230\u6709\u6548\u83dc\u5355");
        }
        List<TenantMenuBO> dataList = this.queryPlatformMenuToImport(appMap);
        if (dataList.isEmpty()) {
            return ApiResult.fail((String)"\u83dc\u5355\u6570\u636e\u4e3a\u7a7a");
        }
        this.saveImportData(dataList, false);
        this.clearCache();
        return ApiResult.ok((Object)true);
    }

    private void clearCache() {
        this.cacheMenuRpcService.clearCache();
    }

    private void deleteCascade(List<Long> ids) {
        if (CollUtil.isEmpty(ids)) {
            return;
        }
        List<Long> childrenIds = this.tenantMenuTreeRepoProc.listChildrenIds(ids);
        this.deleteCascade(childrenIds);
        this.tenantMenuTreeRepoProc.delete(ids);
    }

    private List<TenantMenuBO> queryPlatformMenuToImport(Map<String, AppBO> appMap) {
        List<TenantMenuBO> menuList = ((List)this.tenantDataIsolateProvider.byDefaultDirectly(() -> this.menusRepoProc.queryMenu(appMap == null ? null : appMap.keySet(), false, true, true, true))).stream().filter(t -> StringUtils.hasText((String)t.getMenusAppCode())).map(t -> {
            TenantMenuBO tenantMenuBO = new TenantMenuBO();
            tenantMenuBO.setMenuCode(t.getMenusCode());
            tenantMenuBO.setMenuName(t.getMenusName());
            String nodeType = StringUtils.hasText((String)t.getMenusRoute()) ? MenuTreeNodeType.MENU.getValue() : MenuTreeNodeType.MENU_GROUP.getValue();
            tenantMenuBO.setNodeType(nodeType);
            tenantMenuBO.setParentMenuCode(t.getMenusParentCode());
            tenantMenuBO.setIcon(t.getMenusIcon());
            tenantMenuBO.setSortNo(t.getMenusOrder());
            tenantMenuBO.setEnabled(true);
            tenantMenuBO.setAppCode(t.getMenusAppCode());
            return tenantMenuBO;
        }).collect(Collectors.toList());
        if (menuList.isEmpty()) {
            return Collections.emptyList();
        }
        return this.normalizePlatformMenuToImport(menuList, appMap);
    }

    private List<TenantMenuBO> normalizePlatformMenuToImport(List<TenantMenuBO> menuList, Map<String, AppBO> appMap) {
        HashSet<String> menuGroupCodes = new HashSet<String>(64);
        HashSet<CallSite> defaultMenuGroupCodes = new HashSet<CallSite>(64);
        HashMap<String, String> menuParentCodeMap = new HashMap<String, String>(menuList.size());
        for (TenantMenuBO tenantMenuBO : menuList) {
            if (StringUtils.hasText((String)tenantMenuBO.getParentMenuCode())) {
                menuParentCodeMap.put(tenantMenuBO.getMenuCode(), tenantMenuBO.getParentMenuCode());
                continue;
            }
            menuGroupCodes.add(tenantMenuBO.getMenuCode());
        }
        ArrayList<TenantMenuBO> resultList = new ArrayList<TenantMenuBO>();
        for (TenantMenuBO menuBO : menuList) {
            if (menuGroupCodes.contains(menuBO.getMenuCode())) {
                if (MenuTreeNodeType.MENU.getValue().equals(menuBO.getNodeType())) {
                    String parentMenuCode = "__" + menuBO.getAppCode() + "_";
                    menuBO.setParentMenuCode(parentMenuCode);
                    resultList.add(menuBO);
                    if (defaultMenuGroupCodes.contains(parentMenuCode)) continue;
                    TenantMenuBO tenantMenuBO = new TenantMenuBO();
                    tenantMenuBO.setMenuCode(parentMenuCode);
                    tenantMenuBO.setMenuName("\u9ed8\u8ba4\u5206\u7ec4");
                    tenantMenuBO.setNodeType(MenuTreeNodeType.MENU_GROUP.getValue());
                    tenantMenuBO.setParentMenuCode(menuBO.getAppCode());
                    tenantMenuBO.setSortNo(0);
                    tenantMenuBO.setEnabled(true);
                    defaultMenuGroupCodes.add((CallSite)((Object)parentMenuCode));
                    resultList.add(tenantMenuBO);
                    continue;
                }
                menuBO.setParentMenuCode(menuBO.getAppCode());
                resultList.add(menuBO);
                continue;
            }
            String tempParentCode = menuBO.getParentMenuCode();
            String tempMenuCode = menuBO.getMenuCode();
            while (!menuGroupCodes.contains(tempParentCode)) {
                tempMenuCode = tempParentCode = (String)menuParentCodeMap.get(tempMenuCode);
                if (tempParentCode != null) continue;
            }
            if (!StringUtils.hasText((String)tempParentCode)) continue;
            menuBO.setParentMenuCode(tempParentCode);
            resultList.add(menuBO);
        }
        for (AppBO app : appMap.values()) {
            TenantMenuBO tenantMenuBO = new TenantMenuBO();
            tenantMenuBO.setMenuCode(app.getAppCode());
            tenantMenuBO.setMenuName(app.getAppName());
            tenantMenuBO.setNodeType(MenuTreeNodeType.MENU_GROUP.getValue());
            tenantMenuBO.setParentMenuCode(null);
            tenantMenuBO.setSortNo((Integer)ObjectUtil.defaultIfNull((Object)app.getAppOrder(), (Object)0));
            tenantMenuBO.setEnabled(true);
            resultList.add(tenantMenuBO);
        }
        return resultList;
    }

    private void saveImportData(List<TenantMenuBO> dataList, boolean increment) {
        Long tenantId;
        SysTenantMenuDO enabledCurrent;
        if (CollUtil.isEmpty(dataList)) {
            throw new BusinessException("\u5bfc\u5165\u6570\u636e\u4e3a\u7a7a");
        }
        List existsCodes = increment ? this.tenantMenuTreeRepoProc.allMenuCodes() : Collections.emptyList();
        Set<String> nodeTypesAll = Set.of(MenuTreeNodeType.MENU_GROUP.getValue(), MenuTreeNodeType.MENU.getValue());
        List tenantMenuTreeDoList = dataList.stream().filter(t -> {
            if (CharSequenceUtil.isBlank((CharSequence)t.getMenuCode())) {
                return false;
            }
            if (increment) {
                return !existsCodes.contains(t.getMenuCode());
            }
            return true;
        }).map(t -> {
            SysTenantMenuTreeDO tenantMenuTreeDO = new SysTenantMenuTreeDO();
            tenantMenuTreeDO.setMenuCode(t.getMenuCode());
            tenantMenuTreeDO.setMenuName(t.getMenuName());
            tenantMenuTreeDO.setNodeType(t.getNodeType());
            Assert.hasText((String)t.getNodeType(), (String)"\u5b58\u5728\u8282\u70b9\u7c7b\u578b\u4e3a\u7a7a");
            Assert.isTrue((boolean)nodeTypesAll.contains(t.getNodeType()), () -> "\u8282\u70b9\u7c7b\u578b\u53ea\u80fd\u662f\uff1a" + String.join((CharSequence)"\u3001", nodeTypesAll));
            tenantMenuTreeDO.setParentMenuCode(StringUtils.hasText((String)t.getParentMenuCode()) ? t.getParentMenuCode() : null);
            tenantMenuTreeDO.setIcon(t.getIcon());
            tenantMenuTreeDO.setCustom(Boolean.valueOf(true));
            tenantMenuTreeDO.setSortNo((Integer)ObjectUtil.defaultIfNull((Object)t.getSortNo(), (Object)0));
            tenantMenuTreeDO.setEnabled(Boolean.valueOf(true));
            return tenantMenuTreeDO;
        }).collect(Collectors.toList());
        if (!increment) {
            this.tenantMenuTreeRepoProc.delete();
        }
        if (!tenantMenuTreeDoList.isEmpty()) {
            this.tenantMenuTreeRepoProc.save(tenantMenuTreeDoList);
        }
        if ((enabledCurrent = this.tenantMenuRepoProc.getByTenantId(tenantId = this.currentTenantId())) == null) {
            SysTenantMenuDO tenantMenuDO = new SysTenantMenuDO();
            tenantMenuDO.setSysTenantId(tenantId);
            tenantMenuDO.setEnabled(Boolean.valueOf(true));
            this.tenantMenuRepo.save(tenantMenuDO);
        }
    }

    private List<TenantMenuBO> analyzeImportFile(MultipartFile file) throws Exception {
        return ExcelImportUtil.instance((InputStream)file.getInputStream()).headRow(Integer.valueOf(2)).dataType(TenantMenuBO.class, Integer.valueOf(2)).readAllSync();
    }

    private byte[] export2Bytes(List<TenantMenuBO> menuList) {
        ArrayList<ExportColumnParam> columnList = new ArrayList<ExportColumnParam>();
        columnList.add(new ExportColumnParam("menuCode", "\u83dc\u5355\u7f16\u7801"));
        columnList.add(new ExportColumnParam("menuName", "\u83dc\u5355\u540d\u79f0"));
        columnList.add(new ExportColumnParam("nodeType", "\u8282\u70b9\u7c7b\u578b"));
        columnList.add(new ExportColumnParam("parentMenuCode", "\u4e0a\u7ea7\u83dc\u5355\u7f16\u7801"));
        columnList.add(new ExportColumnParam("icon", "\u56fe\u6807"));
        columnList.add(new ExportColumnParam("sortNo", "\u6392\u5e8f"));
        menuList = menuList.stream().sorted(Comparator.comparing(TenantMenuBO::getParentMenuCode, Comparator.nullsFirst(String::compareTo)).thenComparing(TenantMenuBO::getSortNo, Comparator.nullsLast(Integer::compareTo))).collect(Collectors.toList());
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            ExcelExportUtil.instance((OutputStream)bos).fields(columnList, true).write("sys_tenant_menu_tree", menuList);
        }
        catch (IOException e) {
            throw new BusinessException("\u5bfc\u51fa\u5f02\u5e38", (Throwable)e);
        }
        return bos.toByteArray();
    }

    private <T> void setDepth(List<T> dataList, Function<T, List<T>> getChildren, int parentDepth, BiConsumer<T, Integer> setDepth) {
        if (CollectionUtils.isEmpty(dataList)) {
            return;
        }
        for (T data : dataList) {
            setDepth.accept(data, parentDepth + 1);
            this.setDepth(getChildren.apply(data), getChildren, parentDepth + 1, setDepth);
        }
    }

    private List<CustomMenuTreeRespVO> queryCustomMenuTree() {
        List<CustomMenuTreeRespVO> tenantMenuList = this.tenantMenuTreeRepoProc.all().stream().map(t -> {
            CustomMenuTreeRespVO respVO = new CustomMenuTreeRespVO();
            respVO.setNodeType(t.getNodeType());
            respVO.setIcon(t.getIcon());
            respVO.setId(t.getId());
            respVO.setCode(t.getMenuCode());
            respVO.setName(t.getMenuName());
            respVO.setSortNo((Integer)ObjectUtil.defaultIfNull((Object)t.getSortNo(), (Object)0));
            respVO.setParentId(null);
            respVO.setParentCode(t.getParentMenuCode());
            return respVO;
        }).collect(Collectors.toList());
        if (tenantMenuList.isEmpty()) {
            return tenantMenuList;
        }
        Map<String, Long> groupCodeAndIdMap = tenantMenuList.stream().filter(t -> MenuTreeNodeType.MENU_GROUP.getValue().equals(t.getNodeType())).collect(Collectors.toMap(TreeRespParam::getCode, TreeRespParam::getId, (t1, t2) -> t1));
        Map<String, String> menuCodeAndNameMap = ((List)this.tenantDataIsolateProvider.byDefaultDirectly(() -> this.menusRepoProc.getMenuCodeAndNames())).stream().collect(Collectors.toMap(IdCodeNameParam::getCode, IdCodeNameParam::getName));
        for (CustomMenuTreeRespVO respVO : tenantMenuList) {
            if (MenuTreeNodeType.MENU_GROUP.getValue().equals(respVO.getNodeType())) {
                if (!StringUtils.hasText((String)respVO.getParentCode())) continue;
                respVO.setParentId(groupCodeAndIdMap.get(respVO.getParentCode()));
                continue;
            }
            if (!MenuTreeNodeType.MENU.getValue().equals(respVO.getNodeType())) continue;
            respVO.setParentId(groupCodeAndIdMap.get(respVO.getParentCode()));
            if (!CharSequenceUtil.isBlank((CharSequence)respVO.getName())) continue;
            respVO.setName(menuCodeAndNameMap.get(respVO.getCode()));
        }
        return tenantMenuList;
    }

    private SysTenantMenuTreeDO convert(CustomMenuGroupSaveVO saveVO) {
        SysTenantMenuTreeDO menuTreeDO = null;
        boolean exists = false;
        if (saveVO.getId() == null) {
            menuTreeDO = new SysTenantMenuTreeDO();
            Assert.hasText((String)saveVO.getMenuCode(), (String)"\u7f16\u7801\u4e3a\u7a7a");
            exists = this.tenantMenuTreeRepoProc.existsCustomMenuCode(saveVO.getMenuCode(), saveVO.getId());
            Assert.isTrue((!exists ? 1 : 0) != 0, (String)"\u7f16\u7801\u5df2\u5b58\u5728");
        } else {
            menuTreeDO = (SysTenantMenuTreeDO)this.tenantMenuTreeRepoProc.get(saveVO.getId());
            Assert.notNull((Object)menuTreeDO, (String)"\u7f16\u8f91\u7684\u6570\u636e\u4e0d\u5b58\u5728");
            Assert.isTrue((boolean)menuTreeDO.getMenuCode().equals(saveVO.getMenuCode()), (String)"\u7f16\u7801\u4e0d\u53ef\u4fee\u6539");
        }
        menuTreeDO = TenantMenuTreeConvert.INSTANCE.customGroup2Do(saveVO, menuTreeDO);
        if (StringUtils.hasText((String)saveVO.getParentMenuCode())) {
            exists = this.tenantMenuTreeRepoProc.existsCustomMenuCode(saveVO.getParentMenuCode(), null);
            Assert.isTrue((boolean)exists, (String)"\u5206\u7ec4\u4e0d\u5b58\u5728");
        } else {
            menuTreeDO.setParentMenuCode(null);
        }
        menuTreeDO.setNodeType(MenuTreeNodeType.MENU_GROUP.getValue());
        if (menuTreeDO.getSortNo() == null) {
            menuTreeDO.setSortNo(Integer.valueOf(0));
        }
        if (menuTreeDO.getEnabled() == null) {
            menuTreeDO.setEnabled(Boolean.valueOf(true));
        }
        menuTreeDO.setCustom(Boolean.valueOf(true));
        return menuTreeDO;
    }

    private List<MenuTreeRespVO> convertMenuTreeRespVO(Set<String> appCodes) {
        List allApps = this.appProvider.all();
        if (allApps.isEmpty()) {
            throw new BusinessException("\u672a\u83b7\u53d6\u90fd\u6709\u6548\u7684\u5e94\u7528\u5217\u8868");
        }
        ArrayList<MenuTreeRespVO> respVOList = new ArrayList<MenuTreeRespVO>(256);
        if (CollectionUtils.isEmpty(appCodes)) {
            MenuTreeRespVO respVO = null;
            int sortNo = 1;
            for (CodeNameParam app : allApps) {
                respVO = new MenuTreeRespVO();
                respVO.setMenuCode(app.getCode());
                respVO.setMenuName(app.getName());
                respVO.setNodeType(MenuTreeNodeType.APP.getValue());
                respVO.setHidden(false);
                respVO.setEnabled(true);
                respVO.setSortNo(sortNo++);
                respVO.setHasChildren(false);
                respVO.setChildren(new ArrayList<MenuTreeRespVO>(128));
                respVOList.add(respVO);
            }
            return respVOList;
        }
        MenuTreeRespVO respVO = null;
        int sortNo = 1;
        for (CodeNameParam app : allApps) {
            if (!appCodes.contains(app.getCode())) continue;
            respVO = new MenuTreeRespVO();
            respVO.setMenuCode(app.getCode());
            respVO.setMenuName(app.getName());
            respVO.setNodeType(MenuTreeNodeType.APP.getValue());
            respVO.setHidden(false);
            respVO.setEnabled(true);
            respVO.setSortNo(sortNo++);
            respVO.setHasChildren(false);
            respVO.setChildren(new ArrayList<MenuTreeRespVO>(128));
            respVOList.add(respVO);
        }
        return respVOList;
    }

    private List<SysTenantMenuTreeDO> convertAndCheck(Long tenantId, List<MenuTreeSaveVO> saveVOList) {
        if (CollectionUtils.isEmpty(saveVOList)) {
            return Collections.emptyList();
        }
        ArrayList<SysTenantMenuTreeDO> menuTreeDOList = new ArrayList<SysTenantMenuTreeDO>(256);
        this.convertToList(saveVOList, null, menuTreeDOList);
        Set menuCodes = menuTreeDOList.stream().map(SysTenantMenuTreeDO::getMenuCode).collect(Collectors.toSet());
        MenuTreeNodeType nodeType = null;
        for (SysTenantMenuTreeDO menuTreeDO : menuTreeDOList) {
            if (StringUtils.hasText((String)menuTreeDO.getParentMenuCode()) && !menuCodes.contains(menuTreeDO.getParentMenuCode())) {
                menuTreeDO.setParentMenuCode("");
            }
            nodeType = MenuTreeNodeType.valueOf((String)menuTreeDO.getNodeType());
            Assert.notNull((Object)nodeType, (String)("\u672a\u77e5\u8282\u70b9\u7c7b\u578b" + menuTreeDO.getNodeType()));
            if (menuTreeDO.getCustom() == null) {
                menuTreeDO.setCustom(Boolean.valueOf(false));
            }
            if (nodeType != MenuTreeNodeType.APP) continue;
            menuTreeDO.setCustom(Boolean.valueOf(false));
        }
        Map<String, List<SysTenantMenuTreeDO>> menuTreeMap = menuTreeDOList.stream().collect(Collectors.groupingBy(SysTenantMenuTreeDO::getParentMenuCode));
        for (List<SysTenantMenuTreeDO> menus : menuTreeMap.values()) {
            int sortNo = 0;
            for (SysTenantMenuTreeDO menu : menus) {
                menu.setSortNo(Integer.valueOf(sortNo++));
            }
        }
        return menuTreeDOList;
    }

    private void convertToList(List<MenuTreeSaveVO> saveVOList, String parentMenuCode, List<SysTenantMenuTreeDO> menuTreeDOList) {
        if (CollectionUtils.isEmpty(saveVOList)) {
            return;
        }
        if (parentMenuCode == null) {
            parentMenuCode = "";
        }
        int sortNo = 1;
        ArrayList<SysTenantMenuTreeDO> newList = new ArrayList<SysTenantMenuTreeDO>(128);
        SysTenantMenuTreeDO menuTreeDO = null;
        for (MenuTreeSaveVO menuTreeSaveVO : saveVOList) {
            menuTreeDO = CONVERT.saveVo2Do(menuTreeSaveVO);
            if (StringUtils.hasText((String)parentMenuCode) || menuTreeDO.getParentMenuCode() == null) {
                menuTreeDO.setParentMenuCode(parentMenuCode);
            }
            menuTreeDO.setIcon(menuTreeSaveVO.getMenusIcon());
            menuTreeDO.setSortNo(Integer.valueOf(sortNo));
            ++sortNo;
            newList.add(menuTreeDO);
            this.convertToList(menuTreeSaveVO.getChildren(), menuTreeSaveVO.getMenuCode(), menuTreeDOList);
        }
        menuTreeDOList.addAll(newList);
    }
}

