/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.service.impl;

import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ObjectUtil;
import com.elitescloud.boot.common.param.IdCodeNameParam;
import com.elitescloud.boot.common.param.TreeRespParam;
import com.elitescloud.boot.provider.TenantDataIsolateProvider;
import com.elitescloud.boot.util.ObjUtil;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.context.util.CollectionUtil;
import com.elitescloud.cloudt.context.util.TreeDataUtil;
import com.elitescloud.cloudt.core.annotation.TenantOrgTransaction;
import com.elitescloud.cloudt.core.annotation.TenantTransaction;
import com.elitescloud.cloudt.core.annotation.common.TenantIsolateType;
import com.elitescloud.cloudt.system.convert.MenuConvert;
import com.elitescloud.cloudt.system.dto.resp.SysPlatformMenusDTO;
import com.elitescloud.cloudt.system.model.bo.MenuBO;
import com.elitescloud.cloudt.system.model.vo.resp.common.CommonMenuTreeNodeRespVO;
import com.elitescloud.cloudt.system.service.MenuQueryService;
import com.elitescloud.cloudt.system.service.common.constant.MenuTreeNodeType;
import com.elitescloud.cloudt.system.service.manager.PermissionQueryManager;
import com.elitescloud.cloudt.system.service.model.bo.AppBO;
import com.elitescloud.cloudt.system.service.repo.MenuRepoProc;
import com.google.common.base.Functions;
import io.jsonwebtoken.lang.Assert;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
@TenantTransaction(isolateType=TenantIsolateType.TENANT)
@TenantOrgTransaction(useTenantOrg=false)
public class MenuQueryServiceImpl
implements MenuQueryService {
    @Autowired
    private MenuRepoProc menuRepoProc;
    @Autowired
    private PermissionQueryManager permissionQueryManager;
    @Autowired
    private TenantDataIsolateProvider tenantDataIsolateProvider;

    @Override
    public ApiResult<List<CommonMenuTreeNodeRespVO>> menuTreeSystem(String appCode, Boolean withSys, Boolean withBusiness, Boolean withMenu, Boolean withAction, Boolean defTree, Boolean tree) {
        Map appMap = this.permissionQueryManager.tenantApps(appCode);
        if (appMap.isEmpty()) {
            return ApiResult.ok(Collections.emptyList());
        }
        withMenu = withMenu == null || withMenu != false;
        withAction = withMenu != false && withAction != null && withAction != false;
        defTree = defTree != null && defTree != false;
        List<CommonMenuTreeNodeRespVO> menuList = this.queryOriginalMenus(appMap, (Boolean)cn.hutool.core.util.ObjUtil.defaultIfNull((Object)withSys, (Object)false), (Boolean)cn.hutool.core.util.ObjUtil.defaultIfNull((Object)withBusiness, (Object)true), withMenu, withAction);
        if (menuList.isEmpty()) {
            return ApiResult.ok(Collections.emptyList());
        }
        if (CharSequenceUtil.isBlank((CharSequence)appCode)) {
            List<CommonMenuTreeNodeRespVO> appList = this.convertApp2MenuTreeNode(appMap);
            menuList.addAll(appList);
        }
        TreeDataUtil treeDataUtil = new TreeDataUtil(menuList, TreeRespParam::getId, TreeRespParam::getParentId, TreeRespParam::setChildren, Comparator.comparingInt(TreeRespParam::getSortNo));
        List resultList = tree == null || tree != false ? treeDataUtil.getRoots() : CollectionUtil.expandTree((List)treeDataUtil.getRoots(), TreeRespParam::getChildren);
        return ApiResult.ok((Object)resultList);
    }

    @Override
    @TenantTransaction(isolateType=TenantIsolateType.DEFAULT)
    public ApiResult<SysPlatformMenusDTO> getMenuInfo(String menuCode) {
        Assert.hasText((String)menuCode, (String)"\u83dc\u5355\u7f16\u7801\u4e3a\u7a7a");
        MenuBO menuDO = this.menuRepoProc.getByMenuCode(menuCode);
        if (menuDO == null) {
            return ApiResult.ok();
        }
        SysPlatformMenusDTO menuDto = MenuConvert.INSTANCE.do2Dto(menuDO);
        return ApiResult.ok((Object)menuDto);
    }

    @Override
    @TenantTransaction(isolateType=TenantIsolateType.DEFAULT)
    public ApiResult<List<SysPlatformMenusDTO>> getMenuInfo(Set<String> menuCodes) {
        Assert.notEmpty(menuCodes, (String)"\u83dc\u5355\u7f16\u7801\u4e3a\u7a7a");
        List menuList = this.menuRepoProc.listByMenuCode(menuCodes).stream().map(MenuConvert.INSTANCE::do2Dto).collect(Collectors.toList());
        return ApiResult.ok(menuList);
    }

    @Override
    @TenantTransaction(isolateType=TenantIsolateType.DEFAULT)
    public ApiResult<List<IdCodeNameParam>> getMenuWithParents(String menuCode) {
        Assert.hasText((String)menuCode, (String)"\u83dc\u5355\u7f16\u7801\u4e3a\u7a7a");
        ArrayList<String> menuCodeList = new ArrayList<String>(8);
        menuCodeList.add(menuCode);
        String parentCode = this.menuRepoProc.getParentCode(menuCode);
        while (StringUtils.hasText((String)parentCode)) {
            menuCode = parentCode;
            menuCodeList.add(parentCode);
            parentCode = this.menuRepoProc.getParentCode(menuCode);
        }
        Map menuMap = this.menuRepoProc.getMenuCodeAndNames(menuCodeList).stream().collect(Collectors.toMap(IdCodeNameParam::getCode, Functions.identity(), (t1, t2) -> t1));
        if (menuMap.isEmpty()) {
            return ApiResult.ok(Collections.emptyList());
        }
        ArrayList<IdCodeNameParam> menuList = new ArrayList<IdCodeNameParam>(menuCodeList.size());
        for (int i = menuCodeList.size() - 1; i >= 0; --i) {
            IdCodeNameParam menu = (IdCodeNameParam)menuMap.get(menuCodeList.get(i));
            if (menu == null) continue;
            menuList.add(menu);
        }
        return ApiResult.ok(menuList);
    }

    private List<CommonMenuTreeNodeRespVO> convertApp2MenuTreeNode(Map<String, AppBO> appMap) {
        return appMap.values().stream().map(t -> {
            CommonMenuTreeNodeRespVO respVO = new CommonMenuTreeNodeRespVO();
            respVO.setNodeType(MenuTreeNodeType.APP.getValue());
            respVO.setAppCode(t.getAppCode());
            respVO.setMenusIcon(t.getIcon());
            respVO.setHidden(false);
            respVO.setEnabled(true);
            respVO.setId(t.getId());
            respVO.setCode(t.getAppCode());
            respVO.setName(t.getAppName());
            respVO.setSortNo((Integer)cn.hutool.core.util.ObjUtil.defaultIfNull((Object)t.getAppOrder(), (Object)0));
            return respVO;
        }).collect(Collectors.toList());
    }

    private List<CommonMenuTreeNodeRespVO> queryOriginalMenus(Map<String, AppBO> appMap, boolean withSys, boolean withBusiness, boolean withMenu, boolean withAction) {
        List menuBoList = (List)this.tenantDataIsolateProvider.byDefaultDirectly(() -> this.menuRepoProc.queryMenu(appMap.keySet(), withSys, withBusiness, !withAction, true));
        if (menuBoList.isEmpty()) {
            return Collections.emptyList();
        }
        Map<String, Long> menuCodeIdMap = menuBoList.stream().collect(Collectors.toMap(MenuBO::getMenusCode, MenuBO::getId, (t1, t2) -> t1));
        return menuBoList.stream().filter(t -> {
            if (withMenu) {
                return true;
            }
            return CharSequenceUtil.isBlank((CharSequence)t.getMenusRoute());
        }).map(t -> {
            CommonMenuTreeNodeRespVO respVO = new CommonMenuTreeNodeRespVO();
            respVO.setMenusType(t.getMenusType());
            respVO.setNodeType(t.getNodeType());
            respVO.setAppCode(t.getMenusAppCode());
            respVO.setMenusIcon(t.getMenusIcon());
            respVO.setMenusRoute(t.getMenusRoute());
            respVO.setHidden(Boolean.FALSE.equals(t.getDisplay()));
            respVO.setEnabled(Boolean.TRUE.equals(t.getMenusState()));
            respVO.setId(t.getId());
            respVO.setCode(t.getMenusCode());
            respVO.setName(t.getMenusName());
            respVO.setSortNo((Integer)ObjectUtil.defaultIfNull((Object)t.getMenusOrder(), (Object)0));
            if (StringUtils.hasText((String)t.getMenusParentCode())) {
                respVO.setParentId((Long)menuCodeIdMap.get(t.getMenusParentCode()));
                respVO.setParentCode(t.getMenusParentCode());
            } else {
                respVO.setParentCode(t.getMenusAppCode());
                ObjUtil.ifNotNull((Object)((AppBO)appMap.get(t.getMenusAppCode())), app -> respVO.setParentId(app.getId()));
            }
            return respVO;
        }).collect(Collectors.toList());
    }
}

