/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.service.impl;

import cn.hutool.core.collection.CollUtil;
import com.elitescloud.boot.SpringContextHolder;
import com.elitescloud.boot.auth.util.SecurityContextUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.util.ObjUtil;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.annotation.TenantTransaction;
import com.elitescloud.cloudt.core.annotation.common.TenantIsolateType;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitescloud.cloudt.system.convert.NoticeConvert;
import com.elitescloud.cloudt.system.model.vo.query.extend.NoticePageMngQueryVO;
import com.elitescloud.cloudt.system.model.vo.resp.extend.NoticeEditRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.extend.NoticePageRespVO;
import com.elitescloud.cloudt.system.model.vo.save.extend.NoticeSaveVO;
import com.elitescloud.cloudt.system.provider.dto.save.SysNoticeSaveDTO;
import com.elitescloud.cloudt.system.service.NoticeMngService;
import com.elitescloud.cloudt.system.service.impl.BaseNoticeService;
import com.elitescloud.cloudt.system.service.model.entity.SysNoticeDO;
import com.elitescloud.cloudt.system.service.model.entity.SysNoticeTxtDO;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class NoticeMngServiceImpl
extends BaseNoticeService
implements NoticeMngService {
    private static final Logger log = LoggerFactory.getLogger(NoticeMngServiceImpl.class);

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> save(NoticeSaveVO saveVO) {
        SysNoticeDO noticeDO = this.upsert(saveVO);
        return ApiResult.ok((Object)noticeDO.getId());
    }

    @Override
    @TenantTransaction(isolateType=TenantIsolateType.DEFAULT)
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> saveSys(NoticeSaveVO saveVO) {
        SysNoticeDO noticeDO = this.upsert(saveVO);
        return ApiResult.ok((Object)noticeDO.getId());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Set<Long>> delete(Set<Long> ids, Boolean real) {
        if (ids != null) {
            ids = ids.stream().filter(Objects::nonNull).collect(Collectors.toSet());
        }
        if (CollUtil.isEmpty(ids)) {
            return ApiResult.fail((String)"\u516c\u544aID\u4e3a\u7a7a");
        }
        this.noticeAdapter(ids, t -> {
            if (real == null || Boolean.TRUE.equals(real)) {
                this.repoProc.delete((Collection)t);
                this.txtRepoProc.deleteByNoticeId((Collection<Long>)t);
            } else {
                this.repoProc.updateDeleteFlag((Collection)t);
            }
        });
        return ApiResult.ok(ids);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Set<Long>> execPublish(Set<Long> ids) {
        if (ids != null) {
            ids = ids.stream().filter(Objects::nonNull).collect(Collectors.toSet());
        }
        if (CollUtil.isEmpty(ids)) {
            return ApiResult.fail((String)"\u516c\u544aID\u4e3a\u7a7a");
        }
        this.noticeAdapter(ids, t -> {
            this.repoProc.updatePublish((Collection<Long>)t);
            this.repoProc.updatePublish((Collection<Long>)t, LocalDateTime.now());
        });
        return ApiResult.ok(ids);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Set<Long>> execRevoke(Set<Long> ids) {
        if (ids != null) {
            ids = ids.stream().filter(Objects::nonNull).collect(Collectors.toSet());
        }
        if (CollUtil.isEmpty(ids)) {
            return ApiResult.fail((String)"\u516c\u544aID\u4e3a\u7a7a");
        }
        this.noticeAdapter(ids, t -> this.repoProc.updateRevoke((Collection<Long>)t));
        return ApiResult.ok(ids);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> publish(SysNoticeSaveDTO saveDTO) {
        Assert.hasText((String)saveDTO.getTitle(), (String)"\u6807\u9898\u4e3a\u7a7a");
        NoticeSaveVO saveVO = NoticeConvert.INSTANCE.dto2SaveVO(saveDTO);
        Long noticeId = null;
        if (saveVO.getSys() == null || !saveVO.getSys().booleanValue()) {
            saveVO.setSys(false);
            noticeId = (Long)this.save(saveVO).computeData();
        } else {
            noticeId = (Long)((NoticeMngService)SpringContextHolder.getBean(NoticeMngService.class)).saveSys(saveVO).computeData();
        }
        this.execPublish(Set.of(noticeId));
        return ApiResult.ok((Object)noticeId);
    }

    @Override
    public ApiResult<NoticeEditRespVO> getEditVO(Long id) {
        if (id == null) {
            return ApiResult.fail((String)"ID\u4e3a\u7a7a");
        }
        NoticeEditRespVO noticeVO = this.get(id);
        if (noticeVO == null) {
            noticeVO = (NoticeEditRespVO)this.tenantDataIsolateProvider.byDefaultDirectly(() -> this.get(id));
        }
        return ApiResult.ok((Object)noticeVO);
    }

    @Override
    public ApiResult<PagingVO<NoticePageRespVO>> pageMng(NoticePageMngQueryVO queryVO) {
        PagingVO<NoticePageRespVO> pageData = this.queryByPage(queryVO, false);
        return ApiResult.ok(pageData);
    }

    @Override
    @TenantTransaction(isolateType=TenantIsolateType.DEFAULT)
    public ApiResult<PagingVO<NoticePageRespVO>> pageSysMng(NoticePageMngQueryVO queryVO) {
        PagingVO<NoticePageRespVO> pageData = this.queryByPage(queryVO, true);
        return ApiResult.ok(pageData);
    }

    private void noticeAdapter(Collection<Long> ids, Consumer<Collection<Long>> consumer) {
        List normalIds = this.repoProc.exists(ids);
        if (!normalIds.isEmpty()) {
            consumer.accept(normalIds);
            if (normalIds.size() == ids.size()) {
                return;
            }
        }
        this.tenantDataIsolateProvider.byDefaultDirectly(() -> {
            List sysIds = this.repoProc.exists(ids);
            if (!sysIds.isEmpty()) {
                consumer.accept(sysIds);
            }
            return null;
        });
    }

    private NoticeEditRespVO get(long id) {
        SysNoticeDO noticeDO = (SysNoticeDO)this.repoProc.get(id);
        if (noticeDO == null) {
            return null;
        }
        NoticeEditRespVO noticeVO = NoticeConvert.INSTANCE.convert2EditVO(noticeDO);
        noticeVO.setPublished(this.hasPublished(noticeDO));
        super.fillDetailInfo(noticeDO, noticeVO);
        return noticeVO;
    }

    private SysNoticeDO upsert(NoticeSaveVO saveVO) {
        SysNoticeDO noticeDO = this.checkAndConvert(saveVO);
        this.repoProc.save((Serializable)noticeDO);
        SysNoticeTxtDO noticeTxtDO = this.saveTxt(saveVO, noticeDO);
        this.repoProc.updateTxtId(noticeDO.getId(), noticeTxtDO.getId());
        return noticeDO;
    }

    private PagingVO<NoticePageRespVO> queryByPage(NoticePageMngQueryVO queryVO, boolean sys) {
        PagingVO pageData = this.repoProc.pageMng(queryVO, sys).map(t -> {
            NoticePageRespVO respVO = NoticeConvert.INSTANCE.convert2PageVO((SysNoticeDO)t);
            respVO.setPublished(this.hasPublished((SysNoticeDO)t));
            return respVO;
        });
        if (pageData.isEmpty()) {
            return pageData;
        }
        super.fillListInfo(pageData.getRecords());
        return pageData;
    }

    private boolean hasPublished(SysNoticeDO noticeDO) {
        if (Boolean.FALSE.equals(noticeDO.getPublished())) {
            return false;
        }
        return noticeDO.getPublishTime() != null && noticeDO.getPublishTime().isBefore(LocalDateTime.now());
    }

    private SysNoticeDO checkAndConvert(NoticeSaveVO saveVO) {
        GeneralUserDetails currentUser = SecurityContextUtil.currentUserIfUnauthorizedThrow();
        SysNoticeDO noticeDO = null;
        if (saveVO.getId() == null) {
            noticeDO = new SysNoticeDO();
        } else {
            noticeDO = (SysNoticeDO)this.repoProc.get(saveVO.getId());
            Assert.notNull((Object)noticeDO, (String)"\u516c\u544a\u4e0d\u5b58\u5728");
            if (this.hasPublished(noticeDO)) {
                throw new BusinessException("\u516c\u544a\u5df2\u53d1\u5e03\uff0c\u4e0d\u53ef\u4fee\u6539");
            }
        }
        Assert.hasText((String)saveVO.getTitle(), (String)"\u6807\u9898\u4e3a\u7a7a");
        Assert.hasText((String)saveVO.getTxt(), (String)"\u5185\u5bb9\u4e3a\u7a7a");
        ObjUtil.ifNull((Object)saveVO.getAuthorId(), (Object)currentUser.getUserId(), saveVO::setAuthorId);
        ObjUtil.ifNull((Object)saveVO.getTop(), (Object)false, saveVO::setTop);
        ObjUtil.ifNull((Object)saveVO.getSys(), (Object)false, saveVO::setSys);
        NoticeConvert.INSTANCE.convert2DO(saveVO, noticeDO);
        noticeDO.setPublished(Boolean.valueOf(saveVO.getPublishTime() != null));
        noticeDO.setChangeTime(LocalDateTime.now());
        if (CollUtil.isNotEmpty(saveVO.getFileCodes())) {
            noticeDO.setFileCodesStr(String.join((CharSequence)",", saveVO.getFileCodes()));
        } else {
            noticeDO.setFileCodesStr(null);
        }
        ObjUtil.ifNull((Object)noticeDO.getReadAmount(), (Object)0L, arg_0 -> ((SysNoticeDO)noticeDO).setReadAmount(arg_0));
        return noticeDO;
    }

    private SysNoticeTxtDO saveTxt(NoticeSaveVO saveVO, SysNoticeDO noticeDO) {
        SysNoticeTxtDO noticeTxtDO = noticeDO.getTxtId() == null ? new SysNoticeTxtDO() : (SysNoticeTxtDO)this.txtRepoProc.get(noticeDO.getTxtId());
        noticeTxtDO.setTxt(saveVO.getTxt());
        noticeTxtDO.setNoticeId(noticeDO.getId());
        this.txtRepoProc.save((Serializable)noticeTxtDO);
        return noticeTxtDO;
    }
}

