/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.service.impl;

import com.elitescloud.boot.openfeign.common.DynamicClientHelper;
import com.elitescloud.boot.swagger.openapi.common.OpenApiRpcClient;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.service.OpenApiQueryService;
import com.elitescloud.cloudt.system.service.common.constant.OpenApiStatusEnum;
import com.elitescloud.cloudt.system.service.model.entity.SysOpenApiInfoDO;
import com.elitescloud.cloudt.system.service.repo.OpenApiInfoRepoProc;
import com.elitescloud.cloudt.system.service.repo.OpenApiResourceRepoProc;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ContentDisposition;
import org.springframework.http.HttpEntity;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.StreamUtils;
import org.springframework.web.servlet.mvc.method.annotation.StreamingResponseBody;

@Service
public class OpenApiQueryServiceImpl
implements OpenApiQueryService {
    private static final Logger log = LoggerFactory.getLogger(OpenApiQueryServiceImpl.class);
    @Autowired
    private OpenApiInfoRepoProc openApiInfoRepoProc;
    @Autowired
    private OpenApiResourceRepoProc resourceRepoProc;

    @Override
    public HttpEntity<StreamingResponseBody> downloadOpenApi(Long openApiId) {
        byte[] resource;
        SysOpenApiInfoDO openApiInfo = (SysOpenApiInfoDO)this.openApiInfoRepoProc.get(openApiId);
        if (openApiInfo == null) {
            return this.emptyBody("OpenApi\u4e0d\u5b58\u5728");
        }
        if (!OpenApiStatusEnum.FINISHED.name().equals(openApiInfo.getState())) {
            return this.emptyBody("OpenApi\u5c1a\u672a\u6784\u5efa\u6210\u529f");
        }
        byte[] byArray = resource = openApiInfo.getResourceId() == null ? null : this.resourceRepoProc.getResourceBytes(openApiInfo.getResourceId());
        if (resource == null || resource.length == 0) {
            return this.emptyBody("OpenApi\u672a\u53d1\u73b0\u6709\u6548\u8d44\u6e90");
        }
        ContentDisposition contentDisposition = ContentDisposition.builder((String)"attachment").filename(openApiInfo.getAppCode() + "[OpenApi].json", StandardCharsets.UTF_8).build();
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().contentType(MediaType.APPLICATION_JSON).header("Content-Disposition", new String[]{contentDisposition.toString()})).contentLength((long)resource.length).body(outputStream -> {
            try {
                StreamUtils.copy((byte[])resource, (OutputStream)outputStream);
            }
            catch (Exception e) {
                log.error("\u4e0b\u8f7d\u8d44\u6e90\u6587\u4ef6\u5f02\u5e38\uff1a", (Throwable)e);
            }
        });
    }

    @Override
    public HttpEntity<StreamingResponseBody> downloadOpenApiByRpc(String appCode) {
        OpenApiRpcClient openApiClient = (OpenApiRpcClient)DynamicClientHelper.getClient((String)appCode, OpenApiRpcClient.class, (String)"/rpc/cloudt/swagger/openapi");
        ApiResult openApiResult = null;
        try {
            openApiResult = openApiClient.getOpenApiJsonPretty();
        }
        catch (Exception e) {
            log.error("\u8c03\u7528\u670d\u52a1{}\u83b7\u53d6OpenAPI\u5f02\u5e38\uff1a", (Object)appCode, (Object)e);
            return this.emptyBody("\u8c03\u7528\u670d\u52a1\u5f02\u5e38\uff0c\u8bf7\u786e\u8ba4\u670d\u52a1" + appCode + "\u5728\u7ebf\u4e14\u652f\u6301OpenApi\u4e0b\u8f7d");
        }
        if (openApiResult.isFailed() || openApiResult.getData() == null) {
            return this.emptyBody(openApiResult.getMsg());
        }
        String resource = (String)openApiResult.getData();
        ContentDisposition contentDisposition = ContentDisposition.builder((String)"attachment").filename(appCode + "[OpenApi].json", StandardCharsets.UTF_8).build();
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().contentType(MediaType.APPLICATION_JSON).header("Content-Disposition", new String[]{contentDisposition.toString()})).body(outputStream -> {
            try {
                StreamUtils.copy((byte[])resource.getBytes(StandardCharsets.UTF_8), (OutputStream)outputStream);
            }
            catch (Exception e) {
                log.error("\u4e0b\u8f7d\u8d44\u6e90\u6587\u4ef6\u5f02\u5e38\uff1a", (Throwable)e);
            }
        });
    }

    private HttpEntity<StreamingResponseBody> emptyBody(String msg) {
        ContentDisposition contentDisposition = ContentDisposition.builder((String)"attachment").filename(msg + ".txt", StandardCharsets.UTF_8).build();
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().contentType(MediaType.TEXT_PLAIN).header("Content-Disposition", new String[]{contentDisposition.toString()})).body(outputStream -> {
            try {
                StreamUtils.copy((byte[])msg.getBytes(StandardCharsets.UTF_8), (OutputStream)outputStream);
            }
            catch (Exception e) {
                log.error("\u4e0b\u8f7d\u8d44\u6e90\u6587\u4ef6\u5f02\u5e38\uff1a", (Throwable)e);
            }
        });
    }
}

