/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.elitescloud.boot.common.BaseUdc;
import com.elitescloud.boot.common.param.CodeNameParam;
import com.elitescloud.boot.common.param.IdCodeNameCheckParam;
import com.elitescloud.boot.common.param.IdCodeNameParam;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.boot.datasecurity.config.DataSecurityProperties;
import com.elitescloud.boot.datasecurity.dpr.content.DprRuleConditionEnum;
import com.elitescloud.boot.datasecurity.dpr.content.DprRuleRelationEnum;
import com.elitescloud.boot.datasecurity.dpr.content.DprRuleValueTypeEnum;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.provider.TenantOrgProvider;
import com.elitescloud.boot.util.JSONUtil;
import com.elitescloud.boot.util.ObjUtil;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.context.util.TreeDataUtil;
import com.elitescloud.cloudt.core.annotation.TenantOrgTransaction;
import com.elitescloud.cloudt.core.annotation.TenantTransaction;
import com.elitescloud.cloudt.core.annotation.common.TenantIsolateType;
import com.elitescloud.cloudt.platform.model.entity.SysPlatformApiPermissionDO;
import com.elitescloud.cloudt.system.config.SystemProperties;
import com.elitescloud.cloudt.system.constant.DataPermissionType;
import com.elitescloud.cloudt.system.constant.UserType;
import com.elitescloud.cloudt.system.convert.PermissionConverter;
import com.elitescloud.cloudt.system.dto.BaseDataSecurityRuleDTO;
import com.elitescloud.cloudt.system.dto.SysDpcRoleApiFieldsDTO;
import com.elitescloud.cloudt.system.dto.SysDprRoleApiDataRuleListQueryDTO;
import com.elitescloud.cloudt.system.dto.SysDprRoleApiRowColumnRuleDTO;
import com.elitescloud.cloudt.system.dto.SysTenantDTO;
import com.elitescloud.cloudt.system.dto.SysUserBasicDTO;
import com.elitescloud.cloudt.system.model.bo.BusinessObjectBO;
import com.elitescloud.cloudt.system.model.bo.BusinessOperationParamBO;
import com.elitescloud.cloudt.system.model.bo.BusinessParamBO;
import com.elitescloud.cloudt.system.model.bo.MenuBO;
import com.elitescloud.cloudt.system.model.bo.PermissionParameterBO;
import com.elitescloud.cloudt.system.model.vo.resp.api.SysMenuApiRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.dpr.DataPermissionFieldRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.dpr.DataPermissionParamRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.dpr.DataPermissionRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.dpr.DataPermissionRuleRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.dpr.SysDprApiCustomRuleRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.dpr.SysDprApiFieldRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.dpr.SysDprRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.org.EmployeeUserInfoRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.permission.DataPermissionTreeNodeRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.role.GroupRoleRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.role.PermissionDetailRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.role.PermissionMenuRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.role.RolePermissionRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.role.UserRoleDataPermissionRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.role.UserRoleMenuRespVO;
import com.elitescloud.cloudt.system.modules.dpr.SysDprValueType;
import com.elitescloud.cloudt.system.modules.dpr.strategy.DprValueResolverFactory;
import com.elitescloud.cloudt.system.modules.dpr.strategy.impl.DprSysInternallyDynamic;
import com.elitescloud.cloudt.system.provider.dto.SysApiPermissionMetadataDTO;
import com.elitescloud.cloudt.system.service.PermissionQueryService;
import com.elitescloud.cloudt.system.service.common.constant.BelongType;
import com.elitescloud.cloudt.system.service.common.constant.BusinessObjectParamInEnum;
import com.elitescloud.cloudt.system.service.common.constant.MenuTreeNodeType;
import com.elitescloud.cloudt.system.service.impl.UserQueryServiceImpl;
import com.elitescloud.cloudt.system.service.manager.BusinessObjectManager;
import com.elitescloud.cloudt.system.service.manager.PermissionMngManager;
import com.elitescloud.cloudt.system.service.manager.PermissionQueryManager;
import com.elitescloud.cloudt.system.service.manager.RoleMngManager;
import com.elitescloud.cloudt.system.service.model.entity.SysDprRoleApiRowRuleDO;
import com.elitescloud.cloudt.system.service.model.entity.SysPlatformAppDO;
import com.elitescloud.cloudt.system.service.model.entity.SysRoleDataPermissionDO;
import com.elitescloud.cloudt.system.service.model.entity.SysRoleFieldPermissionDO;
import com.elitescloud.cloudt.system.service.model.entity.SysTenantMenuTreeDO;
import com.elitescloud.cloudt.system.service.repo.ApiParameterRepoProc;
import com.elitescloud.cloudt.system.service.repo.ApiRepoProc;
import com.elitescloud.cloudt.system.service.repo.AppRepoProc;
import com.elitescloud.cloudt.system.service.repo.BusinessObjectRepoProc;
import com.elitescloud.cloudt.system.service.repo.BusinessOperationParamRepoProc;
import com.elitescloud.cloudt.system.service.repo.BusinessOperationRepoProc;
import com.elitescloud.cloudt.system.service.repo.BusinessParamRepoProc;
import com.elitescloud.cloudt.system.service.repo.MenuApiRepoProc;
import com.elitescloud.cloudt.system.service.repo.MenuRepoProc;
import com.elitescloud.cloudt.system.service.repo.RoleDataPermissionRepoProc;
import com.elitescloud.cloudt.system.service.repo.RoleFieldPermissionRepoProc;
import com.elitescloud.cloudt.system.service.repo.RolePermissionRepoProc;
import com.elitescloud.cloudt.system.service.repo.RoleRepoProc;
import com.elitescloud.cloudt.system.service.repo.SysDpcrApiFieldsRepoProc;
import com.elitescloud.cloudt.system.service.repo.SysDprRoleApiRowRuleRepoProc;
import com.elitescloud.cloudt.system.service.repo.TenantMenuRepoProc;
import com.elitescloud.cloudt.system.service.repo.TenantMenuTreeRepoProc;
import com.elitescloud.cloudt.system.service.repo.TenantOrgRepoProc;
import com.elitescloud.cloudt.system.service.repo.UserRepoProc;
import com.elitescloud.cloudt.system.vo.DprUdcVO;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.base.Functions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
@TenantTransaction(isolateType=TenantIsolateType.TENANT)
@TenantOrgTransaction(useTenantOrg=false)
public class PermissionQueryServiceImpl
extends BaseServiceImpl
implements PermissionQueryService {
    private static final Logger log = LoggerFactory.getLogger(PermissionQueryServiceImpl.class);
    @Autowired
    private ApiRepoProc apiRepoProc;
    @Autowired
    private TenantMenuRepoProc tenantMenuRepoProc;
    @Autowired
    private TenantMenuTreeRepoProc tenantMenuTreeRepoProc;
    @Autowired
    private RolePermissionRepoProc rolePermissionRepoProc;
    @Autowired
    private RoleDataPermissionRepoProc dataPermissionRepoProc;
    @Autowired
    private BusinessOperationRepoProc businessOperationRepoProc;
    @Autowired
    private BusinessObjectRepoProc businessObjectRepoProc;
    @Autowired
    private BusinessParamRepoProc businessParamRepoProc;
    @Autowired
    private BusinessOperationParamRepoProc businessOperationParamRepoProc;
    @Autowired
    private BusinessObjectManager businessObjectManager;
    @Autowired
    private RoleRepoProc roleRepoProc;
    @Autowired
    private MenuRepoProc menusRepoProc;
    @Autowired
    private AppRepoProc appRepoProc;
    @Autowired
    private MenuApiRepoProc menuApiRepoProc;
    @Autowired
    private SysDprRoleApiRowRuleRepoProc roleApiRowRuleRepoProc;
    @Autowired
    private SysDpcrApiFieldsRepoProc apiFieldsRepoProc;
    @Autowired
    private ApiParameterRepoProc apiParameterRepoProc;
    @Autowired
    private UserRepoProc userRepoProc;
    @Autowired
    private TenantOrgRepoProc tenantOrgRepoProc;
    @Autowired
    private TenantOrgProvider tenantOrgProvider;
    @Autowired
    private PermissionMngManager permissionMngManager;
    @Autowired
    private PermissionQueryManager permissionQueryManager;
    @Autowired
    private RoleMngManager roleMngManager;
    @Autowired
    private DataSecurityProperties dataSecurityProperties;
    @Autowired
    private SystemProperties systemProperties;
    @Autowired
    private RoleFieldPermissionRepoProc roleFieldPermissionRepoProc;
    @Autowired
    private UserQueryServiceImpl userQueryService;
    private static final Set<String> INNER_BUSINESS_OBJECT = new HashSet<String>(8);

    @Override
    public ApiResult<List<GroupRoleRespVO>> listGroupRole(Boolean showDisabled, Boolean showAll) {
        showDisabled = showDisabled != null && showDisabled != false;
        showAll = showAll != null && showAll != false;
        BelongType.Belonger belonger = showAll != false ? null : BelongType.getBelonger();
        List<GroupRoleRespVO> dataList = this.roleMngManager.listGroupRole(showDisabled, belonger);
        return ApiResult.ok(dataList);
    }

    @Override
    public ApiResult<List<GroupRoleRespVO>> listGroupRoleByRelated(String relatedType, String relationId) {
        List<GroupRoleRespVO> dataList = this.roleMngManager.listGroupRoleByRelated(relatedType, relationId, BelongType.getBelonger());
        return ApiResult.ok(dataList);
    }

    @Override
    public ApiResult<List<IdCodeNameCheckParam>> getRoleByUserId(Long userId, Boolean onlyHave) {
        Assert.notNull((Object)userId, (String)"\u8d26\u53f7ID\u4e3a\u7a7a");
        if (onlyHave == null) {
            onlyHave = true;
        }
        List<IdCodeNameCheckParam> roleList = this.permissionMngManager.getUserRole(userId, onlyHave);
        return ApiResult.ok(roleList);
    }

    @Override
    public ApiResult<List<RolePermissionRespVO>> getPermissionMenuByRole(Long roleId, String appCode, Boolean tree) {
        Assert.notNull((Object)roleId, (String)"\u89d2\u8272ID\u4e3a\u7a7a");
        tree = tree == null || tree != false;
        List<RolePermissionRespVO> menuList = this.permissionMngManager.getPermissionMenuByRole(roleId, appCode, false, true, tree);
        return ApiResult.ok(menuList);
    }

    @Override
    public ApiResult<PermissionDetailRespVO> getPermissionDetailByCode(String code) {
        PermissionDetailRespVO respVo;
        Assert.hasText((String)code, (String)"\u6743\u9650\u7f16\u7801\u4e3a\u7a7a");
        Long tenantId = super.currentTenantId();
        Boolean enabledCustom = (Boolean)ObjectUtil.defaultIfNull((Object)this.tenantMenuRepoProc.getEnabledByTenant(tenantId), (Object)false);
        PermissionDetailRespVO permissionDetailRespVO = respVo = enabledCustom != false ? this.detailForCustom(code, tenantId) : this.detailForDefault(code, tenantId);
        if (respVo == null) {
            return ApiResult.ok((Object)this.detailForApp(code));
        }
        if (StrUtil.isBlank((CharSequence)respVo.getNodeType())) {
            return ApiResult.fail((String)"\u672a\u77e5\u8282\u70b9\u7c7b\u578b");
        }
        if (MenuTreeNodeType.APP.getValue().equals(respVo.getNodeType())) {
            respVo = this.detailForApp(code);
            return ApiResult.ok((Object)respVo);
        }
        if (MenuTreeNodeType.MENU.getValue().equals(respVo.getNodeType())) {
            this.fillApp(respVo);
            return ApiResult.ok((Object)respVo);
        }
        if (MenuTreeNodeType.ACTION.getValue().equals(respVo.getNodeType())) {
            this.fillApp(respVo);
            this.fillMenu(respVo);
            return ApiResult.ok((Object)respVo);
        }
        if (MenuTreeNodeType.API.getValue().equals(respVo.getNodeType())) {
            this.fillApp(respVo);
            this.fillMenu(respVo);
            return ApiResult.ok((Object)respVo);
        }
        return ApiResult.fail((String)("\u4e0d\u652f\u6301\u7684\u8282\u70b9\u7c7b\u578b\uff1a" + respVo.getNodeType()));
    }

    @Override
    public ApiResult<List<SysApiPermissionMetadataDTO>> queryApiMetadata(String appCode) {
        Assert.hasText((String)appCode, (String)"\u5e94\u7528\u7f16\u7801\u4e3a\u7a7a");
        List permissionMetadataList = (List)this.tenantDataIsolateProvider.byDefaultDirectly(() -> this.apiRepoProc.queryPermissionMetadata(appCode));
        if (permissionMetadataList.isEmpty()) {
            return ApiResult.ok(Collections.emptyList());
        }
        Long tenantId = super.currentTenantId();
        Boolean enabledCustom = this.tenantMenuRepoProc.getEnabledByTenant(tenantId);
        Map<String, Set<String>> rolePermissionMap = this.rolePermissionRepoProc.queryRoleCodeForApi((Boolean)ObjectUtil.defaultIfNull((Object)enabledCustom, (Object)false));
        for (SysApiPermissionMetadataDTO dto : permissionMetadataList) {
            dto.setRoleCodes(rolePermissionMap.getOrDefault(dto.getPermissionCode(), Collections.emptySet()));
        }
        return ApiResult.ok((Object)permissionMetadataList);
    }

    @Override
    public ApiResult<List<CodeNameParam>> dataPermissionRanges(String operationCode, String businessObjectCode) {
        Set userTypes;
        HashSet<String> ignored = new HashSet<String>(8);
        ignored.add(SysDprValueType.DPR_SYS_INTERNALLY_EMPLOYEE_SALESMAN.code());
        ignored.add(SysDprValueType.DPR_SYS_INTERNALLY_DYNAMIC.code());
        List dataList = DprValueResolverFactory.getValueTypes().stream().filter(t -> !ignored.contains(t.getCode())).collect(Collectors.toList());
        if ((StringUtils.hasText((String)operationCode) || StringUtils.hasText((String)businessObjectCode)) && !(userTypes = ((List)this.tenantDataIsolateProvider.byDefaultDirectly(() -> StringUtils.hasText((String)operationCode) ? this.businessParamRepoProc.listSimpleBoByBusinessOperationCode(operationCode, null) : this.businessParamRepoProc.listSimpleBoByBusinessObjectCode(businessObjectCode))).stream().filter(t -> Boolean.TRUE.equals(t.getDataPermissionEnabled())).map(BusinessParamBO::getUserType).filter(StringUtils::hasText).collect(Collectors.toSet())).isEmpty()) {
            Map nameMap = this.udcMap((BaseUdc)new UserType());
            for (Map.Entry entry : nameMap.entrySet()) {
                if (!userTypes.contains(entry.getKey())) continue;
                dataList.add(new CodeNameParam(DprSysInternallyDynamic.PREFIX + (String)entry.getKey(), "\u672c\u4eba-" + (String)entry.getValue() + "(ID)"));
            }
        }
        return ApiResult.ok(dataList);
    }

    @Override
    public ApiResult<List<CodeNameParam>> dataPermissionRuleCondition() {
        List result = Arrays.stream(DprRuleConditionEnum.values()).map(DprRuleConditionEnum::getUdcVO).sorted(Comparator.comparing(DprUdcVO::getValSortNo, Comparator.nullsLast(Integer::compareTo))).map(t -> new CodeNameParam(t.getUdcVal(), t.getValDesc())).collect(Collectors.toList());
        return ApiResult.ok(result);
    }

    @Override
    public ApiResult<List<CodeNameParam>> dataPermissionRuleValueMethod() {
        List result = Stream.of(DprRuleValueTypeEnum.DPR_RULE_VALUE_TYPE_CUSTOM, DprRuleValueTypeEnum.DPR_RULE_VALUE_TYPE_SYS, DprRuleValueTypeEnum.DPR_RULE_VALUE_TYPE_BUSINESS).map(DprRuleValueTypeEnum::getUdcVO).sorted(Comparator.comparing(DprUdcVO::getValSortNo, Comparator.nullsLast(Integer::compareTo))).map(t -> new CodeNameParam(t.getUdcVal(), t.getValDesc())).collect(Collectors.toList());
        return ApiResult.ok(result);
    }

    @Override
    public ApiResult<List<SysMenuApiRespVO>> getApi(String menuCode) {
        Assert.hasText((String)menuCode, (String)"\u83dc\u5355\u7f16\u7801\u4e3a\u7a7a");
        HashMap appNameMap = new HashMap(32);
        List apiList = ((List)this.tenantDataIsolateProvider.byDefaultDirectly(() -> {
            for (IdCodeNameParam param : this.appRepoProc.allParams(null)) {
                appNameMap.put(param.getCode(), param.getName());
            }
            return this.menuApiRepoProc.queryApiOfMenu(menuCode);
        })).stream().map(t -> {
            SysMenuApiRespVO respVO = new SysMenuApiRespVO();
            respVO.setId(t.getId());
            respVO.setAppCode(t.getAppCode());
            respVO.setAppName((String)appNameMap.get(t.getAppCode()));
            respVO.setName(t.getApiName());
            respVO.setCode(t.getApiCode());
            respVO.setRequestType(t.getRequestType());
            respVO.setApiPath(t.getApiPath());
            respVO.setApiDescribe(t.getApiDescribe());
            respVO.setMenusCode(menuCode);
            return respVO;
        }).collect(Collectors.toList());
        return ApiResult.ok(apiList);
    }

    @Override
    public ApiResult<List<Long>> getMenuIdOfApi(Long apiId, String appCode) {
        Assert.notNull((Object)apiId, (String)"\u63a5\u53e3ID\u4e3a\u7a7a");
        List<Long> menuIds = this.menuApiRepoProc.getMenuIdByApiId(apiId, appCode);
        return ApiResult.ok(menuIds);
    }

    @Override
    public ApiResult<List<PermissionMenuRespVO>> getMenuDetailOfApi(Long apiId, String appCode) {
        Assert.notNull((Object)apiId, (String)"\u63a5\u53e3ID\u4e3a\u7a7a");
        List menuList = this.menuApiRepoProc.getMenuDetailByApiId(apiId, appCode).stream().map(PermissionConverter.INSTANCE::convertMenuRespVO).collect(Collectors.toList());
        if (menuList.isEmpty()) {
            return ApiResult.ok(menuList);
        }
        Map<String, String> appMap = this.appRepoProc.all().stream().collect(Collectors.toMap(SysPlatformAppDO::getAppCode, SysPlatformAppDO::getAppName, (t1, t2) -> t1));
        Set<String> parentMenuCodes = menuList.stream().map(PermissionMenuRespVO::getMenusParentCode).filter(StringUtils::hasText).collect(Collectors.toSet());
        Map parentMenuNameMap = parentMenuCodes.isEmpty() ? Collections.emptyMap() : this.menusRepoProc.getMenuNameByMenuCode(parentMenuCodes);
        for (PermissionMenuRespVO respVO : menuList) {
            respVO.setMenusParentName((String)parentMenuNameMap.get(respVO.getMenusParentCode()));
            respVO.setMenusAppName(appMap.get(respVO.getMenusAppCode()));
        }
        return ApiResult.ok(menuList);
    }

    @Override
    public ApiResult<List<UserRoleMenuRespVO>> getMenusOfUser(long userId, Boolean includeAction, Boolean tree) {
        List<UserRoleMenuRespVO> menuList = this.permissionQueryManager.queryUserRoleMenus(userId, includeAction != null && includeAction != false, tree == null || tree != false);
        return ApiResult.ok(menuList);
    }

    @Override
    public ApiResult<List<UserRoleDataPermissionRespVO>> getDataPermissionOfUser(long userId) {
        SysUserDTO user = this.userQueryService.getUserById(userId);
        if (user == null) {
            return ApiResult.fail((String)"\u7528\u6237\u4e0d\u5b58\u5728");
        }
        if (CollUtil.isEmpty((Collection)user.getRoles())) {
            return ApiResult.ok(Collections.emptyList());
        }
        SysDprRoleApiRowColumnRuleDTO ruleDTO = this.permissionQueryManager.getDataPermissionByUser(user);
        if (CollUtil.isEmpty((Collection)ruleDTO.getSysDprRoleApiDataRuleListQueryDTO()) && CollUtil.isEmpty((Collection)ruleDTO.getSysDpcRoleApiFieldsDTOList())) {
            return ApiResult.ok(Collections.emptyList());
        }
        Map rowRulesMap = CollUtil.isEmpty((Collection)ruleDTO.getSysDprRoleApiDataRuleListQueryDTO()) ? Collections.emptyMap() : ruleDTO.getSysDprRoleApiDataRuleListQueryDTO().stream().filter(t -> !DataPermissionType.BUSINESS_RESOURCE_RULE.name().equals(t.getPermissionType())).collect(Collectors.groupingBy(BaseDataSecurityRuleDTO::getRoleCode));
        Map fieldRulesMap = CollUtil.isEmpty((Collection)ruleDTO.getSysDpcRoleApiFieldsDTOList()) ? Collections.emptyMap() : ruleDTO.getSysDpcRoleApiFieldsDTOList().stream().collect(Collectors.groupingBy(BaseDataSecurityRuleDTO::getRoleCode));
        ArrayList respVoList = new ArrayList(64);
        ArrayList<CompletableFuture<Void>> futureList = new ArrayList<CompletableFuture<Void>>(user.getRoles().size());
        for (IdCodeNameParam role : user.getRoles()) {
            if (!rowRulesMap.containsKey(role.getCode()) && !fieldRulesMap.containsKey(role.getCode())) continue;
            CompletableFuture<Void> future = CompletableFuture.runAsync(() -> {
                UserRoleDataPermissionRespVO respVO = new UserRoleDataPermissionRespVO();
                respVO.setRoleCode(role.getCode());
                respVO.setRoleName(role.getName());
                respVO.setDataPermissions(this.convertDataPermission((List)rowRulesMap.get(role.getCode()), (List)fieldRulesMap.get(role.getCode())));
                respVoList.add(respVO);
            });
            futureList.add(future);
        }
        CompletableFuture.allOf(futureList.toArray(new CompletableFuture[0])).join();
        return ApiResult.ok(respVoList);
    }

    private Set<String> collectFieldBusinessObjectCode(List<SysDpcRoleApiFieldsDTO> fieldRuleList) {
        return CollUtil.isEmpty(fieldRuleList) ? Collections.emptySet() : fieldRuleList.stream().map(BaseDataSecurityRuleDTO::getBusinessObjectCode).filter(StringUtils::hasText).collect(Collectors.toSet());
    }

    private Set<String> collectRowBusinessObjectCode(List<SysDprRoleApiDataRuleListQueryDTO> rowRuleList) {
        if (CollUtil.isEmpty(rowRuleList)) {
            return Collections.emptySet();
        }
        HashSet<String> businessObjectCodes = new HashSet<String>(rowRuleList.size());
        for (SysDprRoleApiDataRuleListQueryDTO rule : rowRuleList) {
            if (StringUtils.hasText((String)rule.getBusinessObjectCode())) {
                businessObjectCodes.add(rule.getBusinessObjectCode());
            }
            if (StringUtils.hasText((String)rule.getRefBusinessObject())) {
                businessObjectCodes.add(rule.getRefBusinessObject());
            }
            businessObjectCodes.addAll(this.collectRowBusinessObjectCode(rule.getGroupRules()));
        }
        return businessObjectCodes;
    }

    private String generateDataPermissionExpression(List<UserRoleDataPermissionRespVO.RowPermission> permissions, Boolean and, boolean value) {
        if (CollUtil.isEmpty(permissions)) {
            return null;
        }
        if (and == null) {
            for (UserRoleDataPermissionRespVO.RowPermission permission : permissions) {
                if (Boolean.TRUE.equals(permission.getRuleGroup())) continue;
                and = !DprRuleRelationEnum.DPR_RULE_RELATION_OR.name().equals(permission.getDprRuleRelation());
                break;
            }
            if (and == null) {
                and = true;
            }
        }
        ArrayList<Object> expressions = new ArrayList<Object>(permissions.size());
        for (UserRoleDataPermissionRespVO.RowPermission permission : permissions) {
            if (CollUtil.isNotEmpty(permission.getGroupRuleList())) {
                String expression = this.generateDataPermissionExpression(permission.getGroupRuleList(), !DprRuleRelationEnum.DPR_RULE_RELATION_OR.name().equals(permission.getDprRuleRelation()), value);
                if (expression == null) continue;
                expressions.add("(" + expression + ")");
                continue;
            }
            boolean in = DprRuleConditionEnum.InList.name().equals(permission.getDprRuleCondition());
            if (value) {
                expressions.add(String.format("%s %s (%s)", permission.getDprRuleField(), in ? "in" : "not in", permission.getDprRuleValue()));
                continue;
            }
            Object ruleValue = CharSequenceUtil.blankToDefault((CharSequence)permission.getDprRuleValueName(), (String)permission.getDprRuleValue());
            if (Boolean.TRUE.equals(permission.getRefResource())) {
                ruleValue = "\u3010\u516c\u5171\u8d44\u6e90\u3011" + permission.getRefBusinessObjectName();
            }
            expressions.add(String.format("%s %s (%s)", permission.getDprRuleFieldName(), in ? "\u5c5e\u4e8e" : "\u4e0d\u5c5e\u4e8e", ruleValue));
        }
        return expressions.isEmpty() ? null : String.join((CharSequence)(and.booleanValue() ? (value ? " and " : " \u4e14 ") : (value ? " or " : " \u6216 ")), expressions);
    }

    private List<UserRoleDataPermissionRespVO.DataPermission> convertDataPermission(List<SysDprRoleApiDataRuleListQueryDTO> rowRuleList, List<SysDpcRoleApiFieldsDTO> fieldRuleList) {
        UserRoleDataPermissionRespVO.DataPermission dataPermission;
        Function<BaseDataSecurityRuleDTO, String> permissionGroupKey = t -> String.join((CharSequence)"::", t.getPermissionType(), t.getAppCode(), t.getBusinessObjectCode(), t.getApiPermissionCode(), t.getMenusCode());
        Map rowRulesMap = CollUtil.isEmpty(rowRuleList) ? Collections.emptyMap() : rowRuleList.stream().collect(Collectors.groupingBy(permissionGroupKey));
        Map fieldRulesMap = CollUtil.isEmpty(fieldRuleList) ? Collections.emptyMap() : fieldRuleList.stream().collect(Collectors.groupingBy(permissionGroupKey));
        Map<String, String> appMap = this.appRepoProc.allParams(null).stream().collect(Collectors.toMap(IdCodeNameParam::getCode, IdCodeNameParam::getName, (t1, t2) -> t1));
        Map<String, String> menuMap = this.menusRepoProc.getMenuNames(null, false, false, false);
        HashSet<String> businessObjectCodes = new HashSet<String>(this.collectRowBusinessObjectCode(rowRuleList));
        businessObjectCodes.addAll(this.collectFieldBusinessObjectCode(fieldRuleList));
        Map<String, String> businessObjectMap = businessObjectCodes.isEmpty() ? Collections.emptyMap() : this.businessObjectRepoProc.getCodeAndNames(businessObjectCodes);
        Map businessOperationMap = businessObjectCodes.isEmpty() ? Collections.emptyMap() : this.businessOperationRepoProc.getNamesByBusinessObject(businessObjectCodes);
        Map<String, Map<String, String>> businessParamsMap = businessObjectCodes.isEmpty() ? Collections.emptyMap() : this.businessParamRepoProc.getNamesByBusinessObject(businessObjectCodes);
        Function<BaseDataSecurityRuleDTO, UserRoleDataPermissionRespVO.DataPermission> convert = t -> {
            UserRoleDataPermissionRespVO.DataPermission dataPermission = new UserRoleDataPermissionRespVO.DataPermission();
            dataPermission.setPermissionType(t.getPermissionType());
            dataPermission.setPermissionTypeName(DataPermissionType.getDescription((String)t.getPermissionType()));
            dataPermission.setPermissionRef(t.getPermissionRef());
            dataPermission.setAppCode(t.getAppCode());
            dataPermission.setAppName((String)appMap.get(t.getAppCode()));
            dataPermission.setBusinessObjectCode(t.getBusinessObjectCode());
            dataPermission.setBusinessObjectName((String)businessObjectMap.get(t.getBusinessObjectCode()));
            dataPermission.setApiPermissionCode(t.getApiPermissionCode());
            dataPermission.setApiPermissionName(CharSequenceUtil.isBlank((CharSequence)t.getApiPermissionCode()) ? null : (String)businessOperationMap.get(t.getApiPermissionCode()));
            dataPermission.setMenusCode(t.getMenusCode());
            dataPermission.setMenusName(CharSequenceUtil.isBlank((CharSequence)t.getMenusCode()) ? null : (String)menuMap.get(t.getMenusCode()));
            return dataPermission;
        };
        ArrayList<UserRoleDataPermissionRespVO.DataPermission> dataPermissionList = new ArrayList<UserRoleDataPermissionRespVO.DataPermission>(64);
        for (Map.Entry entry : rowRulesMap.entrySet()) {
            dataPermission = convert.apply((BaseDataSecurityRuleDTO)((List)entry.getValue()).get(0));
            dataPermission.setRowPermissions(this.convertRowPermissions((List)entry.getValue(), businessObjectMap, businessParamsMap));
            dataPermission.setFieldPermissions(this.convertFieldPermissions((List)fieldRulesMap.get(entry.getKey()), businessParamsMap.get(dataPermission.getBusinessObjectCode())));
            dataPermission.setRowPermissionExpression(this.generateDataPermissionExpression(dataPermission.getRowPermissions(), true, false));
            dataPermission.setRowPermissionValueExpression(this.generateDataPermissionExpression(dataPermission.getRowPermissions(), true, true));
            dataPermissionList.add(dataPermission);
        }
        for (Map.Entry entry : fieldRulesMap.entrySet()) {
            dataPermission = convert.apply((BaseDataSecurityRuleDTO)((List)entry.getValue()).get(0));
            dataPermission.setRowPermissions(Collections.emptyList());
            dataPermission.setFieldPermissions(this.convertFieldPermissions((List)entry.getValue(), businessParamsMap.get(dataPermission.getBusinessObjectCode())));
            dataPermissionList.add(dataPermission);
        }
        return dataPermissionList;
    }

    private List<UserRoleDataPermissionRespVO.RowPermission> convertRowPermissions(List<SysDprRoleApiDataRuleListQueryDTO> ruleList, Map<String, String> businessObjectMap, Map<String, Map<String, String>> businessParamsMap) {
        if (CollUtil.isEmpty(ruleList)) {
            return Collections.emptyList();
        }
        return ruleList.stream().map(t -> {
            Map params;
            UserRoleDataPermissionRespVO.RowPermission permission = PermissionConverter.INSTANCE.convert2UserPermissionRow((SysDprRoleApiDataRuleListQueryDTO)t);
            if (CollUtil.isNotEmpty((Collection)t.getGroupRules())) {
                permission.setRuleGroup(true);
                permission.setGroupRuleList(this.convertRowPermissions(t.getGroupRules(), businessObjectMap, businessParamsMap));
                return permission;
            }
            if (permission.getRefBusinessObject() != null) {
                permission.setRefBusinessObjectName((String)businessObjectMap.get(permission.getRefBusinessObject()));
            }
            if ((params = (Map)businessParamsMap.get(t.getBusinessObjectCode())) != null) {
                permission.setDprRuleFieldName((String)params.get(t.getDprRuleField()));
            }
            if (permission.getRefBusinessObject() != null && permission.getRefField() != null) {
                params = (Map)businessParamsMap.get(permission.getRefBusinessObject());
                permission.setRefFieldName((String)params.get(permission.getRefField()));
            }
            permission.setDprRuleConditionName(DprRuleConditionEnum.getValue((String)t.getDprRuleCondition()));
            permission.setDprRuleValueTypeName(DprRuleValueTypeEnum.getValue((String)t.getDprRuleValueType()));
            if (CharSequenceUtil.isBlank((CharSequence)permission.getDprRuleValueName())) {
                if (DprRuleValueTypeEnum.DPR_RULE_VALUE_TYPE_SYS.name().equals(permission.getDprRuleValueType()) && StringUtils.hasText((String)permission.getDprRuleValue())) {
                    permission.setDprRuleValueName(DprValueResolverFactory.convertDprValueTypeName(permission.getDprRuleValue()));
                }
                if (permission.getDprRuleValueName() == null) {
                    permission.setDprRuleValueName(permission.getDprRuleValue());
                }
            }
            return permission;
        }).collect(Collectors.toList());
    }

    private List<UserRoleDataPermissionRespVO.FieldPermission> convertFieldPermissions(List<SysDpcRoleApiFieldsDTO> ruleList, Map<String, String> businessParamsMap) {
        if (CollUtil.isEmpty(ruleList)) {
            return Collections.emptyList();
        }
        return ruleList.stream().map(t -> {
            UserRoleDataPermissionRespVO.FieldPermission permission = PermissionConverter.INSTANCE.convert2UserPermissionField((SysDpcRoleApiFieldsDTO)t);
            if (businessParamsMap != null) {
                permission.setFieldDescription((String)businessParamsMap.get(t.getFieldName()));
            }
            return permission;
        }).collect(Collectors.toList());
    }

    @Override
    public ApiResult<SysDprRespVO> getApiDataPermission(Long roleId, String menuCode, String apiCode) {
        Assert.notNull((Object)roleId, (String)"\u89d2\u8272ID\u4e3a\u7a7a");
        Assert.hasText((String)menuCode, (String)"\u83dc\u5355\u7f16\u7801\u4e3a\u7a7a");
        Assert.hasText((String)apiCode, (String)"\u63a5\u53e3\u7f16\u7801\u4e3a\u7a7a");
        SysDprRespVO respVO = this.queryRoleCustomRule(roleId, menuCode, apiCode);
        respVO.setFieldList(this.queryRoleApiFields(roleId, menuCode, apiCode));
        respVO.setArgList(this.queryReqArguments(apiCode));
        return ApiResult.ok((Object)respVO);
    }

    @Override
    public ApiResult<DataPermissionRespVO> getDataPermission(String roleCode, String permissionType, String menuCode, String operationCode, String businessObjectCode) {
        Assert.hasText((String)roleCode, (String)"\u89d2\u8272\u7f16\u7801\u4e3a\u7a7a");
        Assert.hasText((String)permissionType, (String)"\u6570\u636e\u6743\u9650\u7c7b\u578b\u4e3a\u7a7a");
        DataPermissionType dataPermissionType = DataPermissionType.valueOf((String)permissionType);
        Assert.notNull((Object)dataPermissionType, (String)"\u6570\u636e\u6743\u9650\u7c7b\u578b\u9519\u8bef");
        DataPermissionRespVO respVO = new DataPermissionRespVO();
        List<SysRoleDataPermissionDO> permissionDoList = this.queryDataPermissionRule(roleCode, dataPermissionType, menuCode, operationCode, businessObjectCode);
        respVO.setCustomRuleList(this.convertRule(permissionDoList));
        DprRuleRelationEnum relation = null;
        for (DataPermissionRuleRespVO rule : respVO.getCustomRuleList()) {
            if (Boolean.TRUE.equals(rule.getRuleGroup())) continue;
            relation = rule.getGroupRelation();
            break;
        }
        if (relation == null) {
            relation = DprRuleRelationEnum.DPR_RULE_RELATION_AND;
        }
        respVO.setCustomRuleExpression(this.convertPrettyExpression(respVO.getCustomRuleList(), relation));
        AtomicReference refOperationCode = new AtomicReference();
        ArrayList<BusinessOperationParamBO> operationParamList = new ArrayList<BusinessOperationParamBO>(64);
        List paramList = (List)this.tenantDataIsolateProvider.byDefaultDirectly(() -> {
            if (StringUtils.hasText((String)operationCode)) {
                refOperationCode.set(this.businessOperationRepoProc.getPermissionRefByOperationCode(operationCode));
                operationParamList.addAll(this.queryResponseParams(operationCode));
            }
            return this.queryPermissionParams(dataPermissionType, businessObjectCode, operationCode);
        });
        respVO.setArgList(this.convertRuleArgList(paramList));
        if (CollUtil.isNotEmpty(respVO.getCustomRuleList())) {
            Map argMap = respVO.getArgList().stream().collect(Collectors.toMap(DataPermissionParamRespVO::getFieldName, Function.identity(), (t1, t2) -> t1));
            for (DataPermissionRuleRespVO vo : respVO.getCustomRuleList()) {
                DataPermissionParamRespVO arg = (DataPermissionParamRespVO)argMap.get(vo.getDprRuleField());
                if (arg == null) continue;
                vo.setRefBusinessObject(arg.getRelatedBusinessObject());
                vo.setRefField(arg.getRelatedField());
            }
        }
        List<SysRoleFieldPermissionDO> fieldPermissionList = this.queryFieldPermission(roleCode, dataPermissionType, menuCode, operationCode, businessObjectCode);
        respVO.setFieldList(this.convertFieldList(paramList, fieldPermissionList, operationParamList));
        respVO.setUseRef(StringUtils.hasText((String)((String)refOperationCode.get())) && CollUtil.isEmpty(permissionDoList) && CollUtil.isEmpty(fieldPermissionList));
        if (Boolean.TRUE.equals(respVO.getUseRef())) {
            DataPermissionRespVO refPermission = (DataPermissionRespVO)this.getDataPermission(roleCode, permissionType, menuCode, (String)refOperationCode.get(), businessObjectCode).getData();
            respVO.setCustomRuleList(refPermission.getCustomRuleList());
            respVO.setFieldList(refPermission.getFieldList());
        }
        return ApiResult.ok((Object)respVO);
    }

    @Override
    public ApiResult<Set<Long>> getUserIdByRoleCode(String roleCode) {
        Assert.hasText((String)roleCode, (String)"\u89d2\u8272\u7f16\u7801\u4e3a\u7a7a");
        Set<Long> userIds = this.permissionQueryManager.queryUserIdOfRole(roleCode);
        return ApiResult.ok(userIds);
    }

    @Override
    public ApiResult<List<IdCodeNameParam>> listAllRoles(String tenantCode) {
        if (CharSequenceUtil.isBlank((CharSequence)tenantCode)) {
            List<IdCodeNameParam> roleList = this.roleRepoProc.listQuery(BelongType.getBelonger(), null, null);
            return ApiResult.ok(roleList);
        }
        SysTenantDTO tenant = this.tenantClientProvider.getTenantByCode(tenantCode);
        if (tenant == null) {
            return ApiResult.fail((String)"\u79df\u6237\u4e0d\u5b58\u5728");
        }
        List roleList = (List)this.tenantDataIsolateProvider.byTenantDirectly(() -> this.roleRepoProc.listQuery(new BelongType.Belonger(BelongType.TENANT, tenant.getId().toString()), null, null), tenant);
        return ApiResult.ok((Object)roleList);
    }

    @Override
    public ApiResult<List<IdCodeNameParam>> listAllRolesByTenantOrg(String tenantOrgCode) {
        Long orgId = null;
        if (StringUtils.hasText((String)tenantOrgCode)) {
            orgId = this.tenantOrgRepoProc.getOrgIdByCode(tenantOrgCode, false);
            if (orgId == null) {
                return ApiResult.fail((String)"\u79df\u6237\u7ec4\u7ec7\u4e0d\u5b58\u5728\u6216\u5df2\u7981\u7528");
            }
        } else {
            orgId = this.tenantOrgProvider.getSessionTenantOrgId();
            if (orgId == null) {
                return ApiResult.ok(Collections.emptyList());
            }
        }
        List<IdCodeNameParam> roleList = this.roleRepoProc.listQuery(new BelongType.Belonger(BelongType.TENANT_ORG, orgId.toString()), null, null);
        return ApiResult.ok(roleList);
    }

    @Override
    public ApiResult<List<SysUserBasicDTO>> listUserByRole(String roleCode) {
        Assert.hasText((String)roleCode, (String)"\u89d2\u8272\u7f16\u7801\u4e3a\u7a7a");
        Set<Long> userIds = this.permissionQueryManager.queryUserIdOfRole(roleCode);
        if (CollUtil.isEmpty(userIds)) {
            return ApiResult.ok(Collections.emptyList());
        }
        List userList = (List)this.tenantDataIsolateProvider.byDefaultDirectly(() -> this.userRepoProc.getBasicDto(userIds));
        return ApiResult.ok((Object)userList);
    }

    @Override
    public ApiResult<List<EmployeeUserInfoRespVO>> listEmployeeUserByRole(Long roleId, Boolean onlyEmployee) {
        if (roleId == null) {
            return ApiResult.fail((String)"\u89d2\u8272ID\u4e3a\u7a7a");
        }
        if (onlyEmployee == null) {
            onlyEmployee = true;
        }
        List<EmployeeUserInfoRespVO> respVoLList = this.permissionQueryManager.queryUserOfRole(roleId, onlyEmployee);
        return ApiResult.ok(respVoLList);
    }

    @Override
    public ApiResult<List<DataPermissionTreeNodeRespVO>> dataPermissionTree(Long roleId, String appCode, Boolean tree) {
        tree = tree == null || tree != false;
        List<DataPermissionTreeNodeRespVO> menuList = this.permissionMngManager.getDataPermissionByRole(roleId, appCode, true, tree);
        return ApiResult.ok(menuList);
    }

    @Override
    public ApiResult<List<DataPermissionTreeNodeRespVO>> dataPermissionTree(String roleCode, String dataPermissionTypeValue, Boolean withRef, String appCode, Boolean tree) {
        tree = tree == null || tree != false;
        withRef = withRef != null && withRef != false;
        DataPermissionType dataPermissionType = DataPermissionType.valueOf((String)dataPermissionTypeValue);
        List<DataPermissionTreeNodeRespVO> permissionList = this.permissionMngManager.getDataPermissionByRole(roleCode, dataPermissionType, withRef, appCode, true, tree);
        return ApiResult.ok(permissionList);
    }

    @Override
    public ApiResult<SysDprRoleApiRowColumnRuleDTO> getDataPermissionOfCurrentUser() {
        SysDprRoleApiRowColumnRuleDTO roleRuleDTO = this.permissionQueryManager.getDataPermissionOfCurrentUser();
        return ApiResult.ok((Object)roleRuleDTO);
    }

    private BusinessObjectBO getBusinessObjectInfo(String businessObjectCode, String operationCode, String operationRefCode) {
        if (StringUtils.hasText((String)operationRefCode)) {
            return this.businessObjectRepoProc.getSimpleByOperationCode(operationRefCode);
        }
        if (StringUtils.hasText((String)operationCode)) {
            return this.businessObjectRepoProc.getSimpleByOperationCode(operationCode);
        }
        if (StringUtils.hasText((String)businessObjectCode)) {
            return this.businessObjectRepoProc.getSimple(businessObjectCode);
        }
        return null;
    }

    private List<BusinessOperationParamBO> queryResponseParams(String operationCode) {
        List<BusinessOperationParamBO> operationParams = this.businessOperationParamRepoProc.listBoByOperationCode(operationCode, BusinessObjectParamInEnum.RESPONSE_BODY);
        if (operationParams.isEmpty()) {
            return Collections.emptyList();
        }
        List<BusinessOperationParamBO> paramVoList = this.businessObjectManager.convertParam(operationParams, null);
        return this.filterResponseData(paramVoList);
    }

    private List<BusinessOperationParamBO> filterResponseData(List<BusinessOperationParamBO> paramList) {
        if (CollUtil.isEmpty(paramList)) {
            return Collections.emptyList();
        }
        for (BusinessOperationParamBO operationParam : paramList) {
            if (!operationParam.isApiResultData()) continue;
            List<BusinessOperationParamBO> pageData = this.businessObjectManager.attemptObtainPagingData(operationParam.getChildrenParams());
            return (List)CollUtil.defaultIfEmpty(pageData, operationParam.getChildrenParams());
        }
        return paramList;
    }

    private List<DataPermissionFieldRespVO> convertFieldList(List<BusinessParamBO> paramList, List<SysRoleFieldPermissionDO> permissionList, List<BusinessOperationParamBO> operationParamList) {
        if (CollectionUtils.isEmpty(paramList)) {
            return Collections.emptyList();
        }
        Map permissionMap = CollUtil.isEmpty(permissionList) ? Collections.emptyMap() : permissionList.stream().collect(Collectors.toMap(SysRoleFieldPermissionDO::getFieldName, Function.identity(), (t1, t2) -> t1));
        List<DataPermissionFieldRespVO> fieldList = paramList.stream().filter(t -> {
            if (Boolean.FALSE.equals(t.getEnabled())) {
                return false;
            }
            if (Boolean.FALSE.equals(t.getFieldPermissionEnabled())) {
                if (Boolean.TRUE.equals(t.getBaseField())) {
                    return this.dataSecurityProperties.getFieldPermission().getBaseFields().contains(t.getFieldName());
                }
                return false;
            }
            return true;
        }).map(t -> {
            DataPermissionFieldRespVO respVO = new DataPermissionFieldRespVO();
            respVO.setEntity(true);
            respVO.setFieldName(t.getFieldName());
            respVO.setFieldRemark(CharSequenceUtil.blankToDefault((CharSequence)t.getCustomDescription(), (String)t.getFieldDescription()));
            SysRoleFieldPermissionDO permission = (SysRoleFieldPermissionDO)permissionMap.get(t.getFieldName());
            if (permission == null) {
                respVO.setReadable((Boolean)ObjUtil.defaultIfNull((Object)this.dataSecurityProperties.getDefaultAllow(), (Object)true));
                respVO.setWriteable((Boolean)ObjUtil.defaultIfNull((Object)this.dataSecurityProperties.getDefaultAllow(), (Object)true));
            } else {
                respVO.setReadable(permission.getReadable());
                respVO.setWriteable(permission.getWriteable());
            }
            return respVO;
        }).collect(Collectors.toList());
        if (CollUtil.isNotEmpty(operationParamList)) {
            Set<String> excludeFieldNames = Set.of("extensionInfo");
            Set fieldNames = fieldList.stream().map(DataPermissionFieldRespVO::getFieldName).collect(Collectors.toSet());
            for (BusinessOperationParamBO operationParam : operationParamList) {
                if (operationParam.getFieldName() == null || fieldNames.contains(operationParam.getFieldName()) || excludeFieldNames.contains(operationParam.getFieldName())) continue;
                DataPermissionFieldRespVO respVO = new DataPermissionFieldRespVO();
                respVO.setFieldName(operationParam.getFieldName());
                respVO.setFieldRemark(operationParam.getFieldDescription());
                respVO.setEntity(false);
                SysRoleFieldPermissionDO permission = (SysRoleFieldPermissionDO)permissionMap.get(operationParam.getFieldName());
                if (permission == null) {
                    respVO.setReadable(true);
                    respVO.setWriteable(true);
                } else {
                    respVO.setReadable(permission.getReadable());
                    respVO.setWriteable(permission.getWriteable());
                }
                fieldNames.add(operationParam.getFieldName());
                fieldList.add(respVO);
            }
        }
        return fieldList;
    }

    private List<DataPermissionParamRespVO> convertRuleArgList(List<BusinessParamBO> paramList) {
        if (CollectionUtils.isEmpty(paramList)) {
            return Collections.emptyList();
        }
        List<DataPermissionParamRespVO> argList = paramList.stream().filter(t -> {
            if (Boolean.TRUE.equals(t.getDataPermissionEnabled())) {
                return true;
            }
            if (Boolean.TRUE.equals(t.getBaseField())) {
                return this.dataSecurityProperties.getBaseFields().contains(t.getFieldName());
            }
            return false;
        }).map(t -> {
            String[] values;
            DataPermissionParamRespVO respVO = new DataPermissionParamRespVO();
            respVO.setId(t.getId());
            respVO.setFieldName(t.getFieldName());
            respVO.setFieldRemark(CharSequenceUtil.blankToDefault((CharSequence)t.getCustomDescription(), (String)t.getFieldDescription()));
            respVO.setEnabled(t.getEnabled());
            respVO.setRelatedBusinessObject(t.getRelatedBusinessObject());
            respVO.setRelatedField(t.getRelatedField());
            respVO.setRelatedResource(false);
            if (StringUtils.hasText((String)t.getValuesJson()) && StringUtils.hasText((String)t.getRelatedBusinessObject()) && t.getRelatedBusinessObject().equals("SysPlatform_Udc:\u5e73\u53f0UDC".split(":")[0]) && (values = (String[])JSONUtil.json2Obj((String)t.getValuesJson(), (TypeReference)new TypeReference<String[]>(){})).length >= 2) {
                respVO.setRelatedAppCode(values[0]);
                respVO.setRelatedUdcCode(values[1]);
            }
            if (Boolean.TRUE.equals(t.getBaseField())) {
                this.fillBaseModelParam(respVO);
            }
            respVO.setInner(respVO.getRelatedBusinessObject() != null && this.isInnerBusinessObject(respVO.getRelatedBusinessObject()));
            return respVO;
        }).collect(Collectors.toList());
        if (argList.isEmpty()) {
            return argList;
        }
        Set relatedBusinessObjectCodes = argList.stream().map(DataPermissionParamRespVO::getRelatedBusinessObject).filter(StringUtils::hasText).collect(Collectors.toSet());
        if (!relatedBusinessObjectCodes.isEmpty()) {
            Map businessObjectMap = ((List)this.tenantDataIsolateProvider.byDefaultDirectly(() -> this.businessObjectRepoProc.listSimple(relatedBusinessObjectCodes))).stream().collect(Collectors.toMap(BusinessObjectBO::getCode, Functions.identity(), (t1, t2) -> t1));
            for (DataPermissionParamRespVO paramRespVO : argList) {
                if (!StringUtils.hasText((String)paramRespVO.getRelatedBusinessObject())) continue;
                BusinessObjectBO ob = (BusinessObjectBO)businessObjectMap.get(paramRespVO.getRelatedBusinessObject());
                if (ob == null) {
                    log.error("\u5173\u8054\u7684\u4e1a\u52a1\u5bf9\u8c61\u4e0d\u5b58\u5728\uff1a{}", (Object)paramRespVO.getRelatedBusinessObject());
                    continue;
                }
                paramRespVO.setRelatedBusinessObjectName(CharSequenceUtil.blankToDefault((CharSequence)ob.getCustomName(), (String)ob.getName()));
                paramRespVO.setRelatedResource(ob.getPublicResource());
            }
        }
        return argList;
    }

    private boolean isInnerBusinessObject(String businessObject) {
        if (INNER_BUSINESS_OBJECT.contains(businessObject)) {
            return true;
        }
        return this.systemProperties.getBusinessObjectInnerCustom() != null && this.systemProperties.getBusinessObjectInnerCustom().contains(businessObject);
    }

    private void fillBaseModelParam(DataPermissionParamRespVO respVO) {
        if (this.dataSecurityProperties.getOrgIdBaseFields().contains(respVO.getFieldName())) {
            respVO.setRelatedBusinessObject("Sys_Org:\u7ec4\u7ec7".split(":")[0]);
            respVO.setRelatedField("id");
        } else if (this.dataSecurityProperties.getUserIdBaseFields().contains(respVO.getFieldName())) {
            respVO.setRelatedBusinessObject("Sys_User:\u8d26\u53f7".split(":")[0]);
            respVO.setRelatedField("id");
        }
    }

    private List<BusinessParamBO> queryPermissionParams(DataPermissionType permissionType, String businessObjectCode, String operationCode) {
        List<BusinessParamBO> paramBoList = null;
        switch (permissionType) {
            case MENU_OPERATION_RULE: 
            case BUSINESS_OPERATION_RULE: {
                paramBoList = this.businessParamRepoProc.listSimpleBoByBusinessOperationCode(operationCode, null);
                break;
            }
            case BUSINESS_OBJECT_RULE: 
            case BUSINESS_RESOURCE_RULE: {
                paramBoList = this.businessParamRepoProc.listSimpleBoByBusinessObjectCode(businessObjectCode);
                break;
            }
            default: {
                throw new BusinessException("\u67e5\u8be2\u53c2\u6570\u5931\u8d25\uff0c\u6682\u4e0d\u652f\u6301\u7684\u6743\u9650\u7c7b\u578b");
            }
        }
        return paramBoList;
    }

    private String convertPrettyExpression(List<DataPermissionRuleRespVO> ruleRespVoList, DprRuleRelationEnum relation) {
        if (CollUtil.isEmpty(ruleRespVoList)) {
            return null;
        }
        ArrayList<Object> expressions = new ArrayList<Object>();
        for (DataPermissionRuleRespVO respVO : ruleRespVoList) {
            if (Boolean.TRUE.equals(respVO.getRuleGroup())) {
                String groupExpression = this.convertPrettyExpression(respVO.getGroupRules(), respVO.getGroupRelation());
                if (groupExpression == null) continue;
                expressions.add("(" + groupExpression + ")");
                continue;
            }
            expressions.add(respVO.getDprRuleName());
        }
        return String.join((CharSequence)(" " + relation.getValueDescription() + " "), expressions);
    }

    private List<DataPermissionRuleRespVO> convertRule(List<SysRoleDataPermissionDO> permissionDoList) {
        if (CollUtil.isEmpty(permissionDoList)) {
            return Collections.emptyList();
        }
        List ruleList = permissionDoList.stream().map(t -> {
            DataPermissionRuleRespVO respVO = new DataPermissionRuleRespVO();
            respVO.setRuleGroup(Boolean.TRUE.equals(t.getRuleGroup()));
            respVO.setGroupRelation(DprRuleRelationEnum.valueOf((String)t.getRuleRelation()));
            if (respVO.getRuleGroup().booleanValue()) {
                respVO.setRuleGroupCode(t.getRuleGroupCode());
                int index = t.getRuleGroupCode().lastIndexOf("_");
                String parentId = index > 0 ? t.getRuleGroupCode().substring(0, index) : "0";
                respVO.setRuleGroupCodeParent(parentId);
                respVO.setRuleOrder(Integer.valueOf(t.getRuleGroupCode().substring(index + 1)));
                respVO.setGroupRules(new ArrayList<DataPermissionRuleRespVO>());
            } else {
                respVO.setRuleGroupCode(t.getId().toString());
                respVO.setRuleGroupCodeParent(CharSequenceUtil.blankToDefault((CharSequence)t.getRuleGroupCode(), (String)"0"));
                respVO.setRuleOrder((Integer)ObjUtil.defaultIfNull((Object)t.getRuleOrder(), (Object)0));
                respVO.setGroupRules(null);
            }
            respVO.setId(t.getId());
            respVO.setDprRuleName(t.getRuleName());
            respVO.setDprRuleField(t.getRuleField());
            respVO.setRefResource(Boolean.TRUE.equals(t.getRefResource()));
            respVO.setRefBusinessObject(t.getRefBusinessObject());
            respVO.setRefField(t.getRefField());
            if (StringUtils.hasText((String)t.getFieldValueCondition())) {
                DprRuleConditionEnum condition = DprRuleConditionEnum.valueOf((String)t.getFieldValueCondition());
                respVO.setDprRuleCondition(condition);
                respVO.setDprRuleConditionName(condition.getValueDescription());
            }
            if (StringUtils.hasText((String)t.getRuleValueType())) {
                DprRuleValueTypeEnum valueType = DprRuleValueTypeEnum.valueOf((String)t.getRuleValueType());
                respVO.setDprRuleValueType(valueType);
                respVO.setDprRuleValueTypeName(valueType.getValueDescription());
            }
            respVO.setDataSet(t.getDataSet());
            respVO.setDprRuleValue(t.getRuleValue());
            respVO.setDprRuleValueName(t.getRuleValueName());
            respVO.setDprRuleDeclare(t.getRuleDescription());
            respVO.setBs1(t.getBs1());
            respVO.setBs2(t.getBs2());
            respVO.setBs3(t.getBs3());
            return respVO;
        }).collect(Collectors.toList());
        Set refBusinessObjectCodes = ruleList.stream().map(DataPermissionRuleRespVO::getRefBusinessObject).filter(CharSequenceUtil::isNotBlank).collect(Collectors.toSet());
        if (!refBusinessObjectCodes.isEmpty()) {
            Map businessObjectMap = ((List)this.tenantDataIsolateProvider.byDefaultDirectly(() -> this.businessObjectRepoProc.listSimple(refBusinessObjectCodes))).stream().collect(Collectors.toMap(BusinessObjectBO::getCode, Function.identity(), (t1, t2) -> t1));
            for (DataPermissionRuleRespVO respVO : ruleList) {
                if (!StringUtils.hasText((String)respVO.getRefBusinessObject())) continue;
                ObjUtil.ifNotNull((Object)((BusinessObjectBO)businessObjectMap.get(respVO.getRefBusinessObject())), ob -> respVO.setRefBusinessObjectName(CharSequenceUtil.blankToDefault((CharSequence)ob.getCustomName(), (String)ob.getName())));
            }
        }
        return new TreeDataUtil(ruleList, DataPermissionRuleRespVO::getRuleGroupCode, DataPermissionRuleRespVO::getRuleGroupCodeParent, DataPermissionRuleRespVO::setGroupRules, Comparator.comparingInt(DataPermissionRuleRespVO::getRuleOrder)).getRoots();
    }

    private List<SysRoleDataPermissionDO> queryDataPermissionRule(String roleCode, DataPermissionType permissionType, String menuCode, String operationCode, String businessObjectCode) {
        switch (permissionType) {
            case MENU_OPERATION_RULE: {
                Assert.hasText((String)menuCode, (String)"\u83dc\u5355\u7f16\u7801\u4e3a\u7a7a");
                Assert.hasText((String)operationCode, (String)"\u64cd\u4f5c\u7f16\u7801\u4e3a\u7a7a");
                return this.dataPermissionRepoProc.listByRoleForMenuOperation(roleCode, menuCode, operationCode);
            }
            case BUSINESS_OPERATION_RULE: {
                Assert.hasText((String)operationCode, (String)"\u64cd\u4f5c\u7f16\u7801\u4e3a\u7a7a");
                return this.dataPermissionRepoProc.listByRoleForBusinessOperation(roleCode, operationCode);
            }
            case BUSINESS_OBJECT_RULE: {
                Assert.hasText((String)businessObjectCode, (String)"\u4e1a\u52a1\u5bf9\u8c61\u7f16\u7801\u4e3a\u7a7a");
                return this.dataPermissionRepoProc.listByRoleForBusinessObject(roleCode, businessObjectCode);
            }
            case BUSINESS_RESOURCE_RULE: {
                Assert.hasText((String)businessObjectCode, (String)"\u4e1a\u52a1\u5bf9\u8c61\u7f16\u7801\u4e3a\u7a7a");
                return this.dataPermissionRepoProc.listByRoleForBusinessObjectResource(roleCode, businessObjectCode);
            }
        }
        throw new BusinessException("\u67e5\u8be2\u6743\u9650\u5931\u8d25\uff0c\u6682\u4e0d\u652f\u6301\u7684\u6570\u636e\u6743\u9650\u7c7b\u578b");
    }

    private List<SysRoleFieldPermissionDO> queryFieldPermission(String roleCode, DataPermissionType permissionType, String menuCode, String operationCode, String businessObjectCode) {
        switch (permissionType) {
            case MENU_OPERATION_RULE: {
                Assert.hasText((String)menuCode, (String)"\u83dc\u5355\u7f16\u7801\u4e3a\u7a7a");
                Assert.hasText((String)operationCode, (String)"\u64cd\u4f5c\u7f16\u7801\u4e3a\u7a7a");
                return this.roleFieldPermissionRepoProc.listByRoleForMenuOperation(roleCode, menuCode, operationCode);
            }
            case BUSINESS_OPERATION_RULE: {
                Assert.hasText((String)operationCode, (String)"\u64cd\u4f5c\u7f16\u7801\u4e3a\u7a7a");
                return this.roleFieldPermissionRepoProc.listByRoleForBusinessOperation(roleCode, operationCode);
            }
            case BUSINESS_OBJECT_RULE: {
                Assert.hasText((String)businessObjectCode, (String)"\u4e1a\u52a1\u5bf9\u8c61\u7f16\u7801\u4e3a\u7a7a");
                return this.roleFieldPermissionRepoProc.listByRoleForBusinessObject(roleCode, businessObjectCode);
            }
            case BUSINESS_RESOURCE_RULE: {
                Assert.hasText((String)businessObjectCode, (String)"\u4e1a\u52a1\u5bf9\u8c61\u7f16\u7801\u4e3a\u7a7a");
                return this.roleFieldPermissionRepoProc.listByRoleForBusinessObjectResource(roleCode, businessObjectCode);
            }
        }
        throw new BusinessException("\u67e5\u8be2\u6743\u9650\u5931\u8d25\uff0c\u6682\u4e0d\u652f\u6301\u7684\u6570\u636e\u6743\u9650\u7c7b\u578b");
    }

    private List<SysDprApiFieldRespVO> queryReqArguments(String apiCode) {
        return ((List)this.tenantDataIsolateProvider.byDefaultDirectly(() -> this.apiParameterRepoProc.queryInParamByApiCode(apiCode))).stream().map(t -> {
            SysDprApiFieldRespVO respVO = new SysDprApiFieldRespVO();
            respVO.setFieldName(t.getCode());
            respVO.setFieldRemark(t.getName());
            respVO.setEnabled(false);
            return respVO;
        }).collect(Collectors.toList());
    }

    private List<SysDprApiFieldRespVO> queryRoleApiFields(Long roleId, String menuCode, String apiCode) {
        Map<String, PermissionParameterBO> roleFieldMap = this.apiFieldsRepoProc.queryByApi(roleId, menuCode, apiCode).stream().collect(Collectors.toMap(PermissionParameterBO::getFieldName, t -> t, (t1, t2) -> t1));
        return ((List)this.tenantDataIsolateProvider.byDefaultDirectly(() -> this.apiParameterRepoProc.queryOutParamByApiCode(apiCode))).stream().map(t -> {
            SysDprApiFieldRespVO respVO = new SysDprApiFieldRespVO();
            respVO.setFieldName(t.getCode());
            respVO.setFieldRemark(t.getName());
            PermissionParameterBO roleField = (PermissionParameterBO)roleFieldMap.get(t.getCode());
            if (roleField == null) {
                respVO.setFieldApiVisible(false);
                respVO.setFieldFormVisible(false);
                respVO.setFieldFormUpdate(false);
                respVO.setEnabled(false);
                return respVO;
            }
            respVO.setId(roleField.getId());
            respVO.setFieldApiVisible(Boolean.TRUE.equals(roleField.getFieldApiVisible()));
            respVO.setFieldFormVisible(Boolean.TRUE.equals(roleField.getFieldFormVisible()));
            respVO.setFieldFormUpdate(Boolean.TRUE.equals(roleField.getFieldFormUpdate()));
            respVO.setEnabled(true);
            return respVO;
        }).collect(Collectors.toList());
    }

    private SysDprRespVO queryRoleCustomRule(Long roleId, String menuCode, String apiCode) {
        SysDprRespVO respVO = new SysDprRespVO();
        List<SysDprRoleApiRowRuleDO> ruleDoList = this.roleApiRowRuleRepoProc.queryByApi(roleId, menuCode, apiCode);
        if (ruleDoList.isEmpty()) {
            respVO.setCustomRuleList(Collections.emptyList());
            return respVO;
        }
        ArrayList<SysDprApiCustomRuleRespVO> customRuleRespVoList = new ArrayList<SysDprApiCustomRuleRespVO>(ruleDoList.size());
        respVO.setCustomRuleList(customRuleRespVoList);
        for (SysDprRoleApiRowRuleDO ruleDO : ruleDoList) {
            if (Boolean.TRUE.equals(ruleDO.getDataRange())) {
                respVO.setRange(SysDprValueType.valueOf(ruleDO.getDprSysInternally()).code());
                continue;
            }
            SysDprApiCustomRuleRespVO vo = new SysDprApiCustomRuleRespVO();
            vo.setId(ruleDO.getId());
            vo.setDprRuleName(ruleDO.getDprRuleName());
            vo.setDprRuleField(ruleDO.getDprRuleField());
            if (StringUtils.hasText((String)ruleDO.getDprRuleCondition())) {
                vo.setDprRuleCondition(DprRuleConditionEnum.valueOf((String)ruleDO.getDprRuleCondition()));
            }
            if (StringUtils.hasText((String)ruleDO.getDprRuleValueType())) {
                vo.setDprRuleValueType(DprRuleValueTypeEnum.valueOf((String)ruleDO.getDprRuleValueType()));
            }
            vo.setDataSet(ruleDO.getDataSet());
            vo.setDprRuleValue(ruleDO.getDprRuleValue());
            if (DprRuleValueTypeEnum.DPR_RULE_VALUE_TYPE_SYS == vo.getDprRuleValueType() && StringUtils.hasText((String)ruleDO.getDprRuleValue())) {
                vo.setDprRuleValueName(DprValueResolverFactory.convertDprValueTypeName(ruleDO.getDprRuleValue()));
            }
            if (StringUtils.hasText((String)ruleDO.getDprRuleValueName())) {
                vo.setDprRuleValueName(ruleDO.getDprRuleValueName());
            }
            vo.setDprRuleDeclare(ruleDO.getDprRuleDeclare());
            vo.setBs1(ruleDO.getBs1());
            vo.setBs2(ruleDO.getBs2());
            vo.setBs3(ruleDO.getBs3());
            customRuleRespVoList.add(vo);
        }
        return respVO;
    }

    private PermissionDetailRespVO detailForCustom(String code, Long tenantId) {
        String menuName;
        SysTenantMenuTreeDO menuTreeParent;
        SysTenantMenuTreeDO menuTree = this.tenantMenuTreeRepoProc.getByMenuCode(code);
        if (menuTree == null) {
            return this.detailForDefault(code, tenantId);
        }
        PermissionDetailRespVO respVO = new PermissionDetailRespVO();
        respVO.setId(menuTree.getId());
        respVO.setCode(menuTree.getMenuCode());
        respVO.setName(menuTree.getMenuName());
        respVO.setNodeType(menuTree.getNodeType());
        respVO.setParentCode(menuTree.getParentMenuCode());
        if (StringUtils.hasText((String)menuTree.getParentMenuCode()) && (menuTreeParent = this.tenantMenuTreeRepoProc.getByMenuCode(menuTree.getParentMenuCode())) != null) {
            respVO.setParentId(menuTreeParent.getId());
            respVO.setParentName(menuTreeParent.getMenuName());
        }
        if (StrUtil.isBlank((CharSequence)menuTree.getMenuName())) {
            menuName = (String)this.tenantDataIsolateProvider.byDefaultDirectly(() -> this.menusRepoProc.getMenuNameByMenuCode(code));
            respVO.setName(menuName);
            respVO.setApiName(menuName);
        }
        if (StrUtil.isBlank((CharSequence)respVO.getParentName()) && StrUtil.isNotBlank((CharSequence)respVO.getParentCode())) {
            menuName = (String)this.tenantDataIsolateProvider.byDefaultDirectly(() -> this.menusRepoProc.getMenuNameByMenuCode(respVO.getParentCode()));
            respVO.setParentName(menuName);
        }
        return respVO;
    }

    private PermissionDetailRespVO detailForDefault(String code, Long tenantId) {
        MenuBO menuParentBO;
        MenuBO menuBO = (MenuBO)this.tenantDataIsolateProvider.byDefaultDirectly(() -> this.menusRepoProc.getByMenuCode(code));
        if (menuBO == null) {
            return this.detailForApi(code);
        }
        PermissionDetailRespVO respVO = new PermissionDetailRespVO();
        respVO.setId(menuBO.getId());
        respVO.setCode(menuBO.getMenusCode());
        respVO.setName(menuBO.getMenusName());
        MenuTreeNodeType nodeType = MenuTreeNodeType.valueOfPlatformMenu((String)menuBO.getNodeType());
        Assert.notNull((Object)nodeType, (String)"\u4e0d\u652f\u6301\u7684\u8282\u70b9\u7c7b\u578b");
        respVO.setNodeType(nodeType.getValue());
        respVO.setParentCode(menuBO.getMenusParentCode());
        respVO.setAppCode(menuBO.getMenusAppCode());
        respVO.setAction(menuBO.getMenusRoute());
        if (StrUtil.isNotBlank((CharSequence)menuBO.getMenusParentCode()) && (menuParentBO = (MenuBO)this.tenantDataIsolateProvider.byDefaultDirectly(() -> this.menusRepoProc.getByMenuCode(menuBO.getMenusParentCode()))) != null) {
            respVO.setParentId(menuParentBO.getId());
            respVO.setParentCode(menuParentBO.getMenusCode());
            respVO.setParentName(menuParentBO.getMenusName());
            MenuTreeNodeType parentNodeType = MenuTreeNodeType.valueOfPlatformMenu((String)menuParentBO.getNodeType());
            if (parentNodeType == MenuTreeNodeType.MENU || parentNodeType == MenuTreeNodeType.MENU_GROUP) {
                respVO.setMenuCode(menuParentBO.getMenusCode());
                respVO.setMenuName(menuParentBO.getMenusName());
            }
        }
        return respVO;
    }

    private PermissionDetailRespVO detailForApi(String code) {
        MenuBO menuBO;
        SysPlatformApiPermissionDO apiDo = (SysPlatformApiPermissionDO)this.tenantDataIsolateProvider.byDefaultDirectly(() -> this.apiRepoProc.getByCode(code));
        if (apiDo == null) {
            return null;
        }
        PermissionDetailRespVO respVO = new PermissionDetailRespVO();
        respVO.setId(apiDo.getId());
        respVO.setCode(apiDo.getPermissonCode());
        respVO.setName(apiDo.getPermissonName());
        respVO.setNodeType(MenuTreeNodeType.API.getValue());
        respVO.setParentCode(apiDo.getMenusCode());
        if (StringUtils.hasText((String)apiDo.getMenusCode()) && (menuBO = (MenuBO)this.tenantDataIsolateProvider.byDefaultDirectly(() -> this.menusRepoProc.getByMenuCode(apiDo.getMenusCode()))) != null) {
            respVO.setParentId(menuBO.getId());
            respVO.setParentName(menuBO.getMenusName());
            respVO.setMenuCode(menuBO.getMenusCode());
            respVO.setMenuName(menuBO.getMenusName());
        }
        respVO.setAppCode(apiDo.getAppCode());
        respVO.setAction(apiDo.getPermissonPath());
        return respVO;
    }

    private PermissionDetailRespVO detailForApp(String code) {
        SysPlatformAppDO appDO = (SysPlatformAppDO)this.tenantDataIsolateProvider.byDefaultDirectly(() -> this.appRepoProc.getByCode(code));
        if (appDO == null) {
            return null;
        }
        PermissionDetailRespVO respVO = new PermissionDetailRespVO();
        respVO.setId(appDO.getId());
        respVO.setCode(appDO.getAppCode());
        respVO.setName(appDO.getAppName());
        respVO.setNodeType(MenuTreeNodeType.APP.getValue());
        return respVO;
    }

    private void fillApp(PermissionDetailRespVO respVO) {
        SysPlatformAppDO app;
        String appCode = respVO.getAppCode();
        if (StrUtil.isBlank((CharSequence)appCode)) {
            appCode = (String)this.tenantDataIsolateProvider.byDefaultDirectly(() -> this.menusRepoProc.getMenuNameByMenuCode(respVO.getCode()));
            if (StrUtil.isBlank((CharSequence)appCode)) {
                return;
            }
            respVO.setAppCode(appCode);
        }
        if ((app = (SysPlatformAppDO)this.tenantDataIsolateProvider.byDefaultDirectly(() -> this.appRepoProc.getByCode(respVO.getAppCode()))) == null) {
            return;
        }
        respVO.setAppId(app.getId());
        respVO.setAppName(app.getAppName());
    }

    private void fillMenu(PermissionDetailRespVO respVO) {
        if (StrUtil.isNotBlank((CharSequence)respVO.getMenuCode())) {
            return;
        }
        String menuCode = respVO.getParentCode();
        if (StrUtil.isBlank((CharSequence)menuCode)) {
            return;
        }
        MenuBO menu = (MenuBO)this.tenantDataIsolateProvider.byDefaultDirectly(() -> {
            MenuTreeNodeType tempType;
            MenuBO temp = this.menusRepoProc.getByMenuCode(menuCode);
            while (temp != null && (tempType = MenuTreeNodeType.valueOfPlatformMenu((String)temp.getNodeType())) != MenuTreeNodeType.MENU && tempType != MenuTreeNodeType.MENU_GROUP) {
                if (StrUtil.isBlank((CharSequence)temp.getMenusParentCode())) {
                    temp = null;
                    break;
                }
                temp = this.menusRepoProc.getByMenuCode(temp.getMenusParentCode());
            }
            return temp;
        });
        if (menu == null) {
            return;
        }
        respVO.setMenuCode(menu.getMenusCode());
        respVO.setMenuName(menu.getMenusName());
    }

    static {
        INNER_BUSINESS_OBJECT.add("Sys_User:\u8d26\u53f7".split(":")[0]);
        INNER_BUSINESS_OBJECT.add("Sys_Org:\u7ec4\u7ec7".split(":")[0]);
        INNER_BUSINESS_OBJECT.add("Sys_Employee:\u5458\u5de5".split(":")[0]);
    }
}

