/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.elitescloud.boot.common.BaseUdc;
import com.elitescloud.boot.common.param.IdCodeNameParam;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.constant.SysRoleBusiness;
import com.elitescloud.cloudt.core.annotation.TenantOrgTransaction;
import com.elitescloud.cloudt.core.annotation.TenantTransaction;
import com.elitescloud.cloudt.core.annotation.common.TenantIsolateType;
import com.elitescloud.cloudt.system.convert.RoleConvert;
import com.elitescloud.cloudt.system.model.vo.query.role.RolePageQueryVO;
import com.elitescloud.cloudt.system.model.vo.resp.role.GroupRoleRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.role.RoleDetailRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.role.RolePageRespVO;
import com.elitescloud.cloudt.system.model.vo.save.role.RoleCloneSaveVO;
import com.elitescloud.cloudt.system.model.vo.save.role.RoleSaveVO;
import com.elitescloud.cloudt.system.service.RoleMngService;
import com.elitescloud.cloudt.system.service.common.constant.BelongType;
import com.elitescloud.cloudt.system.service.manager.PermissionMngManager;
import com.elitescloud.cloudt.system.service.manager.RoleMngManager;
import com.elitescloud.cloudt.system.service.model.bo.SysRoleSaveBO;
import com.elitescloud.cloudt.system.service.model.entity.SysRoleDO;
import com.elitescloud.cloudt.system.service.repo.RoleGroupRepoProc;
import com.elitescloud.cloudt.system.service.repo.RoleRepoProc;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
@TenantTransaction(isolateType=TenantIsolateType.TENANT)
@TenantOrgTransaction(useTenantOrg=false)
public class RoleMngServiceImpl
extends BaseServiceImpl
implements RoleMngService {
    private static final Logger log = LogManager.getLogger(RoleMngServiceImpl.class);
    private static final RoleConvert CONVERT = RoleConvert.INSTANCE;
    @Autowired
    private RoleRepoProc roleRepoProc;
    @Autowired
    private RoleGroupRepoProc roleGroupRepoProc;
    @Autowired
    private RoleMngManager roleManager;
    @Autowired
    private PermissionMngManager permissionManager;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> save(RoleSaveVO saveVO, BelongType.Belonger belonger) {
        SysRoleSaveBO saveBO = CONVERT.saveVo2SaveBO(saveVO);
        if (belonger == null) {
            belonger = BelongType.getBelonger((boolean)false);
        }
        saveBO.setType(belonger.getBelongType().toString());
        saveBO.setTypeId(belonger.getBelongId());
        SysRoleDO roleDO = this.roleManager.upsert(saveBO);
        return ApiResult.ok((Object)roleDO.getId());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> saveClone(RoleCloneSaveVO cloneSaveVO) {
        Assert.notNull((Object)cloneSaveVO.getOriginalId(), (String)"\u8bf7\u9009\u62e9\u8981\u590d\u5236\u7684\u89d2\u8272");
        SysRoleDO originalRole = (SysRoleDO)this.roleRepoProc.get(cloneSaveVO.getOriginalId());
        if (originalRole == null) {
            return ApiResult.fail((String)"\u89d2\u8272\u4e0d\u5b58\u5728");
        }
        RoleSaveVO saveVO = CONVERT.cloneSaveVo2SaveVo(cloneSaveVO);
        ApiResult<Long> saveResult = this.save(saveVO, new BelongType.Belonger(new BelongType(originalRole.getType()), originalRole.getTypeId()));
        if (saveResult.isFailed() || saveResult.getData() == null) {
            return saveResult;
        }
        this.permissionManager.cloneRolePermission(cloneSaveVO.getOriginalId(), (Long)saveResult.getData(), (Boolean)ObjectUtil.defaultIfNull((Object)cloneSaveVO.getWithSec(), (Object)true), (Boolean)ObjectUtil.defaultIfNull((Object)cloneSaveVO.getWithDataSec(), (Object)true));
        return saveResult;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> updateEnabled(Long id) {
        Boolean enabled = this.roleRepoProc.getEnabled(id);
        enabled = enabled == null || enabled == false;
        this.roleManager.updateEnabled(id, enabled);
        return ApiResult.ok((Object)id);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> updateName(Long id, String name) {
        Assert.notNull((Object)id, (String)"ID\u4e3a\u7a7a");
        Assert.hasText((String)name, (String)"\u89d2\u8272\u540d\u79f0\u4e3a\u7a7a");
        this.roleManager.updateName(id, name);
        return ApiResult.ok((Object)id);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> delete(Long id) {
        this.roleManager.delete(id);
        return ApiResult.ok((Object)id);
    }

    @Override
    public ApiResult<RoleDetailRespVO> get(Long id) {
        return this.roleRepoProc.getOptional(id).map(t -> {
            RoleDetailRespVO vo = CONVERT.do2DetailRespVO((SysRoleDO)t);
            vo.setBusinessKeyName(super.udcValue((BaseUdc)new SysRoleBusiness(vo.getBusinessKey())));
            if (t.getGroupId() == null || t.getGroupId() == -1L) {
                vo.setGroupName("\u9ed8\u8ba4\u5206\u7ec4");
            } else {
                vo.setGroupName(this.roleGroupRepoProc.getName(t.getGroupId()));
            }
            return vo;
        }).map(ApiResult::ok).orElse(ApiResult.noData());
    }

    @Override
    public ApiResult<PagingVO<RolePageRespVO>> page(RolePageQueryVO queryVO, BelongType.Belonger belonger) {
        Map businessKeyNameMap = super.udcMap((BaseUdc)new SysRoleBusiness());
        HashSet<Long> groupIds = new HashSet<Long>(16);
        PagingVO pageResult = this.roleRepoProc.pageMng(belonger, queryVO).map(t -> {
            RolePageRespVO vo = CONVERT.do2PageRespVO((SysRoleDO)t);
            vo.setBusinessKeyName((String)businessKeyNameMap.get(vo.getBusinessKey()));
            if (t.getGroupId() == null || -1L == t.getGroupId()) {
                vo.setGroupId(-1L);
                vo.setGroupName("\u9ed8\u8ba4\u5206\u7ec4");
            } else {
                groupIds.add(t.getGroupId());
            }
            return vo;
        });
        if (!groupIds.isEmpty()) {
            Map<Long, String> groupMap = this.roleGroupRepoProc.queryByList(groupIds).stream().collect(Collectors.toMap(IdCodeNameParam::getId, IdCodeNameParam::getName, (t1, t2) -> t1));
            pageResult.each(t -> {
                if (t.getGroupId() != null && t.getGroupId() != -1L) {
                    t.setGroupName((String)groupMap.get(t.getGroupId()));
                }
            });
        }
        return ApiResult.ok((Object)pageResult);
    }

    @Override
    public ApiResult<List<GroupRoleRespVO>> listGroupRole(Boolean showDisabled, BelongType.Belonger belonger) {
        if (showDisabled == null) {
            showDisabled = false;
        }
        List<GroupRoleRespVO> roleList = this.roleManager.listGroupRole(showDisabled, BelongType.getBelongerPersonal());
        return ApiResult.ok(roleList);
    }
}

