/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.service.impl;

import com.elitescloud.boot.common.param.IdCodeNameParam;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.model.entity.QSysPositionDO;
import com.elitescloud.cloudt.system.model.entity.SysPositionDO;
import com.elitescloud.cloudt.system.model.entity.SysPositionOrgDO;
import com.elitescloud.cloudt.system.model.entity.SysPositionRoleDO;
import com.elitescloud.cloudt.system.model.vo.query.position.OrgVo;
import com.elitescloud.cloudt.system.model.vo.query.position.RoleVo;
import com.elitescloud.cloudt.system.model.vo.query.position.SysPositionConvert;
import com.elitescloud.cloudt.system.model.vo.query.position.SysPositionQueryVo;
import com.elitescloud.cloudt.system.model.vo.query.position.SysPositionSaveVo;
import com.elitescloud.cloudt.system.model.vo.query.position.SysPositionVo;
import com.elitescloud.cloudt.system.service.OrgQueryService;
import com.elitescloud.cloudt.system.service.RoleQueryService;
import com.elitescloud.cloudt.system.service.SysPositionService;
import com.elitescloud.cloudt.system.service.repo.SysPositionOrgRepo;
import com.elitescloud.cloudt.system.service.repo.SysPositionRepo;
import com.elitescloud.cloudt.system.service.repo.SysPositionRoleRepo;
import com.elitescloud.cloudt.system.service.util.JpaPredicateBuilder;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.StringPath;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Service
public class SysPositionServiceImpl
implements SysPositionService {
    private static final Logger log = LoggerFactory.getLogger(SysPositionServiceImpl.class);
    private final SysPositionRepo sysPositionRepository;
    private final SysPositionOrgRepo sysPositionOrgRepo;
    private final SysPositionRoleRepo sysPositionRoleRepo;
    private final RoleQueryService roleQueryService;
    private final OrgQueryService orgQueryService;

    public SysPositionServiceImpl(SysPositionRepo sysPositionRepository, SysPositionOrgRepo sysPositionOrgRepo, SysPositionRoleRepo sysPositionRoleRepo, RoleQueryService roleQueryService, OrgQueryService orgQueryService) {
        this.sysPositionRepository = sysPositionRepository;
        this.sysPositionOrgRepo = sysPositionOrgRepo;
        this.sysPositionRoleRepo = sysPositionRoleRepo;
        this.roleQueryService = roleQueryService;
        this.orgQueryService = orgQueryService;
    }

    @Override
    public ApiResult<List<SysPositionVo>> getAllPositions(SysPositionQueryVo positionParam) {
        QSysPositionDO qdo = QSysPositionDO.sysPositionDO;
        Predicate predicate = JpaPredicateBuilder.builder().and(arg_0 -> ((StringPath)qdo.positionCode).eq(arg_0), (Object)positionParam.getPositionCode()).and(arg_0 -> ((StringPath)qdo.positionName).eq(arg_0), (Object)positionParam.getPositionName()).and(arg_0 -> ((StringPath)qdo.positionDescription).like(arg_0), StringUtils.hasText((String)positionParam.getPositionDescription()) ? "%" + positionParam.getPositionDescription() + "%" : null).getPredicate();
        ArrayList sysPositionDOS = new ArrayList();
        this.sysPositionRepository.findAll(predicate).iterator().forEachRemaining(positionDO -> sysPositionDOS.add(positionDO));
        if (sysPositionDOS != null) {
            List sysPositionVos = sysPositionDOS.stream().map(sysPositionDO -> {
                SysPositionVo sysPositionVo = SysPositionConvert.INSTANCE.doToVo((SysPositionDO)((Object)sysPositionDO));
                List<OrgVo> orgCode = this.findOrgsByPosition(sysPositionDO.getPositionCode());
                List<RoleVo> roleCode = this.findRolesByPosition(sysPositionDO.getPositionCode());
                sysPositionVo.setRoleList(roleCode);
                sysPositionVo.setOrgList(orgCode);
                return sysPositionVo;
            }).collect(Collectors.toList());
            return ApiResult.ok(sysPositionVos);
        }
        return ApiResult.ok(new ArrayList());
    }

    @Override
    public List<RoleVo> findRolesByPosition(String positionCode) {
        Set<String> roleCodes = this.sysPositionRoleRepo.findByPositionCode(positionCode).stream().map(sysPositionRoleDO -> sysPositionRoleDO.getRoleCode()).collect(Collectors.toSet());
        if (roleCodes == null || roleCodes.size() == 0) {
            return new ArrayList<RoleVo>();
        }
        ApiResult<List<IdCodeNameParam>> apiResult = this.roleQueryService.listCodeNamesByCode(roleCodes);
        if (apiResult.isSuccess() && apiResult.getData() != null && ((List)apiResult.getData()).size() > 0) {
            return ((List)apiResult.getData()).stream().map(idCodeNameParam -> {
                RoleVo roleVo = new RoleVo();
                roleVo.setRoleCode(idCodeNameParam.getCode());
                roleVo.setRoleName(idCodeNameParam.getName());
                roleVo.setRoleId(idCodeNameParam.getId());
                return roleVo;
            }).collect(Collectors.toList());
        }
        log.error("\u89d2\u8272\u67e5\u8be2\u5931\u8d25\uff1a" + String.valueOf(roleCodes));
        return new ArrayList<RoleVo>();
    }

    @Override
    public List<OrgVo> findOrgsByPosition(String positionCode) {
        Set<String> orgCodes = this.sysPositionOrgRepo.findByPositionCode(positionCode).stream().map(sysPositionRoleDO -> sysPositionRoleDO.getOrgCode()).collect(Collectors.toSet());
        if (orgCodes == null || orgCodes.size() == 0) {
            return new ArrayList<OrgVo>();
        }
        ApiResult<List<IdCodeNameParam>> apiResult = this.orgQueryService.queryIdAndName(orgCodes);
        if (apiResult.isSuccess() && apiResult.getData() != null && ((List)apiResult.getData()).size() > 0) {
            return ((List)apiResult.getData()).stream().map(idCodeNameParam -> {
                OrgVo orgVo = new OrgVo();
                orgVo.setOrgCode(idCodeNameParam.getCode());
                orgVo.setOrgName(idCodeNameParam.getName());
                orgVo.setOrgId(idCodeNameParam.getId());
                return orgVo;
            }).collect(Collectors.toList());
        }
        log.error("\u5d17\u4f4d\u67e5\u8be2\u5931\u8d25\uff1a" + String.valueOf(orgCodes));
        return new ArrayList<OrgVo>();
    }

    @Override
    public ApiResult<SysPositionVo> getPositionById(Long id) {
        SysPositionDO sysPositionDO = this.sysPositionRepository.findById(id).orElse(null);
        if (sysPositionDO != null) {
            SysPositionVo sysPositionVo = SysPositionConvert.INSTANCE.doToVo(sysPositionDO);
            List<OrgVo> orgCode = this.findOrgsByPosition(sysPositionDO.getPositionCode());
            List<RoleVo> roleCode = this.findRolesByPosition(sysPositionDO.getPositionCode());
            sysPositionVo.setRoleList(roleCode);
            sysPositionVo.setOrgList(orgCode);
            return ApiResult.ok((Object)sysPositionVo);
        }
        return ApiResult.fail((String)("id\u5c97\u4f4d\u4e0d\u5b58\u5728:" + id));
    }

    @Override
    public ApiResult<SysPositionVo> getPositionByCode(String positionCode) {
        SysPositionDO sysPositionDO = this.sysPositionRepository.findOneByPositionCode(positionCode);
        if (sysPositionDO != null) {
            SysPositionVo sysPositionVo = SysPositionConvert.INSTANCE.doToVo(sysPositionDO);
            List<OrgVo> orgCode = this.findOrgsByPosition(sysPositionDO.getPositionCode());
            List<RoleVo> roleCode = this.findRolesByPosition(sysPositionDO.getPositionCode());
            sysPositionVo.setRoleList(roleCode);
            sysPositionVo.setOrgList(orgCode);
            return ApiResult.ok((Object)sysPositionVo);
        }
        return ApiResult.fail((String)("\u5c97\u4f4d\u7de8\u78bc\u4e0d\u5b58\u5728:" + positionCode));
    }

    @Override
    @Transactional
    public ApiResult<Long> createPosition(SysPositionSaveVo position) {
        List<String> roleCode;
        List<SysPositionDO> sysPositionDOS = this.sysPositionRepository.findByPositionCode(position.getPositionCode());
        if (sysPositionDOS != null && sysPositionDOS.size() > 0) {
            throw new BusinessException("\u5c97\u4f4d\u7f16\u7801\u5df2\u5b58\u5728");
        }
        SysPositionDO sysPositionDO = new SysPositionDO();
        sysPositionDO.setPositionCode(position.getPositionCode());
        sysPositionDO.setPositionName(position.getPositionName());
        sysPositionDO.setPositionDescription(position.getPositionDescription());
        this.sysPositionRepository.save((Object)sysPositionDO);
        List<String> orgCodes = position.getOrgCodes();
        if (orgCodes != null && orgCodes.size() > 0) {
            List<SysPositionOrgDO> sysPositionOrgDOS = SysPositionServiceImpl.getSysPositionOrgDOS(position.getPositionCode(), orgCodes);
            this.sysPositionOrgRepo.saveAll(sysPositionOrgDOS);
        }
        if ((roleCode = position.getRoleCodes()) != null && roleCode.size() > 0) {
            List<SysPositionRoleDO> sysPositionRoleDOS = SysPositionServiceImpl.getSysPositionRoleDOS(position.getPositionCode(), roleCode);
            this.sysPositionRoleRepo.saveAll(sysPositionRoleDOS);
        }
        return ApiResult.ok((Object)sysPositionDO.getId());
    }

    @Override
    @Transactional
    public ApiResult<Boolean> updatePosition(Long id, SysPositionSaveVo updateParam) {
        List<String> roleCode;
        SysPositionDO existingPosition = (SysPositionDO)((Object)this.sysPositionRepository.findById(id).orElseThrow(() -> new BusinessException("\u5c97\u4f4dID\u4e0d\u5b58\u5728:" + id)));
        existingPosition.setPositionName(updateParam.getPositionName());
        existingPosition.setPositionDescription(updateParam.getPositionDescription());
        this.sysPositionRepository.save((Object)existingPosition);
        List<String> orgCodes = updateParam.getOrgCodes();
        if (orgCodes != null && orgCodes.size() > 0) {
            this.sysPositionOrgRepo.deleteByPositionCode(existingPosition.getPositionCode());
            List<SysPositionOrgDO> sysPositionOrgDOS = SysPositionServiceImpl.getSysPositionOrgDOS(existingPosition.getPositionCode(), orgCodes);
            this.sysPositionOrgRepo.saveAll(sysPositionOrgDOS);
        }
        if ((roleCode = updateParam.getRoleCodes()) != null && roleCode.size() > 0) {
            this.sysPositionRoleRepo.deleteByPositionCode(existingPosition.getPositionCode());
            List<SysPositionRoleDO> sysPositionRoleDOS = SysPositionServiceImpl.getSysPositionRoleDOS(existingPosition.getPositionCode(), roleCode);
            this.sysPositionRoleRepo.saveAll(sysPositionRoleDOS);
        }
        return ApiResult.ok((Object)true);
    }

    @NotNull
    private static List<SysPositionOrgDO> getSysPositionOrgDOS(String positionCode, List<String> orgCodes) {
        List<SysPositionOrgDO> sysPositionOrgDOS = orgCodes.stream().map(s -> {
            SysPositionOrgDO sysPositionOrgDO = new SysPositionOrgDO();
            sysPositionOrgDO.setOrgCode((String)s);
            sysPositionOrgDO.setPositionCode(positionCode);
            return sysPositionOrgDO;
        }).collect(Collectors.toList());
        return sysPositionOrgDOS;
    }

    @NotNull
    private static List<SysPositionRoleDO> getSysPositionRoleDOS(String positionCode, List<String> roleCode) {
        List<SysPositionRoleDO> sysPositionRoleDOS = roleCode.stream().map(s -> {
            SysPositionRoleDO sysPositionOrgDO = new SysPositionRoleDO();
            sysPositionOrgDO.setRoleCode((String)s);
            sysPositionOrgDO.setPositionCode(positionCode);
            return sysPositionOrgDO;
        }).collect(Collectors.toList());
        return sysPositionRoleDOS;
    }

    @Override
    public ApiResult<Boolean> deletePosition(Long id) {
        this.sysPositionRepository.deleteById(id);
        return ApiResult.ok((Object)true);
    }

    @Override
    public ApiResult<Boolean> deleteAllById(List<Long> id) {
        this.sysPositionRepository.deleteAllById(id);
        return ApiResult.ok((Object)true);
    }
}

