/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.BooleanUtil;
import cn.hutool.core.util.ObjectUtil;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.annotation.TenantOrgTransaction;
import com.elitescloud.cloudt.core.annotation.TenantTransaction;
import com.elitescloud.cloudt.core.annotation.common.TenantIsolateType;
import com.elitescloud.cloudt.system.constant.SysNumType;
import com.elitescloud.cloudt.system.convert.UdcConvert;
import com.elitescloud.cloudt.system.dto.SysTenantDTO;
import com.elitescloud.cloudt.system.model.bo.SysUdcBO;
import com.elitescloud.cloudt.system.model.bo.SysUdcValueBO;
import com.elitescloud.cloudt.system.seq.model.bo.SysSeqNextNumberBO;
import com.elitescloud.cloudt.system.seq.model.bo.SysSeqRuleBO;
import com.elitescloud.cloudt.system.seq.model.bo.SysSeqRuleDtlBO;
import com.elitescloud.cloudt.system.seq.service.repo.SeqNextNumRepoProc;
import com.elitescloud.cloudt.system.seq.service.repo.SeqRuleDtlRepoProc;
import com.elitescloud.cloudt.system.seq.service.repo.SeqRuleRepoProc;
import com.elitescloud.cloudt.system.service.SysTenantBasicDataService;
import com.elitescloud.cloudt.system.service.model.entity.SysPlatformNextNumberDO;
import com.elitescloud.cloudt.system.service.model.entity.SysPlatformNumberRuleDO;
import com.elitescloud.cloudt.system.service.model.entity.SysPlatformNumberRuleDtlDO;
import com.elitescloud.cloudt.system.service.model.entity.SysPlatformUdcDO;
import com.elitescloud.cloudt.system.service.model.entity.SysPlatformUdcValueDO;
import com.elitescloud.cloudt.system.service.repo.SysTenantAppRepoProc;
import com.elitescloud.cloudt.system.service.repo.UdcRepoProc;
import com.elitescloud.cloudt.system.service.repo.UdcValueRepoProc;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
@TenantTransaction(isolateType=TenantIsolateType.DEFAULT)
@TenantOrgTransaction(useTenantOrg=false)
public class SysTenantBasicDataServiceImpl
extends BaseServiceImpl
implements SysTenantBasicDataService {
    private static final Logger log = LogManager.getLogger(SysTenantBasicDataServiceImpl.class);
    private static final UdcConvert CONVERT_UDC = UdcConvert.INSTANCE;
    @Autowired
    private UdcRepoProc udcRepoProc;
    @Autowired
    private UdcValueRepoProc udcValueRepoProc;
    @Autowired
    private SeqNextNumRepoProc nextNumRepoProc;
    @Autowired
    private SeqRuleRepoProc seqRuleRepoProc;
    @Autowired
    private SeqRuleDtlRepoProc seqRuleDtlRepoProc;
    @Autowired
    private SysTenantAppRepoProc tenantAppRepoProc;

    public ApiResult<Boolean> syncUdc(Long tenantId) {
        SysTenantDTO tenant = this.tenantClientProvider.getTenant(tenantId);
        if (tenant == null) {
            return ApiResult.fail((String)"\u79df\u6237\u4e0d\u5b58\u5728");
        }
        Set appCodes = this.tenantAppRepoProc.getAppCode(tenantId);
        if (appCodes.isEmpty()) {
            return ApiResult.fail((String)"\u79df\u6237\u5c1a\u672a\u7ed1\u5b9a\u5e94\u7528");
        }
        for (String appCode : appCodes) {
            int page = 0;
            int pageSize = 20;
            log.info("\u5411\u79df\u6237\u3010{}\u3011\u540c\u6b65UDC\u3010{}\u3011...", (Object)tenantId, (Object)appCode);
            PagingVO<SysUdcBO> pageUdc = this.queryUdc(page, pageSize, appCode);
            while (!pageUdc.isEmpty()) {
                this.syncUdcToTenant(tenant, appCode, pageUdc.getRecords());
                pageUdc = this.queryUdc(++page, pageSize, appCode);
            }
        }
        return ApiResult.ok((Object)true);
    }

    public ApiResult<Boolean> syncUdc(String appCode, String udcCode) {
        if (CharSequenceUtil.hasBlank((CharSequence[])new CharSequence[]{appCode, udcCode})) {
            return ApiResult.fail((String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        SysUdcBO udcBO = this.udcRepoProc.getBoByAppCodeAndUdcCode(appCode, udcCode);
        List<SysUdcValueBO> udcValueBoList = this.udcValueRepoProc.listBoByUdc(appCode, udcCode, true);
        if (udcBO == null || CollUtil.isEmpty(udcValueBoList)) {
            CompletableFuture.runAsync(() -> this.tenantDataIsolateProvider.byAllTenant(() -> {
                this.executeDeleteUdc(appCode, udcCode);
                this.udcProvider.clearCache(appCode, udcCode);
                return null;
            }));
            return ApiResult.ok((Object)true);
        }
        udcBO.setValueList(udcValueBoList);
        CompletableFuture.runAsync(() -> this.tenantDataIsolateProvider.byAllTenant(() -> {
            this.executeSyncUdc(appCode, List.of(udcBO));
            this.udcProvider.clearCache(appCode, udcCode);
            return null;
        }));
        return ApiResult.ok((Object)true);
    }

    public ApiResult<Boolean> syncSequence(Long tenantId) {
        SysTenantDTO tenant = this.tenantClientProvider.getTenant(tenantId);
        if (tenant == null) {
            return ApiResult.fail((String)"\u79df\u6237\u4e0d\u5b58\u5728");
        }
        Set appCodes = this.tenantAppRepoProc.getAppCode(tenantId);
        if (appCodes.isEmpty()) {
            return ApiResult.fail((String)"\u79df\u6237\u5c1a\u672a\u7ed1\u5b9a\u5e94\u7528");
        }
        for (String appCode : appCodes) {
            int page = 0;
            int pageSize = 20;
            log.info("\u5411\u79df\u6237\u3010{}\u3011\u540c\u6b65\u4e0b\u4e00\u7f16\u53f7\u3010{}\u3011...", (Object)tenantId, (Object)appCode);
            PagingVO<SysSeqNextNumberBO> pageNextNum = this.queryNextNum(page, pageSize, appCode);
            while (!pageNextNum.isEmpty()) {
                this.syncNextNumToTenant(tenant, appCode, pageNextNum.getRecords());
                pageNextNum = this.queryNextNum(++page, pageSize, appCode);
            }
            log.info("\u5411\u79df\u6237\u3010{}\u3011\u540c\u6b65\u53d1\u53f7\u89c4\u5219\u3010{}\u3011...", (Object)tenantId, (Object)appCode);
            page = 0;
            PagingVO<SysSeqRuleBO> pageRule = this.querySeqRule(page, pageSize, appCode);
            while (!pageRule.isEmpty()) {
                this.syncSeqRuleToTenant(tenant, appCode, pageRule.getRecords());
                pageRule = this.querySeqRule(++page, pageSize, appCode);
            }
        }
        return ApiResult.ok((Object)true);
    }

    public ApiResult<Boolean> syncSequence(String appCode, String ruleCode) {
        if (CharSequenceUtil.hasBlank((CharSequence[])new CharSequence[]{appCode, ruleCode})) {
            return ApiResult.fail((String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        SysSeqRuleBO rule = this.seqRuleRepoProc.getBo(appCode, ruleCode);
        if (rule == null) {
            CompletableFuture.runAsync(() -> this.tenantDataIsolateProvider.byAllTenant(() -> {
                this.executeDeleteSeqRule(appCode, ruleCode);
                return null;
            }));
            return ApiResult.ok((Object)true);
        }
        List detailList = this.seqRuleDtlRepoProc.queryBoByRuleId(rule.getId());
        rule.setRuleDtlList(detailList);
        Set nextNumberCodes = detailList.stream().filter(t -> CharSequenceUtil.equals((CharSequence)t.getNumberType(), (CharSequence)SysNumType.NN.name())).map(SysSeqRuleDtlBO::getNumberPattern).filter(StringUtils::hasText).collect(Collectors.toSet());
        rule.setNextNumberList(this.nextNumRepoProc.getBoByCode(appCode, nextNumberCodes));
        CompletableFuture.runAsync(() -> this.tenantDataIsolateProvider.byAllTenant(() -> {
            this.executeSyncSeqRule(rule);
            return null;
        }));
        return ApiResult.ok((Object)true);
    }

    private PagingVO<SysSeqNextNumberBO> queryNextNum(Integer page, Integer pageSize, String appCode) {
        return this.nextNumRepoProc.pageBo(page.intValue(), pageSize.intValue(), appCode);
    }

    private void syncNextNumToTenant(SysTenantDTO tenant, String appCode, List<SysSeqNextNumberBO> nextNumberSystem) {
        this.tenantDataIsolateProvider.byTenantDirectly(() -> {
            List existsCodes = this.nextNumRepoProc.allCodes(appCode);
            List nextNumberDoList = nextNumberSystem.stream().filter(t -> !existsCodes.contains(t.getCode())).map(t -> {
                SysPlatformNextNumberDO nextNumberDO = new SysPlatformNextNumberDO();
                nextNumberDO.setAppCode(t.getAppCode());
                nextNumberDO.setCode(t.getCode());
                nextNumberDO.setName(t.getName());
                nextNumberDO.setStep(t.getStep());
                nextNumberDO.setNextNumber(Long.valueOf(1L));
                nextNumberDO.setNnPeriod(t.getNnPeriod());
                nextNumberDO.setVersion(Integer.valueOf(1));
                nextNumberDO.setEnabled((Boolean)ObjectUtil.defaultIfNull((Object)t.getEnabled(), (Object)true));
                nextNumberDO.setInternal(Boolean.valueOf(true));
                nextNumberDO.setRemark(t.getRemark());
                return nextNumberDO;
            }).collect(Collectors.toList());
            if (!nextNumberDoList.isEmpty()) {
                this.nextNumRepoProc.save(nextNumberDoList);
            }
            return null;
        }, tenant);
    }

    private PagingVO<SysSeqRuleBO> querySeqRule(Integer page, Integer pageSize, String appCode) {
        PagingVO pageRule = this.seqRuleRepoProc.pageBo(page.intValue(), pageSize.intValue(), appCode);
        if (pageRule.isEmpty()) {
            return pageRule;
        }
        Set ruleIds = pageRule.getRecords().stream().map(SysSeqRuleBO::getId).collect(Collectors.toSet());
        Map ruleDtlMap = this.seqRuleDtlRepoProc.listBo(ruleIds);
        pageRule.each(t -> t.setRuleDtlList((List)ObjectUtil.defaultIfNull((Object)((List)ruleDtlMap.get(t.getId())), Collections.emptyList())));
        return pageRule;
    }

    private void syncSeqRuleToTenant(SysTenantDTO tenant, String appCode, List<SysSeqRuleBO> ruleSystem) {
        this.tenantDataIsolateProvider.byTenantDirectly(() -> {
            List existsCodes = this.seqRuleRepoProc.allCodes(appCode);
            for (SysSeqRuleBO sysSeqRuleBO : ruleSystem) {
                if (existsCodes.contains(sysSeqRuleBO.getRuleCode()) || CollUtil.isEmpty((Collection)sysSeqRuleBO.getRuleDtlList())) continue;
                SysPlatformNumberRuleDO numberRuleDO = new SysPlatformNumberRuleDO();
                numberRuleDO.setAppCode(sysSeqRuleBO.getAppCode());
                numberRuleDO.setRuleCode(sysSeqRuleBO.getRuleCode());
                numberRuleDO.setRuleName(sysSeqRuleBO.getRuleName());
                numberRuleDO.setSampleCode(sysSeqRuleBO.getSampleCode());
                numberRuleDO.setEnabled((Boolean)ObjectUtil.defaultIfNull((Object)sysSeqRuleBO.getEnabled(), (Object)true));
                numberRuleDO.setRemark(sysSeqRuleBO.getRemark());
                numberRuleDO.setTenantCustom(Boolean.valueOf(false));
                this.seqRuleRepoProc.save((Serializable)numberRuleDO);
                AtomicInteger seq = new AtomicInteger(1);
                List numberRuleDtlList = sysSeqRuleBO.getRuleDtlList().stream().map(t -> {
                    SysPlatformNumberRuleDtlDO ruleDtlDO = new SysPlatformNumberRuleDtlDO();
                    ruleDtlDO.setAppCode(t.getAppCode());
                    ruleDtlDO.setRuleId(numberRuleDO.getId());
                    ruleDtlDO.setSeq((Integer)ObjectUtil.defaultIfNull((Object)t.getSeq(), (Object)seq.getAndIncrement()));
                    ruleDtlDO.setNumberType(t.getNumberType());
                    ruleDtlDO.setNumberPattern(t.getNumberPattern());
                    ruleDtlDO.setNnLen(t.getNnLen());
                    ruleDtlDO.setRemark(t.getRemark());
                    return ruleDtlDO;
                }).collect(Collectors.toList());
                this.seqRuleDtlRepoProc.save(numberRuleDtlList);
            }
            return null;
        }, tenant);
    }

    private void executeSyncSeqRule(SysSeqRuleBO seqRuleBO) {
        SysPlatformNumberRuleDO ruleDO = this.seqRuleRepoProc.get(seqRuleBO.getAppCode(), seqRuleBO.getRuleCode());
        if (ruleDO == null) {
            ruleDO = new SysPlatformNumberRuleDO();
            ruleDO.setAppCode(seqRuleBO.getAppCode());
            ruleDO.setRuleCode(seqRuleBO.getRuleCode());
            ruleDO.setRuleName(seqRuleBO.getRuleName());
            ruleDO.setSampleCode(seqRuleBO.getSampleCode());
            ruleDO.setEnabled((Boolean)ObjectUtil.defaultIfNull((Object)seqRuleBO.getEnabled(), (Object)true));
            ruleDO.setRemark(seqRuleBO.getRemark());
            ruleDO.setTenantCustom(Boolean.valueOf(false));
            this.seqRuleRepoProc.save((Serializable)ruleDO);
        }
        if (Boolean.TRUE.equals(ruleDO.getTenantCustom())) {
            return;
        }
        ruleDO.setRuleName(seqRuleBO.getRuleName());
        ruleDO.setSampleCode(seqRuleBO.getSampleCode());
        ruleDO.setEnabled(seqRuleBO.getEnabled());
        this.seqRuleRepoProc.save((Serializable)ruleDO);
        AtomicInteger seq = new AtomicInteger(1);
        this.seqRuleDtlRepoProc.deleteByRuleId(ruleDO.getId());
        SysPlatformNumberRuleDO finalRuleDO = ruleDO;
        List numberRuleDtlList = seqRuleBO.getRuleDtlList().stream().map(t -> {
            SysPlatformNumberRuleDtlDO ruleDtlDO = new SysPlatformNumberRuleDtlDO();
            ruleDtlDO.setAppCode(t.getAppCode());
            ruleDtlDO.setRuleId(finalRuleDO.getId());
            ruleDtlDO.setSeq((Integer)ObjectUtil.defaultIfNull((Object)t.getSeq(), (Object)seq.getAndIncrement()));
            ruleDtlDO.setNumberType(t.getNumberType());
            ruleDtlDO.setNumberPattern(t.getNumberPattern());
            ruleDtlDO.setNnLen(t.getNnLen());
            ruleDtlDO.setRemark(t.getRemark());
            return ruleDtlDO;
        }).collect(Collectors.toList());
        this.seqRuleDtlRepoProc.save(numberRuleDtlList);
        if (CollUtil.isNotEmpty((Collection)seqRuleBO.getNextNumberList())) {
            Set nextNumberCodes = seqRuleBO.getNextNumberList().stream().map(SysSeqNextNumberBO::getCode).collect(Collectors.toSet());
            Map<String, SysPlatformNextNumberDO> nextNumberMap = this.nextNumRepoProc.getByCode(seqRuleBO.getAppCode(), nextNumberCodes).stream().collect(Collectors.toMap(SysPlatformNextNumberDO::getCode, t -> t, (t1, t2) -> t1));
            ArrayList<SysPlatformNextNumberDO> nextNumberList = new ArrayList<SysPlatformNextNumberDO>();
            for (SysSeqNextNumberBO sysSeqNextNumberBO : seqRuleBO.getNextNumberList()) {
                SysPlatformNextNumberDO nextNumberDO = nextNumberMap.get(sysSeqNextNumberBO.getCode());
                if (nextNumberDO == null) {
                    nextNumberDO = new SysPlatformNextNumberDO();
                    nextNumberDO.setAppCode(sysSeqNextNumberBO.getAppCode());
                    nextNumberDO.setCode(sysSeqNextNumberBO.getCode());
                    nextNumberDO.setNextNumber(Long.valueOf(1L));
                    nextNumberDO.setVersion(Integer.valueOf(1));
                }
                nextNumberDO.setName(sysSeqNextNumberBO.getName());
                nextNumberDO.setNnPeriod(sysSeqNextNumberBO.getNnPeriod());
                nextNumberDO.setStep(sysSeqNextNumberBO.getStep());
                nextNumberDO.setEnabled((Boolean)ObjectUtil.defaultIfNull((Object)sysSeqNextNumberBO.getEnabled(), (Object)true));
                nextNumberDO.setRemark(sysSeqNextNumberBO.getRemark());
                nextNumberDO.setInternal(Boolean.valueOf(true));
                nextNumberList.add(nextNumberDO);
            }
            this.nextNumRepoProc.save(nextNumberList);
        }
    }

    private void executeDeleteSeqRule(String appCode, String ruleCode) {
        Long ruleId = this.seqRuleRepoProc.getIdByRuleCode(appCode, ruleCode);
        if (ruleId == null) {
            return;
        }
        this.seqRuleDtlRepoProc.deleteByRuleId(ruleId);
        this.seqRuleRepoProc.delete(ruleId.longValue());
    }

    private PagingVO<SysUdcBO> queryUdc(Integer page, Integer pageSize, String appCode) {
        PagingVO<SysUdcBO> pageUdc = this.udcRepoProc.pageAll(page, pageSize, appCode);
        if (pageUdc.isEmpty()) {
            return pageUdc;
        }
        Set<String> udcCodes = pageUdc.getRecords().stream().map(SysUdcBO::getUdcCode).filter(StringUtils::hasText).collect(Collectors.toSet());
        Map<String, List<SysUdcValueBO>> udcValueMap = this.udcValueRepoProc.queryBoByUdc(appCode, udcCodes, true).stream().collect(Collectors.groupingBy(SysUdcValueBO::getUdcCode));
        pageUdc.each(t -> t.setValueList((List)ObjectUtil.defaultIfNull((Object)((List)udcValueMap.get(t.getUdcCode())), Collections.emptyList())));
        return pageUdc;
    }

    private void syncUdcToTenant(SysTenantDTO tenant, String appCode, List<SysUdcBO> udcSystem) {
        this.tenantDataIsolateProvider.byTenantDirectly(() -> {
            this.executeSyncUdc(appCode, udcSystem);
            this.udcProvider.clearCache(appCode, null);
            return null;
        }, tenant);
    }

    private void executeDeleteUdc(String appCode, String udcCode) {
        this.udcRepoProc.delete(appCode, udcCode);
        this.udcValueRepoProc.delete(appCode, udcCode);
    }

    private void executeSyncUdc(String appCode, List<SysUdcBO> udcSystem) {
        Set<String> udcCodes = udcSystem.stream().map(SysUdcBO::getUdcCode).collect(Collectors.toSet());
        Map<String, SysPlatformUdcDO> existsUdcMap = this.udcRepoProc.queryByUdcCode(appCode, udcCodes).stream().collect(Collectors.toMap(SysPlatformUdcDO::getUdcCode, t -> t, (t1, t2) -> t1));
        Map<String, List<SysPlatformUdcValueDO>> existsUdcValueMap = this.udcValueRepoProc.queryByUdc(appCode, udcCodes, true).stream().collect(Collectors.groupingBy(SysPlatformUdcValueDO::getUdcCode));
        ArrayList<SysPlatformUdcDO> udcList = new ArrayList<SysPlatformUdcDO>(udcCodes.size());
        ArrayList<SysPlatformUdcValueDO> udcValueList = new ArrayList<SysPlatformUdcValueDO>(128);
        HashSet<Long> udcValueIdToDel = new HashSet<Long>(128);
        for (SysUdcBO sysUdcBO : udcSystem) {
            SysPlatformUdcDO udcDO = existsUdcMap.get(sysUdcBO.getUdcCode());
            if (udcDO == null) {
                udcDO = new SysPlatformUdcDO();
            }
            Long udcId = udcDO.getId();
            String udcName = udcDO.getUdcName();
            CONVERT_UDC.copyUdcBO(sysUdcBO, udcDO);
            udcDO.setId(udcId);
            if (CharSequenceUtil.isNotBlank((CharSequence)udcName)) {
                udcDO.setUdcName(udcName);
            }
            udcList.add(udcDO);
            List<SysPlatformUdcValueDO> valueList = this.copyUdcValue(sysUdcBO, sysUdcBO.getValueList(), existsUdcValueMap.getOrDefault(sysUdcBO.getUdcCode().trim(), new ArrayList(16)));
            udcValueList.addAll(valueList);
            udcValueIdToDel.addAll(this.filterUdcValueIdToDel(sysUdcBO.getValueList(), valueList));
        }
        this.udcRepoProc.save(udcList);
        this.udcValueRepoProc.save(udcValueList);
        if (!udcValueIdToDel.isEmpty()) {
            this.udcValueRepoProc.delete(udcValueIdToDel);
        }
    }

    private List<SysPlatformUdcValueDO> copyUdcValue(SysUdcBO sysUdcBO, List<SysUdcValueBO> valueBOS, List<SysPlatformUdcValueDO> valueDOS) {
        Map<String, SysPlatformUdcValueDO> valueMap = valueDOS.stream().collect(Collectors.toMap(t -> t.getUdcValueCode().trim(), t -> t, (t1, t2) -> t1));
        ArrayList<SysPlatformUdcValueDO> valueList = new ArrayList<SysPlatformUdcValueDO>(valueDOS.size());
        HashSet<String> existsCodes = new HashSet<String>();
        for (SysUdcValueBO valueBO : valueBOS) {
            SysPlatformUdcValueDO valueDO = valueMap.get(valueBO.getUdcValueCode().trim());
            if (valueDO == null) {
                valueDO = new SysPlatformUdcValueDO();
                CONVERT_UDC.copyUdcValueBO(valueBO, valueDO);
                valueDO.setAllowDefault(Boolean.valueOf(true));
            } else {
                valueDO.setUdcValueName(valueBO.getUdcValueName());
                valueDO.setUdcOrder((Integer)ObjectUtil.defaultIfNull((Object)valueBO.getUdcOrder(), (Object)1));
                Boolean allowStart = valueDO.getAllowStart();
                if (Boolean.FALSE.equals(sysUdcBO.getAllowUpdate()) && Boolean.FALSE.equals(sysUdcBO.getAllowAddValue())) {
                    allowStart = valueBO.getAllowStart();
                }
                valueDO.setAllowStart((Boolean)ObjectUtil.defaultIfNull((Object)allowStart, (Object)valueBO.getAllowStart()));
                valueDO.setUdcValueDescribe(CharSequenceUtil.blankToDefault((CharSequence)valueDO.getUdcValueDescribe(), (String)valueBO.getUdcValueDescribe()));
                valueDO.setAllowDefault(Boolean.valueOf(true));
                if (StringUtils.hasText((String)valueBO.getParentUdcValueCode())) {
                    valueDO.setParentUdcValueCode(valueBO.getParentUdcValueCode());
                }
                valueDO.setValueAliasName(CharSequenceUtil.blankToDefault((CharSequence)valueDO.getValueAliasName(), (String)valueBO.getValueAliasName()));
            }
            valueList.add(valueDO);
            existsCodes.add(valueDO.getUdcValueCode());
        }
        for (SysPlatformUdcValueDO valueDO : valueDOS) {
            if (valueDO.getAllowDefault() == null || !valueDO.getAllowDefault().booleanValue() || existsCodes.contains(valueDO.getUdcValueCode())) continue;
            valueList.add(valueDO);
        }
        return valueList;
    }

    private Set<Long> filterUdcValueIdToDel(List<SysUdcValueBO> valueBOS, List<SysPlatformUdcValueDO> valueDOS) {
        Set valueCodes = valueBOS.stream().map(SysUdcValueBO::getUdcValueCode).collect(Collectors.toSet());
        HashSet<Long> toDel = new HashSet<Long>(8);
        for (SysPlatformUdcValueDO valueDO : valueDOS) {
            if (!BooleanUtil.isTrue((Boolean)valueDO.getAllowDefault()) || valueCodes.contains(valueDO.getUdcValueCode())) continue;
            toDel.add(valueDO.getId());
        }
        return toDel;
    }
}

