/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.service.impl;

import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.boot.common.BaseUdc;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.constant.TaxRateType;
import com.elitescloud.cloudt.core.annotation.TenantOrgTransaction;
import com.elitescloud.cloudt.core.annotation.TenantTransaction;
import com.elitescloud.cloudt.core.annotation.common.TenantIsolateType;
import com.elitescloud.cloudt.system.convert.TaxRateConvert;
import com.elitescloud.cloudt.system.dto.req.SysTaxRateQueryDTO;
import com.elitescloud.cloudt.system.dto.resp.SysTaxRateRespDTO;
import com.elitescloud.cloudt.system.model.vo.resp.common.CommonTaxRateRespVO;
import com.elitescloud.cloudt.system.service.TaxRateQueryService;
import com.elitescloud.cloudt.system.service.model.entity.SysTaxRateDO;
import com.elitescloud.cloudt.system.service.repo.TaxRateRepoProc;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
@TenantTransaction(isolateType=TenantIsolateType.TENANT)
@TenantOrgTransaction(useTenantOrg=false)
public class TaxRateQueryServiceImpl
extends BaseServiceImpl
implements TaxRateQueryService {
    private static final TaxRateConvert CONVERT = TaxRateConvert.INSTANCE;
    @Autowired
    private TaxRateRepoProc repoProc;

    @Override
    public ApiResult<List<CommonTaxRateRespVO>> queryList(String taxRateNo, String taxRateType) {
        List<CommonTaxRateRespVO> respVOList = this.repoProc.queryList(taxRateNo, taxRateType);
        if (respVOList.isEmpty()) {
            return ApiResult.ok(Collections.emptyList());
        }
        Map typeMap = super.udcMap((BaseUdc)TaxRateType.OUTPUT);
        for (CommonTaxRateRespVO respVO : respVOList) {
            respVO.setTaxRateTypeName((String)typeMap.get(respVO.getTaxRateType()));
        }
        return ApiResult.ok(respVOList);
    }

    @Override
    public ApiResult<SysTaxRateRespDTO> getByTaxRateNo(String taxRateNo) {
        return this.getByTaxRateNo(taxRateNo, null);
    }

    @Override
    public ApiResult<SysTaxRateRespDTO> getByTaxRateNo(String taxRateNo, String taxRateType) {
        Assert.hasText((String)taxRateNo, (String)"\u7a0e\u7387\u7f16\u53f7\u4e3a\u7a7a");
        SysTaxRateDO taxRateNoDO = this.repoProc.getByTaxRateNo(taxRateNo, taxRateType);
        if (taxRateNoDO == null) {
            return ApiResult.noData();
        }
        SysTaxRateRespDTO respDTO = CONVERT.do2DTO(taxRateNoDO);
        if (CharSequenceUtil.isNotBlank((CharSequence)respDTO.getTaxRateType())) {
            respDTO.setTaxRateTypeName(super.udcValue((BaseUdc)new TaxRateType(respDTO.getTaxRateType())));
        }
        return ApiResult.ok((Object)respDTO);
    }

    @Override
    public ApiResult<List<SysTaxRateRespDTO>> queryList(SysTaxRateQueryDTO queryDTO) {
        List<SysTaxRateDO> doList = this.repoProc.queryList(queryDTO);
        if (doList.isEmpty()) {
            return ApiResult.ok(Collections.emptyList());
        }
        Map typeMap = super.udcMap((BaseUdc)TaxRateType.OUTPUT);
        List dtoList = doList.stream().map(t -> {
            SysTaxRateRespDTO dto = CONVERT.do2DTO((SysTaxRateDO)t);
            dto.setTaxRateTypeName((String)typeMap.get(dto.getTaxRateType()));
            return dto;
        }).collect(Collectors.toList());
        return ApiResult.ok(dtoList);
    }
}

