/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.annotation.TenantOrgTransaction;
import com.elitescloud.cloudt.core.annotation.TenantTransaction;
import com.elitescloud.cloudt.core.annotation.common.TenantIsolateType;
import com.elitescloud.cloudt.system.constant.UserType;
import com.elitescloud.cloudt.system.dto.SysOrgBasicDTO;
import com.elitescloud.cloudt.system.dto.SysUserBasicDTO;
import com.elitescloud.cloudt.system.model.vo.query.org.TenantOrgPageQueryVO;
import com.elitescloud.cloudt.system.model.vo.resp.org.TenantOrgDetailRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.org.TenantOrgRespVO;
import com.elitescloud.cloudt.system.model.vo.save.org.OrgTenantSaveVO;
import com.elitescloud.cloudt.system.service.TenantOrgMngService;
import com.elitescloud.cloudt.system.service.manager.UserQueryManager;
import com.elitescloud.cloudt.system.service.model.entity.SysTenantOrgDO;
import com.elitescloud.cloudt.system.service.model.entity.SysUserTypeDO;
import com.elitescloud.cloudt.system.service.repo.OrgRepoProc;
import com.elitescloud.cloudt.system.service.repo.TenantOrgRepo;
import com.elitescloud.cloudt.system.service.repo.TenantOrgRepoProc;
import com.elitescloud.cloudt.system.service.repo.UserTypeRepoProc;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
@TenantTransaction(isolateType=TenantIsolateType.TENANT)
@TenantOrgTransaction(useTenantOrg=false)
public class TenantOrgMngServiceImpl
extends BaseServiceImpl
implements TenantOrgMngService {
    private static final Logger log = LogManager.getLogger(TenantOrgMngServiceImpl.class);
    @Autowired
    private TenantOrgRepo tenantOrgRepo;
    @Autowired
    private TenantOrgRepoProc tenantOrgRepoProc;
    @Autowired
    private UserTypeRepoProc userTypeRepoProc;
    @Autowired
    private OrgRepoProc orgRepoProc;
    @Autowired
    private UserQueryManager userQueryManager;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> saveTenantOrg(OrgTenantSaveVO saveVO) {
        SysTenantOrgDO tenantOrg = this.tenantOrgRepoProc.getByOrgId(saveVO.getOrgId());
        Long oldAdminId = null;
        if (tenantOrg == null) {
            tenantOrg = new SysTenantOrgDO();
        } else {
            oldAdminId = tenantOrg.getAdminId();
        }
        tenantOrg.setOrgId(saveVO.getOrgId());
        tenantOrg.setAdminId(saveVO.getAdminUserId());
        tenantOrg.setEnabled((Boolean)ObjectUtil.defaultIfNull((Object)saveVO.getEnabled(), (Object)true));
        this.tenantOrgRepo.save(tenantOrg);
        this.updateAdminUserType(oldAdminId, saveVO.getAdminUserId());
        return ApiResult.ok((Object)tenantOrg.getId());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> delete(Long id) {
        SysTenantOrgDO tenantOrgDO = (SysTenantOrgDO)this.tenantOrgRepoProc.get(id);
        if (tenantOrgDO == null) {
            return ApiResult.noData();
        }
        this.tenantOrgRepoProc.delete(id);
        if (tenantOrgDO.getAdminId() != null) {
            Long tenantId = super.currentTenantId();
            this.tenantDataIsolateProvider.byDefaultDirectly(() -> {
                this.userTypeRepoProc.delete(tenantOrgDO.getAdminId(), Set.of(UserType.ADMIN_ORG.getValue()), tenantId);
                return null;
            });
        }
        return ApiResult.ok((Object)id);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> updateEnabled(Long id) {
        Boolean enabled = this.tenantOrgRepoProc.getEnabled(id);
        enabled = enabled == null || enabled == false;
        this.tenantOrgRepoProc.updateEnabled(id, enabled);
        return ApiResult.ok();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> updateAdmin(Long id, Long adminId) {
        Long oldAdminId = this.tenantOrgRepoProc.getAdminId(id);
        if (oldAdminId != null && Objects.equals(oldAdminId, adminId)) {
            return ApiResult.ok((Object)id);
        }
        this.tenantOrgRepoProc.updateAdminId(id, adminId);
        this.updateAdminUserType(oldAdminId, adminId);
        return ApiResult.ok((Object)id);
    }

    @Override
    public ApiResult<TenantOrgDetailRespVO> getDetail(Long id) {
        SysTenantOrgDO tenantOrgDO = (SysTenantOrgDO)this.tenantOrgRepoProc.get(id);
        if (tenantOrgDO == null) {
            return ApiResult.noData();
        }
        TenantOrgDetailRespVO respVO = new TenantOrgDetailRespVO();
        respVO.setId(tenantOrgDO.getId());
        respVO.setOrgId(tenantOrgDO.getOrgId());
        respVO.setEnabled(tenantOrgDO.getEnabled());
        SysOrgBasicDTO org = this.orgRepoProc.getBasicDto(tenantOrgDO.getOrgId());
        if (org != null) {
            respVO.setOrgCode(org.getCode());
            respVO.setOrgName(org.getName());
        }
        SysUserBasicDTO admin = null;
        if (tenantOrgDO.getAdminId() != null && (admin = this.userQueryManager.getBasic(tenantOrgDO.getAdminId())) != null) {
            respVO.setAdminUserId(admin.getId());
            respVO.setAdminUsername(admin.getUsername());
            respVO.setAdminUser(admin.getFullName());
            respVO.setMobile(admin.getMobile());
        }
        return ApiResult.ok((Object)respVO);
    }

    @Override
    public ApiResult<List<TenantOrgRespVO>> getList() {
        List tenantOrgs = this.tenantOrgRepoProc.all();
        List<TenantOrgRespVO> tenantOrgList = this.tenantOrgDo2VoList(tenantOrgs);
        return ApiResult.ok(tenantOrgList);
    }

    @Override
    public ApiResult<PagingVO<TenantOrgRespVO>> pageQuery(TenantOrgPageQueryVO queryVO) {
        PagingVO<SysTenantOrgDO> pageTenantOrgDO = this.tenantOrgRepoProc.pageMng(queryVO);
        if (pageTenantOrgDO.isEmpty()) {
            return ApiResult.ok((Object)PagingVO.empty());
        }
        List<TenantOrgRespVO> tenantOrgList = this.tenantOrgDo2VoList(pageTenantOrgDO.getRecords());
        PagingVO pageData = PagingVO.builder().total(pageTenantOrgDO.getTotal()).records(tenantOrgList).build();
        return ApiResult.ok((Object)pageData);
    }

    private List<TenantOrgRespVO> tenantOrgDo2VoList(List<SysTenantOrgDO> orgDoList) {
        if (orgDoList.isEmpty()) {
            return Collections.emptyList();
        }
        Set<Long> orgIds = orgDoList.stream().map(SysTenantOrgDO::getOrgId).collect(Collectors.toSet());
        Set<Long> adminIds = orgDoList.stream().map(SysTenantOrgDO::getAdminId).filter(Objects::nonNull).collect(Collectors.toSet());
        Map<Long, SysOrgBasicDTO> orgMap = this.orgRepoProc.getBasicDtoList(orgIds).stream().collect(Collectors.toMap(SysOrgBasicDTO::getId, t -> t, (t1, t2) -> t1));
        Map<Long, SysUserBasicDTO> adminMap = this.userQueryManager.getBasic(adminIds).stream().collect(Collectors.toMap(SysUserBasicDTO::getId, t -> t, (t1, t2) -> t1));
        return orgDoList.stream().map(t -> {
            TenantOrgRespVO respVO = new TenantOrgRespVO();
            respVO.setId(t.getId());
            respVO.setOrgId(t.getOrgId());
            SysOrgBasicDTO org = (SysOrgBasicDTO)orgMap.get(t.getOrgId());
            if (org != null) {
                respVO.setOrgCode(org.getCode());
                respVO.setOrgName(org.getName());
            }
            if (t.getAdminId() != null) {
                respVO.setAdminUserId(t.getAdminId());
                SysUserBasicDTO admin = (SysUserBasicDTO)adminMap.get(t.getAdminId());
                if (admin != null) {
                    respVO.setAdminUsername(admin.getUsername());
                    respVO.setAdminUser(admin.getFullName());
                    respVO.setMobile(admin.getMobile());
                }
            }
            respVO.setEnabled(t.getEnabled());
            respVO.setCreateTime(t.getCreateTime());
            respVO.setModifyTime(t.getModifyTime());
            return respVO;
        }).collect(Collectors.toList());
    }

    private void updateAdminUserType(Long oldAdminId, Long adminUserId) {
        if (oldAdminId != null && !Objects.equals(oldAdminId, adminUserId)) {
            Long tenantId = super.currentTenantId();
            this.tenantDataIsolateProvider.byDefaultDirectly(() -> {
                this.userTypeRepoProc.delete(oldAdminId, Set.of(UserType.ADMIN_ORG.getValue()), tenantId);
                return null;
            });
        }
        if (adminUserId != null && !Objects.equals(oldAdminId, adminUserId)) {
            Long currentTenantId = super.currentTenantId();
            Assert.isTrue((boolean)this.userQueryManager.belongToTenant(adminUserId, currentTenantId), (String)"\u6307\u5b9a\u7528\u6237\u4e0d\u5c5e\u4e8e\u5f53\u524d\u79df\u6237");
            SysUserTypeDO userTypeDO = new SysUserTypeDO();
            userTypeDO.setUserId(adminUserId);
            userTypeDO.setType(UserType.ADMIN_ORG.getValue());
            this.userTypeRepoProc.save((Serializable)userTypeDO);
        }
    }
}

