/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.elitescloud.boot.CloudtContextProperties;
import com.elitescloud.boot.auth.util.SecurityContextUtil;
import com.elitescloud.boot.provider.TenantDataIsolateProvider;
import com.elitescloud.boot.task.retry.AbstractRetryService;
import com.elitescloud.boot.task.retry.RetryTask;
import com.elitescloud.boot.task.retry.RetryTaskProvider;
import com.elitescloud.boot.util.JSONUtil;
import com.elitescloud.boot.util.LockUtil;
import com.elitescloud.boot.util.RestTemplateFactory;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.config.SystemProperties;
import com.elitescloud.cloudt.system.dto.ThirdApiRetryParamDTO;
import com.elitescloud.cloudt.system.model.entity.SysThirdApiLogDO;
import com.elitescloud.cloudt.system.service.ThirdApiRetrySupportService;
import com.elitescloud.cloudt.system.service.impl.ThirdApiRetryTaskProvider;
import com.elitescloud.cloudt.system.service.repo.ThirdApiBusinessRepoProc;
import com.elitescloud.cloudt.system.service.repo.ThirdApiLogRepoProc;
import com.elitescloud.cloudt.system.service.repo.ThirdApiRetryRepoProc;
import com.fasterxml.jackson.core.type.TypeReference;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.validation.constraints.NotBlank;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Lazy;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

@Component
@ConditionalOnClass(value={AbstractRetryService.class})
class ThirdApiRetry
extends AbstractRetryService<RetryParam> {
    private static final Logger log = LoggerFactory.getLogger(ThirdApiRetry.class);
    private final SystemProperties.ThirdApiLog properties;
    private final RedissonClient redissonClient;
    private final RestTemplate restTemplate = RestTemplateFactory.instance();
    @Autowired
    private ThirdApiLogRepoProc repoProc;
    @Autowired
    private ThirdApiBusinessRepoProc businessRepoProc;
    @Autowired
    private ThirdApiRetryRepoProc retryRepoProc;
    @Autowired
    @Lazy
    private ThirdApiRetrySupportService service;
    @Autowired
    private CloudtContextProperties cloudtContextProperties;

    public ThirdApiRetry(ThirdApiRetryTaskProvider retryTaskProvider, SystemProperties systemProperties, RedissonClient redissonClient, TenantDataIsolateProvider tenantDataIsolateProvider) {
        super((RetryTaskProvider)retryTaskProvider, tenantDataIsolateProvider);
        this.properties = systemProperties.getThirdApiLog();
        this.redissonClient = redissonClient;
    }

    protected boolean supportRetry() {
        return Boolean.TRUE.equals(this.properties.getEnabledRetry());
    }

    protected int retryTimes() {
        return (Integer)ObjectUtil.defaultIfNull((Object)this.properties.getRetryTimes(), (Object)0);
    }

    protected List<Duration> retryIntervals() {
        return this.properties.getRetryIntervals();
    }

    protected void executeTask(RetryParam retryParam) {
        log.info("\u5f00\u59cb\u91cd\u8bd5\u8bf7\u6c42\uff1a{}", (Object)retryParam.getTaskId());
        Long logId = StringUtils.hasText((String)retryParam.getTaskId()) ? Long.valueOf(Long.parseLong(retryParam.getTaskId())) : null;
        Assert.notNull((Object)logId, (String)"\u8bb0\u5f55ID\u4e3a\u7a7a");
        SysThirdApiLogDO logDO = (SysThirdApiLogDO)((Object)this.repoProc.get(logId));
        this.execute(logDO, false);
        if (logDO.getOriginalId() != null) {
            this.retryRepoProc.updateVersionByRecordLogId(logDO.getOriginalId());
        }
    }

    public void executeByManual(SysThirdApiLogDO logDO) {
        this.execute(logDO, true);
    }

    protected Duration scheduleDelay() {
        return Duration.ofMinutes(30L);
    }

    private void execute(SysThirdApiLogDO logDO, boolean manual) {
        Assert.notNull((Object)((Object)logDO), (String)"\u65e5\u5fd7\u8bb0\u5f55\u5df2\u4e0d\u5b58\u5728");
        String lockKey = "thirdApiRetryExecute:" + logDO.getBusinessKey() + ":" + logDO.getBusinessType();
        LockUtil.executeByLock((String)lockKey, () -> {
            this.tryExecuteHttp(logDO, manual);
            return null;
        }, (Duration)Duration.ofMinutes(2L));
    }

    private void tryExecuteHttp(SysThirdApiLogDO logDO, boolean manual) {
        if (Boolean.FALSE.equals(logDO.getRestful())) {
            log.info("\u4e0d\u9700\u8981\u91cd\u8bd5\uff1a{}\uff0c{}", (Object)logDO.getId(), (Object)logDO.getRestful());
            return;
        }
        RetryConfig config = this.buildRetryConfig(logDO);
        this.normalizeRetryConfig(config);
        Supplier<Void> supplier = () -> {
            if (this.isSuccessOfBusiness(logDO)) {
                this.service.updateRetryRespResult(logDO.getId(), manual, true, "\u5176\u5b83\u8bf7\u6c42\u5df2\u6210\u529f", null);
                return null;
            }
            String url = this.buildUrl(config);
            log.info("\u91cd\u8bd5\u8bf7\u6c42\uff1a{} {}", (Object)config.getReqMethod(), (Object)url);
            HttpHeaders headers = this.obtainHeaders(config, logDO);
            log.info("\u8bf7\u6c42\u5934\uff1a{}", (Object)headers);
            ResponseEntity resp = null;
            try {
                resp = this.restTemplate.exchange(url, config.getReqMethod(), new HttpEntity(config.getReqBody(), (MultiValueMap)headers), String.class, new Object[0]);
            }
            catch (RestClientException e) {
                log.error("\u91cd\u8bd5\u8bf7\u6c42\u5f02\u5e38\uff1a", (Throwable)e);
                String reason = e.getMessage();
                this.service.updateRetryRespResult(logDO.getId(), manual, false, (String)ObjectUtil.defaultIfNull((Object)reason, (Object)"\u8bf7\u6c42\u5931\u8d25"), null);
                return null;
            }
            if (resp.getStatusCode().is2xxSuccessful()) {
                String asyncValue = resp.getHeaders().getFirst("X-System-Async");
                log.info("\u662f\u5426\u5f02\u6b65\uff1a{}", (Object)asyncValue);
                if ("true".equalsIgnoreCase(asyncValue)) {
                    return null;
                }
                ApiResult<String> apiResult = this.attemptAnalyzeForResult((String)resp.getBody());
                if (apiResult != null && apiResult.getTime() != null && apiResult.getCode() != 0) {
                    this.service.updateRetryRespResult(logDO.getId(), manual, apiResult.isSuccess(), CharSequenceUtil.blankToDefault((CharSequence)apiResult.getMsg(), (String)apiResult.getErrorMsg()), (String)resp.getBody());
                    return null;
                }
                this.service.updateRetryRespResult(logDO.getId(), manual, true, null, (String)resp.getBody());
                return null;
            }
            this.service.updateRetryRespResult(logDO.getId(), manual, false, resp.getStatusCode().toString(), (String)resp.getBody());
            return null;
        };
        supplier.get();
    }

    private ApiResult<String> attemptAnalyzeForResult(String respBody) {
        return (ApiResult)JSONUtil.json2Obj((String)respBody, (TypeReference)new TypeReference<ApiResult<String>>(){}, (boolean)false, () -> "\u5c1d\u8bd5\u4f7f\u7528ApiResult\u89e3\u6790\u8fd4\u56de\u7ed3\u679c\u5931\u8d25");
    }

    private void normalizeRetryConfig(RetryConfig config) {
        Assert.hasText((String)config.getServerAddr(), (String)"\u670d\u52a1\u7aef\u5730\u5740\u4e3a\u7a7a");
        Assert.hasText((String)config.getUri(), (String)"\u8bf7\u6c42\u63a5\u53e3\u4e3a\u7a7a");
        Assert.notNull((Object)config.getReqMethod(), (String)"\u8bf7\u6c42\u65b9\u5f0f\u4e3a\u7a7a");
        if (!config.getUri().startsWith("/")) {
            config.setUri("/" + config.getUri());
        }
    }

    private RetryConfig buildRetryConfig(SysThirdApiLogDO logDO) {
        RetryConfig retryConfig = new RetryConfig();
        retryConfig.setToken(this.obtainToken(logDO));
        retryConfig.setTenantId(logDO.getSysTenantId());
        if (CharSequenceUtil.isBlank((CharSequence)logDO.getRetryParamJson())) {
            retryConfig.setServerAddr(CharSequenceUtil.blankToDefault((CharSequence)logDO.getServerAddr(), (String)this.cloudtContextProperties.getServerAddr()));
            retryConfig.setUri(logDO.getUri());
            retryConfig.setReqMethod(logDO.getReqMethod());
            retryConfig.setReqQueryParams(this.convertMultiValueMap(logDO.getReqQueryParamsJson()));
            retryConfig.setReqBody(this.convertReqBody(logDO.getReqBody()));
            retryConfig.setReqHeaders(this.convertMultiValueMap(logDO.getReqHeadersJson()));
            if (StrUtil.isBlank((CharSequence)retryConfig.getToken())) {
                retryConfig.setToken(this.obtainToken(retryConfig.getReqHeaders()));
            }
            return retryConfig;
        }
        ThirdApiRetryParamDTO retryParams = (ThirdApiRetryParamDTO)JSONUtil.json2Obj((String)logDO.getRetryParamJson(), ThirdApiRetryParamDTO.class, (boolean)true, () -> "\u8f6c\u6362\u91cd\u8bd5\u53c2\u6570\u5f02\u5e38");
        retryConfig.setServerAddr(CharSequenceUtil.blankToDefault((CharSequence)retryParams.getServerAddr(), (String)this.cloudtContextProperties.getServerAddr()));
        retryConfig.setUri(retryParams.getUri());
        retryConfig.setReqMethod(retryParams.getReqMethod());
        retryConfig.setReqQueryParams(this.convertMultiValueMap(retryParams.getReqQueryParams()));
        retryConfig.setReqBody(this.convertReqBody(retryParams.getReqBody()));
        retryConfig.setReqHeaders(this.convertMultiValueMap(retryParams.getReqHeaders()));
        if (StrUtil.isBlank((CharSequence)retryConfig.getToken())) {
            retryConfig.setToken(this.obtainToken(retryConfig.getReqHeaders()));
        }
        return retryConfig;
    }

    private String obtainToken(MultiValueMap<String, String> headers) {
        if (CollUtil.isEmpty(headers)) {
            return null;
        }
        return (String)headers.getFirst((Object)"Authorization");
    }

    private String obtainToken(SysThirdApiLogDO logDO) {
        if (!Boolean.TRUE.equals(logDO.getDetectedOperatorAuth())) {
            return null;
        }
        String token = SecurityContextUtil.currentToken();
        if (CharSequenceUtil.isBlank((CharSequence)token)) {
            log.info("\u672a\u83b7\u53d6\u5230\u5f53\u524d\u64cd\u4f5c\u4ebatoken\uff1a{}", (Object)logDO.getId());
            return null;
        }
        return token;
    }

    private boolean isSuccessOfBusiness(SysThirdApiLogDO logDO) {
        if (CharSequenceUtil.hasBlank((CharSequence[])new CharSequence[]{logDO.getBusinessType(), logDO.getBusinessKey()})) {
            return false;
        }
        Boolean success = this.businessRepoProc.getSuccess(logDO.getBusinessType(), logDO.getBusinessKey());
        return Boolean.TRUE.equals(success);
    }

    private HttpHeaders obtainHeaders(RetryConfig config, SysThirdApiLogDO logDO) {
        HttpHeaders httpHeaders = new HttpHeaders(config.getReqHeaders());
        if (CharSequenceUtil.isNotBlank((CharSequence)config.getToken())) {
            if (config.getToken().toLowerCase().startsWith("bearer ")) {
                httpHeaders.set("Authorization", config.getToken());
            } else {
                httpHeaders.setBearerAuth(config.getToken());
            }
        }
        if (config.getTenantId() != null) {
            httpHeaders.add("X-Tenant-Id", config.getTenantId().toString());
        }
        httpHeaders.add("X-System-Retry", logDO.getId().toString());
        return httpHeaders;
    }

    private String buildUrl(RetryConfig config) {
        String uri = config.getServerAddr() + config.getUri();
        if (config.getReqQueryParams().isEmpty() || uri.contains("?")) {
            return uri;
        }
        String queryParams = this.convertReqQueryParams(config.getReqQueryParams());
        if (CharSequenceUtil.isNotBlank((CharSequence)queryParams)) {
            uri = uri + "?" + queryParams;
        }
        return uri;
    }

    private Object convertReqBody(String reqBody) {
        if (CharSequenceUtil.isBlank((CharSequence)reqBody)) {
            return null;
        }
        return JSONUtil.json2Obj((String)reqBody, (boolean)true, () -> "\u89e3\u6790\u8bf7\u6c42\u5934\u5f02\u5e38");
    }

    private String convertReqQueryParams(MultiValueMap<String, String> valueMap) {
        if (valueMap.isEmpty()) {
            return null;
        }
        return valueMap.entrySet().stream().map(entry -> {
            if (CollUtil.isEmpty((Collection)((Collection)entry.getValue()))) {
                return (String)entry.getKey() + "=";
            }
            return ((List)entry.getValue()).stream().filter(Objects::nonNull).map(t -> (String)entry.getKey() + "=" + t).collect(Collectors.joining("&"));
        }).collect(Collectors.joining("&"));
    }

    private MultiValueMap<String, String> convertMultiValueMap(Map<String, String[]> originalMap) {
        LinkedMultiValueMap result = new LinkedMultiValueMap();
        if (MapUtil.isEmpty(originalMap)) {
            return result;
        }
        for (Map.Entry<String, String[]> entry : originalMap.entrySet()) {
            if (!ArrayUtil.isNotEmpty((Object[])entry.getValue())) continue;
            for (String v : entry.getValue()) {
                result.add((Object)entry.getKey(), (Object)v);
            }
        }
        return result;
    }

    private MultiValueMap<String, String> convertMultiValueMap(String json) {
        if (CharSequenceUtil.isBlank((CharSequence)json)) {
            return new LinkedMultiValueMap(0);
        }
        return (MultiValueMap)JSONUtil.json2Obj((String)json, (TypeReference)new TypeReference<LinkedMultiValueMap<String, String>>(){}, (boolean)true, () -> "\u53c2\u6570\u8f6c\u6362\u5931\u8d25");
    }

    public static class RetryParam
    extends RetryTask {
        private static final long serialVersionUID = 3323072273214519095L;
    }

    static class RetryConfig {
        private String token;
        private Long tenantId;
        private String serverAddr;
        @NotBlank(message="\u8bf7\u6c42\u7684\u63a5\u53e3\u4e3a\u7a7a")
        private @NotBlank(message="\u8bf7\u6c42\u7684\u63a5\u53e3\u4e3a\u7a7a") String uri;
        private HttpMethod reqMethod;
        private MultiValueMap<String, String> reqQueryParams;
        private Object reqBody;
        private MultiValueMap<String, String> reqHeaders;

        public String getToken() {
            return this.token;
        }

        public Long getTenantId() {
            return this.tenantId;
        }

        public String getServerAddr() {
            return this.serverAddr;
        }

        public String getUri() {
            return this.uri;
        }

        public HttpMethod getReqMethod() {
            return this.reqMethod;
        }

        public MultiValueMap<String, String> getReqQueryParams() {
            return this.reqQueryParams;
        }

        public Object getReqBody() {
            return this.reqBody;
        }

        public MultiValueMap<String, String> getReqHeaders() {
            return this.reqHeaders;
        }

        public void setToken(String token) {
            this.token = token;
        }

        public void setTenantId(Long tenantId) {
            this.tenantId = tenantId;
        }

        public void setServerAddr(String serverAddr) {
            this.serverAddr = serverAddr;
        }

        public void setUri(String uri) {
            this.uri = uri;
        }

        public void setReqMethod(HttpMethod reqMethod) {
            this.reqMethod = reqMethod;
        }

        public void setReqQueryParams(MultiValueMap<String, String> reqQueryParams) {
            this.reqQueryParams = reqQueryParams;
        }

        public void setReqBody(Object reqBody) {
            this.reqBody = reqBody;
        }

        public void setReqHeaders(MultiValueMap<String, String> reqHeaders) {
            this.reqHeaders = reqHeaders;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RetryConfig)) {
                return false;
            }
            RetryConfig other = (RetryConfig)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$tenantId = this.getTenantId();
            Long other$tenantId = other.getTenantId();
            if (this$tenantId == null ? other$tenantId != null : !((Object)this$tenantId).equals(other$tenantId)) {
                return false;
            }
            String this$token = this.getToken();
            String other$token = other.getToken();
            if (this$token == null ? other$token != null : !this$token.equals(other$token)) {
                return false;
            }
            String this$serverAddr = this.getServerAddr();
            String other$serverAddr = other.getServerAddr();
            if (this$serverAddr == null ? other$serverAddr != null : !this$serverAddr.equals(other$serverAddr)) {
                return false;
            }
            String this$uri = this.getUri();
            String other$uri = other.getUri();
            if (this$uri == null ? other$uri != null : !this$uri.equals(other$uri)) {
                return false;
            }
            HttpMethod this$reqMethod = this.getReqMethod();
            HttpMethod other$reqMethod = other.getReqMethod();
            if (this$reqMethod == null ? other$reqMethod != null : !this$reqMethod.equals(other$reqMethod)) {
                return false;
            }
            MultiValueMap<String, String> this$reqQueryParams = this.getReqQueryParams();
            MultiValueMap<String, String> other$reqQueryParams = other.getReqQueryParams();
            if (this$reqQueryParams == null ? other$reqQueryParams != null : !this$reqQueryParams.equals(other$reqQueryParams)) {
                return false;
            }
            Object this$reqBody = this.getReqBody();
            Object other$reqBody = other.getReqBody();
            if (this$reqBody == null ? other$reqBody != null : !this$reqBody.equals(other$reqBody)) {
                return false;
            }
            MultiValueMap<String, String> this$reqHeaders = this.getReqHeaders();
            MultiValueMap<String, String> other$reqHeaders = other.getReqHeaders();
            return !(this$reqHeaders == null ? other$reqHeaders != null : !this$reqHeaders.equals(other$reqHeaders));
        }

        protected boolean canEqual(Object other) {
            return other instanceof RetryConfig;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $tenantId = this.getTenantId();
            result = result * 59 + ($tenantId == null ? 43 : ((Object)$tenantId).hashCode());
            String $token = this.getToken();
            result = result * 59 + ($token == null ? 43 : $token.hashCode());
            String $serverAddr = this.getServerAddr();
            result = result * 59 + ($serverAddr == null ? 43 : $serverAddr.hashCode());
            String $uri = this.getUri();
            result = result * 59 + ($uri == null ? 43 : $uri.hashCode());
            HttpMethod $reqMethod = this.getReqMethod();
            result = result * 59 + ($reqMethod == null ? 43 : $reqMethod.hashCode());
            MultiValueMap<String, String> $reqQueryParams = this.getReqQueryParams();
            result = result * 59 + ($reqQueryParams == null ? 43 : $reqQueryParams.hashCode());
            Object $reqBody = this.getReqBody();
            result = result * 59 + ($reqBody == null ? 43 : $reqBody.hashCode());
            MultiValueMap<String, String> $reqHeaders = this.getReqHeaders();
            result = result * 59 + ($reqHeaders == null ? 43 : $reqHeaders.hashCode());
            return result;
        }

        public String toString() {
            return "ThirdApiRetry.RetryConfig(token=" + this.getToken() + ", tenantId=" + this.getTenantId() + ", serverAddr=" + this.getServerAddr() + ", uri=" + this.getUri() + ", reqMethod=" + String.valueOf(this.getReqMethod()) + ", reqQueryParams=" + String.valueOf(this.getReqQueryParams()) + ", reqBody=" + String.valueOf(this.getReqBody()) + ", reqHeaders=" + String.valueOf(this.getReqHeaders()) + ")";
        }
    }
}

