/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.service.impl;

import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.BooleanUtil;
import cn.hutool.core.util.ObjectUtil;
import com.elitescloud.boot.common.param.FileByteVO;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.annotation.TenantOrgTransaction;
import com.elitescloud.cloudt.core.annotation.TenantTransaction;
import com.elitescloud.cloudt.core.annotation.common.TenantIsolateType;
import com.elitescloud.cloudt.system.convert.TmplConvert;
import com.elitescloud.cloudt.system.dto.SysTmplDTO;
import com.elitescloud.cloudt.system.model.vo.query.extend.TmplQueryParam;
import com.elitescloud.cloudt.system.model.vo.resp.extend.TmplPageQueryRespVO;
import com.elitescloud.cloudt.system.service.TmplQueryService;
import com.elitescloud.cloudt.system.service.impl.TmplBaseServiceImpl;
import com.elitescloud.cloudt.system.service.model.entity.SysTmplDO;
import com.elitescloud.cloudt.system.service.repo.SysTmplRepoProc;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.servlet.mvc.method.annotation.StreamingResponseBody;

@Service
@TenantTransaction(isolateType=TenantIsolateType.DEFAULT)
@TenantOrgTransaction(useTenantOrg=false)
public class TmplQueryServiceImpl
extends TmplBaseServiceImpl
implements TmplQueryService {
    @Autowired
    private SysTmplRepoProc tmplRepoProc;

    @Override
    public ApiResult<PagingVO<TmplPageQueryRespVO>> search(TmplQueryParam queryParam) {
        if (CharSequenceUtil.isBlank((CharSequence)queryParam.getAppCode())) {
            return ApiResult.ok((Object)PagingVO.empty());
        }
        PagingVO result = this.tmplRepoProc.pageQuery(queryParam).map(TmplConvert.INSTANCE::do2PageQueryVo);
        return ApiResult.ok((Object)result);
    }

    @Override
    public ApiResult<SysTmplDTO> getByCode(String code) {
        SysTmplDO tmplDO = this.tmplRepoProc.getByCode(code);
        if (tmplDO == null) {
            return ApiResult.fail((String)"\u6570\u636e\u4e0d\u5b58\u5728");
        }
        if (!BooleanUtil.isTrue((Boolean)tmplDO.getEnabled())) {
            return ApiResult.fail((String)"\u6a21\u677f\u672a\u542f\u7528");
        }
        SysTmplDTO dto = TmplConvert.INSTANCE.vo2Dto(tmplDO);
        List attributes = null;
        if (CharSequenceUtil.isNotBlank((CharSequence)tmplDO.getAttributeList())) {
            attributes = (List)super.json2Obj(tmplDO.getAttributeList(), (TypeReference)new TypeReference<List<List<String>>>(){});
        }
        dto.setAttributes((List)ObjectUtil.defaultIfNull(attributes, Collections.emptyList()));
        if (!dto.getAttributes().isEmpty() && dto.getAttributes().size() >= dto.getFieldTypeRow()) {
            dto.setAttributeFields((List)dto.getAttributes().get(dto.getFieldTypeRow() - 1));
        }
        if (CharSequenceUtil.isNotBlank((CharSequence)tmplDO.getSheetNos())) {
            dto.setSheetNoList(Arrays.stream(tmplDO.getSheetNos().split(",")).map(Integer::parseInt).collect(Collectors.toList()));
        }
        this.cache(dto);
        return ApiResult.ok((Object)dto);
    }

    @Override
    public ApiResult<String> getFileCodeByCode(String code) {
        String fileCode = this.tmplRepoProc.getFileCodeByCode(code);
        return ApiResult.ok((Object)fileCode);
    }

    @Override
    public HttpEntity<StreamingResponseBody> downloadByFileCode(String fileCode) {
        return super.streamByFileCode(fileCode);
    }

    @Override
    public HttpEntity<StreamingResponseBody> downloadByCode(String code) {
        if (CharSequenceUtil.isBlank((CharSequence)code)) {
            return ResponseEntity.badRequest().build();
        }
        String fileCode = this.tmplRepoProc.getFileCodeByCode(code);
        return super.streamByFileCode(fileCode);
    }

    @Override
    public ApiResult<FileByteVO> getTmplFileByCode(String code) {
        if (CharSequenceUtil.isBlank((CharSequence)code)) {
            return ApiResult.fail((String)"\u6a21\u677f\u7f16\u7801\u4e3a\u7a7a");
        }
        String fileCode = this.tmplRepoProc.getFileCodeByCode(code);
        if (CharSequenceUtil.isBlank((CharSequence)fileCode)) {
            return ApiResult.fail((String)"\u672a\u627e\u5230\u6709\u6548\u6a21\u677f\u6587\u4ef6");
        }
        FileByteVO byteVO = super.getFileVO(fileCode);
        return ApiResult.ok((Object)byteVO);
    }
}

