/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.service.impl;

import cn.hutool.core.util.BooleanUtil;
import cn.hutool.core.util.ObjectUtil;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.boot.core.base.UdcProvider;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.annotation.TenantOrgTransaction;
import com.elitescloud.cloudt.core.annotation.TenantTransaction;
import com.elitescloud.cloudt.core.annotation.common.TenantIsolateType;
import com.elitescloud.cloudt.platform.service.repo.SysPlatformUdcValueRepo;
import com.elitescloud.cloudt.system.cacheable.SysCacheUdcRpcService;
import com.elitescloud.cloudt.system.convert.UdcConvert;
import com.elitescloud.cloudt.system.model.vo.query.udc.UdcPageQueryVO;
import com.elitescloud.cloudt.system.model.vo.resp.udc.UdcDetailRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.udc.UdcPageRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.udc.UdcValueRespVO;
import com.elitescloud.cloudt.system.model.vo.save.udc.UdcSaveVO;
import com.elitescloud.cloudt.system.model.vo.save.udc.UdcValueSaveVO;
import com.elitescloud.cloudt.system.service.UdcMngService;
import com.elitescloud.cloudt.system.service.model.entity.SysPlatformUdcDO;
import com.elitescloud.cloudt.system.service.model.entity.SysPlatformUdcValueDO;
import com.elitescloud.cloudt.system.service.repo.UdcRepoProc;
import com.elitescloud.cloudt.system.service.repo.UdcValueRepoProc;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
@TenantTransaction(isolateType=TenantIsolateType.TENANT)
@TenantOrgTransaction(useTenantOrg=false)
public class UdcMngServiceImpl
extends BaseServiceImpl
implements UdcMngService {
    private static final Logger log = LogManager.getLogger(UdcMngServiceImpl.class);
    private static final UdcConvert CONVERT = UdcConvert.INSTANCE;
    @Autowired
    private UdcRepoProc udcRepoProc;
    @Autowired
    private UdcValueRepoProc udcValueRepoProc;
    @Autowired
    private SysPlatformUdcValueRepo udcValueRepo;
    @Autowired
    private UdcProvider udcProvider;
    @Autowired
    private SysCacheUdcRpcService cacheUdcRpcService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> save(UdcSaveVO saveVO) {
        SysPlatformUdcDO udcDO = (SysPlatformUdcDO)this.udcRepoProc.get(saveVO.getId());
        if (udcDO == null) {
            return ApiResult.noData();
        }
        List<SysPlatformUdcValueDO> valueDOList = this.udcValueRepoProc.listByUdc(udcDO.getAppCode(), udcDO.getUdcCode(), true);
        Set<Long> idsToDel = this.checkValueForSave(udcDO, valueDOList, saveVO.getValueList());
        this.udcValueRepo.saveAll(valueDOList);
        if (!idsToDel.isEmpty()) {
            this.udcValueRepoProc.delete(idsToDel);
        }
        this.clearCache(udcDO.getAppCode(), udcDO.getUdcCode());
        return ApiResult.ok((Object)saveVO.getId());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> saveValue(Long id, UdcValueSaveVO saveVO) {
        SysPlatformUdcDO udcDO = (SysPlatformUdcDO)this.udcRepoProc.get(id);
        if (udcDO == null) {
            return ApiResult.noData();
        }
        List<SysPlatformUdcValueDO> valueDOList = this.udcValueRepoProc.listByUdc(udcDO.getAppCode(), udcDO.getUdcCode(), true);
        SysPlatformUdcValueDO valueDO = this.checkValueForSave(udcDO, valueDOList, saveVO);
        this.udcValueRepo.save((Object)valueDO);
        this.clearCache(udcDO.getAppCode(), udcDO.getUdcCode());
        return ApiResult.ok((Object)valueDO.getId());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> updateValueEnabled(Long valueId) {
        SysPlatformUdcValueDO valueDO = (SysPlatformUdcValueDO)this.udcValueRepoProc.get(valueId);
        if (valueDO == null) {
            return ApiResult.ok((Object)valueId);
        }
        if (((Boolean)ObjectUtil.defaultIfNull((Object)valueDO.getAllowDefault(), (Object)true)).booleanValue()) {
            SysPlatformUdcDO udcDO = this.udcRepoProc.getByAppCodeAndUdcCode(valueDO.getAppCode(), valueDO.getUdcCode());
            if (udcDO == null) {
                return ApiResult.fail((String)"\u672a\u67e5\u8be2\u5230UDC\u6570\u636e");
            }
            if (!((Boolean)ObjectUtil.defaultIfNull((Object)udcDO.getAllowUpdate(), (Object)true)).booleanValue()) {
                return ApiResult.fail((String)"\u4e0d\u5141\u8bb8\u4fee\u6539\u503c");
            }
        }
        boolean enabled = valueDO.getAllowStart() == null || valueDO.getAllowStart() == false;
        this.udcValueRepoProc.updateEnabled(valueId, enabled);
        this.clearCache(valueDO.getAppCode(), valueDO.getUdcCode());
        return ApiResult.ok((Object)valueId);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> deleteValue(Long valueId) {
        SysPlatformUdcValueDO valueDO = (SysPlatformUdcValueDO)this.udcValueRepoProc.get(valueId);
        if (valueDO == null) {
            return ApiResult.ok((Object)valueId);
        }
        if (((Boolean)ObjectUtil.defaultIfNull((Object)valueDO.getAllowDefault(), (Object)true)).booleanValue()) {
            return ApiResult.fail((String)"\u7cfb\u7edf\u5185\u7f6e\u7684\u4e0d\u53ef\u5220\u9664");
        }
        this.udcValueRepoProc.delete(valueId);
        this.clearCache(valueDO.getAppCode(), valueDO.getUdcCode());
        return ApiResult.ok((Object)valueId);
    }

    @Override
    public ApiResult<PagingVO<UdcPageRespVO>> page(UdcPageQueryVO queryVO) {
        PagingVO<SysPlatformUdcDO> pageData = this.udcRepoProc.pageMng(queryVO);
        if (pageData.isEmpty()) {
            return ApiResult.ok((Object)PagingVO.empty());
        }
        PagingVO pageResult = pageData.map(CONVERT::do2PageRespVO);
        return ApiResult.ok((Object)pageResult);
    }

    @Override
    public ApiResult<UdcDetailRespVO> detail(Long id) {
        return this.udcRepoProc.getOptional(id).map(t -> {
            UdcDetailRespVO respVO = CONVERT.do2DetailRespVO((SysPlatformUdcDO)t);
            List<SysPlatformUdcValueDO> valueDoList = this.udcValueRepoProc.listByUdc(t.getAppCode(), t.getUdcCode(), true);
            respVO.setValueList(CONVERT.valueDo2RespVoList(valueDoList));
            for (UdcValueRespVO udcValueRespVO : respVO.getValueList()) {
                if (udcValueRespVO.getUdcOrder() == null) {
                    udcValueRespVO.setUdcOrder(0);
                }
                udcValueRespVO.setAllowDefault((Boolean)ObjectUtil.defaultIfNull((Object)udcValueRespVO.getAllowDefault(), (Object)true));
                udcValueRespVO.setAllowStart((Boolean)ObjectUtil.defaultIfNull((Object)udcValueRespVO.getAllowStart(), (Object)true));
            }
            return ApiResult.ok((Object)respVO);
        }).orElse(ApiResult.noData());
    }

    private void clearCache(String appCode, String udcCode) {
        this.udcProvider.clearCache(appCode, udcCode);
        this.cacheUdcRpcService.clearCache();
    }

    private SysPlatformUdcValueDO checkValueForSave(SysPlatformUdcDO udcDO, List<SysPlatformUdcValueDO> valueDOList, UdcValueSaveVO valueSaveVO) {
        boolean nameExists;
        Set valueCodes = valueDOList.stream().map(SysPlatformUdcValueDO::getUdcValueCode).collect(Collectors.toSet());
        if (valueSaveVO.getId() == null) {
            if (valueSaveVO.getUdcOrder() == null) {
                Integer order = valueDOList.isEmpty() ? 1 : (Integer)ObjectUtil.defaultIfNull((Object)valueDOList.get(valueDOList.size() - 1).getUdcOrder(), (Object)1) + 1;
                valueSaveVO.setUdcOrder(order);
            }
            if (valueSaveVO.getAllowStart() == null) {
                valueSaveVO.setAllowStart(true);
            }
            if (valueCodes.contains(valueSaveVO.getUdcValueCode())) {
                throw new IllegalArgumentException("\u503c\u7f16\u7801\u5df2\u5b58\u5728");
            }
            Assert.isTrue((boolean)((Boolean)ObjectUtil.defaultIfNull((Object)udcDO.getAllowAddValue(), (Object)true)), (String)"\u4e0d\u5141\u8bb8\u65b0\u589e\u503c");
            return this.initNewValue(udcDO, valueSaveVO);
        }
        SysPlatformUdcValueDO valueDO = valueDOList.stream().filter(t -> t.getId().longValue() == valueSaveVO.getId().longValue()).findFirst().orElse(null);
        Assert.notNull((Object)valueDO, (String)"\u4fee\u6539\u7684\u503c\u4e0d\u5b58\u5728");
        if (((Boolean)ObjectUtil.defaultIfNull((Object)valueDO.getAllowDefault(), (Object)true)).booleanValue()) {
            Assert.isTrue((boolean)valueDO.getUdcValueCode().equals(valueSaveVO.getUdcValueCode()), (String)"\u7cfb\u7edf\u5185\u7f6e\u7684\u4e0d\u53ef\u4fee\u6539\u503c\u7f16\u7801");
            if (!((Boolean)ObjectUtil.defaultIfNull((Object)udcDO.getAllowUpdate(), (Object)true)).booleanValue()) {
                Assert.isTrue((boolean)Objects.equals(valueDO.getUdcValueName(), valueSaveVO.getUdcValueName()), (String)"\u7cfb\u7edf\u5185\u7f6e\u7684\u503c\u4e0d\u53ef\u7f16\u8f91\u663e\u793a\u540d\u79f0");
                Assert.isTrue((boolean)Objects.equals(valueDO.getAllowStart(), valueSaveVO.getAllowStart()), (String)"\u7cfb\u7edf\u5185\u7f6e\u7684\u503c\u4e0d\u53ef\u7f16\u8f91\u542f\u7528\u72b6\u6001");
            }
        } else {
            if (!valueSaveVO.getUdcValueCode().equals(valueDO.getUdcValueCode())) {
                Assert.isTrue((boolean)valueCodes.contains(valueSaveVO.getUdcValueCode()), (String)"\u503c\u7f16\u7801\u5df2\u5b58\u5728");
            }
            if (valueSaveVO.getAllowStart() == null) {
                valueSaveVO.setAllowStart(true);
            }
        }
        if (valueSaveVO.getUdcOrder() == null) {
            valueSaveVO.setUdcOrder((Integer)ObjectUtil.defaultIfNull((Object)valueDO.getUdcOrder(), (Object)1));
        }
        Assert.isTrue((!(nameExists = valueDOList.stream().filter(t -> !t.getId().equals(valueSaveVO.getId())).anyMatch(t -> t.getUdcValueName().equals(valueSaveVO.getUdcValueName()))) ? 1 : 0) != 0, (String)"\u503c\u540d\u79f0\u5df2\u5b58\u5728");
        CONVERT.copyUdcValue(valueSaveVO, valueDO);
        return valueDO;
    }

    private Set<Long> checkValueForSave(SysPlatformUdcDO udcDO, List<SysPlatformUdcValueDO> valueDOList, List<UdcValueSaveVO> valueVONewList) {
        Assert.notEmpty(valueVONewList, (String)"\u503c\u4e0d\u80fd\u4e3a\u7a7a");
        Map<Long, SysPlatformUdcValueDO> valueDoMap = valueDOList.stream().collect(Collectors.toMap(BaseModel::getId, t -> t, (t1, t2) -> t1));
        ArrayList<SysPlatformUdcValueDO> newValueDoList = new ArrayList<SysPlatformUdcValueDO>(16);
        HashSet<String> codes = new HashSet<String>(16);
        HashSet<String> names = new HashSet<String>(16);
        int index = 0;
        for (UdcValueSaveVO saveVO : valueVONewList) {
            saveVO.setUdcOrder((Integer)ObjectUtil.defaultIfNull((Object)saveVO.getUdcOrder(), (Object)(++index)));
            if (saveVO.getAllowStart() == null) {
                saveVO.setAllowStart(true);
            }
            Assert.isTrue((!codes.contains(saveVO.getUdcValueCode()) ? 1 : 0) != 0, (String)"\u5b58\u5728\u91cd\u590d\u7684\u503c\u7f16\u7801");
            codes.add(saveVO.getUdcValueCode());
            Assert.isTrue((!names.contains(saveVO.getUdcValueName()) ? 1 : 0) != 0, (String)"\u5b58\u5728\u91cd\u590d\u7684\u503c\u540d\u79f0");
            names.add(saveVO.getUdcValueName());
            if (saveVO.getId() == null) {
                Assert.isTrue((!BooleanUtil.isFalse((Boolean)udcDO.getAllowAddValue()) ? 1 : 0) != 0, (String)"\u4e0d\u5141\u8bb8\u65b0\u589e\u503c");
                SysPlatformUdcValueDO newValue = this.initNewValue(udcDO, saveVO);
                newValueDoList.add(newValue);
                continue;
            }
            SysPlatformUdcValueDO valueDO = valueDoMap.get(saveVO.getId());
            Assert.notNull((Object)valueDO, (String)"\u4fee\u6539\u7684\u503c\u4e0d\u5b58\u5728");
            if (((Boolean)ObjectUtil.defaultIfNull((Object)valueDO.getAllowDefault(), (Object)true)).booleanValue()) {
                Assert.isTrue((boolean)valueDO.getUdcValueCode().equals(saveVO.getUdcValueCode()), (String)"\u7cfb\u7edf\u5185\u7f6e\u7684\u4e0d\u53ef\u4fee\u6539\u503c\u7f16\u7801");
                if (!((Boolean)ObjectUtil.defaultIfNull((Object)udcDO.getAllowUpdate(), (Object)true)).booleanValue()) {
                    Assert.isTrue((boolean)Objects.equals(valueDO.getUdcValueName(), saveVO.getUdcValueName()), (String)"\u7cfb\u7edf\u5185\u7f6e\u7684\u503c\u4e0d\u53ef\u7f16\u8f91\u663e\u793a\u540d\u79f0");
                    Assert.isTrue((boolean)Objects.equals(valueDO.getAllowStart(), saveVO.getAllowStart()), (String)"\u7cfb\u7edf\u5185\u7f6e\u7684\u503c\u4e0d\u53ef\u7f16\u8f91\u542f\u7528\u72b6\u6001");
                }
            }
            CONVERT.copyUdcValue(saveVO, valueDO);
        }
        valueDOList.addAll(newValueDoList);
        HashSet<Long> idToDel = new HashSet<Long>(16);
        for (SysPlatformUdcValueDO valueDO : valueDOList) {
            if (codes.contains(valueDO.getUdcValueCode())) continue;
            Assert.isTrue((boolean)((Boolean)ObjectUtil.defaultIfNull((Object)valueDO.getAllowDefault(), (Object)true)), (String)"\u7cfb\u7edf\u5185\u7f6e\u7684\u503c\u4e0d\u53ef\u5220\u9664");
            idToDel.add(valueDO.getId());
        }
        return idToDel;
    }

    private SysPlatformUdcValueDO initNewValue(SysPlatformUdcDO udcDO, UdcValueSaveVO saveVO) {
        SysPlatformUdcValueDO valueDO = CONVERT.valueSaveVo2DO(saveVO);
        valueDO.setAppCode(udcDO.getAppCode());
        valueDO.setUdcCode(udcDO.getUdcCode());
        valueDO.setAllowDefault(Boolean.valueOf(false));
        return valueDO;
    }
}

