/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.service.impl;

import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.boot.auth.util.SecurityContextUtil;
import com.elitescloud.boot.util.ClassUtil;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.core.annotation.TenantTransaction;
import com.elitescloud.cloudt.core.annotation.common.TenantIsolateType;
import com.elitescloud.cloudt.system.service.UserOuterappQueryService;
import com.elitescloud.cloudt.system.service.common.service.UserOuterAppProvider;
import com.elitescloud.cloudt.system.service.dto.SysUserOuterAppDTO;
import com.elitescloud.cloudt.system.service.model.entity.SysUserOuterappDO;
import com.elitescloud.cloudt.system.service.repo.SysUserOuterappRepoProc;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.concurrent.CompletableFuture;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.task.TaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
@TenantTransaction(isolateType=TenantIsolateType.DEFAULT)
public class UserOuterappQueryServiceImpl
implements UserOuterappQueryService {
    private static final Logger logger = LoggerFactory.getLogger(UserOuterappQueryServiceImpl.class);
    @Autowired
    private SysUserOuterappRepoProc repoProc;
    @Autowired
    private TaskExecutor taskExecutor;
    @Autowired
    private ObjectProvider<UserOuterAppProvider> userOuterAppProviders;

    @Override
    public ApiResult<String> getOpenId(HttpServletRequest request, String outerAppId) {
        Assert.hasText((String)outerAppId, (String)"\u5916\u90e8\u5e94\u7528\u6807\u8bc6\u4e3a\u7a7a");
        Long userId = SecurityContextUtil.currentUserIfUnauthorizedThrow().getUserId();
        String openId = this.repoProc.getOpenIdByUserIdAndOuterAppId(userId.longValue(), outerAppId);
        if (CharSequenceUtil.isNotBlank((CharSequence)openId)) {
            return ApiResult.ok((Object)openId);
        }
        SysUserOuterAppDTO outerAppDTO = this.queryOuterAppInfo(request, outerAppId);
        if (outerAppDTO == null) {
            return ApiResult.fail((String)"\u83b7\u53d6openId\u5931\u8d25");
        }
        CompletableFuture.runAsync(() -> {
            SysUserOuterappDO userOuterappDO = new SysUserOuterappDO();
            userOuterappDO.setUserId(userId);
            userOuterappDO.setOuterAppId(outerAppId);
            userOuterappDO.setOpenId(outerAppDTO.getOpenId());
            userOuterappDO.setUnionId(outerAppDTO.getUnionId());
            userOuterappDO.setBindTime(LocalDateTime.now());
            userOuterappDO.setTenantCode(outerAppDTO.getTenantCode());
            this.repoProc.save((Serializable)userOuterappDO);
        }).whenComplete((r, e) -> {
            if (e != null) {
                logger.error("\u4fdd\u5b58openId\u5931\u8d25\uff1a{}\uff0c{}\uff0c{}", new Object[]{userId, outerAppDTO.getOpenId(), outerAppDTO.getUnionId(), e});
            }
        });
        return ApiResult.ok((Object)outerAppDTO.getOpenId());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<String> unbind(String outerAppId) {
        Assert.hasText((String)outerAppId, (String)"\u5916\u90e8\u5e94\u7528\u6807\u8bc6\u4e3a\u7a7a");
        Long userId = SecurityContextUtil.currentUserIfUnauthorizedThrow().getUserId();
        String openId = this.repoProc.getOpenIdByUserIdAndOuterAppId(userId.longValue(), outerAppId);
        if (CharSequenceUtil.isBlank((CharSequence)openId)) {
            return ApiResult.ok((Object)openId);
        }
        this.repoProc.deleteByAppIdAndUserId(userId.longValue(), outerAppId);
        return ApiResult.ok((Object)openId);
    }

    private SysUserOuterAppDTO queryOuterAppInfo(HttpServletRequest request, String outerAppId) {
        for (UserOuterAppProvider userOuterAppProvider : this.userOuterAppProviders) {
            SysUserOuterAppDTO outerAppDTO = userOuterAppProvider.get(outerAppId, request);
            if (outerAppDTO == null) continue;
            logger.info("\u5339\u914d\u5230\u5e94\u7528\uff1a{}\uff0c{}", (Object)outerAppId, (Object)ClassUtil.getTargetClass((Object)userOuterAppProvider).getName());
            if (CharSequenceUtil.isAllBlank((CharSequence[])new CharSequence[]{outerAppDTO.getOpenId(), outerAppDTO.getUnionId()})) {
                logger.warn("\u83b7\u53d6openId\u5931\u8d25\uff1a{}", (Object)outerAppId);
                return null;
            }
            return outerAppDTO;
        }
        return null;
    }
}

